/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.enterprise;

import com.oracle.iot.client.StorageObject;
import com.oracle.iot.client.impl.StorageObjectBase;
import java.io.IOException;
import java.security.GeneralSecurityException;
import oracle.iot.client.StorageObject;
import oracle.iot.client.enterprise.VirtualDevice;

public final class StorageObjectImpl
extends StorageObjectBase {
    private String nameForSyncEvent;
    private VirtualDevice deviceForSyncEvent;

    public StorageObjectImpl(StorageObject delegate) {
        super(delegate);
    }

    @Override
    public final void sync() {
        if (this.getSyncStatus() == StorageObject.SyncStatus.NOT_IN_SYNC) {
            super.sync();
            dispatcher.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        StorageObjectImpl.this.getDelegate().sync();
                        StorageObjectImpl.this.addSyncEvent(StorageObjectImpl.this.createSyncEvent());
                        StorageObjectImpl.this.setSyncStatus(StorageObject.SyncStatus.IN_SYNC);
                    }
                    catch (IOException e) {
                        StorageObjectImpl.this.addSyncEvent(StorageObjectImpl.this.createSyncEvent());
                        StorageObjectImpl.this.setSyncStatus(StorageObject.SyncStatus.SYNC_FAILED);
                    }
                    catch (GeneralSecurityException e) {
                        StorageObjectImpl.this.addSyncEvent(StorageObjectImpl.this.createSyncEvent());
                        StorageObjectImpl.this.setSyncStatus(StorageObject.SyncStatus.SYNC_FAILED);
                    }
                }
            });
        } else {
            super.sync();
        }
    }

    void setSyncEventInfo(VirtualDevice virtualDevice, String nameForSyncEvent) {
        this.deviceForSyncEvent = virtualDevice;
        this.nameForSyncEvent = nameForSyncEvent;
    }

    @Override
    protected void handleStateChange() {
    }

    @Override
    protected StorageObject.SyncEvent<VirtualDevice> createSyncEvent() {
        return new StorageObjectBase.SyncEventImpl<VirtualDevice>(this, this.deviceForSyncEvent, this.nameForSyncEvent);
    }
}

