/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.enterprise;

import com.oracle.iot.client.HttpResponse;
import com.oracle.iot.client.impl.http.HttpSecureConnection;
import com.oracle.iot.client.message.StatusCode;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import oracle.iot.client.enterprise.Pageable;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class PageableEnumerator<T>
implements Pageable<T> {
    protected int size;
    protected int offset;
    protected int limit;
    protected boolean hasMore;
    private Collection<T> elements;

    public PageableEnumerator(int offset, int limit) {
        this.offset = offset;
        this.limit = limit;
        this.hasMore = false;
        this.elements = Collections.emptyList();
    }

    protected abstract HttpSecureConnection getSecureConnection();

    protected abstract PagedResponse<T> load(int var1, int var2) throws IOException;

    public void setSize(int size) {
        this.size = size;
        this.hasMore = size < 0 || this.offset + this.elements.size() < this.size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean hasMore() {
        return this.hasMore;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    private synchronized void offset(int offset) throws IOException {
        PagedResponse<T> resp = this.load(offset, this.limit);
        this.elements = resp.elements();
        this.hasMore = resp.hasMore();
        this.offset = resp.offset();
        this.size = resp.total();
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public Pageable<T> limit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public Collection<T> elements() {
        return this.elements;
    }

    @Override
    public Pageable<T> next() throws IOException {
        this.offset(this.offset + this.elements.size());
        if (this.elements.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this;
    }

    @Override
    public Pageable<T> first() throws IOException {
        return this.at(0);
    }

    @Override
    public Pageable<T> last() throws IOException {
        return this.at(this.size - this.limit);
    }

    @Override
    public Pageable<T> at(int offset) throws IOException {
        this.offset(offset);
        if (this.elements.isEmpty()) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    protected JSONObject get(Map<String, String> headers, String request) throws IOException, GeneralSecurityException {
        HttpResponse res = this.getSecureConnection().get(request);
        int status = res.getStatus();
        if (status != StatusCode.OK.getCode()) {
            throw new IOException(res.getVerboseStatus("GET", request));
        }
        byte[] data = res.getData();
        if (data == null) {
            throw new IOException("GET " + request + " failed: no data received");
        }
        String json = new String(data, "UTF-8");
        try {
            return new JSONObject(json);
        }
        catch (JSONException e) {
            throw new IOException("GET " + request + " failed: cannot parse data received" + e.getMessage());
        }
    }

    public static class PagedResponse<T> {
        private final Collection<T> elements;
        private final boolean hasMore;
        private final int offset;
        private final int total;
        private final Map<String, String> links;

        public static <T> PagedResponse<T> empty() {
            return new PagedResponse(Collections.emptyList(), 0, 0, false, null);
        }

        protected PagedResponse(Collection<T> elements, int offset, int total, boolean hasMore, Map<String, String> links) {
            this.elements = elements;
            this.hasMore = hasMore;
            this.offset = offset;
            this.total = total;
            this.links = links;
        }

        public Collection<T> elements() {
            return this.elements;
        }

        public Map<String, String> links() {
            return this.links;
        }

        public boolean hasMore() {
            return this.hasMore;
        }

        public int offset() {
            return this.offset;
        }

        public int count() {
            return this.elements().size();
        }

        public int total() {
            return this.total;
        }

        public String canonical() {
            return this.links.get("canonical");
        }

        public String self() {
            return this.links.get("self");
        }

        public String next() {
            return this.links.get("next");
        }

        public String first() {
            return this.links.get("first");
        }

        public String last() {
            return this.links.get("last");
        }
    }
}

