/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.enterprise;

import com.oracle.iot.client.DeviceModelAttribute;
import com.oracle.iot.client.DeviceModelFormat;
import com.oracle.iot.client.HttpResponse;
import com.oracle.iot.client.RestApi;
import com.oracle.iot.client.impl.DeviceModelImpl;
import com.oracle.iot.client.impl.StorageConnectionBase;
import com.oracle.iot.client.impl.TimeManager;
import com.oracle.iot.client.impl.VirtualDeviceBase;
import com.oracle.iot.client.impl.enterprise.StorageObjectImpl;
import com.oracle.iot.client.impl.enterprise.VirtualDeviceAttributeImpl;
import com.oracle.iot.client.impl.enterprise.VirtualDeviceImpl;
import com.oracle.iot.client.impl.http.HttpSecureConnection;
import com.oracle.iot.client.message.StatusCode;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.iot.client.AbstractVirtualDevice;
import oracle.iot.client.ExternalObject;
import oracle.iot.client.enterprise.UserAuthenticationException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class Monitor
implements Runnable {
    private static final String BULKDATA_RESOURCE_FORMAT = RestApi.V2.getReqRoot() + "/apps/%1$s/devices/data?formatLimit=%2$d";
    private static final Object MONITOR_LOCK = new Object();
    private static Monitor monitor;
    private volatile boolean running;
    private AtomicLong lastUntil = new AtomicLong();
    private final List<MonitoredDevice> monitoredDeviceList;
    private final Map<String, List<MonitoredDevice>> appDeviceMap;
    private static final String MONITOR_POLLING_INTERVAL = "oracle.iot.client.enterprise.monitor_polling_interval";
    private final int pollingInterval;
    private static final String MONITOR_MAX_FORMATS = "oracle.iot.client.enterprise.monitor_max_formats";
    private final int maxFormats;
    private final Executor executor = Executors.newCachedThreadPool(new NotifierThreadFactory());
    private static final Logger LOGGER;

    private Monitor() {
        this.appDeviceMap = new HashMap<String, List<MonitoredDevice>>();
        this.monitoredDeviceList = new ArrayList<MonitoredDevice>();
        Integer val = Integer.getInteger(MONITOR_POLLING_INTERVAL);
        this.pollingInterval = val != null && val > 0 ? val : 3000;
        val = Integer.getInteger(MONITOR_MAX_FORMATS);
        this.maxFormats = val != null && val > 0 ? val : 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startMonitor(VirtualDeviceImpl virtualDevice, NotifyHandler handler) throws IOException, GeneralSecurityException {
        if (virtualDevice == null) {
            throw new IllegalArgumentException("The virtualDevice argument cannot be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("The handler argument cannot be null");
        }
        Object object = MONITOR_LOCK;
        synchronized (object) {
            if (monitor == null) {
                monitor = new Monitor();
                Monitor.monitor.running = true;
                Thread monitorThread = new Thread(monitor);
                monitorThread.setDaemon(true);
                monitorThread.start();
            }
        }
        String appid = virtualDevice.getEnterpriseClient().getApplication().getId();
        try {
            Monitor.getLogger().log(Level.FINEST, "Getting last known values for device " + virtualDevice.getEndpointId() + " model " + virtualDevice.getDeviceModel().getURN());
            monitor.processInitialBulkData(appid, virtualDevice, handler);
        }
        catch (IOException ioe) {
            Monitor.getLogger().log(Level.SEVERE, "Cannot get attributes for virtual device " + virtualDevice.getEndpointId() + " model " + virtualDevice.getDeviceModel().getURN());
            throw ioe;
        }
        catch (GeneralSecurityException gse) {
            Monitor.getLogger().log(Level.SEVERE, "Cannot get attributes for virtual device " + virtualDevice.getEndpointId() + " model " + virtualDevice.getDeviceModel().getURN());
            throw gse;
        }
        Monitor.getLogger().log(Level.FINEST, "Starting to monitor virtualDevice " + virtualDevice.getDeviceModel().getURN() + " " + virtualDevice.getEndpointId());
        Object object2 = MONITOR_LOCK;
        synchronized (object2) {
            List<MonitoredDevice> appdevices = Monitor.monitor.appDeviceMap.get(appid);
            if (appdevices == null) {
                appdevices = new ArrayList<MonitoredDevice>();
                Monitor.monitor.appDeviceMap.put(appid, appdevices);
            }
            MonitoredDevice monitoredDevice = new MonitoredDevice(virtualDevice, handler);
            appdevices.add(monitoredDevice);
            Monitor.monitor.monitoredDeviceList.add(monitoredDevice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ecClosed(String appId) {
        Object object = MONITOR_LOCK;
        synchronized (object) {
            if (monitor == null) {
                return;
            }
            List<MonitoredDevice> appdevices = Monitor.monitor.appDeviceMap.get(appId);
            if (appdevices == null) {
                return;
            }
            for (MonitoredDevice device : appdevices) {
                Monitor.monitor.monitoredDeviceList.remove(device);
            }
            Monitor.monitor.appDeviceMap.remove(appId);
            if (Monitor.monitor.appDeviceMap.isEmpty()) {
                Monitor.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        Object object = MONITOR_LOCK;
        synchronized (object) {
            if (monitor != null) {
                Monitor.getLogger().log(Level.FINEST, "Stopping Monitor");
                Monitor.monitor.running = false;
                monitor = null;
            }
        }
    }

    private byte[] bulkDataPayload(Object[] deviceList) {
        HashMap<String, JSONArray> jsonModels = new HashMap<String, JSONArray>();
        for (Object device : deviceList) {
            VirtualDeviceImpl virtualDevice = (VirtualDeviceImpl)device;
            String endpointId = virtualDevice.getEndpointId();
            String modelUrn = virtualDevice.getDeviceModel().getURN();
            JSONArray models = (JSONArray)jsonModels.get(endpointId);
            if (models == null) {
                models = new JSONArray().put(modelUrn);
                jsonModels.put(endpointId, models);
                continue;
            }
            models.put(modelUrn);
        }
        try {
            JSONObject payload = new JSONObject();
            Set endpoints = jsonModels.entrySet();
            for (Map.Entry entry : endpoints) {
                payload.put((String)entry.getKey(), entry.getValue());
            }
            return payload.toString().getBytes("UTF-8");
        }
        catch (Exception e) {
            Monitor.getLogger().log(Level.WARNING, "Exception converting json to bytes.", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Monitor.getLogger().log(Level.FINEST, "Starting Monitor");
        while (this.running) {
            HashMap<String, VirtualDeviceImpl[]> monitorMap = new HashMap<String, VirtualDeviceImpl[]>(this.appDeviceMap.size());
            Object object = MONITOR_LOCK;
            synchronized (object) {
                Set<Map.Entry<String, List<MonitoredDevice>>> entrySet = this.appDeviceMap.entrySet();
                for (Map.Entry<String, List<MonitoredDevice>> entry : entrySet) {
                    String appid = entry.getKey();
                    List<MonitoredDevice> monitoredDevices = entry.getValue();
                    if (monitoredDevices == null || monitoredDevices.isEmpty()) continue;
                    ArrayList<VirtualDeviceImpl> virtualDevices = new ArrayList<VirtualDeviceImpl>(monitoredDevices.size());
                    Iterator<MonitoredDevice> iterator = monitoredDevices.iterator();
                    while (iterator.hasNext()) {
                        MonitoredDevice md = iterator.next();
                        WeakReference<VirtualDeviceImpl> ref = md.deviceRef;
                        VirtualDeviceImpl vd = (VirtualDeviceImpl)ref.get();
                        if (vd == null) {
                            iterator.remove();
                            continue;
                        }
                        virtualDevices.add(vd);
                    }
                    if (virtualDevices.isEmpty()) continue;
                    monitorMap.put(appid, virtualDevices.toArray(new VirtualDeviceImpl[virtualDevices.size()]));
                }
            }
            Set entrySet = monitorMap.entrySet();
            for (Map.Entry entry : entrySet) {
                String appid = (String)entry.getKey();
                Object[] devices = (VirtualDeviceImpl[])entry.getValue();
                VirtualDeviceImpl virtualDevice = devices[0];
                HttpSecureConnection secureConnection = virtualDevice.getSecureConnection();
                if (secureConnection.isClosed()) {
                    Monitor.ecClosed(appid);
                    continue;
                }
                byte[] payload = this.bulkDataPayload(devices);
                if (payload != null) {
                    String resource = String.format(BULKDATA_RESOURCE_FORMAT, appid, this.maxFormats);
                    long since = this.lastUntil.get();
                    if (since != 0L) {
                        resource = resource.concat("&since=").concat(Long.toString(since));
                    }
                    try {
                        JSONObject jsonAttributes = this.request(secureConnection, "POST", resource, payload);
                        if (jsonAttributes != null) {
                            this.processBulkData(jsonAttributes);
                        }
                    }
                    catch (UserAuthenticationException ue) {
                        Monitor.getLogger().log(Level.FINEST, "Session Expired, User Authentication Exception thrown", ue);
                        entrySet.remove(entry);
                        throw new RuntimeException(ue);
                    }
                    catch (Exception e) {
                        if (secureConnection.isClosed()) {
                            Monitor.ecClosed(appid);
                        }
                        Monitor.getLogger().log(Level.WARNING, "Exception processing bulk json data", e);
                    }
                }
                try {
                    Thread.sleep(this.pollingInterval);
                }
                catch (InterruptedException e) {
                    Monitor.getLogger().log(Level.SEVERE, "Stopping monitor due to exception.", e);
                    this.running = false;
                    Thread.currentThread().interrupt();
                }
            }
        }
        Monitor.getLogger().log(Level.FINEST, "Monitor ending");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBulkData(JSONObject jsonData) {
        Object until = jsonData.opt("until");
        if (until == null) {
            Monitor.getLogger().log(Level.FINEST, "Monitor: until data in response");
        } else {
            this.lastUntil.set(((Number)until).longValue());
        }
        JSONObject jsonDevices = jsonData.optJSONObject("data");
        if (jsonDevices == null) {
            Monitor.getLogger().log(Level.FINEST, "Monitor: no bulk data in response");
            return;
        }
        ArrayList<MonitoredDevice> monitoredDevices = new ArrayList<MonitoredDevice>(this.monitoredDeviceList.size());
        Iterator iterator = MONITOR_LOCK;
        synchronized (iterator) {
            Iterator<MonitoredDevice> iterator2 = this.monitoredDeviceList.iterator();
            while (iterator2.hasNext()) {
                MonitoredDevice md = iterator2.next();
                WeakReference<VirtualDeviceImpl> ref = md.deviceRef;
                VirtualDeviceImpl vd = (VirtualDeviceImpl)ref.get();
                if (vd == null) {
                    iterator2.remove();
                    continue;
                }
                monitoredDevices.add(md);
            }
        }
        for (MonitoredDevice md : monitoredDevices) {
            String endpoint;
            JSONObject jsonDevice;
            NotifyHandler handler;
            WeakReference<VirtualDeviceImpl> ref = md.deviceRef;
            VirtualDeviceImpl vd = (VirtualDeviceImpl)ref.get();
            if (vd == null || (handler = md.handler) == null || (jsonDevice = jsonDevices.optJSONObject(endpoint = vd.getEndpointId())) == null) continue;
            String model = vd.getDeviceModel().getURN();
            JSONObject jsonModel = jsonDevice.optJSONObject(model);
            if (jsonModel != null) {
                this.processModelData(vd, jsonModel, handler);
                continue;
            }
            Monitor.getLogger().log(Level.WARNING, "Monitor: virtual device " + endpoint + " does not implement model " + model);
        }
    }

    private CustomMessage[] customMessagesFromJson(VirtualDeviceImpl vd, JSONObject jsonModelFormats) {
        if (jsonModelFormats == null) {
            return null;
        }
        ArrayList<CustomMessage> customMessages = new ArrayList<CustomMessage>();
        Map<String, DeviceModelFormat> deviceFormats = ((DeviceModelImpl)vd.getDeviceModel()).getDeviceModelFormats();
        for (DeviceModelFormat dmf : deviceFormats.values()) {
            JSONArray jsonAlerts = jsonModelFormats.optJSONArray(dmf.getURN());
            if (jsonAlerts == null) continue;
            int size = jsonAlerts.length();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonAlert = jsonAlerts.optJSONObject(i);
                Number jsonNumber = (Number)jsonAlert.opt("eventTime");
                long eventTime = jsonNumber.longValue();
                JSONObject jsonFields = jsonAlert.optJSONObject("fields");
                List<DeviceModelFormat.Field> dmffields = dmf.getFields();
                VirtualDeviceBase.NamedValueImpl<Object> fields = null;
                VirtualDeviceBase.NamedValueImpl<Object> last = null;
                for (DeviceModelFormat.Field dmff : dmffields) {
                    String fieldName = dmff.getName();
                    if (!jsonFields.has(fieldName)) continue;
                    Object value = this.jsonValueToDMAType(fieldName, jsonFields, dmff.getType(), vd);
                    VirtualDeviceBase.NamedValueImpl<Object> field = new VirtualDeviceBase.NamedValueImpl<Object>(fieldName, value);
                    if (last != null) {
                        last.setNext(field);
                        last = field;
                        continue;
                    }
                    fields = last = field;
                }
                customMessages.add(new CustomMessage(dmf.getURN(), dmf.getType(), eventTime, fields));
            }
        }
        return customMessages.toArray(new CustomMessage[customMessages.size()]);
    }

    private VirtualDeviceAttributeImpl[] deviceAttributesFromJson(VirtualDeviceImpl virtualDevice, JSONObject jsonAttributes) {
        Iterator<String> keys;
        Iterator<String> iterator = keys = jsonAttributes != null ? jsonAttributes.keys() : null;
        if (keys == null || !keys.hasNext()) {
            return null;
        }
        DeviceModelImpl dm = (DeviceModelImpl)virtualDevice.getDeviceModel();
        ArrayList attributes = new ArrayList();
        while (keys.hasNext()) {
            String attribute = keys.next();
            DeviceModelAttribute dma = dm.getDeviceModelAttributes().get(attribute);
            if (dma == null) {
                Monitor.getLogger().log(Level.WARNING, "Remote attribute " + attribute + " is not an attribute of model " + dm.getURN());
                return null;
            }
            VirtualDeviceAttributeImpl<?> vda = this.deviceAttributeFromJson(virtualDevice, dma, jsonAttributes);
            if (vda != null) {
                attributes.add(vda);
                continue;
            }
            Monitor.getLogger().log(Level.WARNING, "Failed to create VirtualDeviceAttribute for attribute " + attribute + " for model " + dm.getURN());
        }
        return attributes.toArray(new VirtualDeviceAttributeImpl[attributes.size()]);
    }

    private VirtualDeviceAttributeImpl<?> deviceAttributeFromJson(VirtualDeviceImpl virtualDevice, DeviceModelAttribute dma, JSONObject jsonAttributes) {
        if (dma == null) {
            return null;
        }
        try {
            Object value = this.jsonValueToDMAType(dma.getName(), jsonAttributes, dma.getType(), virtualDevice);
            return new VirtualDeviceAttributeImpl<Object>(virtualDevice, dma, value);
        }
        catch (Exception e) {
            Monitor.getLogger().log(Level.SEVERE, "Cannot create VirtualDeviceAttribute from json attribute for field " + dma.getName() + " in model " + virtualDevice.getDeviceModel().getURN(), e);
            return null;
        }
    }

    private Object jsonValueToDMAType(String fieldName, JSONObject jsonObjects, DeviceModelAttribute.Type type, VirtualDeviceImpl virtualDevice) {
        Object value = null;
        try {
            switch (type) {
                case NUMBER: {
                    value = jsonObjects.getDouble(fieldName);
                    break;
                }
                case STRING: {
                    value = jsonObjects.getString(fieldName);
                    break;
                }
                case BOOLEAN: {
                    value = jsonObjects.getBoolean(fieldName);
                    break;
                }
                case INTEGER: {
                    value = jsonObjects.getInt(fieldName);
                    break;
                }
                case DATETIME: {
                    value = new Date(jsonObjects.getLong(fieldName));
                    break;
                }
                case URI: {
                    String uri = jsonObjects.getString(fieldName);
                    if (StorageConnectionBase.isStorageCloudURI(uri)) {
                        try {
                            StorageObjectImpl storageObjectImpl = (StorageObjectImpl)virtualDevice.getEnterpriseClient().createStorageObject(uri);
                            storageObjectImpl.setSyncEventInfo(virtualDevice, fieldName);
                            value = storageObjectImpl;
                            break;
                        }
                        catch (Exception e) {
                            Monitor.getLogger().log(Level.WARNING, "Storage CS object access failed: " + e.getMessage());
                        }
                    }
                    value = new ExternalObject(uri);
                }
            }
            return value;
        }
        catch (Exception e) {
            Monitor.getLogger().log(Level.SEVERE, "Cannot determine type from from json attribute for field " + fieldName, e);
            return null;
        }
    }

    private JSONObject request(HttpSecureConnection secureConnection, String method, String resource, byte[] payload) throws IOException, GeneralSecurityException {
        HttpResponse response;
        if ("GET".equals(method)) {
            response = secureConnection.get(resource);
        } else if ("POST".equals(method)) {
            response = secureConnection.post(resource, payload);
        } else {
            throw new IOException(method + " " + resource + ": method not supported.");
        }
        int status = response.getStatus();
        JSONObject jsonAttributes = null;
        if (status == StatusCode.OK.getCode()) {
            Monitor.getLogger().log(Level.FINEST, "Monitor " + method + " " + resource + " received 'HTTP " + status + ", data.length = " + response.getData().length);
            byte[] data = response.getData();
            if (data != null && data.length > 2) {
                String json = new String(data, "UTF-8");
                try {
                    jsonAttributes = new JSONObject(json);
                }
                catch (JSONException je) {
                    if (Monitor.getLogger().isLoggable(Level.WARNING)) {
                        Monitor.getLogger().log(Level.WARNING, "Monitor " + method + " " + resource + " could nor parse json response", je);
                    }
                    return null;
                }
            }
        } else {
            if (status == StatusCode.NOT_FOUND.getCode()) {
                Monitor.getLogger().info(response.getVerboseStatus(method, resource));
                throw new IOException(method + " " + resource + ": Endpoint cannot be virtualized");
            }
            if (status == StatusCode.FORBIDDEN.getCode()) {
                Monitor.getLogger().info(response.getVerboseStatus(method, resource));
                throw new IOException(method + " " + resource + ": Invalid virtual device");
            }
            throw new IOException(response.getVerboseStatus(method, resource));
        }
        return jsonAttributes;
    }

    private void processInitialBulkData(String appid, VirtualDeviceImpl virtualDevice, NotifyHandler handler) throws IOException, GeneralSecurityException {
        HttpSecureConnection secureConnection = virtualDevice.getSecureConnection();
        byte[] payload = this.bulkDataPayload(new Object[]{virtualDevice});
        if (payload != null) {
            JSONObject jsonBulkData;
            String resource = String.format(BULKDATA_RESOURCE_FORMAT, appid, 0);
            long since = this.lastUntil.get();
            if (since == 0L) {
                since = TimeManager.currentTimeMillis() - (long)this.pollingInterval;
            }
            if ((jsonBulkData = this.request(secureConnection, "POST", resource = resource.concat("&formatSince=").concat(Long.toString(since)), payload)) != null) {
                this.processInitialBulkData(virtualDevice, jsonBulkData, handler);
            } else {
                throw new IOException("POST " + resource + ": No data for " + virtualDevice.getEndpointId() + " model " + virtualDevice.getDeviceModel().getURN());
            }
        }
    }

    private void processModelData(VirtualDeviceImpl vd, JSONObject jsonModel, NotifyHandler handler) {
        JSONObject jsonCustomMessages;
        CustomMessage[] customMessages;
        JSONObject jsonAttributes = jsonModel.optJSONObject("attributes");
        VirtualDeviceAttributeImpl[] attributes = this.deviceAttributesFromJson(vd, jsonAttributes);
        if (attributes != null && attributes.length > 0) {
            this.executor.execute(new OnChangeNotifier(handler, vd, attributes));
        }
        if ((customMessages = this.customMessagesFromJson(vd, jsonCustomMessages = jsonModel.optJSONObject("formats"))) != null) {
            for (CustomMessage cm : customMessages) {
                if (cm.type == DeviceModelFormat.Type.ALERT) {
                    this.executor.execute(new OnAlertNotifier(handler, vd, cm.formatUrn, cm.eventTime, cm.namedValues));
                    continue;
                }
                this.executor.execute(new OnDataNotifier(handler, vd, cm.formatUrn, cm.eventTime, cm.namedValues));
            }
        }
    }

    private void processInitialBulkData(VirtualDeviceImpl vd, JSONObject jsonData, NotifyHandler handler) {
        Number until;
        JSONObject jsonDevices;
        try {
            jsonDevices = jsonData.getJSONObject("data");
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        JSONObject jsonDevice = jsonDevices.optJSONObject(vd.getEndpointId());
        if (this.lastUntil.get() == 0L && (until = (Number)jsonData.opt("until")) != null) {
            this.lastUntil.set(until.longValue());
        }
        if (jsonDevice == null) {
            if (!((DeviceModelImpl)vd.getDeviceModel()).getDeviceModelAttributes().isEmpty()) {
                throw new IllegalArgumentException(vd.getEndpointId() + " is not ready for virtualization");
            }
            return;
        }
        String model = vd.getDeviceModel().getURN();
        JSONObject jsonModel = jsonDevice.optJSONObject(model);
        if (jsonModel == null) {
            throw new IllegalArgumentException(vd.getEndpointId() + " does not implement " + model);
        }
        this.processModelData(vd, jsonModel, handler);
    }

    private static Logger getLogger() {
        return LOGGER;
    }

    static {
        LOGGER = Logger.getLogger("oracle.iot.client");
    }

    private static class OnDataNotifier
    implements Runnable {
        private final NotifyHandler handler;
        private final VirtualDeviceImpl virtualDevice;
        private final String formatURN;
        private final long eventTime;
        private final AbstractVirtualDevice.NamedValue<?> namedValues;

        private OnDataNotifier(NotifyHandler handler, VirtualDeviceImpl virtualDevice, String formatURN, long eventTime, AbstractVirtualDevice.NamedValue<?> namedValues) {
            this.handler = handler;
            this.virtualDevice = virtualDevice;
            this.formatURN = formatURN;
            this.eventTime = eventTime;
            this.namedValues = namedValues;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            NotifyHandler notifyHandler = this.handler;
            synchronized (notifyHandler) {
                this.handler.notifyOnData(this.virtualDevice, this.formatURN, this.eventTime, this.namedValues);
            }
        }
    }

    private static class OnAlertNotifier
    implements Runnable {
        private final NotifyHandler handler;
        private final VirtualDeviceImpl virtualDevice;
        private final String formatURN;
        private final long eventTime;
        private final AbstractVirtualDevice.NamedValue<?> namedValues;

        private OnAlertNotifier(NotifyHandler handler, VirtualDeviceImpl virtualDevice, String formatURN, long eventTime, AbstractVirtualDevice.NamedValue<?> namedValues) {
            this.handler = handler;
            this.virtualDevice = virtualDevice;
            this.formatURN = formatURN;
            this.eventTime = eventTime;
            this.namedValues = namedValues;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            NotifyHandler notifyHandler = this.handler;
            synchronized (notifyHandler) {
                this.handler.notifyOnAlert(this.virtualDevice, this.formatURN, this.eventTime, this.namedValues);
            }
        }
    }

    private static class OnChangeNotifier
    implements Runnable {
        private final NotifyHandler handler;
        private final VirtualDeviceImpl virtualDevice;
        private final VirtualDeviceAttributeImpl[] attributes;

        private OnChangeNotifier(NotifyHandler handler, VirtualDeviceImpl virtualDevice, VirtualDeviceAttributeImpl[] attributes) {
            this.handler = handler;
            this.virtualDevice = virtualDevice;
            this.attributes = attributes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            NotifyHandler notifyHandler = this.handler;
            synchronized (notifyHandler) {
                this.handler.notifyOnChange(this.virtualDevice, this.attributes);
            }
        }
    }

    static class NotifierThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        NotifierThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "notifier-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    static final class CustomMessage {
        final String formatUrn;
        final DeviceModelFormat.Type type;
        final long eventTime;
        final AbstractVirtualDevice.NamedValue<?> namedValues;

        CustomMessage(String formatUrn, DeviceModelFormat.Type type, long eventTime, AbstractVirtualDevice.NamedValue<?> namedValues) {
            this.formatUrn = formatUrn;
            this.type = type;
            this.eventTime = eventTime;
            this.namedValues = namedValues;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("format: ").append(this.formatUrn).append("\n").append("type: ").append((Object)this.type).append("\n").append("eventTime: ").append(this.eventTime).append("\n").append("fields:\n");
            for (AbstractVirtualDevice.NamedValue<?> namedValue = this.namedValues; namedValue != null; namedValue = namedValue.next()) {
                sb.append("  ").append(namedValue.getName()).append(" : ").append(String.valueOf(namedValue.getValue())).append("\n");
            }
            return sb.toString();
        }
    }

    static class MonitoredDevice {
        final WeakReference<VirtualDeviceImpl> deviceRef;
        final NotifyHandler handler;

        MonitoredDevice(VirtualDeviceImpl device, NotifyHandler handler) {
            this.deviceRef = new WeakReference<VirtualDeviceImpl>(device);
            this.handler = handler;
        }
    }

    static interface NotifyHandler {
        public void notifyOnChange(VirtualDeviceImpl var1, VirtualDeviceAttributeImpl<?>[] var2);

        public void notifyOnAlert(VirtualDeviceImpl var1, String var2, long var3, AbstractVirtualDevice.NamedValue<?> var5);

        public void notifyOnData(VirtualDeviceImpl var1, String var2, long var3, AbstractVirtualDevice.NamedValue<?> var5);
    }
}

