/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.enterprise;

import com.oracle.iot.client.enterprise.MessageEnumerator;
import com.oracle.iot.client.impl.enterprise.MessageIterator;
import com.oracle.iot.client.impl.http.HttpSecureConnection;
import com.oracle.iot.client.message.Message;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.iot.client.enterprise.Pageable;

public final class MessagePoller
implements Runnable {
    private static final int DEFAULT_POLL_INTERVAL = 3000;
    private static final int MIN_PAGE_SIZE = 10;
    private static final int MAX_PAGE_SIZE = 200;
    private static final int pollInterval;
    private static final int limit;
    private static final HashMap<String, RestParameters> listeners;
    private static boolean running;
    private static final Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setListener(String appID, HttpSecureConnection secureConnection, String deviceId, Message.Type type, MessageEnumerator.MessageListener listener) throws IllegalStateException, IOException, GeneralSecurityException {
        if (listener == null) {
            MessagePoller.removeListener(deviceId);
            return;
        }
        HashMap<String, RestParameters> hashMap = listeners;
        synchronized (hashMap) {
            if (listeners.containsKey(deviceId)) {
                throw new IllegalStateException("Already listening for device " + deviceId);
            }
        }
        RestParameters rp = new RestParameters(appID, secureConnection, deviceId, type, listener);
        rp.since = MessagePoller.getStartTime(rp);
        HashMap<String, RestParameters> hashMap2 = listeners;
        synchronized (hashMap2) {
            if (!running) {
                running = true;
                Thread t = new Thread(new MessagePoller());
                t.setDaemon(true);
                t.start();
            }
        }
        hashMap2 = listeners;
        synchronized (hashMap2) {
            listeners.put(deviceId, rp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeListener(String deviceId) {
        HashMap<String, RestParameters> hashMap = listeners;
        synchronized (hashMap) {
            listeners.remove(deviceId);
        }
    }

    private static long getStartTime(RestParameters rp) throws IOException, GeneralSecurityException {
        MessageIterator messages = new MessageIterator(rp.appID, 0, 1, rp.deviceID, rp.type, true, 0L, 0L, rp.secureConnection, true);
        if (!messages.hasMore()) {
            return 0L;
        }
        return ((Message)messages.next().elements().iterator().next()).getReceivedTime() + 1L;
    }

    private static Pageable<Message> poll(RestParameters rp) throws IOException, GeneralSecurityException {
        if (rp.messages == null || !rp.messages.hasMore()) {
            rp.messages = new MessageIterator(rp.appID, 0, limit, rp.deviceID, rp.type, true, rp.since, 0L, rp.secureConnection, false);
        }
        return rp.messages;
    }

    private MessagePoller() {
    }

    @Override
    public void run() {
        MessagePoller.poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void poll() {
        while (running) {
            boolean sleep;
            ArrayList<RestParameters> list = null;
            HashMap<String, RestParameters> hashMap = listeners;
            synchronized (hashMap) {
                sleep = true;
                list = new ArrayList<RestParameters>(listeners.values());
            }
            for (RestParameters rp : list) {
                try {
                    Pageable<Message> messages = MessagePoller.poll(rp);
                    if (!messages.hasMore()) continue;
                    List elements = (List)(messages = messages.next()).elements();
                    int size = elements.size();
                    if (size > 0 && rp.lastMsgId != null) {
                        Message m;
                        int i;
                        for (i = 0; i < size && !(m = (Message)elements.get(i)).getId().equals(rp.lastMsgId); ++i) {
                            if (m.getReceivedTime() <= rp.since) continue;
                            i = size;
                            break;
                        }
                        if (i < size) {
                            while (i >= 0) {
                                elements.remove(0);
                                --i;
                            }
                        }
                        size = elements.size();
                    }
                    if (size == 0) {
                        rp.lastMsgId = null;
                        ++rp.since;
                        continue;
                    }
                    rp.listener.notify(elements);
                    Message last = (Message)elements.get(elements.size() - 1);
                    rp.lastMsgId = last.getId();
                    rp.since = last.getReceivedTime();
                    if (!messages.hasMore()) continue;
                    sleep = false;
                }
                catch (Exception ignored) {
                    MessagePoller.getLogger().log(Level.SEVERE, ignored.toString(), ignored);
                }
            }
            try {
                if (!sleep) continue;
                hashMap = listeners;
                synchronized (hashMap) {
                    listeners.wait(pollInterval);
                }
            }
            catch (InterruptedException e) {
                HashMap<String, RestParameters> hashMap2 = listeners;
                synchronized (hashMap2) {
                    running = false;
                }
            }
        }
    }

    private static Logger getLogger() {
        return LOGGER;
    }

    static {
        Integer val = Integer.getInteger("com.oracle.iot.client.enterprise.message_polling_interval");
        pollInterval = val != null && val > 0 ? val : 3000;
        val = Integer.getInteger("com.oracle.iot.client.enterprise.message_polling_limit");
        limit = val != null ? Math.min(200, Math.max(10, val)) : 10;
        listeners = new HashMap(10);
        running = false;
        LOGGER = Logger.getLogger("oracle.iot.client");
    }

    private static class RestParameters {
        final String appID;
        final HttpSecureConnection secureConnection;
        final String deviceID;
        final Message.Type type;
        final MessageEnumerator.MessageListener listener;
        long since;
        String lastMsgId;
        Pageable<Message> messages;

        RestParameters(String appID, HttpSecureConnection secureConnection, String deviceID, Message.Type type, MessageEnumerator.MessageListener listener) {
            this.appID = appID;
            this.secureConnection = secureConnection;
            this.deviceID = deviceID;
            this.type = type;
            this.listener = listener;
        }
    }
}

