/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.enterprise;

import com.oracle.iot.client.RestApi;
import com.oracle.iot.client.impl.enterprise.DeviceImpl;
import com.oracle.iot.client.impl.enterprise.PageableEnumerator;
import com.oracle.iot.client.impl.http.HttpSecureConnection;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.iot.client.enterprise.Device;
import oracle.iot.client.enterprise.Filter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class DeviceEnumerator
extends PageableEnumerator<Device> {
    private final boolean includeDecommissioned;
    private final Set<Device.Field> fields;
    private final Filter filter;
    private final String appID;
    private final HttpSecureConnection secureConnection;
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");

    public DeviceEnumerator(String appID, int offset, int limit, boolean includeDecommissioned, Set<Device.Field> fields, Filter filter, HttpSecureConnection secureConnection) throws IOException, GeneralSecurityException {
        super(offset, limit);
        this.appID = appID;
        this.fields = fields;
        this.filter = filter;
        this.includeDecommissioned = includeDecommissioned;
        this.secureConnection = secureConnection;
        this.setSize(this.getCount());
    }

    private int getCount() {
        DeviceEnumerationRequest req = new DeviceEnumerationRequest(this.appID, "count", this.offset, this.limit, this.includeDecommissioned, this.fields, this.filter);
        try {
            JSONObject jsonObject = this.get(req.headers(), req.request());
            return jsonObject.optInt("count", -1);
        }
        catch (IOException ignored) {
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
        return -1;
    }

    @Override
    protected PageableEnumerator.PagedResponse<Device> load(int offset, int limit) throws IOException {
        DeviceEnumerationRequest req = new DeviceEnumerationRequest(this.appID, null, offset, limit, this.includeDecommissioned, this.fields, this.filter);
        try {
            JSONObject jsonObject = this.get(req.headers(), req.request());
            return DeviceEnumerationResponse.fromJson(jsonObject);
        }
        catch (JSONException e) {
            throw new IOException("GET " + req.request() + ": " + e.getMessage());
        }
        catch (GeneralSecurityException e) {
            throw new IOException("GET " + req.request() + ": " + e.getMessage());
        }
    }

    @Override
    protected HttpSecureConnection getSecureConnection() {
        return this.secureConnection;
    }

    private static Logger getLogger() {
        return LOGGER;
    }

    public static class DeviceEnumerationResponse
    extends PageableEnumerator.PagedResponse<Device> {
        private DeviceEnumerationResponse(Collection<Device> devices, int offset, int total, boolean hasMore, Map<String, String> links) {
            super(devices, offset, total, hasMore, links);
        }

        public static DeviceEnumerationResponse fromJson(JSONObject jsonObject) throws JSONException {
            try {
                JSONArray items = (JSONArray)jsonObject.opt("items");
                JSONArray links = (JSONArray)jsonObject.opt("links");
                boolean hasMore = jsonObject.optBoolean("hasMore", false);
                int offset = jsonObject.optInt("offset", -1);
                int total = jsonObject.optInt("totalResults", -1);
                ArrayList<Device> list = new ArrayList<Device>();
                if (items != null) {
                    int size = items.length();
                    for (int i = 0; i < size; ++i) {
                        Object item = items.opt(i);
                        list.add(DeviceImpl.from((JSONObject)item));
                    }
                }
                HashMap<String, String> map = new HashMap<String, String>();
                if (links != null) {
                    int size = links.length();
                    for (int i = 0; i < size; ++i) {
                        JSONObject object = (JSONObject)links.opt(i);
                        String rel = object.optString("rel", null);
                        String href = object.optString("href", null);
                        if (rel == null || href == null) continue;
                        map.put(rel, href);
                    }
                }
                return new DeviceEnumerationResponse((Collection<Device>)list, offset, total, hasMore, (Map<String, String>)map);
            }
            catch (ClassCastException e) {
                throw new JSONException("Incorrect response format");
            }
        }
    }

    public static class DeviceEnumerationRequest {
        private static final Map<String, String> headers = new HashMap<String, String>();
        private final String request;

        public DeviceEnumerationRequest(int offset, int limit, boolean includeDecommissioned, Set<Device.Field> fields, Filter filter) {
            this(null, null, offset, limit, includeDecommissioned, fields, filter);
        }

        public DeviceEnumerationRequest(String applicationID, int offset, int limit, boolean includeDecommissioned, Set<Device.Field> fields, Filter filter) {
            this(applicationID, null, offset, limit, includeDecommissioned, fields, filter);
        }

        public DeviceEnumerationRequest(String applicationID, String path, int offset, int limit, boolean includeDecommissioned, Set<Device.Field> fields, Filter filter) {
            int queryPos;
            String sep = "?";
            String req = applicationID == null ? RestApi.V2.getReqRoot() : RestApi.V2.getReqRoot() + "/apps/" + applicationID;
            req = req + "/devices";
            if (path != null) {
                req = req + "/" + path;
            }
            if (limit > 0) {
                req = req + sep + "limit=" + limit;
                sep = "&";
            }
            if (offset > 0) {
                req = req + sep + "offset=" + offset;
                sep = "&";
            }
            req = req + sep + "includeDecommissioned=" + includeDecommissioned;
            req = req + "&totalResults=true";
            req = req + "&expand=location,metadata";
            HashSet<Device.Field> reqFields = fields != null ? new HashSet<Device.Field>(fields) : new HashSet();
            reqFields.add(Device.Field.TYPE);
            reqFields.add(Device.Field.ID);
            if (fields != null) {
                req = req + "&fields=";
                req = req + this.joinFields(",", reqFields);
            }
            if (filter != null) {
                req = req + "&q=";
                req = req + filter.toString();
            }
            if ((queryPos = req.indexOf(63)) > 0) {
                String p = req.substring(0, queryPos);
                String query = req.substring(queryPos + 1, req.length());
                try {
                    URI uri = new URI(null, null, p, query, null);
                    req = uri.toString();
                }
                catch (URISyntaxException e) {
                    DeviceEnumerator.getLogger().log(Level.SEVERE, e.toString());
                }
            }
            this.request = req;
        }

        private String joinFields(String delimiter, Iterable<Device.Field> list) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Device.Field f : list) {
                if (first) {
                    first = false;
                } else {
                    sb.append(delimiter);
                }
                sb.append(f.alias());
            }
            return sb.toString();
        }

        public String request() {
            return this.request;
        }

        public Map<String, String> headers() {
            return headers;
        }

        public String toString() {
            return "DeviceEnumerationRequest: " + this.request();
        }

        static {
            headers.put("Content-Type", "application/json");
            headers.put("Accept", "application/json");
        }
    }
}

