/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.enterprise;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.iot.client.enterprise.Application;
import org.json.JSONException;
import org.json.JSONObject;

public class ApplicationImpl
extends Application {
    private final String id;
    private final String name;
    private final String description;
    private final Map<String, String> metadata;

    private ApplicationImpl(String id, String name, String description, Map<String, String> metadata) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.metadata = metadata;
    }

    public static Application fromJson(JSONObject object) throws JSONException {
        try {
            HashMap<String, String> mt = new HashMap<String, String>();
            JSONObject metadata = object.optJSONObject("metadata");
            if (metadata != null) {
                Iterator<String> keys = metadata.keys();
                while (keys.hasNext()) {
                    String key = keys.next();
                    mt.put(key, metadata.opt(key).toString());
                }
            }
            return new ApplicationImpl(object.getString("id"), object.getString("name"), object.optString("description", ""), mt);
        }
        catch (NullPointerException e) {
            throw new JSONException("field is missing");
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getMetadata(String key) {
        return this.metadata.get(key);
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }
}

