/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl;

import com.oracle.iot.client.impl.TimeManager;
import org.json.JSONException;
import org.json.JSONObject;

public class AccessToken {
    private final long expires;
    private final String tokenType;
    private final String token;
    private final long expirationTime;

    public AccessToken(long expires, String tokenType, String token) {
        this.expires = expires;
        this.tokenType = tokenType;
        this.token = token;
        this.expirationTime = TimeManager.currentTimeMillis() + expires;
    }

    public final boolean hasExpired() {
        return TimeManager.currentTimeMillis() >= this.expirationTime;
    }

    public long getExpires() {
        return this.expires;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public String getToken() {
        return this.token;
    }

    public String toString() {
        return "Accessor.Token{expires=" + this.expires + ", tokenType='" + this.tokenType + '\'' + ", token='" + this.token + '\'' + '}';
    }

    public static AccessToken fromJson(JSONObject jsonObject) {
        try {
            return new AccessToken(jsonObject.getInt("expires_in"), jsonObject.getString("token_type"), jsonObject.getString("access_token"));
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }
}

