/*
 * Decompiled with CFR 0.152.
 */
package oracle.iot.client.device;

import com.oracle.iot.client.device.persistence.BatchByPersistence;
import com.oracle.iot.client.device.persistence.MessagePersistence;
import com.oracle.iot.client.device.util.MessageDispatcher;
import com.oracle.iot.client.impl.DeviceModelImpl;
import com.oracle.iot.client.impl.device.MessageDispatcherImpl;
import com.oracle.iot.client.impl.device.StorageObjectImpl;
import com.oracle.iot.client.impl.device.VirtualDeviceImpl;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.logging.Logger;
import oracle.iot.client.Client;
import oracle.iot.client.DeviceModel;
import oracle.iot.client.StorageObject;
import oracle.iot.client.device.VirtualDevice;

public class DirectlyConnectedDevice
extends Client<VirtualDevice> {
    final com.oracle.iot.client.device.DirectlyConnectedDevice dcdImpl;
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");

    public DirectlyConnectedDevice() throws GeneralSecurityException {
        this(null);
    }

    public DirectlyConnectedDevice(Object context) throws GeneralSecurityException {
        super(context);
        this.dcdImpl = new com.oracle.iot.client.device.DirectlyConnectedDevice(context);
        MessagePersistence messagePersistence = MessagePersistence.initMessagePersistence(context);
        BatchByPersistence batchByPersistence = BatchByPersistence.initBatchByPersistence(messagePersistence);
        this.bootstrapMessageDispatcher();
    }

    public DirectlyConnectedDevice(String configFilePath, String configFilePassword) throws GeneralSecurityException {
        this(configFilePath, configFilePassword, null);
    }

    public DirectlyConnectedDevice(String configFilePath, String configFilePassword, Object context) throws GeneralSecurityException {
        super(context);
        this.dcdImpl = new com.oracle.iot.client.device.DirectlyConnectedDevice(configFilePath, configFilePassword, context);
        MessagePersistence messagePersistence = MessagePersistence.initMessagePersistence(context);
        BatchByPersistence batchByPersistence = BatchByPersistence.initBatchByPersistence(messagePersistence);
        this.bootstrapMessageDispatcher();
    }

    DirectlyConnectedDevice(com.oracle.iot.client.device.DirectlyConnectedDevice dcdImpl, Object context) {
        super(context);
        this.dcdImpl = dcdImpl;
        MessagePersistence messagePersistence = MessagePersistence.initMessagePersistence(context);
        BatchByPersistence batchByPersistence = BatchByPersistence.initBatchByPersistence(messagePersistence);
        this.bootstrapMessageDispatcher();
    }

    public final void activate(String ... deviceModels) throws IOException, GeneralSecurityException {
        String[] dmArray = new String[deviceModels != null ? deviceModels.length + 3 : 3];
        dmArray[0] = "urn:oracle:iot:dcd:capability:diagnostics";
        dmArray[1] = "urn:oracle:iot:dcd:capability:message_dispatcher";
        dmArray[2] = "urn:oracle:iot:dcd:capability:device_policy";
        if (deviceModels != null) {
            System.arraycopy(deviceModels, 0, dmArray, 3, deviceModels.length);
        }
        this.dcdImpl.activate(dmArray);
        this.bootstrapMessageDispatcher();
    }

    public final boolean isActivated() {
        return this.dcdImpl.isActivated();
    }

    public final String getEndpointId() {
        return this.dcdImpl.getEndpointId();
    }

    @Override
    public final VirtualDevice createVirtualDevice(String endpointId, DeviceModel deviceModel) {
        if (endpointId == null) {
            throw new NullPointerException("endpointId may not be null");
        }
        if (deviceModel == null) {
            throw new NullPointerException("deviceModel may not be null");
        }
        if (!(deviceModel instanceof DeviceModelImpl)) {
            throw new IllegalArgumentException("device model must be an instanceof com.oracle.iot.client.impl.DeviceModelImpl");
        }
        return new VirtualDeviceImpl(this.dcdImpl, endpointId, (DeviceModelImpl)deviceModel);
    }

    @Override
    public final DeviceModel getDeviceModel(String deviceModelUrn) throws IOException, GeneralSecurityException {
        DeviceModel deviceModel = this.dcdImpl.getDeviceModel(deviceModelUrn);
        return deviceModel;
    }

    @Override
    public void close() throws IOException {
        try {
            MessageDispatcher messageDispatcher;
            if (this.isActivated() && (messageDispatcher = MessageDispatcher.removeMessageDispatcher(this.dcdImpl)) != null) {
                messageDispatcher.close();
            }
        }
        finally {
            this.dcdImpl.close();
        }
    }

    @Override
    public StorageObject createStorageObject(String name, String contentType) throws IOException, GeneralSecurityException {
        com.oracle.iot.client.StorageObject delegate = this.dcdImpl.createStorageObject(name, contentType);
        return new StorageObjectImpl(this.dcdImpl, delegate);
    }

    private void bootstrapMessageDispatcher() {
        if (!this.isActivated()) {
            return;
        }
        MessageDispatcherImpl messageDispatcher = new MessageDispatcherImpl(this.dcdImpl);
        MessageDispatcher.setMessageDispatcher(this.dcdImpl, messageDispatcher);
    }

    private static Logger getLogger() {
        return LOGGER;
    }
}

