/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.device;

import com.oracle.iot.client.DeviceModelAction;
import com.oracle.iot.client.DeviceModelAttribute;
import com.oracle.iot.client.DeviceModelFormat;
import com.oracle.iot.client.StorageObject;
import com.oracle.iot.client.VirtualDeviceAttribute;
import com.oracle.iot.client.device.DirectlyConnectedDevice;
import com.oracle.iot.client.device.util.MessageDispatcher;
import com.oracle.iot.client.device.util.RequestDispatcher;
import com.oracle.iot.client.device.util.RequestHandler;
import com.oracle.iot.client.impl.DeviceModelImpl;
import com.oracle.iot.client.impl.StorageConnectionBase;
import com.oracle.iot.client.impl.VirtualDeviceAttributeBase;
import com.oracle.iot.client.impl.VirtualDeviceBase;
import com.oracle.iot.client.impl.device.AlertImpl;
import com.oracle.iot.client.impl.device.DataImpl;
import com.oracle.iot.client.impl.device.DeviceAnalog;
import com.oracle.iot.client.impl.device.DeviceFunction;
import com.oracle.iot.client.impl.device.DevicePolicy;
import com.oracle.iot.client.impl.device.DevicePolicyManager;
import com.oracle.iot.client.impl.device.MessageDispatcherImpl;
import com.oracle.iot.client.impl.device.StorageObjectImpl;
import com.oracle.iot.client.impl.device.VirtualDeviceAttributeImpl;
import com.oracle.iot.client.impl.util.Pair;
import com.oracle.iot.client.impl.util.WritableValue;
import com.oracle.iot.client.message.AlertMessage;
import com.oracle.iot.client.message.DataItem;
import com.oracle.iot.client.message.DataMessage;
import com.oracle.iot.client.message.Message;
import com.oracle.iot.client.message.RequestMessage;
import com.oracle.iot.client.message.ResponseMessage;
import com.oracle.iot.client.message.StatusCode;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.iot.client.AbstractVirtualDevice;
import oracle.iot.client.DeviceModel;
import oracle.iot.client.ExternalObject;
import oracle.iot.client.StorageObject;
import oracle.iot.client.device.Alert;
import oracle.iot.client.device.Data;
import oracle.iot.client.device.VirtualDevice;
import org.json.JSONException;
import org.json.JSONObject;

public final class VirtualDeviceImpl
extends VirtualDevice
implements VirtualDeviceBase.Adapter<VirtualDevice>,
DeviceAnalog,
RequestHandler,
DevicePolicyManager.ChangeListener {
    private final VirtualDeviceBase<VirtualDevice> base;
    final DirectlyConnectedDevice directlyConnectedDevice;
    private final DevicePolicyManager devicePolicyManager;
    private final Map<String, VirtualDeviceAttributeBase<VirtualDevice, Object>> attributeMap;
    private final Map<String, List<Map<String, Object>>> pipelineDataCache;
    private final Object UPDATE_LOCK = new int[0];
    private static final ErrorCallbackBridge ERROR_CALLBACK_BRIDGE = new ErrorCallbackBridge();
    private static final MessageDispatcher.DeliveryCallback DELIVERY_CALLBACK = new MessageDispatcher.DeliveryCallback(){

        @Override
        public void delivered(List<Message> messages) {
            for (Message message : messages) {
                if (message.getType() != Message.Type.ALERT && message.getType() != Message.Type.DATA) continue;
                VirtualDeviceImpl.removeOnErrorCallback(message.getClientId());
            }
        }
    };
    private final Object actionMapLock = new Object();
    private volatile Map<String, VirtualDevice.Callable<?>> actionMap;
    static final Map<String, WeakReference<AbstractVirtualDevice.ErrorCallback<VirtualDevice>>> onErrorCallbacks = new HashMap<String, WeakReference<AbstractVirtualDevice.ErrorCallback<VirtualDevice>>>();
    private static final ExecutorService errorEventDispatcher = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            SecurityManager s = System.getSecurityManager();
            ThreadGroup group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            Thread t = new Thread(group, r, "errorEventDispatchingThread", 0L);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    });
    private final Map<ScheduledPolicyData.Key, ScheduledPolicyData> scheduledPolicies = new HashMap<ScheduledPolicyData.Key, ScheduledPolicyData>();
    private final TimedPolicyThread timedPolicyThread = new TimedPolicyThread();
    private static int timed_policy_thread_count = 0;
    private List<Pair<Set<String>, String>> computedMetricTriggerMap = new ArrayList<Pair<Set<String>, String>>();
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");

    public VirtualDeviceImpl(DirectlyConnectedDevice directlyConnectedDevice, String endpointId, DeviceModelImpl deviceModel) {
        this.base = new VirtualDeviceBase<VirtualDevice>(this, endpointId, deviceModel);
        this.directlyConnectedDevice = directlyConnectedDevice;
        this.attributeMap = VirtualDeviceImpl.createAttributeMap(this, deviceModel);
        this.pipelineDataCache = new HashMap<String, List<Map<String, Object>>>();
        this.devicePolicyManager = DevicePolicyManager.getDevicePolicyManager(directlyConnectedDevice);
        this.devicePolicyManager.addChangeListener(this);
        MessageDispatcher messageDispatcher = MessageDispatcher.getMessageDispatcher(directlyConnectedDevice);
        RequestDispatcher requestDispatcher = messageDispatcher.getRequestDispatcher();
        requestDispatcher.registerRequestHandler(endpointId, "deviceModels/" + deviceModel.getURN(), this);
        ERROR_CALLBACK_BRIDGE.add(this);
        messageDispatcher.setOnError(ERROR_CALLBACK_BRIDGE);
        messageDispatcher.setOnDelivery(DELIVERY_CALLBACK);
    }

    private static Map<String, VirtualDeviceAttributeBase<VirtualDevice, Object>> createAttributeMap(VirtualDeviceImpl virtualDevice, DeviceModel deviceModel) {
        HashMap<String, VirtualDeviceAttributeBase<VirtualDevice, Object>> map = new HashMap<String, VirtualDeviceAttributeBase<VirtualDevice, Object>>();
        if (deviceModel instanceof DeviceModelImpl) {
            DeviceModelImpl deviceModelImpl = (DeviceModelImpl)deviceModel;
            for (DeviceModelAttribute attribute : deviceModelImpl.getDeviceModelAttributes().values()) {
                VirtualDeviceAttributeImpl vda = new VirtualDeviceAttributeImpl(virtualDevice, attribute);
                map.put(attribute.getName(), vda);
                String alias = attribute.getAlias();
                if (alias == null || alias.length() == 0) continue;
                map.put(alias, vda);
            }
        }
        return map;
    }

    @Override
    public VirtualDeviceAttributeBase<VirtualDevice, Object> getAttribute(String attributeName) {
        VirtualDeviceAttributeBase<VirtualDevice, Object> virtualDeviceAttribute = this.attributeMap.get(attributeName);
        if (virtualDeviceAttribute == null) {
            throw new IllegalArgumentException("no such attribute '" + attributeName + "'.\n\tVerify that the URN for the device model you created " + "matches the URN that you use when activating the device in " + "the Java application.\n\tVerify that the attribute name " + "(and spelling) you chose for your device model matches the " + "attribute you are setting in the Java application.");
        }
        return virtualDeviceAttribute;
    }

    @Override
    public void setValue(VirtualDeviceAttributeBase<VirtualDevice, Object> attribute, Object value) {
        if (attribute == null) {
            throw new IllegalArgumentException("attribute may not be null");
        }
        attribute.set(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFields(List<Pair<VirtualDeviceAttributeBase<VirtualDevice, Object>, Object>> updatedAttributes) {
        HashSet<String> updatedAttributeSet = new HashSet<String>();
        Iterator<Pair<VirtualDeviceAttributeBase<VirtualDevice, Object>, Object>> iterator = updatedAttributes.iterator();
        Object object = this.UPDATE_LOCK;
        synchronized (object) {
            while (iterator.hasNext()) {
                Pair<VirtualDeviceAttributeBase<VirtualDevice, Object>, Object> entry = iterator.next();
                VirtualDeviceAttributeBase<VirtualDevice, Object> attribute = entry.getKey();
                Object value = entry.getValue();
                String attributeName = attribute.getDeviceModelAttribute().getName();
                try {
                    if (!attribute.update(value)) {
                        iterator.remove();
                        continue;
                    }
                    updatedAttributeSet.add(attributeName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    DeviceFunction.removeInProcessValue(this.getEndpointId(), this.getDeviceModel().getURN(), attributeName);
                }
            }
            Set<String> computedMetrics = this.checkComputedMetrics(updatedAttributeSet);
            if (!computedMetrics.isEmpty()) {
                for (String attr : computedMetrics) {
                    VirtualDeviceAttributeBase<VirtualDevice, Object> attributeBase = this.getAttribute(attr);
                    Object value = attributeBase.get();
                    Pair<VirtualDeviceAttributeBase<VirtualDevice, Object>, Object> pair = new Pair<VirtualDeviceAttributeBase<VirtualDevice, Object>, Object>(attributeBase, value);
                    updatedAttributes.add(pair);
                }
            }
        }
        this.processOnChange(updatedAttributes);
    }

    @Override
    public DeviceModel getDeviceModel() {
        return this.base.getDeviceModel();
    }

    @Override
    public String getEndpointId() {
        return this.base.getEndpointId();
    }

    @Override
    public <T> T get(String attributeName) {
        VirtualDeviceAttributeBase<VirtualDevice, Object> attribute = this.getAttribute(attributeName);
        return (T)attribute.get();
    }

    @Override
    public <T> T getLastKnown(String attributeName) {
        VirtualDeviceAttributeBase<VirtualDevice, Object> attribute = this.getAttribute(attributeName);
        return (T)attribute.getLastKnown();
    }

    @Override
    public <T> VirtualDevice set(String attributeName, T value) {
        this.base.set(attributeName, value);
        return this;
    }

    @Override
    public VirtualDevice update() {
        this.base.update();
        return this;
    }

    @Override
    public void finish() {
        this.base.finish();
    }

    @Override
    public <T> VirtualDevice offer(String attributeName, T value) {
        VirtualDeviceAttributeBase<VirtualDevice, Object> attribute = this.getAttribute(attributeName);
        if (!attribute.isSettable()) {
            throw new UnsupportedOperationException("attempt to modify read-only attribute '" + attributeName + "'");
        }
        DevicePolicy devicePolicy = this.devicePolicyManager.getPolicy(this.getDeviceModel().getURN(), this.getEndpointId());
        if (devicePolicy == null) {
            return this.set(attributeName, (Object)value);
        }
        List<DevicePolicy.Function> pipeline = devicePolicy.getPipeline(attributeName);
        if (pipeline == null || pipeline.isEmpty()) {
            return this.set(attributeName, (Object)value);
        }
        List<Map<String, Object>> pipelineData = this.getPipelineData(attributeName);
        Object policyValue = this.offer0(attribute.getDeviceModelAttribute(), value, pipeline, pipelineData);
        if (policyValue != null) {
            if (VirtualDeviceImpl.getLogger().isLoggable(Level.FINE)) {
                VirtualDeviceImpl.getLogger().log(Level.FINE, this.getEndpointId() + " : Set   : \"" + attributeName + "\"=" + policyValue);
            }
            if (this.base.isUpdateMode()) {
                this.set(attributeName, policyValue);
            } else {
                ArrayList<Pair<VirtualDeviceAttributeBase<VirtualDevice, Object>, Object>> updatedAttributes = new ArrayList<Pair<VirtualDeviceAttributeBase<VirtualDevice, Object>, Object>>(1);
                updatedAttributes.add(new Pair<VirtualDeviceAttributeBase<VirtualDevice, Object>, Object>(attribute, policyValue));
                this.updateFields((List<Pair<VirtualDeviceAttributeBase<VirtualDevice, Object>, Object>>)updatedAttributes);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object offer0(DeviceModelAttribute attribute, Object value, List<DevicePolicy.Function> pipeline, List<Map<String, Object>> pipelineData) {
        String attributeName = attribute.getName();
        Object policyValue = value;
        if (pipeline != null && !pipeline.isEmpty()) {
            Object object = this.UPDATE_LOCK;
            synchronized (object) {
                DeviceFunction.putInProcessValue(this.getEndpointId(), this.getDeviceModel().getURN(), attributeName, policyValue);
                int maxIndex = pipeline.size();
                for (int index = 0; index < maxIndex; ++index) {
                    HashMap<String, Object> functionData;
                    DevicePolicy.Function function = pipeline.get(index);
                    if (index < pipelineData.size()) {
                        functionData = pipelineData.get(index);
                    } else {
                        functionData = new HashMap();
                        pipelineData.add(functionData);
                    }
                    String key = function.getId();
                    Map<String, ?> parameters = function.getParameters();
                    DeviceFunction deviceFunction = DeviceFunction.getDeviceFunction(key);
                    if (deviceFunction == null) continue;
                    if (deviceFunction.apply(this, attributeName, parameters, functionData, policyValue)) {
                        Object valueFromPolicy = deviceFunction.get(this, attributeName, parameters, functionData);
                        if (valueFromPolicy != null) {
                            policyValue = this.cast(attribute.getType(), valueFromPolicy);
                            DeviceFunction.putInProcessValue(this.getEndpointId(), this.getDeviceModel().getURN(), attributeName, policyValue);
                            continue;
                        }
                        if (VirtualDeviceImpl.getLogger().isLoggable(Level.FINEST)) {
                            VirtualDeviceImpl.getLogger().log(Level.FINEST, attributeName + " got null value from policy" + deviceFunction.getDetails(parameters));
                        }
                        return null;
                    }
                    if (VirtualDeviceImpl.getLogger().isLoggable(Level.FINEST) && deviceFunction.getId().startsWith("filter")) {
                        VirtualDeviceImpl.getLogger().log(Level.FINEST, "VirtualDevice: " + this.getEndpointId() + ": offer '" + attributeName + "' = " + policyValue + " rejected by policy '" + deviceFunction.getDetails(parameters) + "'");
                    }
                    return null;
                }
            }
        }
        return policyValue;
    }

    @Override
    public void setOnChange(String attributeName, AbstractVirtualDevice.ChangeCallback callback) {
        VirtualDeviceAttributeBase<VirtualDevice, Object> attribute = this.getAttribute(attributeName);
        ((VirtualDeviceAttribute)attribute).setOnChange(callback);
    }

    @Override
    public void setOnChange(AbstractVirtualDevice.ChangeCallback callback) {
        this.base.setOnChange(callback);
    }

    AbstractVirtualDevice.ChangeCallback getChangeCallback() {
        return this.base.getOnChangeCallback();
    }

    @Override
    public void setOnError(AbstractVirtualDevice.ErrorCallback callback) {
        this.base.setOnError(callback);
    }

    AbstractVirtualDevice.ErrorCallback getErrorCallback() {
        return this.base.getOnErrorCallback();
    }

    @Override
    public void setOnError(String attributeName, AbstractVirtualDevice.ErrorCallback<VirtualDevice> callback) {
        VirtualDeviceAttributeBase<VirtualDevice, Object> attribute = this.getAttribute(attributeName);
        ((VirtualDeviceAttribute)attribute).setOnError(callback);
    }

    @Override
    public ResponseMessage handleRequest(RequestMessage requestMessage) throws Exception {
        String method = requestMessage.getMethod().toUpperCase(Locale.ROOT);
        StatusCode responseStatus = StatusCode.BAD_REQUEST;
        if ("POST".equals(method)) {
            String methodOverride = requestMessage.getHeaderValue("X-HTTP-Method-Override");
            responseStatus = "PATCH".equalsIgnoreCase(methodOverride) ? this.handlePatch(requestMessage) : this.handlePost(requestMessage);
        } else if ("PUT".equals(method)) {
            responseStatus = this.handlePut(requestMessage);
        } else if ("PATCH".equals(method)) {
            responseStatus = this.handlePatch(requestMessage);
        } else {
            VirtualDeviceImpl.getLogger().log(Level.SEVERE, "unexpected method: " + method);
        }
        return new ResponseMessage.Builder(requestMessage).statusCode(responseStatus).build();
    }

    private StatusCode handlePatch(RequestMessage requestMessage) {
        VirtualDeviceBase.NamedValueImpl<Object> root = null;
        VirtualDeviceBase.NamedValueImpl<Object> last = null;
        try {
            VirtualDeviceAttributeImpl attribute;
            Object jsonValue;
            String attributeName;
            Iterator<String> keys;
            byte[] rawData = requestMessage.getBody();
            String json = new String(rawData, "UTF-8");
            JSONObject jsonObject = new JSONObject(json);
            if (this.base.getOnChangeCallback() == null) {
                keys = jsonObject.keys();
                while (keys.hasNext()) {
                    attributeName = keys.next();
                    jsonValue = jsonObject.get(attributeName);
                    attribute = (VirtualDeviceAttributeImpl)this.getAttribute(attributeName);
                    if (attribute.getOnChange() != null) continue;
                    VirtualDeviceImpl.getLogger().log(Level.INFO, "No handler for: '" + requestMessage.getMethod().toUpperCase(Locale.ROOT) + " " + requestMessage.getURL());
                    return StatusCode.NOT_FOUND;
                }
            }
            keys = jsonObject.keys();
            while (keys.hasNext()) {
                attributeName = keys.next();
                jsonValue = jsonObject.get(attributeName);
                attribute = (VirtualDeviceAttributeImpl)this.getAttribute(attributeName);
                DeviceModelAttribute dma = attribute.getDeviceModelAttribute();
                Object newValue = this.getValue(dma.getType(), jsonValue, attributeName);
                attribute.validate(dma, newValue);
                Object oldValue = attribute.get();
                if (oldValue != null ? oldValue.equals(newValue) : newValue == null) continue;
                VirtualDeviceBase.NamedValueImpl<Object> nameValue = new VirtualDeviceBase.NamedValueImpl<Object>(attributeName, newValue);
                if (attribute.getOnChange() != null) {
                    attribute.getOnChange().onChange(new VirtualDeviceBase.ChangeEvent<VirtualDeviceImpl>(this, nameValue));
                }
                if (last != null) {
                    last.setNext(nameValue);
                    last = nameValue;
                    continue;
                }
                root = last = nameValue;
            }
        }
        catch (Exception e) {
            VirtualDeviceImpl.getLogger().log(Level.SEVERE, e.getMessage(), e);
            return StatusCode.BAD_REQUEST;
        }
        if (root == null) {
            return StatusCode.ACCEPTED;
        }
        AbstractVirtualDevice.ChangeCallback<VirtualDevice> changeCallback = this.base.getOnChangeCallback();
        try {
            if (changeCallback != null) {
                changeCallback.onChange(new VirtualDeviceBase.ChangeEvent<VirtualDeviceImpl>(this, root));
            }
            ArrayList dataItems = new ArrayList();
            block14: for (AbstractVirtualDevice.NamedValue namedValue = root; namedValue != null; namedValue = ((AbstractVirtualDevice.NamedValue)namedValue).next()) {
                String attributeName = ((AbstractVirtualDevice.NamedValue)namedValue).getName();
                VirtualDeviceAttributeImpl attribute = (VirtualDeviceAttributeImpl)this.getAttribute(attributeName);
                Object newValue = ((AbstractVirtualDevice.NamedValue)namedValue).getValue();
                attribute.update(newValue);
                DeviceModelAttribute dma = attribute.getDeviceModelAttribute();
                switch (dma.getType()) {
                    case INTEGER: {
                        dataItems.add(new DataItem(attributeName, ((Integer)newValue).intValue()));
                        continue block14;
                    }
                    case NUMBER: {
                        dataItems.add(new DataItem(attributeName, ((Number)newValue).doubleValue()));
                        continue block14;
                    }
                    case BOOLEAN: {
                        dataItems.add(new DataItem(attributeName, (Boolean)newValue));
                        continue block14;
                    }
                    case URI: {
                        dataItems.add(new DataItem(attributeName, ((ExternalObject)newValue).getURI()));
                        continue block14;
                    }
                    case STRING: {
                        dataItems.add(new DataItem(attributeName, (String)newValue));
                        continue block14;
                    }
                    case DATETIME: {
                        dataItems.add(new DataItem(attributeName, ((Long)newValue).longValue()));
                        continue block14;
                    }
                    default: {
                        VirtualDeviceImpl.getLogger().log(Level.SEVERE, "'" + (Object)((Object)dma.getType()) + "' not handled");
                    }
                }
            }
            DataMessage dataMessage = ((DataMessage.Builder)new DataMessage.Builder().format(this.getDeviceModel().getURN() + ":attributes").source(this.getEndpointId())).dataItems(dataItems).build();
            MessageDispatcher messageDispatcher = MessageDispatcher.getMessageDispatcher(this.directlyConnectedDevice);
            messageDispatcher.queue((Message)dataMessage);
            return StatusCode.ACCEPTED;
        }
        catch (Exception e) {
            VirtualDeviceImpl.getLogger().log(Level.SEVERE, e.getMessage(), e);
            return StatusCode.INTERNAL_SERVER_ERROR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatusCode handlePost(RequestMessage requestMessage) {
        VirtualDevice.Callable<?> callable;
        String actionName;
        String path = requestMessage.getURL();
        String dmURN = "deviceModels/" + this.getDeviceModel().getURN() + "/actions";
        String string = actionName = dmURN.regionMatches(0, path, 0, dmURN.length()) ? path.substring(dmURN.length() + 1) : path;
        if (this.actionMap == null) {
            callable = null;
        } else {
            Object object = this.actionMapLock;
            synchronized (object) {
                callable = this.actionMap.get(actionName);
            }
        }
        if (callable != null) {
            try {
                DeviceModelAction action = VirtualDeviceImpl.getDeviceModelAction(this.base.getDeviceModel(), actionName);
                Object data = action.getArgType() != null ? this.getValue(action.getArgType(), requestMessage.getBody(), actionName) : null;
                callable.call(this, data);
                return StatusCode.ACCEPTED;
            }
            catch (Exception e) {
                VirtualDeviceImpl.getLogger().log(Level.FINEST, e.getMessage(), e);
                return StatusCode.BAD_REQUEST;
            }
        }
        VirtualDeviceImpl.getLogger().log(Level.INFO, "No handler for: '" + requestMessage.getMethod().toUpperCase(Locale.ROOT) + " " + requestMessage.getURL());
        return StatusCode.NOT_FOUND;
    }

    private StatusCode handlePut(RequestMessage requestMessage) {
        try {
            String path = requestMessage.getURL();
            String dmURN = "deviceModels/" + this.getDeviceModel().getURN() + "/attributes";
            String attributeName = dmURN.regionMatches(0, path, 0, dmURN.length()) ? path.substring(dmURN.length() + 1) : path;
            VirtualDeviceAttributeBase<VirtualDevice, Object> virtualDeviceAttribute = this.getAttribute(attributeName);
            DeviceModelAttribute<Object> deviceModelAttribute = virtualDeviceAttribute.getDeviceModelAttribute();
            DeviceModelAttribute.Type attributeType = deviceModelAttribute.getType();
            byte[] data = requestMessage.getBody();
            Object newValue = this.getValue(attributeType, data, attributeName);
            Object oldValue = virtualDeviceAttribute.get();
            if (oldValue != null ? oldValue.equals(newValue) : newValue == null) {
                return StatusCode.ACCEPTED;
            }
            VirtualDeviceBase.NamedValueImpl<Object> namedValue = new VirtualDeviceBase.NamedValueImpl<Object>(attributeName, newValue);
            boolean attrOnChangeCalled = false;
            if (virtualDeviceAttribute.getOnChange() != null) {
                virtualDeviceAttribute.getOnChange().onChange(new VirtualDeviceBase.ChangeEvent<VirtualDeviceImpl>(this, namedValue));
                attrOnChangeCalled = true;
            }
            if (this.base.getOnChangeCallback() != null) {
                this.base.getOnChangeCallback().onChange(new VirtualDeviceBase.ChangeEvent<VirtualDeviceImpl>(this, namedValue));
                attrOnChangeCalled = true;
            }
            if (attrOnChangeCalled) {
                virtualDeviceAttribute.set(newValue);
                return StatusCode.ACCEPTED;
            }
            VirtualDeviceImpl.getLogger().log(Level.INFO, "No handler for: '" + requestMessage.getMethod().toUpperCase(Locale.ROOT) + " " + requestMessage.getURL());
            return StatusCode.NOT_FOUND;
        }
        catch (Exception e) {
            VirtualDeviceImpl.getLogger().log(Level.FINEST, e.getMessage(), e);
            return StatusCode.BAD_REQUEST;
        }
    }

    private static DeviceModelAction getDeviceModelAction(DeviceModelImpl deviceModel, String actionName) {
        Map<String, DeviceModelAction> actions;
        if (deviceModel != null && !(actions = deviceModel.getDeviceModelActions()).isEmpty()) {
            DeviceModelAction act = actions.get(actionName);
            if (act != null) {
                return act;
            }
            for (DeviceModelAction action : actions.values()) {
                if (!actionName.equals(action.getAlias())) continue;
                return action;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCallable(String actionName, VirtualDevice.Callable<?> callable) {
        Map<String, DeviceModelAction> actions;
        DeviceModelAction deviceModelAction;
        if (this.actionMap == null) {
            Object object = this.actionMapLock;
            synchronized (object) {
                if (this.actionMap == null) {
                    this.actionMap = new HashMap();
                }
            }
        }
        if ((deviceModelAction = (actions = this.base.getDeviceModel().getDeviceModelActions()).get(actionName)) == null) {
            for (DeviceModelAction action : actions.values()) {
                if (!actionName.equals(action.getAlias())) continue;
                deviceModelAction = action;
                break;
            }
        }
        if (deviceModelAction == null) {
            throw new IllegalArgumentException("action not found in model");
        }
        Object object = this.actionMapLock;
        synchronized (object) {
            this.actionMap.put(deviceModelAction.getName(), callable);
            if (deviceModelAction.getAlias() != null) {
                this.actionMap.put(deviceModelAction.getAlias(), callable);
            }
        }
    }

    @Override
    public Alert createAlert(String format) {
        return new AlertImpl(this, format);
    }

    @Override
    public Data createData(String format) {
        return new DataImpl(this, format);
    }

    <T> void processOnChange(VirtualDeviceAttribute<VirtualDevice, T> virtualDeviceAttribute, Object newValue) {
        DataMessage.Builder builder = new DataMessage.Builder();
        WritableValue<StorageObjectImpl> storageObject = new WritableValue<StorageObjectImpl>();
        try {
            this.processOnChange(builder, (VirtualDeviceAttributeImpl)virtualDeviceAttribute, newValue, storageObject);
        }
        catch (RuntimeException re) {
            return;
        }
        DataMessage dataMessage = builder.build();
        try {
            this.queueMessage(dataMessage, storageObject.getValue());
        }
        catch (ArrayStoreException e) {
            HashSet<VirtualDeviceAttributeBase<VirtualDevice, Object>> attributes = new HashSet<VirtualDeviceAttributeBase<VirtualDevice, Object>>(1);
            attributes.add((VirtualDeviceAttributeImpl)virtualDeviceAttribute);
            this.notifyException(attributes, e);
        }
    }

    void queueMessage(Message message, StorageObjectImpl storageObject) throws ArrayStoreException {
        Pair<Message, StorageObjectImpl> pair = new Pair<Message, StorageObjectImpl>(message, storageObject);
        Pair[] pairs = new Pair[]{pair};
        String deviceModelURN = this.getDeviceModel().getURN();
        DevicePolicy devicePolicy = this.devicePolicyManager.getPolicy(this.getDeviceModel().getURN(), this.getEndpointId());
        if (devicePolicy != null && devicePolicy.getPipeline(DevicePolicy.ALL_ATTRIBUTES()) != null) {
            AlertMessage.Severity alertSeverity;
            if (message instanceof AlertMessage) {
                AlertMessage alertMessage = (AlertMessage)message;
                alertSeverity = alertMessage.getSeverity();
            } else {
                alertSeverity = null;
            }
            List<DevicePolicy.Function> pipeline = devicePolicy.getPipeline(DevicePolicy.ALL_ATTRIBUTES());
            if (pipeline.size() > 1) {
                int maxIndex = pipeline.size();
                for (int index = 0; index < maxIndex; ++index) {
                    DevicePolicy.Function function = pipeline.get(index);
                    String id = function.getId();
                    Map<String, ?> parameters = function.getParameters();
                    DeviceFunction deviceFunction = DeviceFunction.getDeviceFunction(id);
                    if (index == 0) {
                        VirtualDeviceImpl.getLogger().log(Level.WARNING, "Only one function allowed for all-attribute pipeline.");
                        VirtualDeviceImpl.getLogger().log(Level.WARNING, "\tApplying: " + deviceFunction.getDetails(parameters));
                        continue;
                    }
                    VirtualDeviceImpl.getLogger().log(Level.WARNING, "\tIgnoring: " + deviceFunction.getDetails(parameters));
                }
            }
            List<Map<String, Object>> pipelineData = this.getPipelineData(DevicePolicy.ALL_ATTRIBUTES());
            int maxIndex = 1;
            for (int index = 0; index < maxIndex; ++index) {
                HashMap<String, Object> functionData;
                boolean alertOverridesPolicy;
                DevicePolicy.Function function = pipeline.get(index);
                String id = function.getId();
                Map<String, ?> parameters = function.getParameters();
                DeviceFunction deviceFunction = DeviceFunction.getDeviceFunction(id);
                if (deviceFunction == null) continue;
                if (alertSeverity != null) {
                    AlertMessage.Severity configuredSeverity = AlertMessage.Severity.CRITICAL;
                    String criterion = (String)parameters.get("alertSeverity");
                    if (criterion != null) {
                        try {
                            configuredSeverity = AlertMessage.Severity.valueOf(criterion);
                        }
                        catch (IllegalArgumentException e) {
                            configuredSeverity = AlertMessage.Severity.CRITICAL;
                        }
                    }
                    alertOverridesPolicy = configuredSeverity.compareTo(alertSeverity) <= 0;
                } else {
                    alertOverridesPolicy = false;
                }
                if (index < pipelineData.size()) {
                    functionData = pipelineData.get(index);
                } else {
                    functionData = new HashMap();
                    pipelineData.add(functionData);
                }
                if (deviceFunction.apply(this, null, parameters, functionData, pair) || alertOverridesPolicy) {
                    long window = DeviceFunction.getWindow(parameters);
                    if (window > 0L) {
                        long slide = DeviceFunction.getSlide(parameters, window);
                        ScheduledPolicyData.Key key = new ScheduledPolicyData.Key(window, slide);
                        ScheduledPolicyData scheduledPolicyData = this.scheduledPolicies.get(key);
                        long timeZero = System.currentTimeMillis();
                        if (scheduledPolicyData != null) {
                            ArrayList<Pair<VirtualDeviceAttributeBase<VirtualDevice, Object>, Object>> updatedAttributes = new ArrayList<Pair<VirtualDeviceAttributeBase<VirtualDevice, Object>, Object>>();
                            scheduledPolicyData.processExpiredFunction(this, updatedAttributes, timeZero);
                            if (!updatedAttributes.isEmpty()) {
                                this.updateFields((List<Pair<VirtualDeviceAttributeBase<VirtualDevice, Object>, Object>>)updatedAttributes);
                            }
                            return;
                        }
                    }
                    List value = (List)deviceFunction.get(this, null, parameters, functionData);
                    pairs = value.toArray(new Pair[value.size()]);
                    if (!VirtualDeviceImpl.getLogger().isLoggable(Level.FINE)) continue;
                    VirtualDeviceImpl.getLogger().log(Level.FINE, "VirtualDevice: " + this.getEndpointId() + " dispatching " + pairs.length + " messages per policy '" + deviceFunction.getDetails(parameters) + "'");
                    continue;
                }
                return;
            }
        }
        try {
            Message[] messages = new Message[pairs.length];
            MessageDispatcherImpl messageDispatcher = (MessageDispatcherImpl)MessageDispatcher.getMessageDispatcher(this.directlyConnectedDevice);
            for (int n = 0; n < messages.length; ++n) {
                messages[n] = (Message)pairs[n].getKey();
                StorageObjectImpl so = (StorageObjectImpl)pairs[n].getValue();
                if (so == null) continue;
                messageDispatcher.addStorageObjectDependency(so, message.getClientId());
                so.sync();
            }
            messageDispatcher.queue(messages);
        }
        catch (ArrayStoreException e) {
            throw e;
        }
        catch (Throwable t) {
            VirtualDeviceImpl.getLogger().log(Level.SEVERE, t.toString());
        }
    }

    private void processOnChange(List<Pair<VirtualDeviceAttributeBase<VirtualDevice, Object>, Object>> updatedAttributes) {
        if (updatedAttributes.isEmpty()) {
            return;
        }
        HashSet<VirtualDeviceAttributeBase<VirtualDevice, Object>> keySet = new HashSet<VirtualDeviceAttributeBase<VirtualDevice, Object>>();
        DataMessage.Builder builder = new DataMessage.Builder();
        WritableValue<StorageObjectImpl> storageObject = new WritableValue<StorageObjectImpl>();
        for (Pair<VirtualDeviceAttributeBase<VirtualDevice, Object>, Object> entry : updatedAttributes) {
            VirtualDeviceAttributeBase<VirtualDevice, Object> attribute = entry.getKey();
            keySet.add(attribute);
            Object newValue = entry.getValue();
            try {
                this.processOnChange(builder, attribute, newValue, storageObject);
            }
            catch (RuntimeException re) {
                VirtualDeviceImpl.getLogger().log(Level.SEVERE, re.getMessage(), re);
                return;
            }
        }
        DataMessage dataMessage = builder.build();
        try {
            this.queueMessage(dataMessage, (StorageObjectImpl)storageObject.getValue());
        }
        catch (ArrayStoreException e) {
            this.notifyException(keySet, e);
        }
        catch (Exception e) {
            VirtualDeviceImpl.getLogger().log(Level.SEVERE, e.getMessage(), e);
        }
    }

    void handleStorageObjectStateChange(StorageObjectImpl so) {
        MessageDispatcherImpl messageDispatcherImpl = (MessageDispatcherImpl)MessageDispatcher.getMessageDispatcher(this.directlyConnectedDevice);
        messageDispatcherImpl.removeStorageObjectDependency(so);
    }

    public String toString() {
        return this.base.toString();
    }

    private Object getValue(DeviceModelAttribute.Type attributeType, byte[] payload, String name) throws JSONException, IllegalArgumentException {
        String json;
        try {
            json = new String(payload, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new JSONException(e.getMessage());
        }
        JSONObject jsonObject = new JSONObject(json);
        Object jsonValue = jsonObject.opt("value");
        if (jsonValue == null) {
            throw new IllegalArgumentException("bad payload " + String.valueOf(jsonObject));
        }
        return this.getValue(attributeType, jsonValue, name);
    }

    private Object getValue(DeviceModelAttribute.Type attributeType, Object jsonValue, String name) throws IllegalArgumentException {
        if (jsonValue == null) {
            return null;
        }
        Object data = null;
        switch (attributeType) {
            case BOOLEAN: {
                if (!(jsonValue instanceof Boolean)) {
                    throw new IllegalArgumentException("value is not BOOLEAN");
                }
                data = jsonValue;
                break;
            }
            case INTEGER: {
                if (!(jsonValue instanceof Number)) {
                    throw new IllegalArgumentException("value is not NUMBER");
                }
                data = ((Number)jsonValue).intValue();
                break;
            }
            case NUMBER: {
                if (!(jsonValue instanceof Number)) {
                    throw new IllegalArgumentException("value is not NUMBER");
                }
                data = jsonValue;
                break;
            }
            case DATETIME: {
                if (!(jsonValue instanceof Number)) {
                    throw new IllegalArgumentException("value is not NUMBER");
                }
                data = ((Number)jsonValue).longValue();
                break;
            }
            case STRING: {
                if (!(jsonValue instanceof String)) {
                    throw new IllegalArgumentException("value is not STRING");
                }
                data = jsonValue;
                break;
            }
            case URI: {
                if (!(jsonValue instanceof String)) {
                    throw new IllegalArgumentException("value is not STRING");
                }
                try {
                    if (StorageConnectionBase.isStorageCloudURI((String)jsonValue)) {
                        try {
                            StorageObject delegate = this.directlyConnectedDevice.createStorageObject((String)jsonValue);
                            StorageObjectImpl storageObjectImpl = new StorageObjectImpl(this.directlyConnectedDevice, delegate);
                            storageObjectImpl.setSyncEventInfo(this, name);
                            data = storageObjectImpl;
                            break;
                        }
                        catch (Exception e) {
                            VirtualDeviceImpl.getLogger().log(Level.WARNING, "Storage CS object access failed: " + e.getMessage());
                        }
                    }
                    data = new ExternalObject((String)jsonValue);
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Cannot get value for attribute" + name, e);
                }
            }
            default: {
                throw new IllegalArgumentException("unexpected type '" + (Object)((Object)attributeType) + "'");
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void addOnErrorCallback(String messageId, AbstractVirtualDevice.ErrorCallback<VirtualDevice> callback) {
        WeakReference<AbstractVirtualDevice.ErrorCallback<VirtualDevice>> ref = new WeakReference<AbstractVirtualDevice.ErrorCallback<VirtualDevice>>(callback);
        Map<String, WeakReference<AbstractVirtualDevice.ErrorCallback<VirtualDevice>>> map = onErrorCallbacks;
        synchronized (map) {
            onErrorCallbacks.put(messageId, ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final AbstractVirtualDevice.ErrorCallback<VirtualDevice> removeOnErrorCallback(String messageId) {
        AbstractVirtualDevice.ErrorCallback callback;
        WeakReference<AbstractVirtualDevice.ErrorCallback<VirtualDevice>> ref;
        Map<String, WeakReference<AbstractVirtualDevice.ErrorCallback<VirtualDevice>>> map = onErrorCallbacks;
        synchronized (map) {
            ref = onErrorCallbacks.remove(messageId);
        }
        if (ref != null && (callback = (AbstractVirtualDevice.ErrorCallback)ref.get()) != null) {
            return callback;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void replaceOnErrorCallback(AbstractVirtualDevice.ErrorCallback<VirtualDevice> oldCallback, AbstractVirtualDevice.ErrorCallback<VirtualDevice> newCallback) {
        WeakReference<AbstractVirtualDevice.ErrorCallback<VirtualDevice>> newCallbackRef;
        WeakReference<AbstractVirtualDevice.ErrorCallback<VirtualDevice>> weakReference = newCallbackRef = newCallback != null ? new WeakReference<AbstractVirtualDevice.ErrorCallback<VirtualDevice>>(newCallback) : null;
        if (oldCallback != null) {
            Map<String, WeakReference<AbstractVirtualDevice.ErrorCallback<VirtualDevice>>> map = onErrorCallbacks;
            synchronized (map) {
                HashSet<String> keys = new HashSet<String>(onErrorCallbacks.keySet());
                for (String key : keys) {
                    AbstractVirtualDevice.ErrorCallback errorCallback;
                    WeakReference<AbstractVirtualDevice.ErrorCallback<VirtualDevice>> entry = onErrorCallbacks.remove(key);
                    if (entry == null || (errorCallback = (AbstractVirtualDevice.ErrorCallback)entry.get()) != oldCallback || newCallback == null) continue;
                    onErrorCallbacks.put(key, newCallbackRef);
                }
            }
        }
    }

    private void processOnChange(DataMessage.Builder builder, VirtualDeviceAttributeBase<VirtualDevice, Object> attribute, Object newValue, WritableValue<StorageObjectImpl> storageObject) {
        DeviceModelAttribute<Object> deviceModelAttribute = attribute.getDeviceModelAttribute();
        String attributeName = deviceModelAttribute.getName();
        builder.format(this.base.getDeviceModel().getURN() + ":attributes").source(this.base.getEndpointId());
        switch (deviceModelAttribute.getType()) {
            case INTEGER: 
            case NUMBER: {
                builder.dataItem(attributeName, ((Number)newValue).doubleValue());
                break;
            }
            case STRING: {
                builder.dataItem(attributeName, (String)newValue);
                break;
            }
            case URI: {
                if (newValue instanceof StorageObjectImpl) {
                    StorageObjectImpl storageObjectImpl = (StorageObjectImpl)newValue;
                    if (storageObjectImpl.getSyncStatus() == StorageObject.SyncStatus.NOT_IN_SYNC || storageObjectImpl.getSyncStatus() == StorageObject.SyncStatus.SYNC_PENDING) {
                        storageObject.setValue(storageObjectImpl);
                    }
                    storageObjectImpl.setSyncEventInfo(this, attributeName);
                }
                builder.dataItem(attributeName, ((ExternalObject)newValue).getURI());
                break;
            }
            case BOOLEAN: {
                builder.dataItem(attributeName, (Boolean)newValue);
                break;
            }
            case DATETIME: {
                if (newValue instanceof Date) {
                    builder.dataItem(attributeName, ((Date)newValue).getTime());
                    break;
                }
                if (!(newValue instanceof Number)) break;
                builder.dataItem(attributeName, ((Number)newValue).longValue());
                break;
            }
            default: {
                VirtualDeviceImpl.getLogger().log(Level.SEVERE, "unknown attribute type " + (Object)((Object)deviceModelAttribute.getType()));
                throw new RuntimeException("unknown attribute type " + (Object)((Object)deviceModelAttribute.getType()));
            }
        }
    }

    private void notifyException(Set<VirtualDeviceAttributeBase<VirtualDevice, Object>> attributes, Exception e) {
        final AbstractVirtualDevice.ErrorCallback errorCallback = this.getErrorCallback();
        if (errorCallback == null) {
            return;
        }
        VirtualDeviceBase.NamedValueImpl<Object> head = null;
        VirtualDeviceBase.NamedValueImpl<Object> tail = null;
        for (VirtualDeviceAttributeBase<VirtualDevice, Object> attribute : attributes) {
            String name = attribute.getDeviceModelAttribute().getName();
            Object value = attribute.get();
            VirtualDeviceBase.NamedValueImpl<Object> next = new VirtualDeviceBase.NamedValueImpl<Object>(name, value);
            if (head != null) {
                tail.setNext(next);
                tail = next;
                continue;
            }
            head = tail = next;
        }
        final VirtualDeviceBase.ErrorEvent<VirtualDeviceImpl> errorEvent = new VirtualDeviceBase.ErrorEvent<VirtualDeviceImpl>(this, head, e.getMessage());
        final String msg = e.getMessage();
        errorEventDispatcher.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    errorCallback.onError(errorEvent);
                }
                catch (Exception ignored) {
                    VirtualDeviceImpl.getLogger().log(Level.WARNING, "onError threw: " + msg);
                }
            }
        });
    }

    private List<Map<String, Object>> getPipelineData(String attribute) {
        DevicePolicy devicePolicy = this.devicePolicyManager.getPolicy(this.getDeviceModel().getURN(), this.getEndpointId());
        if (devicePolicy == null) {
            return Collections.emptyList();
        }
        List<DevicePolicy.Function> pipeline = devicePolicy.getPipeline(attribute);
        if (pipeline == null || pipeline.isEmpty()) {
            return Collections.emptyList();
        }
        List<Map<String, Object>> pipelineData = this.pipelineDataCache.get(attribute);
        if (pipelineData == null) {
            pipelineData = new ArrayList<Map<String, Object>>();
            this.pipelineDataCache.put(attribute, pipelineData);
        }
        if (pipelineData.size() < pipeline.size()) {
            int nMax = pipeline.size();
            for (int n = pipelineData.size(); n < nMax; ++n) {
                pipelineData.add(new HashMap());
            }
        }
        return pipelineData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addScheduledPolicy(long window, long slide, long timeZero, String attributeName, int pipelineIndex) {
        Map<ScheduledPolicyData.Key, ScheduledPolicyData> map = this.scheduledPolicies;
        synchronized (map) {
            ScheduledPolicyData.Key key = new ScheduledPolicyData.Key(window, slide);
            ScheduledPolicyData scheduledPolicyData = this.scheduledPolicies.get(key);
            if (scheduledPolicyData == null) {
                scheduledPolicyData = new ScheduledPolicyData(window, slide, timeZero);
                this.scheduledPolicies.put(key, scheduledPolicyData);
                this.timedPolicyThread.addTimedPolicyData(scheduledPolicyData);
                if (!this.timedPolicyThread.isAlive() && !this.timedPolicyThread.isCancelled()) {
                    this.timedPolicyThread.start();
                }
            }
            scheduledPolicyData.addAttribute(attributeName, pipelineIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeScheduledPolicy(long slide, String attributeName, int pipelineIndex, long window) {
        Map<ScheduledPolicyData.Key, ScheduledPolicyData> map = this.scheduledPolicies;
        synchronized (map) {
            ScheduledPolicyData.Key key = new ScheduledPolicyData.Key(window, slide);
            ScheduledPolicyData scheduledPolicyData = this.scheduledPolicies.get(key);
            if (scheduledPolicyData != null) {
                scheduledPolicyData.removeAttribute(attributeName, pipelineIndex);
                if (scheduledPolicyData.isEmpty()) {
                    this.scheduledPolicies.remove(key);
                    this.timedPolicyThread.removeTimedPolicyData(scheduledPolicyData);
                }
            }
        }
    }

    @Override
    public void policyAssigned(DevicePolicy policy, Set<String> assignedDevices) {
        if (assignedDevices == null || !assignedDevices.contains(this.getEndpointId())) {
            return;
        }
        if (VirtualDeviceImpl.getLogger().isLoggable(Level.FINE)) {
            VirtualDeviceImpl.getLogger().log(Level.FINE, this.getEndpointId() + " : Policy assigned : " + policy.getId());
        }
        long timeZero = System.currentTimeMillis();
        Set<Map.Entry<String, List<DevicePolicy.Function>>> entries = policy.getPipelines().entrySet();
        for (Map.Entry<String, List<DevicePolicy.Function>> entry : entries) {
            this.policyAssigned(entry.getKey(), entry.getValue(), timeZero);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void policyAssigned(String attributeName, List<DevicePolicy.Function> newPipeline, long timeZero) {
        if (newPipeline != null && !newPipeline.isEmpty()) {
            int indexMax = newPipeline.size();
            for (int index = 0; index < indexMax; ++index) {
                DevicePolicy.Function function = newPipeline.get(index);
                String id = function.getId();
                Map<String, ?> parameters = function.getParameters();
                long window = DeviceFunction.getWindow(parameters);
                if (window > -1L && !"eliminateDuplicates".equals(id) && !"detectDuplicates".equals(id)) {
                    long slide = DeviceFunction.getSlide(parameters, window);
                    this.addScheduledPolicy(window, slide, timeZero, attributeName, index);
                }
                if (index != 0 || !"computedMetric".equals(id)) continue;
                String formula = (String)parameters.get("formula");
                HashSet<String> triggerAttributes = new HashSet<String>();
                int pos = formula.indexOf("$(");
                while (pos != -1) {
                    String attr;
                    int end = formula.indexOf(41, pos + 1);
                    if (!(pos != 0 && formula.charAt(pos - 1) == '$' || (attr = formula.substring(pos + "$(".length(), end)).equals(attributeName))) {
                        triggerAttributes.add(attr);
                    }
                    pos = formula.indexOf("$(", end + 1);
                }
                if (triggerAttributes.isEmpty()) continue;
                List<Pair<Set<String>, String>> list = this.computedMetricTriggerMap;
                synchronized (list) {
                    this.computedMetricTriggerMap.add(new Pair(triggerAttributes, attributeName));
                    continue;
                }
            }
        }
    }

    @Override
    public void policyUnassigned(DevicePolicy devicePolicy, Set<String> unassignedDevices) {
        if (unassignedDevices == null || !unassignedDevices.contains(this.getEndpointId())) {
            return;
        }
        if (VirtualDeviceImpl.getLogger().isLoggable(Level.FINE)) {
            VirtualDeviceImpl.getLogger().log(Level.FINE, this.getEndpointId() + " : Policy un-assigned : " + devicePolicy.getId());
        }
        ArrayList<Pair<VirtualDeviceAttributeBase<VirtualDevice, Object>, Object>> updatedAttributes = new ArrayList<Pair<VirtualDeviceAttributeBase<VirtualDevice, Object>, Object>>();
        Set<Map.Entry<String, List<DevicePolicy.Function>>> entries = devicePolicy.getPipelines().entrySet();
        for (Map.Entry<String, List<DevicePolicy.Function>> entry : entries) {
            this.policyUnassigned(updatedAttributes, entry.getKey(), entry.getValue());
        }
        if (!updatedAttributes.isEmpty()) {
            this.updateFields((List<Pair<VirtualDeviceAttributeBase<VirtualDevice, Object>, Object>>)updatedAttributes);
        }
    }

    private void policyUnassigned(List<Pair<VirtualDeviceAttributeBase<VirtualDevice, Object>, Object>> updatedAttributes, String attributeName, List<DevicePolicy.Function> oldPipeline) {
        if (oldPipeline != null && !oldPipeline.isEmpty()) {
            int indexMax = oldPipeline.size();
            for (int index = 0; index < indexMax; ++index) {
                DevicePolicy.Function function = oldPipeline.get(index);
                String id = function.getId();
                Map<String, ?> parameters = function.getParameters();
                long window = DeviceFunction.getWindow(parameters);
                if (window <= -1L || "eliminateDuplicates".equals(id) || "detectDuplicates".equals(id)) continue;
                long slide = DeviceFunction.getSlide(parameters, window);
                this.removeScheduledPolicy(slide, attributeName, index, window);
            }
            List<Map<String, Object>> pipelineData = this.getPipelineData(attributeName);
            if (pipelineData != null && !pipelineData.isEmpty()) {
                if (!DevicePolicy.ALL_ATTRIBUTES().equals(attributeName)) {
                    this.processExpiredFunction(updatedAttributes, attributeName, oldPipeline, pipelineData);
                } else {
                    this.processExpiredFunction(oldPipeline, pipelineData);
                }
            }
            if (attributeName != null) {
                for (int index = this.computedMetricTriggerMap.size() - 1; 0 <= index; --index) {
                    Pair<Set<String>, String> pair = this.computedMetricTriggerMap.get(index);
                    if (!attributeName.equals(pair.getValue())) continue;
                    this.computedMetricTriggerMap.remove(index);
                }
            }
            this.pipelineDataCache.remove(attributeName);
        }
    }

    private void processExpiredFunction(List<Pair<VirtualDeviceAttributeBase<VirtualDevice, Object>, Object>> updatedAttributes, String attributeName, List<DevicePolicy.Function> pipeline, List<Map<String, Object>> pipelineData) {
        if (pipeline == null || pipeline.isEmpty()) {
            return;
        }
        try {
            Object policyValue;
            VirtualDeviceAttributeBase<VirtualDevice, Object> attribute = this.getAttribute(attributeName);
            DeviceModelAttribute<Object> deviceModelAttribute = attribute.getDeviceModelAttribute();
            DevicePolicy.Function function = pipeline.get(0);
            String functionId = function.getId();
            Map<String, ?> config = function.getParameters();
            Map<String, Object> data = pipelineData.get(0);
            DeviceFunction deviceFunction = DeviceFunction.getDeviceFunction(functionId);
            if (deviceFunction == null) {
                VirtualDeviceImpl.getLogger().log(Level.SEVERE, "device function " + functionId + " not found");
                return;
            }
            Object value = deviceFunction.get(this, attributeName, config, data);
            if (value != null && pipeline.size() > 1) {
                value = this.offer0(deviceModelAttribute, value, pipeline.subList(1, pipeline.size()), pipelineData.subList(1, pipelineData.size()));
            }
            if (value != null && (policyValue = this.cast(attribute.getDeviceModelAttribute().getType(), value)) != null) {
                if (VirtualDeviceImpl.getLogger().isLoggable(Level.FINE)) {
                    VirtualDeviceImpl.getLogger().log(Level.FINE, this.getEndpointId() + " : Set   : \"" + attributeName + "\"=" + policyValue);
                }
                updatedAttributes.add(new Pair(attribute, policyValue));
            }
        }
        catch (IllegalArgumentException e) {
            VirtualDeviceImpl.getLogger().log(Level.WARNING, e.getMessage());
        }
        catch (ClassCastException e) {
            VirtualDeviceImpl.getLogger().log(Level.WARNING, attributeName, e);
        }
    }

    private void processExpiredFunction(List<DevicePolicy.Function> pipeline, List<Map<String, Object>> pipelineData) {
        if (pipeline == null || pipeline.isEmpty()) {
            return;
        }
        if (pipeline.size() > 1) {
            int maxIndex = pipeline.size();
            for (int index = 0; index < maxIndex; ++index) {
                DevicePolicy.Function function = pipeline.get(index);
                String id = function.getId();
                Map<String, ?> parameters = function.getParameters();
                DeviceFunction deviceFunction = DeviceFunction.getDeviceFunction(id);
                if (index == 0) {
                    VirtualDeviceImpl.getLogger().log(Level.WARNING, "Only one function allowed for all-attribute pipeline.");
                    VirtualDeviceImpl.getLogger().log(Level.WARNING, "\tApplying: " + deviceFunction.getDetails(parameters));
                    continue;
                }
                VirtualDeviceImpl.getLogger().log(Level.WARNING, "\tIgnoring: " + deviceFunction.getDetails(parameters));
            }
        }
        try {
            DevicePolicy.Function function = pipeline.get(0);
            String functionId = function.getId();
            Map<String, ?> config = function.getParameters();
            Map<String, Object> data = pipelineData.get(0);
            DeviceFunction deviceFunction = DeviceFunction.getDeviceFunction(functionId);
            if (deviceFunction == null) {
                VirtualDeviceImpl.getLogger().log(Level.SEVERE, "device function " + functionId + " not found");
                return;
            }
            Object value = deviceFunction.get(this, null, config, data);
            if (value != null) {
                List pairs = (List)value;
                if (pairs.isEmpty()) {
                    return;
                }
                Message[] messages = new Message[pairs.size()];
                MessageDispatcherImpl messageDispatcher = (MessageDispatcherImpl)MessageDispatcher.getMessageDispatcher(this.directlyConnectedDevice);
                int nMax = pairs.size();
                for (int n = 0; n < nMax; ++n) {
                    Pair messagePair = (Pair)pairs.get(n);
                    messages[n] = (Message)messagePair.getKey();
                    StorageObjectImpl so = (StorageObjectImpl)messagePair.getValue();
                    if (so == null) continue;
                    messageDispatcher.addStorageObjectDependency(so, messages[n].getClientId());
                    so.sync();
                }
                messageDispatcher.queue(messages);
            }
        }
        catch (ArrayStoreException e) {
            throw e;
        }
        catch (Throwable t) {
            VirtualDeviceImpl.getLogger().log(Level.SEVERE, t.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> checkComputedMetrics(Set<String> updatedAttributes) {
        if (updatedAttributes == null || updatedAttributes.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        if (this.computedMetricTriggerMap.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> computedAttributes = new HashSet<String>();
        List<Pair<Set<String>, String>> list = this.computedMetricTriggerMap;
        synchronized (list) {
            for (Pair<Set<String>, String> entry : this.computedMetricTriggerMap) {
                Set<String> key = entry.getKey();
                if (!updatedAttributes.containsAll(key)) continue;
                computedAttributes.add(entry.getValue());
            }
        }
        if (!computedAttributes.isEmpty()) {
            Iterator iterator = computedAttributes.iterator();
            while (iterator.hasNext()) {
                List<DevicePolicy.Function> pipeline;
                String attributeName = (String)iterator.next();
                VirtualDeviceAttributeBase<VirtualDevice, Object> attribute = this.getAttribute(attributeName);
                if (!attribute.isSettable()) {
                    VirtualDeviceImpl.getLogger().log(Level.WARNING, "attempt to modify read-only attribute '" + attributeName + "'");
                    computedAttributes.remove(attributeName);
                    continue;
                }
                DevicePolicy devicePolicy = this.devicePolicyManager.getPolicy(this.getDeviceModel().getURN(), this.getEndpointId());
                if (devicePolicy == null || (pipeline = devicePolicy.getPipeline(attributeName)) == null || pipeline.isEmpty()) continue;
                List<Map<String, Object>> pipelineData = this.getPipelineData(attributeName);
                Object policyValue = this.offer0(attribute.getDeviceModelAttribute(), attribute.get(), pipeline, pipelineData);
                if (policyValue != null) {
                    if (VirtualDeviceImpl.getLogger().isLoggable(Level.FINE)) {
                        VirtualDeviceImpl.getLogger().log(Level.FINE, this.getEndpointId() + " : Set   : \"" + attributeName + "\"=" + policyValue);
                    }
                    attribute.update(policyValue);
                    continue;
                }
                iterator.remove();
            }
        }
        return computedAttributes;
    }

    private <T> T cast(DeviceModelAttribute.Type type, Object newValue) {
        Number castValue = null;
        switch (type) {
            case INTEGER: {
                Number number = (Number)Number.class.cast(newValue);
                Long roundedValue = Math.round(number.doubleValue());
                castValue = roundedValue.intValue();
                break;
            }
            case NUMBER: {
                Number number = (Number)Number.class.cast(newValue);
                castValue = number.doubleValue();
                break;
            }
            case STRING: {
                castValue = (Number)String.class.cast(newValue);
                break;
            }
            case BOOLEAN: {
                castValue = (Number)Boolean.class.cast(newValue);
                break;
            }
            case DATETIME: {
                if (newValue instanceof Date) {
                    castValue = ((Date)Date.class.cast(newValue)).getTime();
                    break;
                }
                Number number = (Number)Number.class.cast(newValue);
                castValue = number.longValue();
                break;
            }
            case URI: {
                castValue = (Number)String.class.cast(newValue);
            }
        }
        return (T)castValue;
    }

    @Override
    public void setAttributeValue(String attribute, Object value) {
        this.set(attribute, value);
    }

    @Override
    public Object getAttributeValue(String attribute) {
        return this.get(attribute);
    }

    @Override
    public void call(String actionName, Object ... args) {
        VirtualDevice.Callable<?> callable = this.actionMap.get(actionName);
        if (callable == null) {
            VirtualDeviceImpl.getLogger().log(Level.WARNING, this.getDeviceModel().getURN() + " does not contain action '" + actionName + "'");
            return;
        }
        DeviceModelAction deviceModelAction = VirtualDeviceImpl.getDeviceModelAction(this.base.getDeviceModel(), actionName);
        DeviceModelAttribute.Type argType = deviceModelAction.getArgType();
        if (argType != null) {
            boolean goodArg;
            Object arg;
            Object object = arg = args != null && args.length > 0 ? args[0] : null;
            if (arg == null) {
                VirtualDeviceImpl.getLogger().log(Level.WARNING, this.getDeviceModel().getURN() + " action '" + actionName + "' requires an argument");
                return;
            }
            switch (argType) {
                case INTEGER: 
                case NUMBER: {
                    double lower;
                    double upper;
                    goodArg = arg instanceof Number;
                    if (!goodArg) break;
                    double val = ((Number)arg).doubleValue();
                    if (deviceModelAction.getUpperBound() != null && Double.compare(val, upper = deviceModelAction.getUpperBound().doubleValue()) > 0) {
                        VirtualDeviceImpl.getLogger().log(Level.WARNING, this.getDeviceModel().getURN() + " action '" + actionName + "' arg out of range: " + val + " > " + upper);
                    }
                    if (deviceModelAction.getLowerBound() == null || Double.compare(val, lower = deviceModelAction.getLowerBound().doubleValue()) >= 0) break;
                    VirtualDeviceImpl.getLogger().log(Level.WARNING, this.getDeviceModel().getURN() + " action '" + actionName + "' arg out of range: " + val + " < " + lower);
                    break;
                }
                case DATETIME: {
                    goodArg = arg instanceof Date;
                    break;
                }
                case BOOLEAN: {
                    goodArg = arg instanceof Boolean;
                    break;
                }
                case URI: 
                case STRING: {
                    goodArg = arg instanceof String;
                    break;
                }
                default: {
                    VirtualDeviceImpl.getLogger().log(Level.SEVERE, "unexpected type " + (Object)((Object)argType));
                    goodArg = false;
                }
            }
            if (!goodArg) {
                VirtualDeviceImpl.getLogger().log(Level.WARNING, this.getDeviceModel().getURN() + " action '" + actionName + "': wrong argument type. " + "Expected " + (Object)((Object)argType) + " found " + arg.getClass());
                return;
            }
            callable.call(this, arg);
        } else {
            callable.call(this, null);
        }
    }

    @Override
    public void queueMessage(Message message) {
        this.queueMessage(message, null);
    }

    private static Logger getLogger() {
        return LOGGER;
    }

    private class TimedPolicyThread
    extends Thread {
        private final List<ScheduledPolicyData> scheduledPolicyData;
        private transient boolean cancelled;

        private TimedPolicyThread() {
            super("timed-policy-thread" + timed_policy_thread_count++);
            this.scheduledPolicyData = new ArrayList<ScheduledPolicyData>();
            this.cancelled = false;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addTimedPolicyData(ScheduledPolicyData data) {
            List<ScheduledPolicyData> list = this.scheduledPolicyData;
            synchronized (list) {
                int index = this.scheduledPolicyData.indexOf(data);
                if (index == -1) {
                    this.scheduledPolicyData.add(data);
                } else {
                    this.scheduledPolicyData.set(index, data);
                }
                this.scheduledPolicyData.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeTimedPolicyData(ScheduledPolicyData data) {
            List<ScheduledPolicyData> list = this.scheduledPolicyData;
            synchronized (list) {
                this.scheduledPolicyData.remove(data);
                this.scheduledPolicyData.notify();
            }
        }

        private boolean isCancelled() {
            return this.cancelled;
        }

        private void cancel() {
            this.cancelled = true;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.cancelled) {
                long delay = -1L;
                List<ScheduledPolicyData> list = this.scheduledPolicyData;
                synchronized (list) {
                    while (!this.cancelled && this.scheduledPolicyData.isEmpty()) {
                        try {
                            this.scheduledPolicyData.wait();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    final long now = System.currentTimeMillis();
                    Collections.sort(this.scheduledPolicyData, new Comparator<ScheduledPolicyData>(){

                        @Override
                        public int compare(ScheduledPolicyData o1, ScheduledPolicyData o2) {
                            long y;
                            long x = o1.getDelay(now);
                            return x < (y = o2.getDelay(now)) ? -1 : (x == y ? 0 : 1);
                        }
                    });
                    delay = this.scheduledPolicyData.get(0).getDelay(now);
                    if (!this.cancelled && delay > 0L) {
                        try {
                            this.scheduledPolicyData.wait(delay);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        catch (IllegalArgumentException e) {
                            VirtualDeviceImpl.getLogger().log(Level.SEVERE, "wait(" + delay + ")", e);
                        }
                    }
                    long currentTimeMillis = System.currentTimeMillis();
                    ArrayList<Pair<VirtualDeviceAttributeBase<VirtualDevice, Object>, Object>> updatedAttributes = new ArrayList<Pair<VirtualDeviceAttributeBase<VirtualDevice, Object>, Object>>();
                    for (ScheduledPolicyData policyData : this.scheduledPolicyData) {
                        if (policyData.getDelay(currentTimeMillis) > 0L) continue;
                        policyData.processExpiredFunction(VirtualDeviceImpl.this, updatedAttributes, currentTimeMillis);
                    }
                    if (!updatedAttributes.isEmpty()) {
                        VirtualDeviceImpl.this.updateFields((List<Pair<VirtualDeviceAttributeBase<VirtualDevice, Object>, Object>>)updatedAttributes);
                    }
                }
            }
        }
    }

    private static class ScheduledPolicyData {
        private long expiry;
        private final long slide;
        private final Map<String, Integer> pipelineIndices;

        private ScheduledPolicyData(long window, long slide, long timeZero) {
            this.slide = slide;
            this.pipelineIndices = new HashMap<String, Integer>();
            this.expiry = (window + timeZero) / 10L * 10L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addAttribute(String attributeName, int pipelineIndex) {
            Map<String, Integer> map = this.pipelineIndices;
            synchronized (map) {
                this.pipelineIndices.put(attributeName, pipelineIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeAttribute(String attributeName, int pipelineIndex) {
            Map<String, Integer> map = this.pipelineIndices;
            synchronized (map) {
                this.pipelineIndices.remove(attributeName);
            }
        }

        private boolean isEmpty() {
            return this.pipelineIndices.isEmpty();
        }

        private long getDelay(long now) {
            long delay = this.expiry - now;
            return delay > 0L ? delay : 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processExpiredFunction(VirtualDeviceImpl virtualDeviceImpl, List<Pair<VirtualDeviceAttributeBase<VirtualDevice, Object>, Object>> updatedAttributes, long timeZero) {
            try {
                this.handleExpiredFunction(virtualDeviceImpl, updatedAttributes);
            }
            finally {
                this.expiry = (this.slide + timeZero) / 10L * 10L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleExpiredFunction(VirtualDeviceImpl virtualDeviceImpl, List<Pair<VirtualDeviceAttributeBase<VirtualDevice, Object>, Object>> updatedAttributes) {
            HashMap<String, Integer> pipelineIndicesCopy;
            DevicePolicy devicePolicy = virtualDeviceImpl.devicePolicyManager.getPolicy(virtualDeviceImpl.getDeviceModel().getURN(), virtualDeviceImpl.getEndpointId());
            if (devicePolicy == null) {
                if (VirtualDeviceImpl.getLogger().isLoggable(Level.SEVERE)) {
                    VirtualDeviceImpl.getLogger().log(Level.SEVERE, "could not find " + virtualDeviceImpl.getDeviceModel().getURN() + " in policy configuration");
                }
                return;
            }
            Map<String, Integer> map = this.pipelineIndices;
            synchronized (map) {
                pipelineIndicesCopy = new HashMap<String, Integer>(this.pipelineIndices);
            }
            this.handleExpiredFunction(virtualDeviceImpl, updatedAttributes, devicePolicy, pipelineIndicesCopy);
        }

        private void handleExpiredFunction(VirtualDeviceImpl virtualDeviceImpl, List<Pair<VirtualDeviceAttributeBase<VirtualDevice, Object>, Object>> updatedAttributes, DevicePolicy devicePolicy, Map<String, Integer> _pipelineIndices) {
            for (Map.Entry<String, Integer> entry : _pipelineIndices.entrySet()) {
                String attributeName = entry.getKey();
                Integer pipelineIndex = entry.getValue();
                this.handleExpiredFunction(virtualDeviceImpl, updatedAttributes, devicePolicy, attributeName, pipelineIndex);
            }
        }

        private void handleExpiredFunction(VirtualDeviceImpl virtualDeviceImpl, List<Pair<VirtualDeviceAttributeBase<VirtualDevice, Object>, Object>> updatedAttributes, DevicePolicy devicePolicy, String attributeName, int pipelineIndex) {
            List<DevicePolicy.Function> pipeline = devicePolicy.getPipeline(attributeName);
            if (pipeline == null || pipeline.isEmpty()) {
                return;
            }
            if (pipeline.size() <= pipelineIndex) {
                if (VirtualDeviceImpl.getLogger().isLoggable(Level.SEVERE)) {
                    VirtualDeviceImpl.getLogger().log(Level.SEVERE, "pipeline does not match configuration");
                }
                return;
            }
            List pipelineData = virtualDeviceImpl.getPipelineData(attributeName);
            if (pipelineData.size() <= pipelineIndex) {
                if (VirtualDeviceImpl.getLogger().isLoggable(Level.SEVERE)) {
                    VirtualDeviceImpl.getLogger().log(Level.SEVERE, "pipeline data does not match configuration");
                }
                return;
            }
            List<DevicePolicy.Function> remainingPipelineConfigs = pipeline.subList(pipelineIndex, pipeline.size());
            List remainingPipelineData = pipelineData.subList(pipelineIndex, pipelineData.size());
            if (!DevicePolicy.ALL_ATTRIBUTES().equals(attributeName)) {
                virtualDeviceImpl.processExpiredFunction(updatedAttributes, attributeName, remainingPipelineConfigs, remainingPipelineData);
            } else {
                virtualDeviceImpl.processExpiredFunction(remainingPipelineConfigs, remainingPipelineData);
            }
        }

        public int hashCode() {
            int hc = (int)(this.slide ^ this.slide >>> 32);
            return hc;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ScheduledPolicyData other = (ScheduledPolicyData)obj;
            return this.slide == other.slide;
        }

        private static class Key {
            private final long window;
            private final long slide;

            private Key(long window, long slide) {
                this.window = window;
                this.slide = slide;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Key key = (Key)o;
                return this.window == key.window && this.slide == key.slide;
            }

            public int hashCode() {
                return (int)((this.window ^ this.window >>> 32) + (this.slide ^ this.slide >>> 32));
            }
        }
    }

    private static class ErrorCallbackBridge
    implements MessageDispatcher.ErrorCallback {
        private final Map<String, WeakReference<VirtualDeviceImpl>> deviceSet = new HashMap<String, WeakReference<VirtualDeviceImpl>>();

        private ErrorCallbackBridge() {
        }

        void add(VirtualDeviceImpl virtualDevice) {
            if (this.deviceSet.size() > 0) {
                Iterator<Map.Entry<String, WeakReference<VirtualDeviceImpl>>> iterator = this.deviceSet.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, WeakReference<VirtualDeviceImpl>> entry = iterator.next();
                    WeakReference<VirtualDeviceImpl> ref = entry.getValue();
                    if (ref.get() != null) continue;
                    iterator.remove();
                }
            }
            assert (virtualDevice.getEndpointId() != null);
            this.deviceSet.put(virtualDevice.getEndpointId(), new WeakReference<VirtualDeviceImpl>(virtualDevice));
        }

        @Override
        public void failed(List<Message> messages, Exception exception) {
            ArrayList<Message> list;
            String source;
            HashMap<String, ArrayList<Message>> collatedMessages = new HashMap<String, ArrayList<Message>>(messages.size());
            for (Message message : messages) {
                source = message.getSource();
                list = (ArrayList<Message>)collatedMessages.get(source);
                if (list == null) {
                    list = new ArrayList<Message>();
                    collatedMessages.put(source, list);
                }
                list.add(message);
            }
            for (Map.Entry entry : collatedMessages.entrySet()) {
                VirtualDeviceImpl virtualDevice;
                source = (String)entry.getKey();
                list = (List)entry.getValue();
                WeakReference<VirtualDeviceImpl> ref = this.deviceSet.get(source);
                if (ref == null) {
                    new Exception("DEBUG source=" + source + " deviceSet=" + this.deviceSet).printStackTrace();
                }
                if ((virtualDevice = ref == null ? null : (VirtualDeviceImpl)ref.get()) == null) continue;
                this.invokeErrorCallback(virtualDevice, list, exception);
            }
        }

        private boolean isDataFormat(VirtualDeviceImpl virtualDevice, String format) {
            DeviceModelFormat deviceModelFormat;
            DeviceModelImpl deviceModel;
            Map<String, DeviceModelFormat> deviceModelFormats;
            if (format != null && (deviceModelFormats = (deviceModel = (DeviceModelImpl)virtualDevice.getDeviceModel()).getDeviceModelFormats()) != null && (deviceModelFormat = deviceModelFormats.get(format)) != null) {
                return deviceModelFormat.getType() == DeviceModelFormat.Type.DATA;
            }
            return false;
        }

        private void invokeErrorCallback(VirtualDeviceImpl virtualDevice, List<Message> messages, Exception exception) {
            VirtualDeviceBase.NamedValueImpl values = null;
            for (Message message : messages) {
                AbstractVirtualDevice.ErrorCallback errorCallback;
                boolean isAlertFormat = false;
                boolean isDataFormat = false;
                List<DataItem<?>> dataItems = null;
                if (message instanceof DataMessage) {
                    DataMessage dataMessage = (DataMessage)message;
                    dataItems = dataMessage.getDataItems();
                    String formatUrn = dataMessage.getFormat();
                    isDataFormat = this.isDataFormat(virtualDevice, formatUrn);
                } else if (message instanceof AlertMessage) {
                    AlertMessage alertMessage = (AlertMessage)message;
                    dataItems = alertMessage.getDataItems();
                    isAlertFormat = true;
                }
                if (dataItems != null) {
                    VirtualDeviceBase.NamedValueImpl last = null;
                    for (DataItem dataItem : dataItems) {
                        VirtualDeviceBase.NamedValueImpl namedValue = new VirtualDeviceBase.NamedValueImpl(dataItem.getKey(), dataItem.getValue());
                        if (!isAlertFormat && !isDataFormat && virtualDevice.attributeMap.containsKey(dataItem.getKey())) {
                            try {
                                VirtualDeviceAttributeBase<VirtualDevice, Object> attribute = virtualDevice.getAttribute(dataItem.getKey());
                                if (attribute.getOnError() != null) {
                                    attribute.getOnError().onError(new VirtualDeviceBase.ErrorEvent<VirtualDeviceImpl>(virtualDevice, namedValue, exception.getMessage()));
                                }
                            }
                            catch (IllegalArgumentException e) {
                                VirtualDeviceImpl.getLogger().log(Level.FINE, e.getMessage(), e);
                            }
                            catch (Exception e) {
                                VirtualDeviceImpl.getLogger().log(Level.FINE, e.getMessage(), e);
                            }
                        }
                        if (last != null) {
                            last.setNext(namedValue);
                            last = namedValue;
                            continue;
                        }
                        values = last = namedValue;
                    }
                }
                if ((errorCallback = isAlertFormat || isDataFormat ? VirtualDeviceImpl.removeOnErrorCallback(message.getClientId()) : virtualDevice.getErrorCallback()) == null) continue;
                try {
                    VirtualDeviceBase.ErrorEvent<VirtualDeviceImpl> errorEvent = new VirtualDeviceBase.ErrorEvent<VirtualDeviceImpl>(virtualDevice, values, exception.getMessage());
                    errorCallback.onError(errorEvent);
                }
                catch (Exception e) {
                    VirtualDeviceImpl.getLogger().log(Level.FINE, e.getMessage(), e);
                }
            }
        }
    }
}

