/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.device;

import com.oracle.iot.client.impl.device.PersistenceStore;
import java.util.HashMap;
import java.util.Map;

public class PersistenceStoreManager {
    private static Map<String, PersistenceStore> map = new HashMap<String, PersistenceStore>();

    public static PersistenceStore getPersistenceStore(String name) {
        PersistenceStore persistenceStore = map.get(name);
        if (persistenceStore == null) {
            persistenceStore = new InMemoryPersistenceStore(name);
            map.put(name, persistenceStore);
        }
        return persistenceStore;
    }

    private static class InMemoryPersistenceStore
    implements PersistenceStore {
        private final String name;
        private final Map<String, Object> map;

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Transaction openTransaction() {
            return new Transaction();
        }

        @Override
        public boolean contains(String key) {
            return this.map.containsKey(key);
        }

        @Override
        public Map<String, ?> getAll() {
            return new HashMap<String, Object>(this.map);
        }

        @Override
        public boolean getBoolean(String key, boolean defaultValue) {
            Object obj = this.map.get(key);
            return obj != null ? (Boolean)Boolean.class.cast(obj) : defaultValue;
        }

        @Override
        public double getDouble(String key, double defaultValue) {
            Object obj = this.map.get(key);
            return obj != null ? (Double)Double.class.cast(obj) : defaultValue;
        }

        @Override
        public float getFloat(String key, float defaultValue) {
            Object obj = this.map.get(key);
            return obj != null ? ((Float)Float.class.cast(obj)).floatValue() : defaultValue;
        }

        @Override
        public int getInt(String key, int defaultValue) {
            Object obj = this.map.get(key);
            return obj != null ? (Integer)Integer.class.cast(obj) : defaultValue;
        }

        @Override
        public long getLong(String key, long defaultValue) {
            Object obj = this.map.get(key);
            return obj != null ? (Long)Long.class.cast(obj) : defaultValue;
        }

        @Override
        public String getString(String key, String defaultValue) {
            Object obj = this.map.get(key);
            return obj != null ? (String)String.class.cast(obj) : defaultValue;
        }

        @Override
        public Object getOpaque(String key, Object defaultValue) {
            Object obj = this.map.get(key);
            return obj != null ? obj : defaultValue;
        }

        private InMemoryPersistenceStore(String name) {
            this.name = name;
            this.map = new HashMap<String, Object>();
        }

        private class Transaction
        implements PersistenceStore.Transaction {
            private final Map<String, Object> map = new HashMap<String, Object>();

            @Override
            public PersistenceStore.Transaction clear() {
                this.map.clear();
                return this;
            }

            @Override
            public boolean commit() {
                InMemoryPersistenceStore.this.map.putAll(this.map);
                return true;
            }

            @Override
            public PersistenceStore.Transaction putBoolean(String key, boolean value) {
                this.map.put(key, value);
                return this;
            }

            @Override
            public PersistenceStore.Transaction putDouble(String key, double value) {
                this.map.put(key, value);
                return this;
            }

            @Override
            public PersistenceStore.Transaction putFloat(String key, float value) {
                this.map.put(key, Float.valueOf(value));
                return this;
            }

            @Override
            public PersistenceStore.Transaction putInt(String key, int value) {
                this.map.put(key, value);
                return this;
            }

            @Override
            public PersistenceStore.Transaction putLong(String key, long value) {
                this.map.put(key, value);
                return this;
            }

            @Override
            public PersistenceStore.Transaction putString(String key, String value) {
                this.map.put(key, value);
                return this;
            }

            @Override
            public PersistenceStore.Transaction putOpaque(String key, Object value) {
                this.map.put(key, value);
                return this;
            }

            @Override
            public PersistenceStore.Transaction remove(String key) {
                this.map.remove(key);
                return this;
            }

            Transaction() {
            }
        }
    }
}

