/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.device;

import com.oracle.iot.client.impl.util.Base64;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DirectActivationRequest {
    public static final String FIELD_CERTIFICATION_REQUEST_INFO = "certificationRequestInfo";
    public static final String FIELD_SIGNATURE_ALGORITHM = "signatureAlgorithm";
    public static final String FIELD_SIGNATURE = "signature";
    public static final String FIELD_DEVICE_MODELS = "deviceModels";
    public static final String PUBLIC_KEY_ENCODING_FORMAT_X509 = "X.509";
    private Set<String> deviceModels = new HashSet<String>();
    private CertificationRequestInfo certificationRequestInfo;
    private String signatureAlgorithm;
    private byte[] signature;

    public CertificationRequestInfo getCertificationRequestInfo() {
        return this.certificationRequestInfo;
    }

    public void setCertificationRequestInfo(CertificationRequestInfo certificationRequestInfo) {
        this.certificationRequestInfo = certificationRequestInfo;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public Set<String> getDeviceModels() {
        return this.deviceModels;
    }

    public static DirectActivationRequest fromJson(String jsonString) {
        DirectActivationRequest request = new DirectActivationRequest();
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            if (jsonObject != null) {
                request.fromJson(jsonObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return request;
    }

    public void fromJson(JSONObject jsonObject) {
        this.certificationRequestInfo = new CertificationRequestInfo();
        JSONObject fieldJsonObject = jsonObject.optJSONObject(FIELD_CERTIFICATION_REQUEST_INFO);
        if (fieldJsonObject != null) {
            this.certificationRequestInfo.fromJson(fieldJsonObject);
        }
        this.setSignatureAlgorithm(jsonObject.opt(FIELD_SIGNATURE_ALGORITHM).toString());
        String encodedSignature = jsonObject.opt(FIELD_SIGNATURE).toString();
        this.setSignature(Base64.getDecoder().decode(encodedSignature));
        JSONArray deviceModelsArray = jsonObject.optJSONArray(FIELD_DEVICE_MODELS);
        if (deviceModelsArray != null) {
            int size = deviceModelsArray.length();
            for (int i = 0; i < size; ++i) {
                this.deviceModels.add(deviceModelsArray.opt(i).toString());
            }
        }
    }

    public String toJson() {
        JSONObject objectBuilder = new JSONObject();
        JSONArray deviceModels = new JSONArray();
        try {
            if (this.certificationRequestInfo != null) {
                objectBuilder.put(FIELD_CERTIFICATION_REQUEST_INFO, this.certificationRequestInfo.toJson());
            }
            objectBuilder.put(FIELD_SIGNATURE_ALGORITHM, this.signatureAlgorithm);
            objectBuilder.put(FIELD_SIGNATURE, Base64.getEncoder().encodeToString(this.signature));
            if (this.deviceModels != null) {
                Iterator<String> iterator = this.deviceModels.iterator();
                while (iterator.hasNext()) {
                    deviceModels.put(iterator.next());
                }
                objectBuilder.put(FIELD_DEVICE_MODELS, deviceModels);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return objectBuilder.toString();
    }

    public String toString() {
        return "DirectActivationRequest{deviceModels=" + this.deviceModels.toString() + ", certificationRequestInfo=" + this.certificationRequestInfo + ", signatureAlgorithm='" + this.signatureAlgorithm + '\'' + ", signature=" + Arrays.toString(this.signature) + '}';
    }

    public static class CertificationRequestInfo {
        public static final String FIELD_SUBJECT = "subject";
        public static final String FIELD_SUBJECT_PUBLIC_KEY_INFO = "subjectPublicKeyInfo";
        public static final String FIELD_ATTRIBUTES = "attributes";
        private String subject;
        private SubjectPublicKeyInfo subjectPublicKeyInfo;
        private Map<String, Object> attributes;

        public String getSubject() {
            return this.subject;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, Object> attributes) {
            this.attributes = attributes;
        }

        public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
            return this.subjectPublicKeyInfo;
        }

        public void setSubjectPublicKeyInfo(SubjectPublicKeyInfo subjectPublicKeyInfo) {
            this.subjectPublicKeyInfo = subjectPublicKeyInfo;
        }

        public String toString() {
            return "CertificationRequestInfo{subject='" + this.subject + '\'' + ", subjectPublicKeyInfo=" + this.subjectPublicKeyInfo + ", attributes=" + this.attributes + '}';
        }

        public JSONObject toJson() {
            JSONObject objectBuilder = new JSONObject();
            try {
                objectBuilder.put(FIELD_SUBJECT, this.subject);
                if (this.subjectPublicKeyInfo != null) {
                    objectBuilder.put(FIELD_SUBJECT_PUBLIC_KEY_INFO, this.subjectPublicKeyInfo.toJson());
                }
                JSONObject items = new JSONObject();
                if (this.attributes != null) {
                    CertificationRequestInfo.addEntries(this.attributes, items);
                }
                objectBuilder.put(FIELD_ATTRIBUTES, items);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            return objectBuilder;
        }

        private static void addEntries(Map<String, ?> map, JSONObject items) {
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                try {
                    if (value instanceof Number || value instanceof String || value instanceof Boolean || value instanceof JSONArray || value instanceof JSONObject) {
                        items.put(key, value);
                        continue;
                    }
                    items.put(key, value.toString());
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public void fromJson(JSONObject jsonObject) {
            if (jsonObject != null) {
                try {
                    this.setSubject(jsonObject.get(FIELD_SUBJECT).toString());
                    this.subjectPublicKeyInfo = new SubjectPublicKeyInfo();
                    JSONObject subjectPublicKeyInfoJsonObj = jsonObject.optJSONObject(FIELD_SUBJECT_PUBLIC_KEY_INFO);
                    if (subjectPublicKeyInfoJsonObj != null) {
                        this.subjectPublicKeyInfo.fromJson(subjectPublicKeyInfoJsonObj);
                    }
                    this.setAttributes(CertificationRequestInfo.getJsonMap(jsonObject.get(FIELD_ATTRIBUTES), FIELD_ATTRIBUTES));
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private static Map<String, Object> getJsonMap(Object value, String name) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof JSONObject)) {
                throw new IllegalArgumentException("expected '" + name + "' to be a map");
            }
            Object items = ((JSONObject)value).opt("items");
            if (items == null) {
                if (((JSONObject)value).opt("links") == null) {
                    items = value;
                } else {
                    return new HashMap<String, Object>();
                }
            }
            if (!(items instanceof JSONObject)) {
                throw new IllegalArgumentException("expected '" + name + ".items' to be a map, but found " + items);
            }
            JSONObject jsonItems = (JSONObject)items;
            Iterator<String> keys = jsonItems.keys();
            HashMap<String, Object> result = new HashMap<String, Object>();
            while (keys.hasNext()) {
                String[] v;
                String key = keys.next();
                String[] raw = jsonItems.opt(key);
                if (raw == null || raw instanceof String || raw instanceof Boolean) {
                    v = raw;
                } else if (raw instanceof Number) {
                    v = ((Number)raw).longValue();
                } else if (raw instanceof JSONArray) {
                    ArrayList<String> values = new ArrayList<String>();
                    JSONArray jsonArray = (JSONArray)raw;
                    int size = jsonArray.length();
                    for (int i = 0; i < size; ++i) {
                        values.add(jsonArray.opt(i).toString());
                    }
                    v = values.toArray(new String[0]);
                } else {
                    throw new IllegalArgumentException("unsupported map value '" + raw + "'");
                }
                result.put(key, v);
            }
            return result;
        }
    }

    public static class SubjectPublicKeyInfo {
        public static final String FIELD_ALGORITHM = "algorithm";
        public static final String FIELD_PUBLIC_KEY = "publicKey";
        public static final String FIELD_FORMAT = "format";
        public static final String FIELD_SECRET_HASH_ALGORITHM = "secretHashAlgorithm";
        private String algorithm;
        private byte[] publicKey;
        private String format = "X.509";
        private String secretHashAlgorithm;

        public String getAlgorithm() {
            return this.algorithm;
        }

        public void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        public byte[] getPublicKey() {
            return this.publicKey;
        }

        public void setPublicKey(byte[] subjectPublicKey) {
            this.publicKey = subjectPublicKey;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public String getSecretHashAlgorithm() {
            return this.secretHashAlgorithm;
        }

        public void setSecretHashAlgorithm(String secretHashAlgorithm) {
            this.secretHashAlgorithm = secretHashAlgorithm;
        }

        public JSONObject toJson() {
            JSONObject objectBuilder = new JSONObject();
            try {
                objectBuilder.put(FIELD_ALGORITHM, this.algorithm);
                objectBuilder.put(FIELD_PUBLIC_KEY, Base64.getEncoder().encodeToString(this.publicKey));
                objectBuilder.put(FIELD_FORMAT, this.format.toString());
                objectBuilder.put(FIELD_SECRET_HASH_ALGORITHM, this.secretHashAlgorithm.toString());
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            return objectBuilder;
        }

        public void fromJson(JSONObject jsonObject) {
            if (jsonObject != null) {
                this.setFormat(jsonObject.opt(FIELD_FORMAT).toString());
                this.setAlgorithm(jsonObject.opt(FIELD_ALGORITHM).toString());
                String encodedPublicKey = jsonObject.opt(FIELD_PUBLIC_KEY).toString();
                this.setPublicKey(Base64.getDecoder().decode(encodedPublicKey));
                this.setSecretHashAlgorithm(jsonObject.opt(FIELD_SECRET_HASH_ALGORITHM).toString());
            }
        }

        public String toString() {
            return "SubjectPublicKeyInfo{algorithm='" + this.algorithm + '\'' + ", publicKey=" + Arrays.toString(this.publicKey) + ", format='" + this.format + '\'' + ", secretHashAlgorithm='" + this.secretHashAlgorithm + '\'' + '}';
        }
    }
}

