/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.device;

import com.oracle.iot.client.HttpResponse;
import com.oracle.iot.client.RestApi;
import com.oracle.iot.client.SecureConnection;
import com.oracle.iot.client.TransportException;
import com.oracle.iot.client.device.DirectlyConnectedDevice;
import com.oracle.iot.client.device.GatewayDevice;
import com.oracle.iot.client.impl.device.DevicePolicy;
import com.oracle.iot.client.impl.device.PersistenceStore;
import com.oracle.iot.client.impl.device.PersistenceStoreManager;
import com.oracle.iot.client.message.RequestMessage;
import com.oracle.iot.client.message.ResponseMessage;
import com.oracle.iot.client.message.StatusCode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class DevicePolicyManager {
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");
    private static final String LOCAL_STORE;
    private final SecureConnection secureConnection;
    private final Map<String, Map<String, String>> policiesByDeviceId = new HashMap<String, Map<String, String>>();
    private final Map<String, DevicePolicy> policiesByPolicyId = new HashMap<String, DevicePolicy>();
    private final Map<String, Map<String, Set<String>>> policiesByDeviceModelUrn = new HashMap<String, Map<String, Set<String>>>();
    private final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();
    private final Lock policyChangeLock = new ReentrantLock();

    private static Logger getLogger() {
        return LOGGER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        if (changeListener == null) {
            return;
        }
        List<ChangeListener> list = this.changeListeners;
        synchronized (list) {
            this.changeListeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        if (changeListener == null) {
            return;
        }
        List<ChangeListener> list = this.changeListeners;
        synchronized (list) {
            this.changeListeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPolicyAssigned(DevicePolicy devicePolicy, Set<String> assignedDevices) {
        if (devicePolicy == null || assignedDevices.isEmpty()) {
            return;
        }
        List<ChangeListener> list = this.changeListeners;
        synchronized (list) {
            for (ChangeListener changeListener : this.changeListeners) {
                try {
                    changeListener.policyAssigned(devicePolicy, assignedDevices);
                }
                catch (Exception e) {
                    DevicePolicyManager.getLogger().log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPolicyUnassigned(DevicePolicy devicePolicy, Set<String> unassignedDevices) {
        if (devicePolicy == null || unassignedDevices.isEmpty()) {
            return;
        }
        List<ChangeListener> list = this.changeListeners;
        synchronized (list) {
            for (ChangeListener changeListener : this.changeListeners) {
                try {
                    changeListener.policyUnassigned(devicePolicy, unassignedDevices);
                }
                catch (Exception e) {
                    DevicePolicyManager.getLogger().log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    public static DevicePolicyManager getDevicePolicyManager(DirectlyConnectedDevice directlyConnectedDevice) {
        PersistenceStore persistenceStore = PersistenceStoreManager.getPersistenceStore(directlyConnectedDevice.getEndpointId());
        Object dpmObj = persistenceStore.getOpaque(DevicePolicyManager.class.getName(), null);
        if (dpmObj == null) {
            DevicePolicyManager.getLogger().log(Level.SEVERE, "cannot access DevicePolicyManager for " + directlyConnectedDevice.getEndpointId());
            return null;
        }
        return (DevicePolicyManager)DevicePolicyManager.class.cast(dpmObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DevicePolicy getPolicy(String deviceModelURN, String deviceId) {
        Map<String, Map<String, String>> map = this.policiesByDeviceId;
        synchronized (map) {
            Map<String, String> devicePolicies = this.policiesByDeviceId.get(deviceId);
            if (devicePolicies != null && devicePolicies.containsKey(deviceModelURN)) {
                String policyId = devicePolicies.get(deviceModelURN);
                DevicePolicy devicePolicy = policyId != null ? this.policiesByPolicyId.get(policyId) : null;
                return devicePolicy;
            }
        }
        this.policyChangeLock.lock();
        try {
            DevicePolicy devicePolicy = this.lookupPolicyForDevice(deviceModelURN, deviceId);
            Map<String, String> polices = this.policiesByDeviceId.get(deviceId);
            if (polices == null) {
                polices = new HashMap<String, String>();
                this.policiesByDeviceId.put(deviceId, polices);
            }
            String policyId = devicePolicy != null ? devicePolicy.getId() : null;
            polices.put(deviceModelURN, policyId);
            if (devicePolicy != null) {
                HashSet<String> assignedDevices = new HashSet<String>();
                assignedDevices.add(deviceId);
                this.notifyPolicyAssigned(devicePolicy, assignedDevices);
            }
            DevicePolicy devicePolicy2 = devicePolicy;
            return devicePolicy2;
        }
        finally {
            this.policyChangeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseMessage policyChanged(DirectlyConnectedDevice directlyConnectedDevice, RequestMessage requestMessage) {
        boolean dcdIsGatewayDevice = directlyConnectedDevice instanceof GatewayDevice;
        String endpointId = directlyConnectedDevice.getEndpointId();
        String body = requestMessage.getBodyString();
        this.policyChangeLock.lock();
        try {
            JSONArray items = new JSONArray(body);
            int nMax = items.length();
            for (int n = 0; n < nMax; ++n) {
                JSONObject item = items.getJSONObject(n);
                String op = item.optString("op", "changed");
                String deviceModelUrn = item.getString("deviceModelUrn");
                String policyId = item.getString("id");
                long lastModified = item.getLong("lastModified");
                if ("unassigned".equals(op)) {
                    this.processUnassign(deviceModelUrn, policyId, endpointId, dcdIsGatewayDevice, lastModified);
                    continue;
                }
                if ("assigned".equals(op)) {
                    this.processAssign(deviceModelUrn, policyId, endpointId, dcdIsGatewayDevice, lastModified);
                    continue;
                }
                if ("changed".equals(op)) {
                    DevicePolicy policyAfterChange;
                    DevicePolicy policyBeforeChange = this.policiesByPolicyId.get(policyId);
                    if (policyBeforeChange == null) {
                        Set<String> assignedDevices;
                        Map<String, Set<String>> policies = this.policiesByDeviceModelUrn.get(deviceModelUrn);
                        if (policies == null || (assignedDevices = policies.remove(policyId)) == null) continue;
                        Map<String, Map<String, String>> map = this.policiesByDeviceId;
                        synchronized (map) {
                            for (String deviceId : assignedDevices) {
                                Map<String, String> devicePolicies = this.policiesByDeviceId.get(deviceId);
                                if (devicePolicies == null) continue;
                                devicePolicies.remove(policyId);
                            }
                            continue;
                        }
                    }
                    Map<String, Set<String>> policies = this.policiesByDeviceModelUrn.get(deviceModelUrn);
                    Set<String> assignedDevices = policies != null ? policies.get(policyId) : null;
                    if (assignedDevices != null && policyBeforeChange != null) {
                        this.notifyPolicyUnassigned(policyBeforeChange, assignedDevices);
                    }
                    this.processPipelineChanged(directlyConnectedDevice, deviceModelUrn, policyId, lastModified);
                    if (assignedDevices == null || (policyAfterChange = this.policiesByPolicyId.get(policyId)) == null) continue;
                    this.notifyPolicyAssigned(policyAfterChange, assignedDevices);
                    continue;
                }
                DevicePolicyManager.getLogger().log(Level.WARNING, requestMessage.getURL() + " invalid operation: " + item);
            }
        }
        catch (JSONException e) {
            ResponseMessage responseMessage;
            DevicePolicyManager.getLogger().log(Level.SEVERE, requestMessage.getURL() + " body=" + body, e);
            ResponseMessage responseMessage2 = responseMessage = new ResponseMessage.Builder(requestMessage).statusCode(StatusCode.BAD_REQUEST).body(e.getMessage()).build();
            return responseMessage2;
        }
        finally {
            this.policyChangeLock.unlock();
        }
        ResponseMessage responseMessage = new ResponseMessage.Builder(requestMessage).statusCode(StatusCode.OK).build();
        return responseMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPipelineChanged(DirectlyConnectedDevice directlyConnectedDevice, String deviceModelUrn, String policyId, long lastModified) {
        DevicePolicy devicePolicy;
        DevicePolicy currentDevicePolicy = this.policiesByPolicyId.get(policyId);
        if (currentDevicePolicy != null && lastModified < currentDevicePolicy.getLastModified()) {
            return;
        }
        Map<String, Map<String, String>> map = this.policiesByDeviceId;
        synchronized (map) {
            devicePolicy = this.downloadPolicy(deviceModelUrn, policyId);
        }
        if (devicePolicy != null && DevicePolicyManager.getLogger().isLoggable(Level.FINE)) {
            DevicePolicyManager.getLogger().log(Level.FINE, directlyConnectedDevice.getEndpointId() + " : Policy changed : \"" + devicePolicy.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void processAssign(String deviceModelUrn, String policyId, String endpointId, boolean dcdIsGatewayDevice, long lastModified) {
        assignedDevices = null;
        if (dcdIsGatewayDevice) {
            couldNotGetIcds = true;
            try {
                assignedDevices = this.getIndirectlyConnectedDeviceIdsForPolicy(deviceModelUrn, policyId, endpointId);
                couldNotGetIcds = false;
            }
            catch (IOException e) {
                if (!couldNotGetIcds) ** GOTO lbl48
                deviceModelPolicies = this.policiesByDeviceModelUrn.get(deviceModelUrn);
                if (deviceModelPolicies != null && (assignedDeviceIds = deviceModelPolicies.remove(policyId)) != null) {
                    for (String deviceId : assignedDeviceIds) {
                        assignedPolicies = this.policiesByDeviceId.get(deviceId);
                        if (assignedPolicies != null) {
                            assignedPolicies.remove(deviceModelUrn);
                        }
                        this.removePersistedAssociation(deviceModelUrn, policyId, deviceId);
                    }
                }
                return;
            }
            catch (GeneralSecurityException e) {
                if (!couldNotGetIcds) ** GOTO lbl48
                deviceModelPolicies = this.policiesByDeviceModelUrn.get(deviceModelUrn);
                if (deviceModelPolicies != null && (assignedDeviceIds = deviceModelPolicies.remove(policyId)) != null) {
                    for (String deviceId : assignedDeviceIds) {
                        assignedPolicies = this.policiesByDeviceId.get(deviceId);
                        if (assignedPolicies != null) {
                            assignedPolicies.remove(deviceModelUrn);
                        }
                        this.removePersistedAssociation(deviceModelUrn, policyId, deviceId);
                    }
                }
                return;
            }
            finally {
                if (couldNotGetIcds) {
                    deviceModelPolicies = this.policiesByDeviceModelUrn.get(deviceModelUrn);
                    if (deviceModelPolicies != null && (assignedDeviceIds = deviceModelPolicies.remove(policyId)) != null) {
                        for (String deviceId : assignedDeviceIds) {
                            assignedPolicies = this.policiesByDeviceId.get(deviceId);
                            if (assignedPolicies != null) {
                                assignedPolicies.remove(deviceModelUrn);
                            }
                            this.removePersistedAssociation(deviceModelUrn, policyId, deviceId);
                        }
                    }
                    return;
                }
            }
        } else {
            assignedDevices = new HashSet<String>();
            assignedDevices.add(endpointId);
        }
lbl48:
        // 4 sources

        if (assignedDevices == null || assignedDevices.isEmpty()) {
            return;
        }
        couldNotGetIcds = this.policiesByDeviceId;
        synchronized (couldNotGetIcds) {
            newPolicy = this.downloadPolicy(deviceModelUrn, policyId);
            this.policiesByPolicyId.put(policyId, newPolicy);
            for (String deviceId : assignedDevices) {
                this.assignPolicyToDevice(deviceModelUrn, policyId, deviceId, lastModified);
            }
        }
        devicePolicy = this.policiesByPolicyId.get(policyId);
        if (devicePolicy != null) {
            this.notifyPolicyAssigned(devicePolicy, assignedDevices);
        }
    }

    private void assignPolicyToDevice(String deviceModelUrn, String policyId, String deviceId, long lastModified) {
        Map<String, String> policies = this.policiesByDeviceId.get(deviceId);
        String currentPolicyId = policies != null ? policies.get(deviceModelUrn) : null;
        if (policyId.equals(currentPolicyId)) {
            return;
        }
        DevicePolicy devicePolicy = this.policiesByPolicyId.get(policyId);
        if (devicePolicy == null) {
            devicePolicy = this.loadLocalDevicePolicy(deviceModelUrn, policyId);
            if (devicePolicy == null) {
                devicePolicy = this.downloadPolicy(deviceModelUrn, policyId);
            }
            this.policiesByPolicyId.put(policyId, devicePolicy);
            if (devicePolicy != null && DevicePolicyManager.getLogger().isLoggable(Level.FINE)) {
                DevicePolicyManager.getLogger().log(Level.FINE, deviceId.replaceAll(".", " ") + " : Policy : " + devicePolicy.getId() + "\n" + devicePolicy.toString());
            }
        }
        if (devicePolicy != null) {
            Set<String> assignedDevices;
            Map<String, String> devicePolicies = this.policiesByDeviceId.get(deviceId);
            if (devicePolicies == null) {
                devicePolicies = new HashMap<String, String>();
                this.policiesByDeviceId.put(deviceId, devicePolicies);
            }
            devicePolicies.put(deviceModelUrn, policyId);
            Map<String, Set<String>> deviceModelPolicies = this.policiesByDeviceModelUrn.get(deviceModelUrn);
            if (deviceModelPolicies == null) {
                deviceModelPolicies = new HashMap<String, Set<String>>();
                this.policiesByDeviceModelUrn.put(deviceModelUrn, deviceModelPolicies);
            }
            if ((assignedDevices = deviceModelPolicies.get(policyId)) == null) {
                assignedDevices = new HashSet<String>();
                deviceModelPolicies.put(policyId, assignedDevices);
            }
            assignedDevices.add(deviceId);
            if (currentPolicyId != null) {
                this.removePersistedAssociation(deviceModelUrn, currentPolicyId, deviceId);
            }
            this.persistAssociation(deviceModelUrn, policyId, deviceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUnassign(String deviceModelUrn, String policyId, String endpointId, boolean dcdIsGatewayDevice, long lastModified) {
        Set<String> unassignedDevices;
        Map<String, Set<String>> policies = this.policiesByDeviceModelUrn.get(deviceModelUrn);
        if (policies != null) {
            unassignedDevices = policies.get(policyId);
            if (unassignedDevices == null) {
                return;
            }
        } else {
            return;
        }
        if (!dcdIsGatewayDevice) {
            if (!unassignedDevices.contains(endpointId)) {
                return;
            }
            unassignedDevices.clear();
            unassignedDevices.add(endpointId);
        }
        boolean couldNotGetIcds = dcdIsGatewayDevice;
        if (dcdIsGatewayDevice) {
            try {
                Set<String> serverAssignedDevices = this.getIndirectlyConnectedDeviceIdsForPolicy(deviceModelUrn, policyId, endpointId);
                couldNotGetIcds = false;
                unassignedDevices.removeAll(serverAssignedDevices);
                if (unassignedDevices.isEmpty()) {
                    return;
                }
            }
            catch (IOException e) {
            }
            catch (GeneralSecurityException e) {
                // empty catch block
            }
        }
        DevicePolicy devicePolicy = this.policiesByPolicyId.get(policyId);
        assert (devicePolicy != null);
        this.notifyPolicyUnassigned(devicePolicy, unassignedDevices);
        Map<String, Map<String, String>> map = this.policiesByDeviceId;
        synchronized (map) {
            for (String deviceId : unassignedDevices) {
                Map<String, String> devicePolicies;
                this.unassignPolicyFromDevice(deviceModelUrn, policyId, deviceId, lastModified);
                if (!couldNotGetIcds || (devicePolicies = this.policiesByDeviceId.get(deviceId)) == null) continue;
                devicePolicies.remove(deviceModelUrn);
            }
        }
    }

    private boolean unassignPolicyFromDevice(String deviceModelUrn, String policyId, String deviceId, long lastModified) {
        Map<String, String> policies = this.policiesByDeviceId.get(deviceId);
        String currentPolicyId = policies != null ? policies.get(deviceModelUrn) : null;
        if (currentPolicyId == null) {
            return true;
        }
        boolean badMapping = false;
        if (!policyId.equals(currentPolicyId)) {
            DevicePolicy devicePolicy = this.policiesByPolicyId.get(currentPolicyId);
            if (devicePolicy != null) {
                if (devicePolicy.getLastModified() > lastModified) {
                    return false;
                }
                badMapping = true;
            } else {
                Map<String, String> devicePolicies = this.policiesByDeviceId.get(deviceId);
                if (devicePolicies != null) {
                    devicePolicies.remove(deviceModelUrn);
                }
                this.removePersistedAssociation(deviceModelUrn, currentPolicyId, deviceId);
                return true;
            }
        }
        if (policies != null) {
            if (!badMapping) {
                policies.put(deviceModelUrn, null);
            } else {
                policies.remove(deviceModelUrn);
            }
        }
        this.removePersistedAssociation(deviceModelUrn, policyId, deviceId);
        return true;
    }

    private DevicePolicy downloadPolicy(String deviceModelUrn, String policyId) {
        String query;
        String urn;
        try {
            urn = URLEncoder.encode(deviceModelUrn, "UTF-8");
        }
        catch (UnsupportedEncodingException cannot_happen) {
            throw new RuntimeException(cannot_happen);
        }
        try {
            String fields = URLEncoder.encode("id,pipelines,enabled,lastModified", "UTF-8");
            query = "?fields=" + fields;
        }
        catch (UnsupportedEncodingException cannot_happen) {
            throw new RuntimeException(cannot_happen);
        }
        String uri = RestApi.V2.getPrivateRoot() + "/deviceModels/" + urn + "/devicePolicies/" + policyId + query;
        byte[] data = null;
        try {
            HttpResponse res = this.secureConnection.get(uri);
            int status = res.getStatus();
            if (status != StatusCode.OK.getCode()) {
                throw new TransportException(status, uri);
            }
            data = res.getData();
        }
        catch (IOException e) {
            DevicePolicyManager.getLogger().log(Level.WARNING, "GET " + uri, e);
        }
        catch (GeneralSecurityException e) {
            DevicePolicyManager.getLogger().log(Level.WARNING, "GET " + uri, e);
        }
        DevicePolicy devicePolicy = null;
        if (data != null && data.length > 2) {
            String jsonString;
            try {
                jsonString = new String(data, "UTF-8");
            }
            catch (UnsupportedEncodingException cannot_happen) {
                throw new RuntimeException(cannot_happen);
            }
            try {
                JSONObject policyJson = new JSONObject(jsonString);
                devicePolicy = DevicePolicyManager.devicePolicyFromJSON(deviceModelUrn, policyJson);
                this.persistPolicy(policyJson);
                this.policiesByPolicyId.put(policyId, devicePolicy);
                Map<String, Set<String>> policies = this.policiesByDeviceModelUrn.get(deviceModelUrn);
                if (policies == null) {
                    policies = new HashMap<String, Set<String>>();
                    this.policiesByDeviceModelUrn.put(deviceModelUrn, policies);
                }
                if (devicePolicy != null && DevicePolicyManager.getLogger().isLoggable(Level.FINE)) {
                    DevicePolicyManager.getLogger().log(Level.FINE, policyId.replaceAll(".", " ") + " : Policy : " + devicePolicy.getId() + "\n" + devicePolicy.toString());
                }
            }
            catch (JSONException e) {
                DevicePolicyManager.getLogger().log(Level.SEVERE, e.getMessage());
            }
        }
        return devicePolicy;
    }

    private DevicePolicy lookupPolicyForDevice(String deviceModelUrn, String deviceId) {
        String query;
        String urn;
        DevicePolicy devicePolicy;
        Map<String, Set<String>> policies = this.policiesByDeviceModelUrn.get(deviceModelUrn);
        if (policies != null) {
            for (Map.Entry<String, Set<String>> entry : policies.entrySet()) {
                String policyId = entry.getKey();
                Set<String> deviceIds = entry.getValue();
                if (!deviceIds.contains(deviceId) || (devicePolicy = this.policiesByPolicyId.get(policyId)) == null) continue;
                return devicePolicy;
            }
        }
        try {
            urn = URLEncoder.encode(deviceModelUrn, "UTF-8");
        }
        catch (UnsupportedEncodingException cannot_happen) {
            throw new RuntimeException(cannot_happen);
        }
        try {
            String devicesDotId = URLEncoder.encode("{\"devices.id\":\"" + deviceId + "\"}", "UTF-8");
            String fields = URLEncoder.encode("id,pipelines,enabled,lastModified", "UTF-8");
            query = "?q=" + devicesDotId + "&fields=" + fields;
        }
        catch (UnsupportedEncodingException cannot_happen) {
            throw new RuntimeException(cannot_happen);
        }
        String uri = RestApi.V2.getPrivateRoot() + "/deviceModels/" + urn + "/devicePolicies" + query;
        byte[] data = null;
        try {
            HttpResponse res = this.secureConnection.get(uri);
            int status = res.getStatus();
            if (status != StatusCode.OK.getCode()) {
                throw new TransportException(status, uri);
            }
            data = res.getData();
        }
        catch (IOException e) {
            DevicePolicyManager.getLogger().log(Level.WARNING, "GET " + uri, e);
        }
        catch (GeneralSecurityException e) {
            DevicePolicyManager.getLogger().log(Level.WARNING, "GET " + uri, e);
        }
        devicePolicy = null;
        if (data != null && data.length > 2) {
            String jsonString;
            try {
                jsonString = new String(data, "UTF-8");
            }
            catch (UnsupportedEncodingException cannot_happen) {
                throw new RuntimeException(cannot_happen);
            }
            try {
                JSONObject devicePolicies = new JSONObject(jsonString);
                JSONArray items = devicePolicies.getJSONArray("items");
                if (items.length() > 0) {
                    JSONObject item = items.getJSONObject(0);
                    devicePolicy = DevicePolicyManager.devicePolicyFromJSON(deviceModelUrn, item);
                    this.persistPolicy(item);
                }
            }
            catch (JSONException e) {
                DevicePolicyManager.getLogger().log(Level.SEVERE, e.getMessage());
            }
        }
        if (devicePolicy != null) {
            Set<String> deviceIds;
            String policyId = devicePolicy.getId();
            if (!this.policiesByPolicyId.containsKey(policyId)) {
                this.policiesByPolicyId.put(policyId, devicePolicy);
                if (devicePolicy != null && DevicePolicyManager.getLogger().isLoggable(Level.FINE)) {
                    DevicePolicyManager.getLogger().log(Level.FINE, policyId.replaceAll(".", " ") + " : Policy : " + devicePolicy.getId() + "\n" + devicePolicy.toString());
                }
            }
            if ((policies = this.policiesByDeviceModelUrn.get(deviceModelUrn)) == null) {
                policies = new HashMap<String, Set<String>>();
                this.policiesByDeviceModelUrn.put(deviceModelUrn, policies);
            }
            if ((deviceIds = policies.get(policyId)) == null) {
                deviceIds = new HashSet<String>();
                policies.put(policyId, deviceIds);
            }
            deviceIds.add(deviceId);
            this.persistAssociation(deviceModelUrn, devicePolicy.getId(), deviceId);
        }
        return devicePolicy;
    }

    private Set<String> getIndirectlyConnectedDeviceIdsForPolicy(String deviceModelUrn, String policyId, String directlyConnectedOwner) throws IOException, GeneralSecurityException {
        String body;
        byte[] data;
        String query;
        String urn;
        try {
            urn = URLEncoder.encode(deviceModelUrn, "UTF-8");
        }
        catch (UnsupportedEncodingException cannot_happen) {
            throw new RuntimeException(cannot_happen);
        }
        try {
            String icdFilter = URLEncoder.encode("{\"directlyConnectedOwner\":\"" + directlyConnectedOwner + "\"}", "UTF-8");
            query = "?q=" + icdFilter + "&fields=id";
        }
        catch (UnsupportedEncodingException cannot_happen) {
            throw new RuntimeException(cannot_happen);
        }
        String uri = RestApi.V2.getPrivateRoot() + "/deviceModels/" + urn + "/devicePolicies/" + policyId + "/devices" + query;
        HttpResponse res = this.secureConnection.get(uri);
        int status = res.getStatus();
        if (status != StatusCode.OK.getCode()) {
            DevicePolicyManager.getLogger().log(Level.WARNING, res.getVerboseStatus("GET", uri));
        }
        if ((data = res.getData()) == null || data.length == 2) {
            return Collections.emptySet();
        }
        try {
            body = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException cannot_happen) {
            throw new RuntimeException(cannot_happen);
        }
        HashSet<String> icdIds = new HashSet<String>();
        try {
            JSONObject jsonObject = new JSONObject(body);
            JSONArray items = jsonObject.getJSONArray("items");
            int nMax = items.length();
            for (int n = 0; n < nMax; ++n) {
                JSONObject item = items.getJSONObject(n);
                String icdId = item.getString("id");
                icdIds.add(icdId);
            }
        }
        catch (JSONException e) {
            DevicePolicyManager.getLogger().log(Level.SEVERE, e.getMessage());
        }
        return icdIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void persistPolicy(JSONObject policy) {
        block24: {
            String policyId;
            if (LOCAL_STORE == null) {
                return;
            }
            try {
                policyId = policy.getString("id");
            }
            catch (JSONException e) {
                DevicePolicyManager.getLogger().log(Level.WARNING, "policy not persisted: " + e.getMessage());
                return;
            }
            File policyFile = new File(LOCAL_STORE, policyId);
            FileOutputStream fileOutputStream = null;
            try {
                byte[] data = policy.toString(4).getBytes("UTF-8");
                fileOutputStream = new FileOutputStream(policyFile);
                fileOutputStream.write(data);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            catch (JSONException e) {
                DevicePolicyManager.getLogger().log(Level.WARNING, policyFile.getName() + " could not be written: " + e.getMessage());
                return;
            }
            catch (FileNotFoundException e) {
                DevicePolicyManager.getLogger().log(Level.WARNING, policyFile.getName() + " could not be written: " + e.toString());
            }
            catch (IOException e2) {
                DevicePolicyManager.getLogger().log(Level.WARNING, e2.toString());
                break block24;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException ignored) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void persistAssociation(String deviceModelURN, String policyId, String deviceId) {
        JSONObject associations = null;
        File associationsFile = new File(LOCAL_STORE, "device-associations.json");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(associationsFile);
            StringBuffer buffer = new StringBuffer();
            int c = -1;
            while ((c = fileInputStream.read()) != -1) {
                buffer.append((char)c);
            }
            associations = new JSONObject(buffer.toString());
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            DevicePolicyManager.getLogger().log(Level.SEVERE, associationsFile.getName() + " could not be read: " + e.getMessage());
        }
        catch (JSONException e) {
            DevicePolicyManager.getLogger().log(Level.SEVERE, associationsFile.getName() + " corrupted: " + e.getMessage());
            return;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException ignored) {}
            }
        }
        if (associations == null) {
            try {
                associations = new JSONObject().put("devicePolicyIdsToEndpointIds", new JSONObject()).put("deviceModelUrnsToDevicePolicies", new JSONObject());
            }
            catch (JSONException e) {
                DevicePolicyManager.getLogger().log(Level.WARNING, associationsFile.getName() + " could not be written: " + e.getMessage());
                return;
            }
        }
        try {
            JSONObject policyAssociations = associations.getJSONObject("devicePolicyIdsToEndpointIds");
            JSONArray associatedEndpoints = policyAssociations.optJSONArray(policyId);
            if (associatedEndpoints != null) {
                boolean found = false;
                int nMax = associatedEndpoints.length();
                for (int n = 0; !found && n < nMax; ++n) {
                    found = deviceId.equals(associatedEndpoints.getString(n));
                }
                if (!found) {
                    associatedEndpoints.put(deviceId);
                }
            } else {
                policyAssociations.put(policyId, new JSONArray().put(deviceId));
            }
            JSONObject modelAssociations = associations.getJSONObject("deviceModelUrnsToDevicePolicies");
            JSONArray associatedPolicies = modelAssociations.optJSONArray(deviceModelURN);
            if (associatedPolicies != null) {
                boolean found = false;
                int nMax = associatedPolicies.length();
                for (int n = 0; !found && n < nMax; ++n) {
                    found = policyId.equals(associatedPolicies.getString(n));
                }
                if (!found) {
                    associatedPolicies.put(policyId);
                }
            } else {
                modelAssociations.put(deviceModelURN, new JSONArray().put(policyId));
            }
        }
        catch (JSONException e) {
            DevicePolicyManager.getLogger().log(Level.SEVERE, associationsFile.getName() + " corrupted: " + e.getMessage());
            return;
        }
        FileOutputStream fileOutputStream = null;
        try {
            byte[] bytes = associations.toString(4).getBytes("UTF-8");
            fileOutputStream = new FileOutputStream(associationsFile);
            fileOutputStream.write(bytes);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (JSONException e) {
            DevicePolicyManager.getLogger().log(Level.WARNING, associationsFile.getName() + " could not be written: " + e.getMessage());
            return;
        }
        catch (IOException e) {
            DevicePolicyManager.getLogger().log(Level.SEVERE, e.toString());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void removePersistedAssociation(String deviceModelURN, String policyId, String deviceId) {
        JSONObject associations = null;
        File associationsFile = new File(LOCAL_STORE, "device-associations.json");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(associationsFile);
            StringBuffer buffer = new StringBuffer();
            int c = -1;
            while ((c = fileInputStream.read()) != -1) {
                buffer.append((char)c);
            }
            associations = new JSONObject(buffer.toString());
        }
        catch (FileNotFoundException e) {
            return;
            catch (IOException e2) {
                DevicePolicyManager.getLogger().log(Level.SEVERE, associationsFile.getName() + " could not be read: " + e2.getMessage());
                return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                catch (JSONException e3) {
                    DevicePolicyManager.getLogger().log(Level.SEVERE, associationsFile.getName() + " corrupted: " + e3.getMessage());
                    return;
                }
            }
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException ignored) {}
            }
        }
        assert (associations != null);
        if (associations == null) {
            return;
        }
        try {
            JSONObject policyAssociations = associations.getJSONObject("devicePolicyIdsToEndpointIds");
            JSONArray associatedEndpoints = policyAssociations.optJSONArray(policyId);
            if (associatedEndpoints != null) {
                for (int n = associatedEndpoints.length() - 1; 0 <= n; --n) {
                    if (!deviceId.equals(associatedEndpoints.getString(n))) continue;
                    associatedEndpoints.remove(n);
                }
            }
        }
        catch (JSONException e) {
            DevicePolicyManager.getLogger().log(Level.SEVERE, associationsFile.getName() + " corrupted: " + e.getMessage());
            return;
        }
        FileOutputStream fileOutputStream = null;
        try {
            byte[] bytes = associations.toString(4).getBytes("UTF-8");
            fileOutputStream = new FileOutputStream(associationsFile);
            fileOutputStream.write(bytes);
            return;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (JSONException e) {
            DevicePolicyManager.getLogger().log(Level.WARNING, associationsFile.getName() + " could not be written: " + e.getMessage());
            return;
        }
        catch (IOException e) {
            DevicePolicyManager.getLogger().log(Level.SEVERE, e.toString());
            return;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initializeFromPersistedData() {
        if (DevicePolicyManager.LOCAL_STORE == null) {
            return;
        }
        associationsFile = new File(DevicePolicyManager.LOCAL_STORE, "device-associations.json");
        fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(associationsFile);
            buffer = new StringBuffer();
            c = -1;
            while ((c = fileInputStream.read()) != -1) {
                buffer.append((char)c);
            }
            associations = new JSONObject(buffer.toString());
        }
        catch (FileNotFoundException e) {
            return;
            catch (IOException e) {
                DevicePolicyManager.getLogger().log(Level.SEVERE, associationsFile.getName() + " could not be read: " + e.getMessage());
                return;
                {
                    catch (Throwable var6_15) {
                        throw var6_15;
                    }
                }
                catch (JSONException e) {
                    DevicePolicyManager.getLogger().log(Level.SEVERE, associationsFile.getName() + " corrupted: " + e.getMessage());
                    return;
                }
            }
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException ignored) {}
            }
        }
        try {
            modelAssociations = associations.getJSONObject("deviceModelUrnsToDevicePolicies");
            policyAssociations = associations.getJSONObject("devicePolicyIdsToEndpointIds");
            policyIdToDeviceModelUrn = new HashMap<String, String>();
            deviceModelUrns = modelAssociations.keys();
            while (deviceModelUrns.hasNext()) {
                deviceModelUrn = deviceModelUrns.next();
                deviceModelPolicies = new HashMap<String, HashSet<E>>();
                this.policiesByDeviceModelUrn.put(deviceModelUrn, deviceModelPolicies);
                policyIds = modelAssociations.getJSONArray(deviceModelUrn);
                nMax = policyIds.length();
                for (n = 0; n < nMax; ++n) {
                    policyId = policyIds.getString(n);
                    devicePolicy = this.loadLocalDevicePolicy(deviceModelUrn, policyId);
                    if (devicePolicy == null) {
                        devicePolicy = this.downloadPolicy(deviceModelUrn, policyId);
                    }
                    if (devicePolicy == null) continue;
                    deviceModelPolicies.put(policyId, new HashSet<E>());
                    policyIdToDeviceModelUrn.put(policyId, deviceModelUrn);
                    this.policiesByPolicyId.put(policyId, devicePolicy);
                    if (!DevicePolicyManager.getLogger().isLoggable(Level.FINE)) continue;
                    DevicePolicyManager.getLogger().log(Level.FINE, policyId.replaceAll(".", " ") + " : Policy : " + devicePolicy.getId() + "\n" + devicePolicy.toString());
                }
            }
            policyIds = policyAssociations.keys();
            block24: while (true) {
                if (policyIds.hasNext() == false) return;
                policyId = policyIds.next();
                deviceModelUrn = (String)policyIdToDeviceModelUrn.get(policyId);
                if (deviceModelUrn == null) continue;
                deviceModelPolicies = this.policiesByDeviceModelUrn.get(deviceModelUrn);
                if (!DevicePolicyManager.$assertionsDisabled && deviceModelPolicies == null) {
                    throw new AssertionError();
                }
                if (deviceModelPolicies == null || (assignedDevices = deviceModelPolicies.get(policyId)) == null) continue;
                deviceIds = policyAssociations.getJSONArray(policyId);
                n = 0;
                nMax = deviceIds.length();
                while (true) {
                    if (n < nMax) ** break;
                    continue block24;
                    deviceId = deviceIds.getString(n);
                    assignedDevices.add(deviceId);
                    devicePolicies = this.policiesByDeviceId.get(deviceId);
                    if (devicePolicies == null) {
                        devicePolicies = new HashMap<String, String>();
                        this.policiesByDeviceId.put(deviceId, devicePolicies);
                    }
                    devicePolicies.put(deviceModelUrn, policyId);
                    ++n;
                }
                break;
            }
        }
        catch (JSONException e) {
            DevicePolicyManager.getLogger().log(Level.SEVERE, associationsFile.getName() + " corrupted: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removePolicyFromLocalStore(DevicePolicy devicePolicy) {
        if (LOCAL_STORE == null) {
            return;
        }
        String policyId = devicePolicy.getId();
        String deviceModelUrn = devicePolicy.getDeviceModelURN();
        File policyFile = new File(LOCAL_STORE, policyId);
        if (policyFile.exists()) {
            policyFile.delete();
        }
        JSONObject associations = null;
        File associationsFile = new File(LOCAL_STORE, "device-associations.json");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(associationsFile);
            StringBuffer buffer = new StringBuffer();
            int c = -1;
            while ((c = fileInputStream.read()) != -1) {
                buffer.append((char)c);
            }
            associations = new JSONObject(buffer.toString());
        }
        catch (FileNotFoundException e) {
            return;
            catch (IOException e2) {
                DevicePolicyManager.getLogger().log(Level.SEVERE, associationsFile.getName() + " could not be read: " + e2.getMessage());
                return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                catch (JSONException e3) {
                    DevicePolicyManager.getLogger().log(Level.SEVERE, associationsFile.getName() + " corrupted: " + e3.getMessage());
                    return;
                }
            }
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException ignored) {}
            }
        }
        assert (associations != null);
        try {
            JSONObject modelAssociations = associations.getJSONObject("deviceModelUrnsToDevicePolicies");
            JSONArray associatedPolicies = modelAssociations.optJSONArray(deviceModelUrn);
            if (associatedPolicies != null) {
                int nMax = associatedPolicies.length();
                for (int n = 0; n < nMax; ++n) {
                    String id = associatedPolicies.getString(n);
                    if (!policyId.equals(id)) continue;
                    associatedPolicies.remove(n);
                    break;
                }
            }
            JSONObject policyAssociations = associations.getJSONObject("devicePolicyIdsToEndpointIds");
            policyAssociations.remove(policyId);
        }
        catch (JSONException e) {
            DevicePolicyManager.getLogger().log(Level.SEVERE, associationsFile.getName() + " corrupted: " + e.getMessage());
        }
        FileOutputStream fileOutputStream = null;
        try {
            byte[] bytes = associations.toString(4).getBytes("UTF-8");
            fileOutputStream = new FileOutputStream(associationsFile);
            fileOutputStream.write(bytes);
            return;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (JSONException e) {
            DevicePolicyManager.getLogger().log(Level.WARNING, associationsFile.getName() + " could not be written: " + e.getMessage());
            return;
        }
        catch (IOException e) {
            DevicePolicyManager.getLogger().log(Level.SEVERE, e.toString());
            return;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DevicePolicy loadLocalDevicePolicy(String deviceModelUrn, String devicePolicyId) {
        if (LOCAL_STORE == null || devicePolicyId == null) {
            return null;
        }
        File policyFile = new File(LOCAL_STORE, devicePolicyId);
        Reader reader = null;
        try {
            int c;
            reader = new InputStreamReader(new FileInputStream(policyFile));
            StringBuilder sb = new StringBuilder();
            while ((c = reader.read()) != -1) {
                sb.append((char)c);
            }
            String string = sb.toString();
            JSONObject policyJson = new JSONObject(string);
            DevicePolicy devicePolicy = DevicePolicyManager.devicePolicyFromJSON(deviceModelUrn, policyJson);
            return devicePolicy;
        }
        catch (JSONException e) {
            DevicePolicyManager.getLogger().log(Level.SEVERE, e.getMessage());
        }
        catch (FileNotFoundException e) {
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            DevicePolicyManager.getLogger().log(Level.SEVERE, policyFile.getName() + " could not be read: " + e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ignored) {}
            }
        }
        return null;
    }

    private static DevicePolicy devicePolicyFromJSON(String deviceModelURN, JSONObject jsonObject) throws JSONException {
        String id = jsonObject.getString("id");
        String description = jsonObject.optString("description");
        Long lastModified = jsonObject.getLong("lastModified");
        Boolean enabled = jsonObject.optBoolean("enabled", true);
        HashMap<String, List<DevicePolicy.Function>> pipelines = new HashMap<String, List<DevicePolicy.Function>>();
        if (!jsonObject.has("pipelines")) {
            return null;
        }
        JSONArray pipelineArray = jsonObject.getJSONArray("pipelines");
        if (pipelineArray.length() == 0) {
            return null;
        }
        int indexMax = pipelineArray.length();
        for (int index = 0; index < indexMax; ++index) {
            JSONObject attributePipeline = pipelineArray.getJSONObject(index);
            String attributeName = attributePipeline.optString("attributeName", DevicePolicy.ALL_ATTRIBUTES());
            JSONArray pipeline = attributePipeline.getJSONArray("pipeline");
            ArrayList<DevicePolicy.Function> functions = new ArrayList<DevicePolicy.Function>();
            int nMax = pipeline.length();
            for (int n = 0; n < nMax; ++n) {
                JSONObject function = pipeline.getJSONObject(n);
                String functionId = function.getString("id");
                HashMap<String, Object> parameterMap = new HashMap<String, Object>();
                JSONObject parameters = function.getJSONObject("parameters");
                Iterator<String> keys = parameters.keys();
                while (keys.hasNext()) {
                    String parameterName = keys.next();
                    Object parameterValue = parameters.get(parameterName);
                    if ("action".equals(parameterName)) {
                        JSONObject actionObject = (JSONObject)parameterValue;
                        String actionName = actionObject.getString("name");
                        parameterMap.put("name", actionName);
                        JSONArray actionArguments = actionObject.optJSONArray("arguments");
                        if (actionArguments == null || actionArguments.length() <= 0) continue;
                        ArrayList<Object> argumentList = new ArrayList<Object>();
                        parameterMap.put("arguments", argumentList);
                        int maxArg = actionArguments.length();
                        for (int arg = 0; arg < maxArg; ++arg) {
                            Object argument = actionArguments.get(arg);
                            argumentList.add(argument);
                        }
                        continue;
                    }
                    if ("alert".equals(parameterName)) {
                        JSONObject alertObject = (JSONObject)parameterValue;
                        String urn = alertObject.getString("urn");
                        parameterMap.put("urn", urn);
                        JSONObject fields = alertObject.getJSONObject("fields");
                        HashMap<String, Object> fieldList = new HashMap<String, Object>();
                        Iterator<String> fieldNames = fields.keys();
                        while (fieldNames.hasNext()) {
                            String fieldName = fieldNames.next();
                            Object fieldValue = fields.get(fieldName);
                            fieldList.put(fieldName, fieldValue);
                        }
                        parameterMap.put("fields", fieldList);
                        if (!alertObject.has("severity")) continue;
                        parameterMap.put("severity", alertObject.getString("severity"));
                        continue;
                    }
                    parameterMap.put(parameterName, parameterValue);
                }
                functions.add(new DevicePolicy.Function(functionId, parameterMap));
            }
            pipelines.put(attributeName, Collections.unmodifiableList(functions));
        }
        return new DevicePolicy(id, deviceModelURN, pipelines, description, lastModified, enabled);
    }

    private static String checkLocalStorePath(String localStorePathname) {
        if (localStorePathname == null || "".equals(localStorePathname)) {
            return null;
        }
        File file = new File(localStorePathname);
        if (file.exists()) {
            if (!file.isDirectory()) {
                DevicePolicyManager.getLogger().log(Level.WARNING, "Cannot local device policy store is not a directory: " + localStorePathname);
                return null;
            }
            if (file.canRead() && file.canWrite()) {
                return file.getAbsolutePath();
            }
            if (!file.canRead()) {
                DevicePolicyManager.getLogger().log(Level.WARNING, "Cannot read from local device policy store: " + localStorePathname);
            }
            if (!file.canWrite()) {
                DevicePolicyManager.getLogger().log(Level.WARNING, "Cannot write to local device policy store: " + localStorePathname);
            }
        } else {
            if (file.mkdir()) {
                return file.getAbsolutePath();
            }
            DevicePolicyManager.getLogger().log(Level.WARNING, "Cannot create local device policy store: " + localStorePathname);
        }
        return null;
    }

    public DevicePolicyManager(SecureConnection secureConnection) {
        this.secureConnection = secureConnection;
        this.initializeFromPersistedData();
    }

    static {
        String deviceModelStore = System.getProperty("oracle.iot.client.device_model_store", null);
        String localStorePathname = System.getProperty("oracle.iot.client.device_policy_store", deviceModelStore);
        LOCAL_STORE = DevicePolicyManager.checkLocalStorePath(localStorePathname);
    }

    public static interface ChangeListener {
        public void policyAssigned(DevicePolicy var1, Set<String> var2);

        public void policyUnassigned(DevicePolicy var1, Set<String> var2);
    }
}

