/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.device;

import com.oracle.iot.client.DeviceModelAction;
import com.oracle.iot.client.DeviceModelAttribute;
import com.oracle.iot.client.DeviceModelFormat;
import com.oracle.iot.client.StorageObject;
import com.oracle.iot.client.device.persistence.BatchByPersistence;
import com.oracle.iot.client.impl.DeviceModelImpl;
import com.oracle.iot.client.impl.device.DeviceAnalog;
import com.oracle.iot.client.impl.device.ValueProviderImpl;
import com.oracle.iot.client.impl.util.Base64;
import com.oracle.iot.client.impl.util.Pair;
import com.oracle.iot.client.message.AlertMessage;
import com.oracle.iot.client.message.Message;
import com.oracle.iot.shared.Formula;
import com.oracle.iot.shared.FormulaParser;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public abstract class DeviceFunction {
    private static final Double ZERO = 0.0;
    private static final Map<String, Object> inProcessValues = new HashMap<String, Object>();
    private static final DeviceFunction FILTER_CONDITION = new DeviceFunction("filterCondition"){

        @Override
        public boolean apply(DeviceAnalog deviceAnalog, String attribute, Map<String, ?> configuration, Map<String, Object> data, Object value) {
            Double computedValue;
            data.put("filterCondition.value", value);
            FormulaParser.Node condition = (FormulaParser.Node)data.get("filterCondition.condition");
            if (condition == null) {
                String str = (String)configuration.get("condition");
                List<FormulaParser.Token> tokens = FormulaParser.tokenize(str);
                Stack<FormulaParser.Node> stack = new Stack<FormulaParser.Node>();
                FormulaParser.parseConditionalOrExpression(stack, tokens, str, 0);
                condition = stack.pop();
                data.put("filterCondition.condition", condition);
            }
            return -1.0 < (computedValue = (Double)1.compute(condition, deviceAnalog)) && computedValue < 1.0;
        }

        @Override
        public Object get(DeviceAnalog deviceAnalog, String attribute, Map<String, ?> configuration, Map<String, Object> data) {
            Object value = data.remove("filterCondition.value");
            return value;
        }

        @Override
        public String getDetails(Map<String, ?> config) {
            return super.getDetails(config) + "[condition=\"" + config.get("condition") + "\"]";
        }
    };
    private static final DeviceFunction SAMPLE = new DeviceFunction("sampleQuality"){
        Random rand = new Random();

        @Override
        public boolean apply(DeviceAnalog deviceAnalog, String attribute, Map<String, ?> configuration, Map<String, Object> data, Object value) {
            data.put("sample.value", value);
            Integer terms = (Integer)data.get("sample.terms");
            if (terms == null || terms == Integer.MAX_VALUE) {
                terms = 0;
            }
            terms = terms + 1;
            data.put("sample.terms", terms);
            Integer criterion = (Integer)configuration.get("rate");
            if (criterion == 0) {
                return true;
            }
            if (criterion == -1) {
                return this.rand.nextInt(30) == 0;
            }
            return criterion == terms;
        }

        @Override
        public Object get(DeviceAnalog deviceAnalog, String attribute, Map<String, ?> configuration, Map<String, Object> data) {
            Object sample = data.remove("sample.value");
            data.remove("sample.terms");
            return sample;
        }

        @Override
        public String getDetails(Map<String, ?> config) {
            Object rate = config.get("rate");
            boolean isString = "all".equals(rate) || "none".equals(rate) || "random".equals(rate);
            return super.getDetails(config) + "[rate=" + (isString ? "\"" + rate + "\"" : rate) + "]";
        }
    };
    private static final DeviceFunction MEAN = new DeviceFunction("mean"){

        @Override
        public boolean apply(DeviceAnalog deviceAnalog, String attribute, Map<String, ?> configuration, Map<String, Object> data, Object value) {
            Integer bucketZero;
            long now = System.currentTimeMillis();
            Long windowStartTime = (Long)data.get("mean.windowStartTime");
            if (windowStartTime == null) {
                windowStartTime = now;
                data.put("mean.windowStartTime", windowStartTime);
            }
            long window = 3.getWindow(configuration);
            long slide = 3.getSlide(configuration, window);
            long span = 3.gcd(window, slide);
            Bucket[] buckets = (Bucket[])data.get("mean.buckets");
            if (buckets == null) {
                int numberOfBuckets = (int)(Math.max(slide, window) / span) + 1;
                buckets = new Bucket[numberOfBuckets];
                for (int i = 0; i < numberOfBuckets; ++i) {
                    buckets[i] = new Bucket<Double>(0.0);
                }
                data.put("mean.buckets", buckets);
            }
            if ((bucketZero = (Integer)data.get("mean.bucketZero")) == null) {
                bucketZero = 0;
                data.put("mean.bucketZero", bucketZero);
            }
            int bucketIndex = (int)((now - windowStartTime) / span);
            int bucket = (bucketZero + bucketIndex) % buckets.length;
            Number number = (Number)value;
            Bucket bucket2 = buckets[bucket];
            bucket2.value = (Double)bucket2.value + number.doubleValue();
            ++buckets[bucket].terms;
            return false;
        }

        @Override
        public Object get(DeviceAnalog deviceAnalog, String attribute, Map<String, ?> configuration, Map<String, Object> data) {
            int i;
            Bucket[] buckets = (Bucket[])data.get("mean.buckets");
            if (buckets == null) {
                return null;
            }
            Integer bucketZero = (Integer)data.get("mean.bucketZero");
            assert (bucketZero != null);
            if (bucketZero == null) {
                return null;
            }
            long window = 3.getWindow(configuration);
            long slide = 3.getSlide(configuration, window);
            long span = 3.gcd(window, slide);
            int bucketsPerWindow = (int)(window / span);
            int bucketsPerSlide = (int)(slide / span);
            Long windowStartTime = (Long)data.get("mean.windowStartTime");
            assert (windowStartTime != null);
            if (windowStartTime == null) {
                windowStartTime = System.currentTimeMillis();
            }
            data.put("mean.windowStartTime", windowStartTime + span * (long)bucketsPerSlide);
            data.put("mean.bucketZero", (bucketZero + bucketsPerSlide) % buckets.length);
            double sum = 0.0;
            int terms = 0;
            for (i = 0; i < bucketsPerWindow; ++i) {
                int index = (bucketZero + i) % buckets.length;
                Bucket bucket = buckets[index];
                sum += ((Double)bucket.value).doubleValue();
                terms += bucket.terms;
            }
            for (i = 0; i < bucketsPerSlide; ++i) {
                Bucket bucket = buckets[(bucketZero + i) % buckets.length];
                bucket.value = 0.0;
                bucket.terms = 0;
            }
            if (Double.compare(sum, ZERO) == 0 || terms == 0) {
                return null;
            }
            return sum / (double)terms;
        }

        @Override
        public String getDetails(Map<String, ?> config) {
            Object slide;
            StringBuilder details = new StringBuilder(super.getDetails(config));
            Object window = config.get("window");
            if (window != null) {
                details.append("[window=").append(window);
            }
            if ((slide = config.get("slide")) != null) {
                details.append(window != null ? (char)',' : '[').append("slide=").append(slide);
            }
            details.append(']');
            return details.toString();
        }
    };
    private static final DeviceFunction MIN = new DeviceFunction("min"){

        @Override
        public boolean apply(DeviceAnalog deviceAnalog, String attribute, Map<String, ?> configuration, Map<String, Object> data, Object value) {
            Integer bucketZero;
            long now = System.currentTimeMillis();
            Long windowStartTime = (Long)data.get("min.windowStartTime");
            if (windowStartTime == null) {
                windowStartTime = now;
                data.put("min.windowStartTime", windowStartTime);
            }
            long window = 4.getWindow(configuration);
            long slide = 4.getSlide(configuration, window);
            long span = 4.gcd(window, slide);
            Bucket[] buckets = (Bucket[])data.get("min.buckets");
            if (buckets == null) {
                int numberOfBuckets = (int)(Math.min(slide, window) / span) + 1;
                buckets = new Bucket[numberOfBuckets];
                for (int i = 0; i < numberOfBuckets; ++i) {
                    buckets[i] = new Bucket<Double>((Double)Double.MAX_VALUE);
                }
                data.put("min.buckets", buckets);
            }
            if ((bucketZero = (Integer)data.get("min.bucketZero")) == null) {
                bucketZero = 0;
                data.put("min.bucketZero", bucketZero);
            }
            int bucketIndex = (int)((now - windowStartTime) / span);
            int bucket = (bucketZero + bucketIndex) % buckets.length;
            Number num = (Number)value;
            Number min = (Number)buckets[bucket].value;
            buckets[bucket].value = Double.compare(num.doubleValue(), min.doubleValue()) <= 0 ? (Number)num : (Number)min;
            return false;
        }

        @Override
        public Object get(DeviceAnalog deviceAnalog, String attribute, Map<String, ?> configuration, Map<String, Object> data) {
            int i;
            Bucket[] buckets = (Bucket[])data.get("min.buckets");
            if (buckets == null) {
                return null;
            }
            Integer bucketZero = (Integer)data.get("min.bucketZero");
            assert (bucketZero != null);
            if (bucketZero == null) {
                return null;
            }
            long window = 4.getWindow(configuration);
            long slide = 4.getSlide(configuration, window);
            long span = 4.gcd(window, slide);
            int bucketsPerWindow = (int)(window / span);
            int bucketsPerSlide = (int)(slide / span);
            Long windowStartTime = (Long)data.get("min.windowStartTime");
            assert (windowStartTime != null);
            if (windowStartTime == null) {
                windowStartTime = System.currentTimeMillis();
            }
            data.put("min.windowStartTime", windowStartTime + span * (long)bucketsPerSlide);
            data.put("min.bucketZero", (bucketZero + bucketsPerSlide) % buckets.length);
            Number min = Double.MAX_VALUE;
            for (i = 0; i < bucketsPerWindow; ++i) {
                int index = (bucketZero + i) % buckets.length;
                Bucket bucket = buckets[index];
                Number num = (Number)bucket.value;
                min = Double.compare(num.doubleValue(), min) <= 0 ? (Number)num : (Number)min;
            }
            for (i = 0; i < bucketsPerSlide; ++i) {
                Bucket bucket = buckets[(bucketZero + i) % buckets.length];
                bucket.value = Double.MAX_VALUE;
            }
            return min;
        }

        @Override
        public String getDetails(Map<String, ?> config) {
            Object slide;
            StringBuilder details = new StringBuilder(super.getDetails(config));
            Object window = config.get("window");
            if (window != null) {
                details.append("[window=").append(window);
            }
            if ((slide = config.get("slide")) != null) {
                details.append(window != null ? (char)',' : '[').append("slide=").append(slide);
            }
            details.append(']');
            return details.toString();
        }
    };
    private static final DeviceFunction MAX = new DeviceFunction("max"){

        @Override
        public boolean apply(DeviceAnalog deviceAnalog, String attribute, Map<String, ?> configuration, Map<String, Object> data, Object value) {
            Integer bucketZero;
            long now = System.currentTimeMillis();
            Long windowStartTime = (Long)data.get("max.windowStartTime");
            if (windowStartTime == null) {
                windowStartTime = now;
                data.put("max.windowStartTime", windowStartTime);
            }
            long window = 5.getWindow(configuration);
            long slide = 5.getSlide(configuration, window);
            long span = 5.gcd(window, slide);
            Bucket[] buckets = (Bucket[])data.get("max.buckets");
            if (buckets == null) {
                int numberOfBuckets = (int)(Math.max(slide, window) / span) + 1;
                buckets = new Bucket[numberOfBuckets];
                for (int i = 0; i < numberOfBuckets; ++i) {
                    buckets[i] = new Bucket<Double>((Double)Double.MIN_VALUE);
                }
                data.put("max.buckets", buckets);
            }
            if ((bucketZero = (Integer)data.get("max.bucketZero")) == null) {
                bucketZero = 0;
                data.put("max.bucketZero", bucketZero);
            }
            int bucketIndex = (int)((now - windowStartTime) / span);
            int bucket = (bucketZero + bucketIndex) % buckets.length;
            Number num = (Number)value;
            Number max = (Number)buckets[bucket].value;
            buckets[bucket].value = Double.compare(num.doubleValue(), max.doubleValue()) <= 0 ? (Number)max : (Number)num;
            return false;
        }

        @Override
        public Object get(DeviceAnalog deviceAnalog, String attribute, Map<String, ?> configuration, Map<String, Object> data) {
            int i;
            Bucket[] buckets = (Bucket[])data.get("max.buckets");
            if (buckets == null) {
                return null;
            }
            Integer bucketZero = (Integer)data.get("max.bucketZero");
            assert (bucketZero != null);
            if (bucketZero == null) {
                return null;
            }
            long window = 5.getWindow(configuration);
            long slide = 5.getSlide(configuration, window);
            long span = 5.gcd(window, slide);
            int bucketsPerWindow = (int)(window / span);
            int bucketsPerSlide = (int)(slide / span);
            Long windowStartTime = (Long)data.get("max.windowStartTime");
            assert (windowStartTime != null);
            if (windowStartTime == null) {
                windowStartTime = System.currentTimeMillis();
            }
            data.put("max.windowStartTime", windowStartTime + span * (long)bucketsPerSlide);
            data.put("max.bucketZero", (bucketZero + bucketsPerSlide) % buckets.length);
            Double max = Double.MIN_VALUE;
            for (i = 0; i < bucketsPerWindow; ++i) {
                int index = (bucketZero + i) % buckets.length;
                Bucket bucket = buckets[index];
                Number num = (Number)bucket.value;
                max = Double.compare(num.doubleValue(), max) <= 0 ? (Number)max : (Number)num;
            }
            for (i = 0; i < bucketsPerSlide; ++i) {
                Bucket bucket = buckets[(bucketZero + i) % buckets.length];
                bucket.value = Double.MIN_VALUE;
            }
            return max;
        }

        @Override
        public String getDetails(Map<String, ?> config) {
            Object slide;
            StringBuilder details = new StringBuilder(super.getDetails(config));
            Object window = config.get("window");
            if (window != null) {
                details.append("[window=").append(window);
            }
            if ((slide = config.get("slide")) != null) {
                details.append(window != null ? (char)',' : '[').append("slide=").append(slide);
            }
            details.append(']');
            return details.toString();
        }
    };
    private static final DeviceFunction STANDARD_DEVIATION = new DeviceFunction("standardDeviation"){

        @Override
        public boolean apply(DeviceAnalog deviceAnalog, String attribute, Map<String, ?> configuration, Map<String, Object> data, Object value) {
            Integer bucketZero;
            long now = System.currentTimeMillis();
            Long windowStartTime = (Long)data.get("standardDeviation.windowStartTime");
            if (windowStartTime == null) {
                windowStartTime = now;
                data.put("standardDeviation.windowStartTime", windowStartTime);
            }
            long window = 6.getWindow(configuration);
            long slide = 6.getSlide(configuration, window);
            long span = 6.gcd(window, slide);
            Bucket[] buckets = (Bucket[])data.get("standardDeviation.buckets");
            if (buckets == null) {
                int numberOfBuckets = (int)(Math.min(slide, window) / span) + 1;
                buckets = new Bucket[numberOfBuckets];
                for (int i = 0; i < numberOfBuckets; ++i) {
                    buckets[i] = new Bucket(new ArrayList());
                }
                data.put("standardDeviation.buckets", buckets);
            }
            if ((bucketZero = (Integer)data.get("standardDeviation.bucketZero")) == null) {
                bucketZero = 0;
                data.put("standardDeviation.bucketZero", bucketZero);
            }
            int bucketIndex = (int)((now - windowStartTime) / span);
            int bucket = (bucketZero + bucketIndex) % buckets.length;
            Number number = (Number)value;
            ((List)buckets[bucket].value).add(number);
            return false;
        }

        @Override
        public Object get(DeviceAnalog deviceAnalog, String attribute, Map<String, ?> configuration, Map<String, Object> data) {
            double d;
            int n;
            Bucket[] buckets = (Bucket[])data.get("standardDeviation.buckets");
            if (buckets == null) {
                return null;
            }
            Integer bucketZero = (Integer)data.get("standardDeviation.bucketZero");
            assert (bucketZero != null);
            if (bucketZero == null) {
                return null;
            }
            long window = 6.getWindow(configuration);
            long slide = 6.getSlide(configuration, window);
            long span = 6.gcd(window, slide);
            int bucketsPerWindow = (int)(window / span);
            int bucketsPerSlide = (int)(slide / span);
            Long windowStartTime = (Long)data.get("standardDeviation.windowStartTime");
            assert (windowStartTime != null);
            if (windowStartTime == null) {
                windowStartTime = System.currentTimeMillis();
            }
            data.put("standardDeviation.windowStartTime", windowStartTime + span * (long)bucketsPerSlide);
            data.put("standardDeviation.bucketZero", (bucketZero + bucketsPerSlide) % buckets.length);
            ArrayList<Double> terms = new ArrayList<Double>();
            for (int i = 0; i < bucketsPerWindow; ++i) {
                int index = (bucketZero + i) % buckets.length;
                Bucket bucket = buckets[index];
                List values = (List)bucket.value;
                terms.addAll(values);
            }
            double sum = 0.0;
            int nMax = terms.size();
            for (int n2 = 0; n2 < nMax; ++n2) {
                double d2 = ((Number)terms.get(n2)).doubleValue();
                sum += d2;
            }
            double mean = sum / (double)terms.size();
            int nMax2 = terms.size();
            for (n = 0; n < nMax2; ++n) {
                d = ((Number)terms.get(n)).doubleValue() - mean;
                terms.set(n, Math.pow(d, 2.0));
            }
            sum = 0.0;
            nMax2 = terms.size();
            for (n = 0; n < nMax2; ++n) {
                d = ((Number)terms.get(n)).doubleValue();
                sum += d;
            }
            mean = sum / (double)terms.size();
            double stdDeviation = Math.sqrt(mean);
            for (int i = 0; i < bucketsPerSlide; ++i) {
                Bucket bucket = buckets[(bucketZero + i) % buckets.length];
                ((List)bucket.value).clear();
            }
            return stdDeviation;
        }

        @Override
        public String getDetails(Map<String, ?> config) {
            Object slide;
            StringBuilder details = new StringBuilder(super.getDetails(config));
            Object window = config.get("window");
            if (window != null) {
                details.append("[window=").append(window);
            }
            if ((slide = config.get("slide")) != null) {
                details.append(window != null ? (char)',' : '[').append("slide=").append(slide);
            }
            details.append(']');
            return details.toString();
        }
    };
    private static final DeviceFunction BATCH_BY_SIZE = new DeviceFunction("batchBySize"){

        @Override
        public boolean apply(DeviceAnalog deviceAnalog, String attribute, Map<String, ?> configuration, Map<String, Object> data, Object value) {
            BatchByPersistence batchByPersistence = BatchByPersistence.getInstance();
            if (batchByPersistence != null) {
                Message message = (Message)((Pair)value).getKey();
                batchByPersistence.save(message, deviceAnalog.getEndpointId());
            } else {
                ArrayList<Object> list = (ArrayList<Object>)data.get("batchBySize.value");
                if (list == null) {
                    list = new ArrayList<Object>();
                    data.put("batchBySize.value", list);
                }
                list.add(value);
            }
            Integer batchCount = (Integer)data.get("batchBySize.batchCount");
            if (batchCount == null) {
                batchCount = 0;
            }
            batchCount = batchCount + 1;
            data.put("batchBySize.batchCount", batchCount);
            Integer batchSize = (Integer)configuration.get("batchSize");
            return batchSize == null || batchSize == batchCount;
        }

        @Override
        public Object get(DeviceAnalog deviceAnalog, String attribute, Map<String, ?> configuration, Map<String, Object> data) {
            data.put("batchBySize.batchCount", 0);
            BatchByPersistence batchByPersistence = BatchByPersistence.getInstance();
            if (batchByPersistence != null) {
                List value = DeviceFunction.getPersistedBatchedData(batchByPersistence, deviceAnalog);
                return value;
            }
            Object value = data.remove("batchBySize.value");
            return value;
        }

        @Override
        public String getDetails(Map<String, ?> config) {
            return super.getDetails(config) + "[batchSize=" + config.get("batchSize") + "]";
        }
    };
    private static final DeviceFunction BATCH_BY_TIME = new DeviceFunction("batchByTime"){

        @Override
        public boolean apply(DeviceAnalog deviceAnalog, String attribute, Map<String, ?> configuration, Map<String, Object> data, Object value) {
            BatchByPersistence batchByPersistence = BatchByPersistence.getInstance();
            if (batchByPersistence != null) {
                Message message = (Message)((Pair)value).getKey();
                batchByPersistence.save(message, deviceAnalog.getEndpointId());
            } else {
                ArrayList<Object> list = (ArrayList<Object>)data.get("batchByTime.value");
                if (list == null) {
                    list = new ArrayList<Object>();
                    data.put("batchByTime.value", list);
                }
                list.add(value);
            }
            return false;
        }

        @Override
        public Object get(DeviceAnalog deviceAnalog, String attribute, Map<String, ?> configuration, Map<String, Object> data) {
            BatchByPersistence batchByPersistence = BatchByPersistence.getInstance();
            if (batchByPersistence != null) {
                List value = DeviceFunction.getPersistedBatchedData(batchByPersistence, deviceAnalog);
                return value;
            }
            Object value = data.remove("batchByTime.value");
            return value;
        }

        @Override
        public String getDetails(Map<String, ?> config) {
            return super.getDetails(config) + "[delayLimit=" + config.get("delayLimit") + "]";
        }
    };
    private static final DeviceFunction BATCH_BY_COST = new DeviceFunction("batchByCost"){

        @Override
        public boolean apply(DeviceAnalog deviceAnalog, String attribute, Map<String, ?> configuration, Map<String, Object> data, Object value) {
            BatchByPersistence batchByPersistence = BatchByPersistence.getInstance();
            if (batchByPersistence != null) {
                Message message = (Message)((Pair)value).getKey();
                batchByPersistence.save(message, deviceAnalog.getEndpointId());
            } else {
                ArrayList<Object> list = (ArrayList<Object>)data.get("batchByCost.value");
                if (list == null) {
                    list = new ArrayList<Object>();
                    data.put("batchByCost.value", list);
                }
                list.add(value);
            }
            int configuredCost = NetworkCost.getCost((String)configuration.get("networkCost"), "networkCost", NetworkCost.SATELLITE);
            int networkCost = NetworkCost.getCost(System.getProperty("oracle.iot.client.network_cost"), "oracle.iot.client.network_cost", NetworkCost.ETHERNET);
            return networkCost <= configuredCost;
        }

        @Override
        public Object get(DeviceAnalog deviceAnalog, String attribute, Map<String, ?> configuration, Map<String, Object> data) {
            BatchByPersistence batchByPersistence = BatchByPersistence.getInstance();
            if (batchByPersistence != null) {
                List value = DeviceFunction.getPersistedBatchedData(batchByPersistence, deviceAnalog);
                return value;
            }
            Object value = data.remove("batchByCost.value");
            return value;
        }

        @Override
        public String getDetails(Map<String, ?> config) {
            return super.getDetails(config) + "[networkCost=" + config.get("networkCost") + "]";
        }
    };
    private static final DeviceFunction ELIMINATE_DUPLICATES = new DeviceFunction("eliminateDuplicates"){

        @Override
        public boolean apply(DeviceAnalog deviceAnalog, String attribute, Map<String, ?> configuration, Map<String, Object> data, Object value) {
            boolean isDuplicate = false;
            long now = System.currentTimeMillis();
            Object lastValue = data.put("eliminateDuplicates.lastValue", value);
            if (value.equals(lastValue)) {
                Long windowEnd = (Long)data.get("eliminateDuplicates.windowEnd");
                assert (windowEnd != null);
                boolean bl = isDuplicate = now <= windowEnd;
                if (windowEnd <= now) {
                    long window = 10.getWindow(configuration);
                    data.put("eliminateDuplicates.windowEnd", now + (window > 0L ? window : 0L));
                }
            } else {
                long window = 10.getWindow(configuration);
                data.put("eliminateDuplicates.windowEnd", now + (window > 0L ? window : 0L));
            }
            return !isDuplicate;
        }

        @Override
        public Object get(DeviceAnalog deviceAnalog, String attribute, Map<String, ?> configuration, Map<String, Object> data) {
            return data.get("eliminateDuplicates.lastValue");
        }

        @Override
        public String getDetails(Map<String, ?> config) {
            return super.getDetails(config) + "[window=" + config.get("window") + "]";
        }
    };
    private static final DeviceFunction DETECT_DUPLICATES = new DeviceFunction("detectDuplicates"){

        @Override
        public boolean apply(DeviceAnalog deviceAnalog, String attribute, Map<String, ?> configuration, Map<String, Object> data, Object value) {
            long now = System.currentTimeMillis();
            Object lastValue = data.put("detectDuplicates.lastValue", value);
            if (value.equals(lastValue)) {
                Boolean alertSent;
                Long windowEnd = (Long)data.get("detectDuplicates.windowEnd");
                if (windowEnd <= now) {
                    long window = 11.getWindow(configuration);
                    data.put("detectDuplicates.windowEnd", now + (window > 0L ? window : 0L));
                    data.put("detectDuplicates.alertSent", false);
                }
                if (!(alertSent = (Boolean)data.get("detectDuplicates.alertSent")).booleanValue()) {
                    data.put("detectDuplicates.alertSent", true);
                    AlertMessage alertMessage = DeviceFunction.createAlert(deviceAnalog, configuration);
                    deviceAnalog.queueMessage(alertMessage);
                }
            } else {
                long window = 11.getWindow(configuration);
                data.put("detectDuplicates.windowEnd", now + (window > 0L ? window : 0L));
                data.put("detectDuplicates.alertSent", false);
            }
            return true;
        }

        @Override
        public Object get(DeviceAnalog deviceAnalog, String attribute, Map<String, ?> configuration, Map<String, Object> data) {
            Object value = data.get("detectDuplicates.lastValue");
            return value;
        }

        @Override
        public String getDetails(Map<String, ?> config) {
            return super.getDetails(config) + "[window=" + config.get("window") + ", alertFormatURN=\"" + config.get("alertFormatURN") + "\"]";
        }
    };
    private static final DeviceFunction PRIVACY_POLICY = new DeviceFunction("privacyPolicy"){

        @Override
        public boolean apply(DeviceAnalog deviceAnalog, String attribute, Map<String, ?> configuration, Map<String, Object> data, Object value) {
            data.put("privacyPolicy.value", value);
            return true;
        }

        @Override
        public Object get(DeviceAnalog deviceAnalog, String attribute, Map<String, ?> configuration, Map<String, Object> data) {
            Object value = data.get("privacyPolicy.value");
            if (value != null) {
                byte[] content;
                String string = value.toString();
                try {
                    content = string.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                String level = (String)configuration.get("level");
                if ("one-way".equals(level)) {
                    try {
                        MessageDigest md = MessageDigest.getInstance("SHA-256");
                        byte[] digest = md.digest(content);
                        String urlEncodedDigest = Base64.getUrlEncoder().withoutPadding().encodeToString(digest);
                        return urlEncodedDigest;
                    }
                    catch (NoSuchAlgorithmException e) {
                        return value;
                    }
                }
                if ("two-way".equals(level)) {
                    byte[] key;
                    String hashingKey = (String)configuration.get("hashingKey");
                    if (hashingKey == null) {
                        DeviceFunction.getLogger().log(Level.WARNING, "no hashingKey given");
                        return value;
                    }
                    try {
                        key = hashingKey.getBytes("UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                    try {
                        SecretKeySpec keySpec = new SecretKeySpec(key, "HmacSHA256");
                        Mac mac = Mac.getInstance("HmacSHA256");
                        mac.init(keySpec);
                        mac.update(content);
                        byte[] digest = mac.doFinal();
                        String urlEncodedDigest = Base64.getUrlEncoder().withoutPadding().encodeToString(digest);
                        return urlEncodedDigest;
                    }
                    catch (NoSuchAlgorithmException e) {
                        DeviceFunction.getLogger().log(Level.WARNING, e.getMessage());
                        return value;
                    }
                    catch (InvalidKeyException e) {
                        DeviceFunction.getLogger().log(Level.WARNING, e.getMessage());
                        return value;
                    }
                }
                if ("random".equals(level)) {
                    DeviceFunction.getLogger().log(Level.WARNING, "random privacy not supported");
                } else {
                    return value;
                }
            }
            return null;
        }

        @Override
        public String getDetails(Map<String, ?> config) {
            return super.getDetails(config) + "[level=\"" + config.get("level") + "\"]";
        }
    };
    private static final DeviceFunction ALERT_CONDITION = new DeviceFunction("alertCondition"){

        @Override
        public boolean apply(DeviceAnalog deviceAnalog, String attribute, Map<String, ?> configuration, Map<String, Object> data, Object value) {
            Double computedValue;
            FormulaParser.Node condition = (FormulaParser.Node)data.get("alertCondition.condition");
            if (condition == null) {
                String str = (String)configuration.get("condition");
                List<FormulaParser.Token> tokens = FormulaParser.tokenize(str);
                Stack<FormulaParser.Node> stack = new Stack<FormulaParser.Node>();
                FormulaParser.parseConditionalOrExpression(stack, tokens, str, 0);
                condition = stack.pop();
                data.put("alertCondition.condition", condition);
            }
            if ((computedValue = (Double)13.compute(condition, deviceAnalog)).isNaN() || computedValue.isInfinite() || computedValue.compareTo(0.0) == 0) {
                data.put("alertCondition.value", value);
                return true;
            }
            try {
                AlertMessage alertMessage = DeviceFunction.createAlert(deviceAnalog, configuration);
                if (DeviceFunction.getLogger().isLoggable(Level.FINE)) {
                    DeviceFunction.getLogger().log(Level.FINE, deviceAnalog.getEndpointId() + " : Alert : \"" + attribute + "\"=" + value + " (" + alertMessage.getDescription() + ")");
                }
                deviceAnalog.queueMessage(alertMessage);
            }
            catch (Exception e) {
                DeviceFunction.getLogger().log(Level.SEVERE, e.toString(), e);
            }
            Boolean filter = (Boolean)configuration.get("filter");
            if (filter == null || filter.booleanValue()) {
                return false;
            }
            data.put("alertCondition.value", value);
            return true;
        }

        @Override
        public Object get(DeviceAnalog deviceAnalog, String attribute, Map<String, ?> configuration, Map<String, Object> data) {
            Object value = data.remove("alertCondition.value");
            return value;
        }

        @Override
        public String getDetails(Map<String, ?> config) {
            Boolean filter = config.containsKey("filter") ? config.get("filter") : Boolean.TRUE;
            return super.getDetails(config) + "[condition=\"" + config.get("condition") + "\", urn=\"" + config.get("urn") + "\", fields=" + (Map)config.get("fields") + "\", filter=" + filter + "]";
        }
    };
    private static final DeviceFunction COMPUTED_METRIC = new DeviceFunction("computedMetric"){

        @Override
        public boolean apply(DeviceAnalog deviceAnalog, String attribute, Map<String, ?> configuration, Map<String, Object> data, Object value) {
            Double computedValue;
            FormulaParser.Node formula = (FormulaParser.Node)data.get("computedMetric.formula");
            if (formula == null) {
                String str = (String)configuration.get("formula");
                List<FormulaParser.Token> tokens = FormulaParser.tokenize(str);
                formula = FormulaParser.parseFormula(tokens, str);
                data.put("computedMetric.formula", formula);
            }
            if ((computedValue = (Double)14.compute(formula, deviceAnalog)).isNaN() || computedValue.isInfinite()) {
                return false;
            }
            data.put("computedMetric.value", computedValue);
            return true;
        }

        @Override
        public Object get(DeviceAnalog deviceAnalog, String attribute, Map<String, ?> configuration, Map<String, Object> data) {
            return data.remove("computedMetric.value");
        }

        @Override
        public String getDetails(Map<String, ?> config) {
            return super.getDetails(config) + "[formula=\"" + config.get("formula") + "\"]";
        }
    };
    private static final DeviceFunction ACTION_CONDITION = new DeviceFunction("actionCondition"){

        @Override
        public boolean apply(DeviceAnalog deviceAnalog, String attribute, Map<String, ?> configuration, Map<String, Object> data, Object value) {
            Double computedValue;
            FormulaParser.Node condition = (FormulaParser.Node)data.get("actionCondition.condition");
            if (condition == null) {
                String str = (String)configuration.get("condition");
                List<FormulaParser.Token> tokens = FormulaParser.tokenize(str);
                Stack<FormulaParser.Node> stack = new Stack<FormulaParser.Node>();
                FormulaParser.parseConditionalOrExpression(stack, tokens, str, 0);
                condition = stack.pop();
                data.put("actionCondition.condition", condition);
            }
            if ((computedValue = (Double)15.compute(condition, deviceAnalog)).isNaN() || computedValue.isInfinite() || computedValue.compareTo(0.0) == 0) {
                data.put("actionCondition.value", value);
                return true;
            }
            Object[] actionArgs = DeviceFunction.getActionArgs(deviceAnalog, configuration);
            String actionName = (String)configuration.get("name");
            try {
                deviceAnalog.call(actionName, actionArgs);
            }
            catch (Exception e) {
                DeviceFunction.getLogger().log(Level.SEVERE, e.toString(), e);
            }
            Boolean filter = (Boolean)configuration.get("filter");
            if (filter == null || filter.booleanValue()) {
                return false;
            }
            data.put("actionCondition.value", value);
            return true;
        }

        @Override
        public Object get(DeviceAnalog deviceAnalog, String attribute, Map<String, ?> configuration, Map<String, Object> data) {
            Object value = data.remove("actionCondition.value");
            return value;
        }

        @Override
        public String getDetails(Map<String, ?> config) {
            Boolean filter = config.containsKey("filter") ? config.get("filter") : Boolean.TRUE;
            return super.getDetails(config) + "[condition=\"" + config.get("condition") + "\", action=\"" + config.get("name") + "\", arguments=\"" + config.get("arguments") + "\", filter=" + filter + "]";
        }
    };
    private static final List<DeviceFunction> DEVICE_FUNCTIONS;
    private static final Map<String, DeviceFunction> POLICY_MAP;
    private final String id;
    private static final Logger LOGGER;

    public abstract boolean apply(DeviceAnalog var1, String var2, Map<String, ?> var3, Map<String, Object> var4, Object var5);

    public abstract Object get(DeviceAnalog var1, String var2, Map<String, ?> var3, Map<String, Object> var4);

    public static long getWindow(Map<String, ?> configuration) {
        for (String key : new String[]{"window", "delayLimit"}) {
            Number criterion = (Number)configuration.get(key);
            if (criterion == null) continue;
            return criterion.longValue();
        }
        return -1L;
    }

    public static long getSlide(Map<String, ?> configuration, long window) {
        Number slideParameter = (Number)configuration.get("slide");
        if (slideParameter != null) {
            long slide = slideParameter.longValue();
            return slide > 0L ? slide : window;
        }
        return window;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.id;
    }

    public String getDetails(Map<String, ?> configuration) {
        return this.getId();
    }

    public static DeviceFunction getDeviceFunction(String functionId) {
        return POLICY_MAP.get(functionId);
    }

    private static String createInProcessMapKey(String endpointId, String deviceModelURN, String attribute) {
        return endpointId.concat("/deviceModels/".concat(deviceModelURN.concat(":attributes/".concat(attribute))));
    }

    public static void putInProcessValue(String endpointId, String deviceModelURN, String attribute, Object value) {
        inProcessValues.put(DeviceFunction.createInProcessMapKey(endpointId, deviceModelURN, attribute), value);
    }

    public static Object removeInProcessValue(String endpointId, String deviceModelURN, String attribute) {
        return inProcessValues.remove(DeviceFunction.createInProcessMapKey(endpointId, deviceModelURN, attribute));
    }

    public static Object getInProcessValue(String endpointId, String deviceModelURN, String attribute) {
        return inProcessValues.get(DeviceFunction.createInProcessMapKey(endpointId, deviceModelURN, attribute));
    }

    private static List<Pair<Message, StorageObject>> getPersistedBatchedData(BatchByPersistence batchByPersistence, DeviceAnalog deviceAnalog) {
        List<Message> messages = batchByPersistence.load(deviceAnalog.getEndpointId());
        batchByPersistence.delete(messages);
        ArrayList<Pair<Message, StorageObject>> pairs = new ArrayList<Pair<Message, StorageObject>>();
        for (Message message : messages) {
            pairs.add(new Pair<Message, Object>(message, null));
        }
        return pairs;
    }

    private static Object[] getActionArgs(DeviceAnalog deviceAnalog, Map<String, ?> configuration) {
        List arguments = (List)configuration.get("arguments");
        if (arguments == null || arguments.isEmpty()) {
            return null;
        }
        Object[] actionArgs = new Object[arguments.size()];
        int nMax = arguments.size();
        for (int n = 0; n < nMax; ++n) {
            DeviceModelImpl deviceModel = (DeviceModelImpl)deviceAnalog.getDeviceModel();
            Map<String, DeviceModelAction> actionMap = deviceModel.getDeviceModelActions();
            if (actionMap == null || actionMap.isEmpty()) {
                DeviceFunction.getLogger().log(Level.WARNING, "no actions in device model '" + deviceModel.getURN() + "'");
                actionArgs[n] = null;
                continue;
            }
            String actionName = (String)configuration.get("name");
            DeviceModelAction deviceModelAction = actionMap.get(actionName);
            if (deviceModelAction == null) {
                DeviceFunction.getLogger().log(Level.WARNING, "no action named '" + actionName + "' in device model '" + deviceModel.getURN() + "'");
                actionArgs[n] = null;
                continue;
            }
            DeviceModelAttribute.Type type = deviceModelAction.getArgType();
            try {
                actionArgs[n] = DeviceFunction.convertArg(deviceAnalog, type, arguments.get(n));
                continue;
            }
            catch (IllegalArgumentException e) {
                DeviceFunction.getLogger().log(Level.WARNING, "bad argument to '" + actionName + "' in '" + deviceModel.getURN() + "' :" + e.getMessage());
                actionArgs[n] = arguments.get(n);
            }
        }
        return actionArgs;
    }

    private static Object convertArg(DeviceAnalog deviceAnalog, DeviceModelAttribute.Type type, Object arg) {
        if (arg == null) {
            return null;
        }
        Object conversion = DeviceFunction.convertFormula(deviceAnalog, arg.toString());
        switch (type) {
            case STRING: 
            case URI: {
                return String.valueOf(conversion);
            }
            case BOOLEAN: {
                if (conversion instanceof Boolean) {
                    return conversion;
                }
                if (conversion instanceof String) {
                    return Boolean.valueOf((String)conversion);
                }
                if (conversion instanceof Number) {
                    return ((Number)conversion).doubleValue() != 0.0;
                }
                throw new IllegalArgumentException("cannot convert " + arg + " to " + type.name());
            }
            case DATETIME: {
                if (conversion instanceof Number) {
                    return new Date(((Number)conversion).longValue());
                }
                throw new IllegalArgumentException("cannot convert " + arg + " to " + type.name());
            }
            case INTEGER: {
                if (conversion instanceof Number) {
                    return ((Number)conversion).intValue();
                }
                throw new IllegalArgumentException("cannot convert " + arg + " to " + type.name());
            }
            case NUMBER: {
                if (conversion instanceof Number) {
                    return conversion;
                }
                throw new IllegalArgumentException("cannot convert " + arg + " to " + type.name());
            }
        }
        DeviceFunction.getLogger().log(Level.WARNING, "unknown type : " + type.name());
        return arg;
    }

    private static Object convertFormula(DeviceAnalog deviceAnalog, String formula) {
        try {
            List<FormulaParser.Token> tokens = FormulaParser.tokenize(formula);
            FormulaParser.Node node = FormulaParser.parseFormula(tokens, formula);
            return DeviceFunction.compute(node, deviceAnalog);
        }
        catch (IllegalArgumentException e) {
            DeviceFunction.getLogger().log(Level.WARNING, "field in formula not in device model: " + formula);
            return Double.NaN;
        }
    }

    private static AlertMessage createAlert(DeviceAnalog deviceAnalog, Map<String, ?> configuration) {
        AlertMessage.Severity alertSeverity;
        DeviceModelImpl deviceModel = (DeviceModelImpl)deviceAnalog.getDeviceModel();
        Map<String, DeviceModelFormat> deviceModelFormatMap = deviceModel.getDeviceModelFormats();
        if (deviceModelFormatMap == null) {
            throw new IllegalArgumentException(deviceModel.getURN() + " does not contain alert formats");
        }
        String format = (String)configuration.get("urn");
        DeviceModelFormat deviceModelFormat = deviceModelFormatMap.get(format);
        if (deviceModelFormat == null) {
            throw new IllegalArgumentException(deviceModel.getURN() + " does not contain alert format '" + format + "'");
        }
        List<DeviceModelFormat.Field> fields = deviceModelFormat.getFields();
        try {
            String severityConfig = (String)configuration.get("severity");
            alertSeverity = severityConfig != null ? AlertMessage.Severity.valueOf(severityConfig.toUpperCase(Locale.ROOT)) : AlertMessage.Severity.NORMAL;
        }
        catch (IllegalArgumentException e) {
            alertSeverity = AlertMessage.Severity.NORMAL;
        }
        AlertMessage.Builder builder = ((AlertMessage.Builder)new AlertMessage.Builder().source(deviceAnalog.getEndpointId())).format(format).description(deviceModelFormat.getName()).severity(alertSeverity);
        Map fieldsFromPolicy = (Map)configuration.get("fields");
        for (DeviceModelFormat.Field field : fields) {
            Object policyValue = fieldsFromPolicy.get(field.getName());
            if (policyValue == null) continue;
            try {
                Object value = DeviceFunction.convertArg(deviceAnalog, field.getType(), policyValue);
                DeviceFunction.addDataItem(builder, field, value);
            }
            catch (IllegalArgumentException e) {
                DeviceFunction.getLogger().log(Level.WARNING, "bad value for '" + field.getName() + "' in '" + deviceModel.getURN() + "' :" + e.getMessage());
            }
        }
        return builder.build();
    }

    private static void addDataItem(AlertMessage.Builder builder, DeviceModelFormat.Field field, Object value) {
        switch (field.getType()) {
            case INTEGER: 
            case NUMBER: {
                if (value instanceof Number) {
                    if (field.getType() == DeviceModelAttribute.Type.INTEGER) {
                        builder.dataItem(field.getName(), ((Number)value).intValue());
                        break;
                    }
                    builder.dataItem(field.getName(), ((Number)value).doubleValue());
                    break;
                }
                throw new IllegalArgumentException("value of attribute '" + field.getName() + "' is not a " + (Object)((Object)field.getType()));
            }
            case STRING: 
            case URI: {
                if (value instanceof String) {
                    builder.dataItem(field.getName(), (String)value);
                    break;
                }
                throw new IllegalArgumentException("value of attribute '" + field.getName() + "' is not a " + (Object)((Object)field.getType()));
            }
            default: {
                throw new IllegalArgumentException("the type of attribute '" + field.getName() + "' is not a known type (" + (Object)((Object)field.getType()) + ")");
            }
            case BOOLEAN: {
                if (value instanceof Boolean) {
                    builder.dataItem(field.getName(), (Boolean)value);
                    break;
                }
                throw new IllegalArgumentException("value of attribute '" + field.getName() + "' is not a " + (Object)((Object)field.getType()));
            }
            case DATETIME: {
                if (value instanceof Number) {
                    builder.dataItem(field.getName(), ((Number)value).longValue());
                    break;
                }
                if (value instanceof Date) {
                    builder.dataItem(field.getName(), ((Date)value).getTime());
                    break;
                }
                throw new IllegalArgumentException("value of attribute '" + field.getName() + "' is not a " + (Object)((Object)field.getType()));
            }
        }
    }

    static Object compute(FormulaParser.Node node, DeviceAnalog deviceAnalog) {
        return Formula.compute(node, new ValueProviderImpl(deviceAnalog));
    }

    static long gcd(long x, long y) {
        return y == 0L ? x : DeviceFunction.gcd(y, x % y);
    }

    private DeviceFunction(String id) {
        this.id = id;
    }

    private static Logger getLogger() {
        return LOGGER;
    }

    static {
        ArrayList functions = new ArrayList();
        Collections.addAll(functions, FILTER_CONDITION, ELIMINATE_DUPLICATES, DETECT_DUPLICATES, SAMPLE, MAX, MIN, MEAN, STANDARD_DEVIATION, BATCH_BY_SIZE, BATCH_BY_TIME, BATCH_BY_COST, ALERT_CONDITION, COMPUTED_METRIC, PRIVACY_POLICY, ACTION_CONDITION);
        DEVICE_FUNCTIONS = Collections.unmodifiableList(functions);
        HashMap<String, DeviceFunction> policyMap = new HashMap<String, DeviceFunction>(DEVICE_FUNCTIONS.size());
        for (DeviceFunction deviceFunction : DEVICE_FUNCTIONS) {
            policyMap.put(deviceFunction.getId(), deviceFunction);
        }
        POLICY_MAP = Collections.unmodifiableMap(policyMap);
        LOGGER = Logger.getLogger("oracle.iot.client");
    }

    private static class Bucket<T> {
        T value;
        int terms;

        Bucket(T initialValue) {
            this.value = initialValue;
            this.terms = 0;
        }

        public String toString() {
            return "{\"value\" : " + this.value + ", \"terms\" : " + this.terms + "}";
        }
    }

    private static enum NetworkCost {
        ETHERNET,
        CELLULAR,
        SATELLITE;


        static int getCost(String value, String property, NetworkCost defaultValue) {
            NetworkCost networkCost = null;
            if (value != null) {
                try {
                    String upperValue = value.toUpperCase(Locale.ROOT);
                    upperValue = upperValue.replaceAll("\\(.*", "");
                    networkCost = NetworkCost.valueOf(upperValue);
                }
                catch (IllegalArgumentException e) {
                    DeviceFunction.getLogger().log(Level.WARNING, "invalid '" + property + "' value: '" + value + "'");
                }
            }
            if (networkCost == null) {
                networkCost = defaultValue;
                DeviceFunction.getLogger().log(Level.WARNING, "defaulting '" + property + "' to: '" + (Object)((Object)networkCost) + "'");
            }
            return networkCost.ordinal();
        }
    }
}

