/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.device;

import org.json.JSONException;
import org.json.JSONObject;

public final class ActivationPolicyResponse {
    private final String keyType;
    private final int keySize;
    private final String hashAlgorithm;
    private static final String FIELD_KEY_TYPE = "keyType";
    private static final String FIELD_HASH_ALGORITHM = "hashAlgorithm";
    private static final String FIELD_KEY_SIZE = "keySize";

    public ActivationPolicyResponse(String keyType, int keySize, String hashAlgorithm) {
        this.keyType = keyType;
        this.keySize = keySize;
        this.hashAlgorithm = hashAlgorithm;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public String toString() {
        return "ActivationPolicyResponse{keyType='" + this.keyType + '\'' + ", keySize=" + this.keySize + ", hashAlgorithm='" + this.hashAlgorithm + '\'' + '}';
    }

    public static ActivationPolicyResponse fromJson(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        try {
            String keyType = jsonObject.getString(FIELD_KEY_TYPE);
            int keySize = jsonObject.getInt(FIELD_KEY_SIZE);
            String hashAlgorithm = jsonObject.getString(FIELD_HASH_ALGORITHM);
            return new ActivationPolicyResponse(keyType, keySize, hashAlgorithm);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject toJson() {
        JSONObject objectBuilder = new JSONObject();
        try {
            objectBuilder.put(FIELD_KEY_TYPE, this.keyType);
            objectBuilder.put(FIELD_KEY_SIZE, this.keySize);
            objectBuilder.put(FIELD_HASH_ALGORITHM, this.hashAlgorithm);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return objectBuilder;
    }
}

