/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.device;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

class ActivationPolicyRequest {
    private static final String OS_NAME = "OSName";
    private static final String OS_VERSION = "OSVersion";
    private static final String JSON_FORMAT = "{\"%1$s\":\"%2$s\",\"%3$s\":\"%4$s\"}";
    private final String osVersion;
    private final String osName;

    ActivationPolicyRequest(String osName, String osVersion) {
        this.osName = osName;
        this.osVersion = osVersion;
    }

    public String toQuery() {
        try {
            return "?OSName=" + URLEncoder.encode(this.osName, "UTF-8") + "&" + OS_VERSION + "=" + URLEncoder.encode(this.osVersion, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("utf-8 is not supported", ex);
        }
    }

    public String toJSON() {
        return String.format(JSON_FORMAT, OS_NAME, this.osName, OS_VERSION, this.osVersion);
    }

    public String toString() {
        return "ActivationPolicyRequest{OSName=" + this.osName + OS_VERSION + "=" + this.osVersion + '}';
    }
}

