/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.device;

import com.oracle.iot.client.HttpResponse;
import com.oracle.iot.client.RestApi;
import com.oracle.iot.client.SecureConnection;
import com.oracle.iot.client.TransportException;
import com.oracle.iot.client.impl.device.ActivationPolicyRequest;
import com.oracle.iot.client.impl.device.ActivationPolicyResponse;
import com.oracle.iot.client.impl.device.DirectActivationRequest;
import com.oracle.iot.client.impl.device.DirectActivationResponse;
import com.oracle.iot.client.impl.device.IndirectActivationRequest;
import com.oracle.iot.client.impl.device.IndirectActivationResponse;
import com.oracle.iot.client.trust.TrustException;
import com.oracle.iot.client.trust.TrustedAssetsManager;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public final class ActivationManager {
    public static final String MESSAGE_DISPATCHER_URN = "urn:oracle:iot:dcd:capability:message_dispatcher";
    public static final String DIAGNOSTICS_URN = "urn:oracle:iot:dcd:capability:diagnostics";
    public static final String DIRECT_ACTIVATION_URN = "urn:oracle:iot:dcd:capability:direct_activation";
    public static final String INDIRECT_ACTIVATION_URN = "urn:oracle:iot:dcd:capability:indirect_activation";
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String DEFAULT_MESSAGE_DIGEST_ALGORITHM = "HmacSHA256";
    private static final String REST_ACTIVATION_POLICY = RestApi.V2.getReqRoot() + "/activation/policy";
    private static final String REST_DIRECT_ACTIVATION;
    private static final String REST_INDIRECT_ACTIVATION;
    private static final Logger LOGGER;

    public static ActivationPolicyResponse getActivationPolicy(SecureConnection secureConnection, String deviceId) throws IOException, GeneralSecurityException {
        JSONObject json;
        ActivationPolicyRequest policyRequest = ActivationManager.createActivationPolicyRequest();
        String restRsc = REST_ACTIVATION_POLICY + policyRequest.toQuery();
        HttpResponse response = secureConnection.get(restRsc);
        int status = response.getStatus();
        if (status == 401) {
            throw new IllegalStateException(deviceId);
        }
        if (status != 200) {
            throw new TransportException(status, response.getVerboseStatus("GET", restRsc));
        }
        String jsonResponse = new String(response.getData(), "UTF-8");
        try {
            json = new JSONObject(jsonResponse);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        ActivationPolicyResponse activationPolicyResponse = ActivationPolicyResponse.fromJson(json);
        if (ActivationManager.getLogger().isLoggable(Level.FINEST)) {
            ActivationManager.getLogger().log(Level.FINEST, activationPolicyResponse.toString());
        }
        return activationPolicyResponse;
    }

    private static ActivationPolicyRequest createActivationPolicyRequest() {
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        return new ActivationPolicyRequest(osName, osVersion);
    }

    public static DirectActivationRequest createDirectActivationRequest(TrustedAssetsManager trustedAssetsManager, String hashAlgorithm, Set<String> deviceModels) throws GeneralSecurityException {
        DirectActivationRequest.SubjectPublicKeyInfo subjectPublicKeyInfo = new DirectActivationRequest.SubjectPublicKeyInfo();
        DirectActivationRequest.CertificationRequestInfo certificationRequestInfo = new DirectActivationRequest.CertificationRequestInfo();
        certificationRequestInfo.setSubjectPublicKeyInfo(subjectPublicKeyInfo);
        certificationRequestInfo.setSubject(trustedAssetsManager.getClientId());
        DirectActivationRequest request = new DirectActivationRequest();
        request.setCertificationRequestInfo(certificationRequestInfo);
        request.getDeviceModels().addAll(deviceModels);
        ActivationManager.signRequest(request, trustedAssetsManager, hashAlgorithm);
        return request;
    }

    public static DirectActivationResponse postDirectActivationRequest(SecureConnection secureConnection, DirectActivationRequest directActivationRequest) throws IOException, GeneralSecurityException {
        JSONObject json;
        String payloadString = directActivationRequest.toJson();
        byte[] payload = payloadString.getBytes(UTF_8);
        HttpResponse response = secureConnection.post(REST_DIRECT_ACTIVATION, payload);
        int status = response.getStatus();
        if (status == 401) {
            throw new IllegalStateException(response.getVerboseStatus("POST", REST_DIRECT_ACTIVATION));
        }
        if (status != 200) {
            throw new TransportException(status, response.getVerboseStatus("POST", REST_DIRECT_ACTIVATION));
        }
        String jsonResponse = new String(response.getData(), "UTF-8");
        try {
            json = new JSONObject(jsonResponse);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        DirectActivationResponse directActivationResponse = DirectActivationResponse.fromJson(json);
        if (ActivationManager.getLogger().isLoggable(Level.FINEST)) {
            ActivationManager.getLogger().log(Level.FINEST, directActivationResponse.toString());
        }
        return directActivationResponse;
    }

    public static IndirectActivationRequest createIndirectActivationRequest(String hardwareId, Map<String, String> metadata, Set<String> deviceModels, byte[] signature) {
        IndirectActivationRequest request = new IndirectActivationRequest(hardwareId, metadata, deviceModels, signature);
        return request;
    }

    public static IndirectActivationResponse postIndirectActivationRequest(SecureConnection secureConnection, IndirectActivationRequest indirectActivationRequest) throws IOException, GeneralSecurityException {
        JSONObject json;
        String payloadString = indirectActivationRequest.toJson();
        byte[] payload = payloadString.getBytes(UTF_8);
        HttpResponse response = secureConnection.post(REST_INDIRECT_ACTIVATION, payload);
        int status = response.getStatus();
        if (status == 401) {
            throw new IllegalStateException("endpoint already activated");
        }
        if (status != 200) {
            throw new TransportException(status, response.getVerboseStatus("POST", REST_INDIRECT_ACTIVATION));
        }
        String jsonResponse = new String(response.getData(), "UTF-8");
        try {
            json = new JSONObject(jsonResponse);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        IndirectActivationResponse indirectActivationResponse = IndirectActivationResponse.fromJson(json);
        if (ActivationManager.getLogger().isLoggable(Level.FINEST)) {
            ActivationManager.getLogger().log(Level.FINEST, indirectActivationResponse.toString());
        }
        return indirectActivationResponse;
    }

    private static void signRequest(DirectActivationRequest directActivationRequest, TrustedAssetsManager trustedAssetsManager, String hashAlgorithm) throws TrustException {
        DirectActivationRequest.CertificationRequestInfo certificationRequestInfo = directActivationRequest.getCertificationRequestInfo();
        DirectActivationRequest.SubjectPublicKeyInfo subjectPublicKeyInfo = certificationRequestInfo.getSubjectPublicKeyInfo();
        PublicKey publicKey = trustedAssetsManager.getPublicKey();
        subjectPublicKeyInfo.setAlgorithm(publicKey.getAlgorithm());
        subjectPublicKeyInfo.setPublicKey(publicKey.getEncoded());
        subjectPublicKeyInfo.setFormat(publicKey.getFormat());
        subjectPublicKeyInfo.setSecretHashAlgorithm(DEFAULT_MESSAGE_DIGEST_ALGORITHM);
        byte[] clientSecretData = trustedAssetsManager.getClientId().getBytes(UTF_8);
        byte[] clientSecret = trustedAssetsManager.signWithSharedSecret(clientSecretData, subjectPublicKeyInfo.getSecretHashAlgorithm(), trustedAssetsManager.getClientId());
        byte[] signature = trustedAssetsManager.signWithPrivateKey(ActivationManager.getSignaturePayload(certificationRequestInfo, clientSecret), hashAlgorithm);
        directActivationRequest.setSignatureAlgorithm(hashAlgorithm);
        directActivationRequest.setSignature(signature);
    }

    private static byte[] getSignaturePayload(DirectActivationRequest.CertificationRequestInfo requestInfo, byte[] clientSecret) {
        DirectActivationRequest.SubjectPublicKeyInfo subjectPublicKeyInfo = requestInfo.getSubjectPublicKeyInfo();
        StringBuffer payload = new StringBuffer(requestInfo.getSubject());
        payload.append("\n");
        payload.append(subjectPublicKeyInfo.getAlgorithm());
        payload.append("\n");
        payload.append(subjectPublicKeyInfo.getFormat());
        payload.append("\n");
        payload.append(subjectPublicKeyInfo.getSecretHashAlgorithm());
        payload.append("\n");
        Map<String, Object> map = requestInfo.getAttributes();
        if (map != null) {
            Set<Map.Entry<String, Object>> attributes = map.entrySet();
            for (Map.Entry<String, Object> attribute : attributes) {
                payload.append(attribute.getKey());
                payload.append("=");
                Object attributeValue = attribute.getValue();
                if (attributeValue != null) {
                    payload.append("'");
                    payload.append(attributeValue);
                    payload.append("'");
                } else {
                    payload.append("null");
                }
                payload.append("\n");
            }
        }
        byte[] payloadBytes = payload.toString().getBytes(UTF_8);
        byte[] signatureBytes = new byte[payloadBytes.length + clientSecret.length + subjectPublicKeyInfo.getPublicKey().length];
        System.arraycopy(payloadBytes, 0, signatureBytes, 0, payloadBytes.length);
        System.arraycopy(clientSecret, 0, signatureBytes, payloadBytes.length, clientSecret.length);
        System.arraycopy(subjectPublicKeyInfo.getPublicKey(), 0, signatureBytes, payloadBytes.length + clientSecret.length, subjectPublicKeyInfo.getPublicKey().length);
        return signatureBytes;
    }

    private static Logger getLogger() {
        return LOGGER;
    }

    static {
        String query = "?createDraft=false";
        if (Boolean.getBoolean("com.oracle.iot.client.device.allow_draft_device_models")) {
            query = "";
        }
        REST_DIRECT_ACTIVATION = RestApi.V2.getReqRoot() + "/activation/direct" + query;
        REST_INDIRECT_ACTIVATION = RestApi.V2.getReqRoot() + "/activation/indirect/device" + query;
        LOGGER = Logger.getLogger("oracle.iot.client");
    }
}

