/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl;

import com.oracle.iot.client.DeviceModelAttribute;
import com.oracle.iot.client.VirtualDeviceAttribute;
import java.nio.charset.Charset;
import java.util.Date;
import oracle.iot.client.AbstractVirtualDevice;
import oracle.iot.client.ExternalObject;

public abstract class VirtualDeviceAttributeBase<V extends AbstractVirtualDevice<V>, T>
extends VirtualDeviceAttribute<V, T> {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    protected final V virtualDevice;
    protected final DeviceModelAttribute<T> model;
    protected T value;
    protected T lastKnownValue;
    private AbstractVirtualDevice.ChangeCallback<V> changeCallback;
    private AbstractVirtualDevice.ErrorCallback<V> errorCallback;

    protected VirtualDeviceAttributeBase(V virtualDevice, DeviceModelAttribute<T> model) {
        this.virtualDevice = virtualDevice;
        this.model = model;
    }

    public DeviceModelAttribute<T> getDeviceModelAttribute() {
        return this.model;
    }

    public abstract boolean update(Object var1);

    public abstract boolean isSettable();

    @Override
    public T get() {
        return this.value != null ? this.value : this.getDeviceModelAttribute().getDefaultValue();
    }

    @Override
    public T getLastKnown() {
        return this.lastKnownValue;
    }

    @Override
    public void setOnChange(AbstractVirtualDevice.ChangeCallback<V> callback) {
        this.changeCallback = callback;
    }

    public AbstractVirtualDevice.ChangeCallback<V> getOnChange() {
        return this.changeCallback;
    }

    @Override
    public void setOnError(AbstractVirtualDevice.ErrorCallback<V> callback) {
        this.errorCallback = callback;
    }

    public AbstractVirtualDevice.ErrorCallback<V> getOnError() {
        return this.errorCallback;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("name : ").append(this.model.getName()).append("\n").append("description : ").append(String.valueOf(this.model.getDescription())).append("\n").append("alias : ").append(String.valueOf(this.model.getAlias())).append("\n").append("model : ").append(String.valueOf(this.model.getModel())).append("\n").append("access : ").append(String.valueOf((Object)this.model.getAccess())).append("\n").append("type : ").append(String.valueOf((Object)this.model.getType())).append("\n");
        DeviceModelAttribute.Type modelType = this.model.getType();
        if (modelType == DeviceModelAttribute.Type.NUMBER || modelType == DeviceModelAttribute.Type.INTEGER) {
            sb.append("lowerBound : ").append(String.valueOf(this.model.getLowerBound())).append("\n").append("upperBound : ").append(String.valueOf(this.model.getUpperBound())).append("\n");
        }
        sb.append("value : ").append(String.valueOf(this.value)).append("\n").append("lastKnownValue : ").append(String.valueOf(this.lastKnownValue)).append("\n").append("defaultValue : ").append(String.valueOf(this.getDeviceModelAttribute().getDefaultValue())).append("\n");
        return sb.toString();
    }

    public void validate(DeviceModelAttribute attribute, Object value) {
        if (value == null) {
            return;
        }
        DeviceModelAttribute.Type type = attribute.getType();
        switch (type) {
            case INTEGER: {
                if (value instanceof Integer) break;
                throw new IllegalArgumentException("value is not INTEGER");
            }
            case NUMBER: {
                if (value instanceof Number) break;
                throw new IllegalArgumentException("value is not NUMBER");
            }
            case STRING: {
                if (value instanceof String) break;
                throw new IllegalArgumentException("value is not STRING");
            }
            case BOOLEAN: {
                if (value instanceof Boolean) break;
                throw new IllegalArgumentException("value is not BOOLEAN");
            }
            case DATETIME: {
                if (value instanceof Date || value instanceof Long) break;
                throw new IllegalArgumentException("value is not DATETIME");
            }
            case URI: {
                if (value instanceof ExternalObject) break;
                throw new IllegalArgumentException("value is not an ExternalObject");
            }
        }
        if (type == DeviceModelAttribute.Type.INTEGER || type == DeviceModelAttribute.Type.NUMBER) {
            double lower;
            double upper;
            double val = ((Number)value).doubleValue();
            if (attribute.getUpperBound() != null && Double.compare(val, upper = attribute.getUpperBound().doubleValue()) > 0) {
                throw new IllegalArgumentException(val + " > " + upper);
            }
            if (attribute.getLowerBound() != null && Double.compare(val, lower = attribute.getLowerBound().doubleValue()) < 0) {
                throw new IllegalArgumentException(val + " < " + lower);
            }
        }
    }
}

