/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl;

import com.oracle.iot.client.device.util.MessageDispatcher;
import com.oracle.iot.client.device.util.RequestHandler;
import com.oracle.iot.client.message.DataMessage;
import com.oracle.iot.client.message.Message;
import com.oracle.iot.client.message.RequestMessage;
import com.oracle.iot.client.message.ResponseMessage;
import com.oracle.iot.client.message.StatusCode;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class TestConnectivity {
    private long count;
    private long currentCount;
    private long interval;
    private long size;
    private final MessageDispatcher messageDispatcher;
    private final String endpointId;
    private TestConnectivityThread testConnectivityThread = null;
    private TestConnectivityHandler testConnectivityHandler;
    private final Object testConnectivityThreadLock = new Object();

    public TestConnectivity(String endpointId, MessageDispatcher messageDispatcher) {
        this.endpointId = endpointId;
        this.messageDispatcher = messageDispatcher;
    }

    private void appendSpacesToErrors(StringBuilder errors) {
        if (errors.toString().length() != 0) {
            errors.append("  ");
        }
    }

    private ResponseMessage getAlreadyRunningResponse(RequestMessage requestMessage) {
        return this.getResponseMessage(requestMessage, "Test connectivity is already running.", StatusCode.CONFLICT);
    }

    private ResponseMessage getBadRequestResponse(RequestMessage requestMessage, String message) {
        return this.getResponseMessage(requestMessage, message, StatusCode.BAD_REQUEST);
    }

    private ResponseMessage getResponseMessage(RequestMessage requestMessage, String body, StatusCode statusCode) {
        return new ResponseMessage.Builder(requestMessage).body(body).statusCode(statusCode).build();
    }

    private ResponseMessage getMethodNotAllowedResponse(RequestMessage requestMessage) {
        return this.getResponseMessage(requestMessage, "Unsupported request: " + requestMessage.toString(), StatusCode.METHOD_NOT_ALLOWED);
    }

    private ResponseMessage getNullRequestResponse(RequestMessage requestMessage) {
        return new ResponseMessage.Builder(requestMessage).body("Unsupported request.").statusCode(StatusCode.METHOD_NOT_ALLOWED).build();
    }

    private Long getParam(JSONObject jsonObject, String paramName, StringBuilder errors) {
        Long value;
        block6: {
            value = null;
            try {
                Number jsonNumber = (Number)jsonObject.opt(paramName);
                if (jsonNumber != null) {
                    try {
                        value = jsonNumber.longValue();
                        if (value < 1L) {
                            errors.append(paramName).append(" must be a numeric value greater then 0.");
                        }
                        break block6;
                    }
                    catch (NumberFormatException nfe) {
                        errors.append(paramName).append(" must be a numeric value greater then 0.");
                    }
                    break block6;
                }
                this.appendSpacesToErrors(errors);
                errors.append("The ").append(paramName).append(" value must be supplied.");
            }
            catch (ClassCastException cce) {
                this.appendSpacesToErrors(errors);
                errors.append("The ").append(paramName).append(" value must be a number.");
            }
        }
        return value;
    }

    public RequestHandler getTestConnectivityHandler() {
        if (this.testConnectivityHandler == null) {
            this.testConnectivityHandler = new TestConnectivityHandler();
        }
        return this.testConnectivityHandler;
    }

    private void resetParameters() {
        this.count = 0L;
        this.currentCount = 0L;
        this.interval = 0L;
        this.size = 0L;
    }

    private class TestConnectivityThread
    extends Thread {
        private final byte[] payload;
        private final DataMessage.Builder testConnectivityMessageBuilder;

        TestConnectivityThread() {
            int sizeInt = TestConnectivity.this.size > Integer.MAX_VALUE ? Integer.MAX_VALUE : Integer.parseInt(Long.toString(TestConnectivity.this.size));
            this.payload = new byte[sizeInt];
            Arrays.fill(this.payload, (byte)0);
            try {
                this.testConnectivityMessageBuilder = (DataMessage.Builder)new DataMessage.Builder().dataItem("count", TestConnectivity.this.count).dataItem("payload", new String(this.payload, "UTF-8")).format("urn:oracle:iot:dcd:capability:diagnostics:test_message").source(TestConnectivity.this.endpointId);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void run() {
            try {
                for (long c = 0L; c < TestConnectivity.this.count; ++c) {
                    try {
                        TestConnectivity.this.messageDispatcher.queue((Message)this.testConnectivityMessageBuilder.dataItem("current", c).build());
                        TestConnectivity.this.currentCount = c + 1L;
                    }
                    catch (ArrayStoreException arrayStoreException) {
                        // empty catch block
                    }
                    Thread.sleep(TestConnectivity.this.interval);
                }
            }
            catch (InterruptedException ie) {
                TestConnectivity.this.resetParameters();
                Thread.currentThread().interrupt();
            }
        }
    }

    private class TestConnectivityHandler
    implements RequestHandler {
        private TestConnectivityHandler() {
        }

        @Override
        public ResponseMessage handleRequest(RequestMessage request) throws Exception {
            if (request != null && request.getMethod() != null) {
                String method = request.getMethod().toUpperCase(Locale.ROOT);
                if (method.equals("GET")) {
                    return this.getTestConnectivity(request);
                }
                if (method.equals("PUT")) {
                    return this.putTestConnectivity(request);
                }
                return TestConnectivity.this.getMethodNotAllowedResponse(request);
            }
            return TestConnectivity.this.getNullRequestResponse(request);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ResponseMessage getTestConnectivity(RequestMessage request) throws Exception {
            JSONObject job = new JSONObject();
            Object object = TestConnectivity.this.testConnectivityThreadLock;
            synchronized (object) {
                if (TestConnectivity.this.testConnectivityThread != null && TestConnectivity.this.testConnectivityThread.isAlive()) {
                    job.put("active", true);
                } else {
                    job.put("active", false);
                }
            }
            job.put("count", TestConnectivity.this.count);
            job.put("currentCount", TestConnectivity.this.currentCount);
            job.put("interval", TestConnectivity.this.interval);
            job.put("size", TestConnectivity.this.size);
            return TestConnectivity.this.getResponseMessage(request, job.toString(), StatusCode.OK);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ResponseMessage putTestConnectivity(RequestMessage request) throws Exception {
            Boolean active = null;
            StringBuilder errors = new StringBuilder();
            String jsonRequestBody = new String(request.getBody(), "UTF-8");
            try {
                JSONObject jsonObject = new JSONObject(jsonRequestBody);
                active = jsonObject.getBoolean("active");
                if (active == null) {
                    return TestConnectivity.this.getBadRequestResponse(request, "Required parameter 'active' is missing.");
                }
                if (!active.booleanValue()) {
                    Object object = TestConnectivity.this.testConnectivityThreadLock;
                    synchronized (object) {
                        if (TestConnectivity.this.testConnectivityThread != null && TestConnectivity.this.testConnectivityThread.isAlive()) {
                            TestConnectivity.this.testConnectivityThread.interrupt();
                        }
                    }
                    return TestConnectivity.this.getResponseMessage(request, "", StatusCode.OK);
                }
                Object object = TestConnectivity.this.testConnectivityThreadLock;
                synchronized (object) {
                    if (TestConnectivity.this.testConnectivityThread != null && TestConnectivity.this.testConnectivityThread.isAlive()) {
                        return TestConnectivity.this.getAlreadyRunningResponse(request);
                    }
                }
                TestConnectivity.this.count = TestConnectivity.this.getParam(jsonObject, "count", errors);
                TestConnectivity.this.interval = TestConnectivity.this.getParam(jsonObject, "interval", errors);
                TestConnectivity.this.size = TestConnectivity.this.getParam(jsonObject, "size", errors);
                if (TestConnectivity.this.count < 1L) {
                    errors.append("count must be greater then 0.");
                }
                if (TestConnectivity.this.interval < 0L) {
                    errors.append("interval must be greater then or equal to 0.");
                }
                if (TestConnectivity.this.size > 4096L) {
                    errors.append("size is greater than 4096.");
                }
                if (!errors.toString().isEmpty()) {
                    TestConnectivity.this.resetParameters();
                    return TestConnectivity.this.getBadRequestResponse(request, errors.toString());
                }
                TestConnectivity.this.testConnectivityThread = new TestConnectivityThread();
                TestConnectivity.this.testConnectivityThread.start();
            }
            catch (Exception e) {
                if (e instanceof ClassCastException || e instanceof JSONException || e instanceof NullPointerException) {
                    return TestConnectivity.this.getBadRequestResponse(request, "Error parsing JSON request, check parameters.");
                }
                throw e;
            }
            return TestConnectivity.this.getResponseMessage(request, "", StatusCode.OK);
        }
    }
}

