/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl;

import com.oracle.iot.client.device.util.RequestHandler;
import com.oracle.iot.client.impl.TimeManager;
import com.oracle.iot.client.message.RequestMessage;
import com.oracle.iot.client.message.ResponseMessage;
import com.oracle.iot.client.message.StatusCode;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import org.json.JSONObject;

public abstract class Diagnostics
implements RequestHandler {
    private final Date startTime = new Date(TimeManager.currentTimeMillis());
    private final String version = System.getProperty("oracle.iot.client.version", "Unknown");
    private final String fixedIpAddress = System.getProperty("com.oracle.iot.client.device.ip_address");
    private final String fixedMacAddress = System.getProperty("com.oracle.iot.client.device.mac_address", "Unknown");

    @Override
    public ResponseMessage handleRequest(RequestMessage request) throws Exception {
        if (request == null) {
            throw new NullPointerException("Request is null");
        }
        if (request.getMethod() != null) {
            if ("GET".equals(request.getMethod().toUpperCase(Locale.ROOT))) {
                try {
                    NetworkInterface[] nif = new NetworkInterface[1];
                    JSONObject job = new JSONObject();
                    job.put("freeDiskSpace", this.getFreeDiskSpace());
                    if (this.fixedIpAddress == null) {
                        job.put("ipAddress", this.getIpAddress(nif));
                        job.put("macAddress", this.getMacAddress(nif[0]));
                    } else {
                        job.put("ipAddress", this.fixedIpAddress);
                        job.put("macAddress", this.fixedMacAddress);
                    }
                    job.put("startTime", this.getStartTimeMs());
                    job.put("totalDiskSpace", this.getTotalDiskSpace());
                    job.put("version", this.version);
                    String jsonValue = job.toString();
                    return this.getResponseMessage(request, jsonValue, StatusCode.OK);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return this.getBadRequestResponse(request);
                }
            }
            return this.getMethodNotAllowedResponse(request);
        }
        return this.getNullRequestResponse(request);
    }

    private String getIpAddress(NetworkInterface[] networkInterface) {
        Enumeration<NetworkInterface> nis;
        InetAddress ipAddress = null;
        try {
            nis = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ignored) {
            return "Unknown";
        }
        block4: while (nis.hasMoreElements()) {
            NetworkInterface itf = nis.nextElement();
            try {
                if (itf.isLoopback()) continue;
                if (itf.isVirtual()) {
                }
            }
            catch (SocketException ignored) {}
            continue;
            Enumeration<InetAddress> addresses = itf.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (address.isLoopbackAddress()) continue;
                if (!address.isLinkLocalAddress()) {
                    ipAddress = address;
                    networkInterface[0] = itf;
                    if (!(address instanceof Inet4Address)) continue;
                    break block4;
                }
                if (ipAddress == null) {
                    ipAddress = address;
                    networkInterface[0] = itf;
                    continue;
                }
                if (!ipAddress.isLinkLocalAddress() || !(address instanceof Inet4Address)) continue;
                ipAddress = address;
                networkInterface[0] = itf;
            }
        }
        if (ipAddress == null) {
            return "Unknown";
        }
        return ipAddress.getHostAddress();
    }

    private String getMacAddress(NetworkInterface networkInterface) {
        if (networkInterface != null) {
            byte[] macAddress = null;
            try {
                macAddress = networkInterface.getHardwareAddress();
            }
            catch (SocketException ignored) {
                // empty catch block
            }
            if (macAddress != null) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < macAddress.length; ++i) {
                    sb.append(String.format(Locale.ROOT, "%02X%s", macAddress[i], i < macAddress.length - 1 ? "-" : ""));
                }
                return sb.toString();
            }
        }
        return "Unknown";
    }

    protected abstract Long getFreeDiskSpace();

    protected abstract Long getTotalDiskSpace();

    private Long getStartTimeMs() {
        return this.startTime.getTime();
    }

    private ResponseMessage getBadRequestResponse(RequestMessage requestMessage) {
        return this.getResponseMessage(requestMessage, "Unable to retrieve resource: state.", StatusCode.BAD_REQUEST);
    }

    private ResponseMessage getMethodNotAllowedResponse(RequestMessage requestMessage) {
        return this.getResponseMessage(requestMessage, "Unsupported request: " + requestMessage.toString(), StatusCode.METHOD_NOT_ALLOWED);
    }

    private ResponseMessage getNullRequestResponse(RequestMessage requestMessage) {
        return this.getResponseMessage(requestMessage, "Unsupported request.", StatusCode.METHOD_NOT_ALLOWED);
    }

    private ResponseMessage getResponseMessage(RequestMessage requestMessage, String body, StatusCode statusCode) {
        return new ResponseMessage.Builder(requestMessage).body(body).statusCode(statusCode).build();
    }
}

