/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl;

import com.oracle.iot.client.DeviceModelAction;
import com.oracle.iot.client.DeviceModelAttribute;

public class DeviceModelActionImpl
extends DeviceModelAction {
    private final String name;
    private final String description;
    private final DeviceModelAttribute.Type argType;
    private final Number lowerBound;
    private final Number upperBound;
    private final String alias;

    public DeviceModelActionImpl(String name, String description, DeviceModelAttribute.Type type, Number lowerBound, Number upperBound, String alias) {
        this.name = name;
        this.description = description;
        this.argType = type;
        if (this.argType == DeviceModelAttribute.Type.INTEGER || this.argType == DeviceModelAttribute.Type.NUMBER) {
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
        } else {
            this.upperBound = null;
            this.lowerBound = null;
        }
        this.alias = alias;
    }

    public DeviceModelActionImpl(String name, String description, String alias) {
        this(name, description, null, null, null, alias);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DeviceModelAttribute.Type getArgType() {
        return this.argType;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Number getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public Number getUpperBound() {
        return this.upperBound;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("name = ");
        b.append(this.name);
        b.append(", description = ");
        b.append(this.description);
        b.append(", type = ");
        b.append((Object)this.argType);
        b.append(", lowerBound = ");
        b.append(this.lowerBound);
        b.append(", upperBound = ");
        b.append(this.upperBound);
        b.append(", alias = ");
        b.append(this.alias);
        return b.toString();
    }
}

