/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.device.persistence;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.apache.derby.jdbc.BasicEmbeddedConnectionPoolDataSource40;
import org.apache.derby.jdbc.BasicEmbeddedDataSource40;

class JavaDBDataSourceFactory {
    static final String JAVADB_DRIVER_NAME = "derby";
    static final String JAVADB_DRIVER_CLASS = "org.apache.derby.jdbc";
    static final String JAVADB_DRIVER_VERSION = "10.11.1.1";
    static final String BOOT_PASSWORD_PROPERTY = "jdbcservice.bootPassword";
    static final String JDBC_DATABASE_NAME = "databaseName";
    static final String JDBC_DATASOURCE_NAME = "datasourceName";
    static final String JDBC_DESCRIPTION = "description";
    static final String JDBC_DRIVER_NAME = "driverName";
    static final String JDBC_DRIVER_CLASS = "driverClass";
    static final String JDBC_DRIVER_VERSION = "driverVersion";
    static final String JDBC_NETWORK_PROTOCOL = "networkProtocol";
    static final String JDBC_SERVER_NAME = "serverName";
    static final String JDBC_PORT_NUMBER = "portNumber";
    static final String JDBC_USER = "user";
    static final String JDBC_PASSWORD = "password";
    static final String JDBC_ROLE_NAME = "roleName";
    static final String JDBC_URL = "url";
    static final String JDBC_INITIAL_POOL_SIZE = "initialPoolSize";
    static final String JDBC_MIN_POOL_SIZE = "minPoolSize";
    static final String JDBC_MAX_POOL_SIZE = "maxPoolSize";
    static final String JDBC_MAX_IDLE_TIME = "maxIdleTime";
    static final String JDBC_MAX_STATEMENTS = "maxStatements";
    static final String JDBC_PROPERTY_CYCLE = "propertyCycle";

    private JavaDBDataSourceFactory() {
    }

    private static void validateProperties(Properties properties, boolean plainDataSource) throws SQLException {
        if (properties.getProperty(JDBC_DATABASE_NAME) == null) {
            throw new SQLException("Database name is not specified");
        }
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (JDBC_NETWORK_PROTOCOL.equals(key) || JDBC_SERVER_NAME.equals(key) || JDBC_PORT_NUMBER.equals(key)) {
                throw new SQLException("Network database is not supported (" + key + ")");
            }
            if (JDBC_USER.equals(key) || JDBC_PASSWORD.equals(key) || JDBC_ROLE_NAME.equals(key)) {
                throw new SQLException("User authentication is not supported (" + key + ")");
            }
            if (JDBC_URL.equals(key)) {
                throw new SQLException("Database URL is not supported");
            }
            if (JDBC_DATABASE_NAME.equals(key) || JDBC_DATASOURCE_NAME.equals(key) || JDBC_DESCRIPTION.equals(key) || BOOT_PASSWORD_PROPERTY.equals(key)) {
                return;
            }
            if (JDBC_INITIAL_POOL_SIZE.equals(key) || JDBC_MIN_POOL_SIZE.equals(key) || JDBC_MAX_POOL_SIZE.equals(key) || JDBC_MAX_IDLE_TIME.equals(key) || JDBC_MAX_STATEMENTS.equals(key) || JDBC_PROPERTY_CYCLE.equals(key)) {
                if (!plainDataSource) continue;
                throw new SQLException(key + " is not supported");
            }
            if (JDBC_DRIVER_CLASS.equals(key)) {
                if (properties.getProperty(key).equalsIgnoreCase(JAVADB_DRIVER_CLASS)) continue;
                throw new SQLException("Unsupported driver class");
            }
            if (JDBC_DRIVER_NAME.equals(key)) {
                if (properties.getProperty(key).equalsIgnoreCase(JAVADB_DRIVER_NAME)) continue;
                throw new SQLException("Unsupported driver name");
            }
            if (JDBC_DRIVER_VERSION.equals(key)) {
                if (properties.getProperty(key).equalsIgnoreCase(JAVADB_DRIVER_VERSION)) continue;
                throw new SQLException("Unsupported driver version");
            }
            throw new SQLException(key + " is not supported");
        }
    }

    static DataSource createDataSource(Properties properties) throws SQLException {
        JavaDBDataSourceFactory.validateProperties(properties, true);
        BasicEmbeddedDataSource40 dataSource = new BasicEmbeddedDataSource40();
        dataSource.setDatabaseName(properties.getProperty(JDBC_DATABASE_NAME));
        dataSource.setDataSourceName(properties.getProperty(JDBC_DATASOURCE_NAME));
        dataSource.setDescription(properties.getProperty(JDBC_DESCRIPTION));
        dataSource.setCreateDatabase("create");
        String bootPassword = properties.getProperty(BOOT_PASSWORD_PROPERTY);
        if (bootPassword != null) {
            dataSource.setConnectionAttributes("dataEncryption=true;bootPassword=" + bootPassword);
        }
        return dataSource;
    }

    static ConnectionPoolDataSource createConnectionPoolDataSource(Properties properties) throws SQLException {
        JavaDBDataSourceFactory.validateProperties(properties, false);
        BasicEmbeddedConnectionPoolDataSource40 dataSource = new BasicEmbeddedConnectionPoolDataSource40();
        dataSource.setDatabaseName(properties.getProperty(JDBC_DATABASE_NAME));
        dataSource.setCreateDatabase("create");
        String bootPassword = properties.getProperty(BOOT_PASSWORD_PROPERTY);
        if (bootPassword != null) {
            dataSource.setConnectionAttributes("dataEncryption=true;bootPassword=" + bootPassword);
        }
        return dataSource;
    }
}

