/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.device.persistence;

import com.oracle.iot.client.device.persistence.BatchByPersistence;
import com.oracle.iot.client.device.persistence.MessagePersistence;
import com.oracle.iot.client.device.persistence.MessagePersistenceImpl;
import com.oracle.iot.client.message.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchByPersistenceImpl
extends BatchByPersistence {
    private final MessagePersistenceImpl delegate;
    private final Collection<Message> messageCollection = new ArrayList<Message>(1);

    public BatchByPersistenceImpl(MessagePersistence messagePersistence) {
        this.delegate = (MessagePersistenceImpl)messagePersistence;
        if (!this.delegate.tableExists("BATCH_BY")) {
            this.delegate.createTable("BATCH_BY");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(Message message, String endpointId) {
        Collection<Message> collection = this.messageCollection;
        synchronized (collection) {
            try {
                this.messageCollection.add(message);
                this.delegate.save("BATCH_BY", this.messageCollection, endpointId);
            }
            finally {
                this.messageCollection.clear();
            }
        }
    }

    @Override
    public void save(Collection<Message> m, String endpointId) {
        this.delegate.save("BATCH_BY", m, endpointId);
    }

    @Override
    public void delete(Collection<Message> m) {
        this.delegate.delete("BATCH_BY", m);
    }

    @Override
    public List<Message> load(String endpointId) {
        return this.delegate.load("BATCH_BY", endpointId);
    }
}

