/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.util;

import com.oracle.iot.client.trust.TrustException;
import com.oracle.iot.client.trust.TrustedAssetsManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.Enumeration;
import java.util.Vector;

public class Bootstrapper {
    static final int UDP_PORT = 4456;
    static final String MULTICAST_ADDRESS = "238.163.7.96";
    static final byte DISCOVER_REQUEST = 1;
    static final byte DISCOVER_RESPONSE = 2;
    static final byte PROVISION_REQUEST = 3;
    static final byte PROVISION_RESPONSE = 4;
    static final byte SUCCESS = 0;
    static final byte FAILURE = 1;
    static final byte UNKNOWN = 2;
    static final Charset UTF_8 = Charset.forName("UTF-8");
    static final int MAX_DATAGRAM_PACKET = 65535;
    static final int MAX_DATAGRAM_DATA = 65507;
    private static String taStore;
    private static String taStorePassword;

    public static void main(String[] args) {
        if (args.length < 3) {
            Bootstrapper.display("\nIncorrect number of arguments.\n");
            Bootstrapper.showUsage();
            System.exit(-1);
        }
        taStore = args[0];
        taStorePassword = args[1];
        try {
            if (!Bootstrapper.isProvisioned(taStore, taStorePassword)) {
                Bootstrapper.listStore(taStore, taStorePassword);
                MulticastSocket multicastSocket = new MulticastSocket(4456);
                InetAddress inetAddress = InetAddress.getByName(MULTICAST_ADDRESS);
                multicastSocket.joinGroup(inetAddress);
                Bootstrapper.display("Joined multicast group.");
                if (multicastSocket.getReceiveBufferSize() < 65535) {
                    multicastSocket.setReceiveBufferSize(65535);
                }
                byte[] receivedData = new byte[65507];
                byte[] outBuffer = new byte[multicastSocket.getSendBufferSize()];
                while (true) {
                    DatagramPacket datagramPacket = new DatagramPacket(receivedData, receivedData.length);
                    multicastSocket.receive(datagramPacket);
                    int length = datagramPacket.getLength();
                    if (length < 1) continue;
                    if (receivedData[0] == 1) {
                        Bootstrapper.handleDiscoverRequest(multicastSocket, outBuffer, datagramPacket.getAddress(), datagramPacket.getPort());
                        continue;
                    }
                    if (receivedData[0] != 3) continue;
                    if (Bootstrapper.handleProvisionRequest(multicastSocket, receivedData, 1, length, datagramPacket.getAddress(), datagramPacket.getPort())) break;
                    Bootstrapper.display("Waiting for provisioning info.");
                }
                multicastSocket.leaveGroup(inetAddress);
                multicastSocket.close();
            }
            Bootstrapper.listStore(taStore, taStorePassword);
            int appArgsLen = args.length - 1;
            String[] appArgs = new String[appArgsLen];
            System.arraycopy(args, 0, appArgs, 0, 2);
            System.arraycopy(args, 3, appArgs, 2, appArgsLen - 2);
            Bootstrapper.startApp(args[2], appArgs);
        }
        catch (Exception e) {
            Bootstrapper.display(e.getMessage());
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private static boolean isProvisioned(String taStore, String taStorePassword) throws GeneralSecurityException {
        if (!new File(taStore).exists()) {
            return false;
        }
        TrustedAssetsManager trustedAssetsManager = Bootstrapper.getTam(taStore, taStorePassword);
        String deviceID = null;
        String serverHost = null;
        try {
            serverHost = trustedAssetsManager.getServerHost();
            deviceID = trustedAssetsManager.getClientId();
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        return serverHost != null && deviceID != null;
    }

    private static void handleDiscoverRequest(DatagramSocket socket, byte[] outBuffer, InetAddress address, int port) throws IOException {
        DeviceInfo clientInfo = Bootstrapper.getDeviceInfo();
        outBuffer[0] = 2;
        int offset = 1;
        offset += Bootstrapper.encodeLengthValue(clientInfo.key, outBuffer, offset);
        int length = offset + Bootstrapper.encodeLengthValue(clientInfo.value, outBuffer, offset);
        socket.send(new DatagramPacket(outBuffer, length, address, port));
    }

    private static boolean handleProvisionRequest(DatagramSocket socket, byte[] request, int offset, int length, InetAddress address, int port) throws IOException {
        if (length < 5) {
            Bootstrapper.display("\tProvisioning was unsuccessful, \n\tformat was not correct.\n");
            Bootstrapper.sendProvisionResponse(socket, (byte)1, address, port);
            return false;
        }
        try {
            Bootstrapper.display("Provisioning...");
            length -= offset;
            int requestLen = (request[offset++] & 0xFF) << 8;
            --length;
            if ((requestLen += request[offset++] & 0xFF) != --length) {
                Bootstrapper.display("Provisioning information too short");
                Bootstrapper.sendProvisionResponse(socket, (byte)1, address, port);
                return false;
            }
            Bootstrapper.updateStore(taStore, request, offset);
            if (Bootstrapper.isProvisioned(taStore, taStorePassword)) {
                Bootstrapper.display("\tSuccessfully provisioned.\n");
                Bootstrapper.sendProvisionResponse(socket, (byte)0, address, port);
                return true;
            }
        }
        catch (IndexOutOfBoundsException e) {
            Bootstrapper.display("\tProvisioning was unsuccessful, \n\tformat was not correct.\n");
            Bootstrapper.sendProvisionResponse(socket, (byte)1, address, port);
            return false;
        }
        catch (Throwable t) {
            // empty catch block
        }
        Bootstrapper.display("\tProvisioning was unsuccessful.\n");
        Bootstrapper.sendProvisionResponse(socket, (byte)1, address, port);
        return false;
    }

    private static void sendProvisionResponse(DatagramSocket socket, byte status, InetAddress address, int port) throws IOException {
        byte[] response = new byte[]{4, status};
        DatagramPacket datagram = new DatagramPacket(response, response.length, address, port);
        socket.send(datagram);
    }

    private static TrustedAssetsManager getTam(String taStore, String taStorePassword) throws GeneralSecurityException {
        return TrustedAssetsManager.Factory.getTrustedAssetsManager(taStore, taStorePassword, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateStore(String taStore, byte[] buff, int offset) throws TrustException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(taStore);
            fos.write(buff, offset, buff.length - offset);
            fos.flush();
        }
        catch (FileNotFoundException fnfe) {
            Bootstrapper.display("Error writing trusted assets store file. ");
        }
        catch (IOException ioe) {
            Bootstrapper.display("Error writing trusted assets store file. ");
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    public static void startApp(String name, String[] args) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Bootstrapper.display("\nStarting application " + name + "...");
        Class<?> c = Class.forName(name);
        Method m = c.getMethod("main", String[].class);
        m.invoke(null, new Object[]{args});
    }

    private static void listStore(String taStore, String taStorePassword) throws GeneralSecurityException {
        if (!new File(taStore).exists()) {
            return;
        }
        TrustedAssetsManager tam = Bootstrapper.getTam(taStore, taStorePassword);
        Bootstrapper.display("Trusted assets store: " + taStore);
        try {
            Bootstrapper.display(" Server scheme: " + tam.getServerScheme());
        }
        catch (IllegalStateException ise) {
            Bootstrapper.display(" Server scheme not set");
        }
        try {
            Bootstrapper.display(" Server host: " + tam.getServerHost());
        }
        catch (IllegalStateException ise) {
            Bootstrapper.display(" Server host not set");
        }
        String serverPort = -1 == tam.getServerPort() ? ("https".equals(tam.getServerScheme()) ? "443" : ("mqtts".equals(tam.getServerScheme()) ? "8883" : "Server port not set")) : Integer.toString(tam.getServerPort());
        Bootstrapper.display(" Server port: " + serverPort);
        try {
            Bootstrapper.display(" Client ID: " + tam.getClientId());
        }
        catch (IllegalStateException ise) {
            Bootstrapper.display(" Client ID not set");
        }
        try {
            Bootstrapper.display(" Endpoint ID: " + tam.getEndpointId());
        }
        catch (IllegalStateException ise) {
            Bootstrapper.display(" Endpoint ID not set");
        }
        try {
            PublicKey key = tam.getPublicKey();
            Bootstrapper.display(" Public key is set");
        }
        catch (IllegalStateException ise) {
            Bootstrapper.display(" Public key not set");
        }
        try {
            Vector<byte[]> certs = tam.getTrustAnchorCertificates();
            Bootstrapper.display(" Trust anchor certificates are set");
        }
        catch (IllegalStateException ise) {
            Bootstrapper.display(" Trust anchor certificates not are set");
        }
    }

    static LV decodeLengthValue(byte[] buffer, int offset) throws IndexOutOfBoundsException {
        int length = buffer[offset++] & 0xFF;
        return new LV(length + 1, UTF_8.decode(ByteBuffer.wrap(buffer, offset, length)).toString());
    }

    static int encodeLengthValue(String value, byte[] buffer, int offset) throws IndexOutOfBoundsException {
        byte[] bytes = UTF_8.encode(value).array();
        if (bytes.length > 255) {
            throw new IndexOutOfBoundsException("value encodes to over 255 bytes");
        }
        buffer[offset++] = (byte)bytes.length;
        System.arraycopy(bytes, 0, buffer, offset, bytes.length);
        return bytes.length + 1;
    }

    private static DeviceInfo getDeviceInfo() {
        try {
            String key = System.getProperty("oracle.iot.client.discovery_key", "MAC");
            String value = System.getProperty("oracle.iot.client.discovery_value", Bootstrapper.getMacAddress());
            return new DeviceInfo(key, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getMacAddress() throws SocketException {
        NetworkInterface networkInterface = null;
        Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
        while (nis.hasMoreElements()) {
            NetworkInterface itf = nis.nextElement();
            if (itf.isLoopback() || itf.isVirtual() || !itf.isUp()) continue;
            networkInterface = itf;
        }
        if (networkInterface != null) {
            byte[] macAddress = null;
            macAddress = networkInterface.getHardwareAddress();
            if (macAddress != null) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < macAddress.length; ++i) {
                    sb.append(String.format("%02X%s", macAddress[i], i < macAddress.length - 1 ? "-" : ""));
                }
                return sb.toString();
            }
        }
        return "Unknown";
    }

    private static void display(String string) {
        System.out.println(string);
    }

    private static void showUsage() {
        Bootstrapper.display("Usage: \n\njava " + Bootstrapper.class.getName() + "\n\t<trust assets file> <trust assets password>" + " <app class name>" + " [<app arg 0>...<app arg 8>]" + "\n\n" + "Where the app class name is the name of the application " + "to start. " + "Where the trust assets store file and trust assets password " + "are also passed on to the application as the first two " + "parameters. " + "Where <app arg 0>...<app arg 8> are any optional arguments " + "to be passed onto the application when started.\n");
    }

    private static class DeviceInfo {
        String key;
        String value;

        DeviceInfo(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }

    static class LV {
        final int length;
        final String value;

        LV(int byteLength, String value) {
            this.length = byteLength;
            this.value = value;
        }
    }
}

