/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.trust;

import com.oracle.iot.client.impl.trust.TrustedAssetsManagerBase;
import com.oracle.iot.client.impl.util.Base64;
import com.oracle.iot.client.trust.TrustException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class UnifiedTrustedAssetsManager
extends TrustedAssetsManagerBase {
    static final int AES_BLOCK_SIZE = 16;
    static final int AES_KEY_SIZE = 128;
    static final int PBKDF2_ITERATIONS = 10000;
    static final byte FORMAT_VERSION = 33;
    static final byte MAX_FORMAT_VERSION = 126;
    static final int SERVER_URI_TAG = 1;
    static final int CLIENT_ID_TAG = 2;
    static final int SHARED_SECRET_TAG = 3;
    static final int ENDPOINT_ID_TAG = 4;
    static final int TRUST_ANCHOR_TAG = 5;
    static final int PRIVATE_KEY_TAG = 6;
    static final int PUBLIC_KEY_TAG = 7;
    static final int CONNECTED_DEVICE_TAG = 8;
    static final Logger logger = Logger.getAnonymousLogger();
    File taStoreFile;
    String taStorePwd;
    byte[] sharedSecretUtf;
    private static final int INTEGER_BYTES = 4;

    public UnifiedTrustedAssetsManager(String path, String password, Object context) throws TrustException {
        this.load(new File(path), password);
    }

    UnifiedTrustedAssetsManager() {
    }

    void load(File path, String password) throws TrustException {
        FileInputStream fis;
        byte[] base64;
        this.taStoreFile = path;
        this.taStorePwd = password;
        if (path == null) {
            throw new TrustException("Path is null");
        }
        if (password == null) {
            throw new TrustException("Password is null");
        }
        try {
            base64 = new byte[(int)this.taStoreFile.length()];
            fis = new FileInputStream(this.taStoreFile);
        }
        catch (FileNotFoundException fnfe) {
            logger.log(Level.SEVERE, this.taStoreFile + " not found");
            throw new TrustException("Error loading trusted assets...", fnfe);
        }
        try {
            fis.read(base64);
            this.initialize(password, base64);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "caught '" + e + "' while loading trusted assets file " + this.taStoreFile);
            throw new TrustException("Error loading trusted assets file " + this.taStoreFile, e);
        }
        finally {
            try {
                fis.close();
            }
            catch (Exception e) {}
        }
    }

    void initialize(String password, byte[] base64) throws Exception {
        int base64Len;
        this.taStorePwd = password;
        if (base64[0] != 33) {
            throw new Exception("Unknown trusted asset store version");
        }
        for (base64Len = 1; base64Len < base64.length && base64[base64Len] != 35; ++base64Len) {
        }
        byte[] cipherText = Base64.getMimeDecoder().decode(base64, 1, base64Len - 1);
        byte[] salt = new byte[16];
        System.arraycopy(cipherText, 0, salt, 0, salt.length);
        SecretKey key = UnifiedTrustedAssetsManager.createKey(password, salt);
        byte[] plainText = UnifiedTrustedAssetsManager.decrypt(key, cipherText);
        TLV tlv = null;
        int length = plainText.length;
        int offset = 0;
        while (offset < length) {
            tlv = new TLV(plainText, offset);
            switch (tlv.tag) {
                case 1: {
                    this.setServer(new String(tlv.value));
                    break;
                }
                case 2: {
                    this.clientId = new String(tlv.value);
                    break;
                }
                case 3: {
                    this.sharedSecretUtf = tlv.value;
                    this.setSharedSecret(this.sharedSecretUtf);
                    break;
                }
                case 4: {
                    this.endpointId = new String(tlv.value);
                    break;
                }
                case 5: {
                    this.addTrustAnchor(tlv.value);
                    break;
                }
                case 6: {
                    this.setPrivateKey(tlv.value);
                    break;
                }
                case 7: {
                    this.setPublicKey(tlv.value);
                    break;
                }
                case 8: {
                    TLV hardwareId = new TLV(tlv.value, 0);
                    TLV sharedSecret = new TLV(tlv.value, hardwareId.offsetToNext);
                    this.addSharedSecret(new String(hardwareId.value), sharedSecret.value);
                    break;
                }
                default: {
                    logger.log(Level.FINEST, "Unknown value tag " + tlv.tag);
                }
            }
            offset = tlv.offsetToNext;
        }
    }

    String getSharedSecret() {
        return new String(this.sharedSecretUtf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void store() throws Exception {
        Iterator iterator;
        X509Certificate trustAnchor = null;
        if (this.trustAnchors != null && (iterator = this.trustAnchors.iterator()).hasNext()) {
            X509Certificate anchor;
            trustAnchor = anchor = (X509Certificate)iterator.next();
        }
        byte[] tas = UnifiedTrustedAssetsManager.createTas(this.taStorePwd, this.serverScheme, this.serverHost, this.serverPort, this.clientId, new String(this.sharedSecretUtf), this.endpointId, trustAnchor, this.privateKey, this.publicKey, this.icdMap);
        FileOutputStream fos = new FileOutputStream(this.taStoreFile);
        try {
            fos.write(tas);
            fos.flush();
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException ioe) {}
        }
    }

    static byte[] createTas(String password, String serverScheme, String serverHost, int serverPort, String clientId, String sharedSecret, String endpointId, X509Certificate trustAnchor, PrivateKey privateKey, PublicKey publicKey, Map<String, SecretKey> icdMap) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        StringBuffer uri = new StringBuffer(serverScheme);
        uri.append("://");
        uri.append(serverHost);
        if (serverPort >= 0) {
            uri.append(':');
            uri.append(serverPort);
        }
        byte[] uriUtf = uri.toString().getBytes("UTF-8");
        TLV.writeValue(bos, 1, uriUtf);
        byte[] clientIdUtf = clientId.getBytes("UTF8");
        TLV.writeValue(bos, 2, clientIdUtf);
        TLV.writeValue(bos, 3, sharedSecret.getBytes("UTF8"));
        if (endpointId != null) {
            TLV.writeValue(bos, 4, endpointId.getBytes("UTF8"));
        }
        if (trustAnchor != null) {
            TLV.writeValue(bos, 5, trustAnchor.getEncoded());
        }
        if (privateKey != null) {
            TLV.writeValue(bos, 6, privateKey.getEncoded());
        }
        if (publicKey != null) {
            TLV.writeValue(bos, 7, publicKey.getEncoded());
        }
        if (icdMap != null) {
            ByteArrayOutputStream icdOutputStream = new ByteArrayOutputStream();
            for (Map.Entry<String, SecretKey> entry : icdMap.entrySet()) {
                TLV.writeValue(icdOutputStream, 2, entry.getKey().getBytes("UTF-8"));
                TLV.writeValue(icdOutputStream, 3, entry.getValue().getEncoded());
                TLV.writeValue(bos, 8, icdOutputStream.toByteArray());
                icdOutputStream.reset();
            }
        }
        byte[] values = bos.toByteArray();
        byte[] iv = UnifiedTrustedAssetsManager.generateIv();
        SecretKey key = UnifiedTrustedAssetsManager.createKey(password, iv);
        byte[] cipherText = UnifiedTrustedAssetsManager.encrypt(key, iv, values);
        byte[] base64 = Base64.getMimeEncoder().encode(cipherText);
        bos.reset();
        bos.write(33);
        bos.write(base64);
        bos.write("\n#serverUri:".getBytes());
        bos.write(uriUtf);
        bos.write("\n#clientId:".getBytes());
        bos.write(clientIdUtf);
        bos.write("\n".getBytes());
        return bos.toByteArray();
    }

    static byte[] generateIv() {
        SecureRandom random = new SecureRandom();
        byte[] iv = new byte[16];
        random.nextBytes(iv);
        return iv;
    }

    static SecretKey createKey(String password, byte[] salt) {
        try {
            PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray(), salt, 10000, 128);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            SecretKey temp = keyFactory.generateSecret(keySpec);
            return new SecretKeySpec(temp.getEncoded(), "AES");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static byte[] encrypt(SecretKey key, byte[] iv, byte[] plainText) {
        return UnifiedTrustedAssetsManager.encrypt(key, iv, plainText, 0, plainText.length);
    }

    static byte[] encrypt(SecretKey key, byte[] iv, byte[] plainText, int offset, int plainTextLength) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)key, new IvParameterSpec(iv));
            byte[] cipherText = new byte[iv.length + cipher.getOutputSize(plainTextLength)];
            System.arraycopy(iv, 0, cipherText, 0, iv.length);
            cipher.doFinal(plainText, offset, plainTextLength, cipherText, iv.length);
            return cipherText;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static byte[] decrypt(SecretKey key, byte[] cipherText) {
        return UnifiedTrustedAssetsManager.decrypt(key, cipherText, 0, cipherText.length);
    }

    static byte[] decrypt(SecretKey key, byte[] cipherText, int offset, int cipherTextLength) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)key, new IvParameterSpec(cipherText, 0, 16));
            return cipher.doFinal(cipherText, offset + 16, cipherTextLength - 16);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static int decodeInt(byte[] buf) {
        int ival = 0;
        for (int n = 0; n < buf.length; ++n) {
            ival <<= 8;
            ival |= buf[n] & 0xFF;
        }
        return ival;
    }

    private static byte[] encodeInt(int ival) {
        byte[] buf = new byte[4];
        for (int n = 3; 0 <= n; --n) {
            int byteval = ival & 0xFF;
            buf[n] = (byte)byteval;
            ival >>>= 8;
        }
        return buf;
    }

    static class TLV {
        int tag;
        int length;
        byte[] value;
        int offsetToNext;

        TLV(byte[] buffer, int offset) {
            this.tag = buffer[offset] & 0xFF;
            this.length = buffer[++offset] & 0xFF;
            this.length <<= 8;
            this.length += buffer[++offset] & 0xFF;
            this.value = new byte[this.length];
            System.arraycopy(buffer, ++offset, this.value, 0, this.length);
            this.offsetToNext = offset + this.length;
        }

        static void writeValue(OutputStream os, int tag, byte[] value) throws IOException {
            os.write(tag);
            os.write(value.length >>> 8);
            os.write(value.length);
            os.write(value);
        }
    }
}

