/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.device.mqtt;

import com.oracle.iot.client.HttpResponse;
import com.oracle.iot.client.RestApi;
import com.oracle.iot.client.SecureConnection;
import com.oracle.iot.client.impl.device.mqtt.MqttSecureConnectionImpl;
import com.oracle.iot.client.trust.TrustedAssetsManager;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.Locale;
import java.util.logging.Logger;

public abstract class MqttSecureConnection
extends SecureConnection {
    protected static final int QOS_AT_MOST_ONCE = 0;
    protected static final int QOS_AT_LEAST_ONCE = 1;
    protected static final int QOS_EXACTLY_ONCE = 2;
    protected static final String MQTT_SSL = "mqtts";
    protected static final String MQTT_TCP = "mqtt";
    protected static final String MQTT_WS = "mqtt-ws";
    protected static final String MQTT_WSS = "mqtt-wss";
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String ACTIVATION_POLICY_TOPIC = "%1$s/%2$s/activation/policy";
    private static final String ACTIVATION_POLICY_PAYLOAD = "{\"OSName\":\"%1$s\",\"OSVersion\":\"%2$s\"}";
    private static final String ACTIVATION_DIRECT_TOPIC = "%1$s/%2$s/activation/direct";
    private static final String ACTIVATION_INDIRECT_TOPIC = "%1$s/%2$s/activation/indirect/device";
    private static final String DEVICE_MODEL_TOPIC = "%1$s/%2$s/deviceModels";
    private static final String DEVICE_MODEL_PAYLOAD = "{\"urn\":\"%1$s\"}";
    private static final String MESSAGES_TOPIC = "%1$s/%2$s/messages";
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");

    public static boolean isMqttPort(TrustedAssetsManager tam) {
        if (tam.getServerScheme() == null) {
            return false;
        }
        String scheme = tam.getServerScheme().toLowerCase(Locale.ROOT);
        return MQTT_SSL.equals(scheme) || MQTT_WSS.equals(scheme) || MQTT_TCP.equals(scheme) || MQTT_WS.equals(scheme);
    }

    protected MqttSecureConnection(TrustedAssetsManager trustedAssetsManager, boolean useOnlySharedSecret) {
        super(trustedAssetsManager, useOnlySharedSecret);
    }

    public static MqttSecureConnection createSecureMqttConnection(TrustedAssetsManager tam, boolean isGateway) throws GeneralSecurityException {
        return new MqttSecureConnectionImpl(tam, isGateway);
    }

    @Override
    public final HttpResponse get(String restApi) throws IOException, GeneralSecurityException {
        if (restApi.startsWith(RestApi.V2.getReqRoot() + "/activation/policy")) {
            String topic = String.format(ACTIVATION_POLICY_TOPIC, "iotcs", this.trustedAssetsManager.getClientId());
            String expect = String.format(ACTIVATION_POLICY_TOPIC, "devices", this.trustedAssetsManager.getClientId());
            byte[] payload = String.format(ACTIVATION_POLICY_PAYLOAD, System.getProperty("os.name"), System.getProperty("os.version")).getBytes(UTF_8);
            return this.publish(topic, payload, expect);
        }
        if (restApi.startsWith(RestApi.V2.getReqRoot() + "/deviceModels")) {
            String topic = String.format(DEVICE_MODEL_TOPIC, "iotcs", this.trustedAssetsManager.isActivated() ? this.trustedAssetsManager.getEndpointId() : this.trustedAssetsManager.getClientId());
            String expect = String.format(DEVICE_MODEL_TOPIC, "devices", this.trustedAssetsManager.isActivated() ? this.trustedAssetsManager.getEndpointId() : this.trustedAssetsManager.getClientId());
            int beginIndex = (RestApi.V2.getReqRoot() + "/deviceModels/").length();
            int endIndex = restApi.indexOf(63);
            String modelName = endIndex != -1 ? restApi.substring(beginIndex, endIndex) : restApi.substring(beginIndex);
            byte[] payload = String.format(DEVICE_MODEL_PAYLOAD, modelName).getBytes(UTF_8);
            return this.publish(topic, payload, expect);
        }
        throw new UnsupportedOperationException("GET " + restApi);
    }

    @Override
    public final HttpResponse post(String restApi, byte[] payload, int timeout) throws IOException, GeneralSecurityException {
        return this.post(restApi, payload);
    }

    @Override
    public final HttpResponse post(String restApi, byte[] payload) throws IOException, GeneralSecurityException {
        if (restApi.startsWith(RestApi.V2.getReqRoot() + "/messages")) {
            String topic = String.format(MESSAGES_TOPIC, "iotcs", this.trustedAssetsManager.getEndpointId());
            String expect = String.format(MESSAGES_TOPIC, "devices", this.trustedAssetsManager.getClientId());
            return this.publish(topic, payload, expect);
        }
        if (restApi.startsWith(RestApi.V2.getReqRoot() + "/activation/direct")) {
            String topic = String.format(ACTIVATION_DIRECT_TOPIC, "iotcs", this.trustedAssetsManager.getClientId());
            String expect = String.format(ACTIVATION_DIRECT_TOPIC, "devices", this.trustedAssetsManager.getClientId());
            return this.publish(topic, payload, expect);
        }
        if (restApi.startsWith(RestApi.V2.getReqRoot() + "/activation/indirect/device")) {
            String topic = String.format(ACTIVATION_INDIRECT_TOPIC, "iotcs", this.trustedAssetsManager.getEndpointId());
            String expect = String.format(ACTIVATION_INDIRECT_TOPIC, "devices", this.trustedAssetsManager.getEndpointId());
            return this.publish(topic, payload, expect);
        }
        throw new UnsupportedOperationException("POST " + restApi);
    }

    @Override
    public final HttpResponse put(String restApi, byte[] payload) throws IOException, GeneralSecurityException {
        throw new UnsupportedOperationException("PUT " + restApi);
    }

    @Override
    public final HttpResponse delete(String restApi) throws IOException, GeneralSecurityException {
        throw new UnsupportedOperationException("DELETE " + restApi);
    }

    @Override
    public final HttpResponse patch(String restApi, byte[] payload) throws IOException, GeneralSecurityException {
        throw new UnsupportedOperationException("PATCH " + restApi);
    }

    protected abstract HttpResponse publish(String var1, byte[] var2, String var3) throws IOException, GeneralSecurityException;

    static Logger getLogger() {
        return LOGGER;
    }
}

