/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.device.http;

import com.oracle.iot.client.HttpResponse;
import com.oracle.iot.client.RestApi;
import com.oracle.iot.client.TransportException;
import com.oracle.iot.client.impl.device.SendReceiveImpl;
import com.oracle.iot.client.impl.http.HttpSecureConnection;
import com.oracle.iot.client.message.Message;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class HttpSendReceiveImpl
extends SendReceiveImpl {
    private static final String LONG_POLL_OFFSET_PROP = "com.oracle.iot.client.device.long_polling_timeout_offset";
    private static final String MIN_ACCEPT_BYTES_HEADER = "X-min-acceptBytes";
    private static final int USE_DEFAULT_TIMEOUT_VALUE = -1;
    private static final int LONG_POLL_OFFSET = Integer.getInteger("com.oracle.iot.client.device.long_polling_timeout_offset", 100);
    private final HttpSecureConnection secureConnection;
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");

    public HttpSendReceiveImpl(HttpSecureConnection secureConnection) {
        this.secureConnection = secureConnection;
    }

    @Override
    protected void post(byte[] payload) throws IOException, GeneralSecurityException {
        this.post(payload, -1);
    }

    @Override
    protected void post(byte[] payload, int timeout) throws IOException, GeneralSecurityException {
        int status;
        HttpResponse response;
        StringBuffer restApi = new StringBuffer(RestApi.V2.getReqRoot()).append("/messages");
        int usedBytes = 0;
        int availableBytes = 0;
        if (!this.useLongPolling || payload == null) {
            usedBytes = this.getUsedBytes();
            availableBytes = this.getRequestBufferSize() - usedBytes - 2;
        }
        restApi.append("?acceptBytes=").append(availableBytes);
        if (this.useLongPolling && availableBytes > 0) {
            restApi.append("&iot.sync");
            if (timeout > 0) {
                int iotTimeout = timeout / 1000;
                if (iotTimeout == 0) {
                    iotTimeout = 1;
                }
                restApi.append("&iot.timeout=");
                restApi.append(iotTimeout);
                timeout = iotTimeout * 1000 + LONG_POLL_OFFSET;
            }
        }
        String uri = restApi.toString();
        if (HttpSendReceiveImpl.getLogger().isLoggable(Level.FINER)) {
            String msg = "POST " + uri + " : " + Message.prettyPrintJson(payload);
            HttpSendReceiveImpl.getLogger().log(Level.FINER, msg);
        }
        try {
            response = this.secureConnection.post(uri, payload, timeout);
        }
        catch (IOException ie) {
            if (ie instanceof SocketTimeoutException) {
                return;
            }
            throw ie;
        }
        if (HttpSendReceiveImpl.getLogger().isLoggable(Level.FINEST)) {
            HttpSendReceiveImpl.getLogger().log(Level.FINEST, response.getVerboseStatus("POST", uri));
        }
        if ((status = response.getStatus()) == 202 || status == 200) {
            if (availableBytes == 0) {
                return;
            }
            Map<String, List<String>> map = response.getHeaders();
            List<String> header = map.get(MIN_ACCEPT_BYTES_HEADER);
            if (header != null && !header.isEmpty()) {
                int requestBufferSize;
                int minAcceptBytes = Integer.parseInt(header.get(0));
                if (minAcceptBytes > (requestBufferSize = this.getRequestBufferSize()) - 2) {
                    HttpSendReceiveImpl.getLogger().log(Level.SEVERE, "The server has a request of " + minAcceptBytes + " bytes for this client, which is too large for the " + requestBufferSize + " byte request buffer. Please " + "restart the client with larger value for " + "oracle.iot.client.device.request_buffer_size");
                } else {
                    HttpSendReceiveImpl.getLogger().log(Level.WARNING, "The server has a request of " + minAcceptBytes + " bytes for this client, which cannot be sent " + " because the " + requestBufferSize + " byte request buffer is filled with " + usedBytes + " of unprocessed requests");
                }
                return;
            }
            this.bufferRequest(response.getData());
            return;
        }
        throw new TransportException(response.getStatus(), response.getVerboseStatus("POST", restApi.toString()));
    }

    private static Logger getLogger() {
        return LOGGER;
    }
}

