/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.device;

import com.oracle.iot.client.TransportException;
import com.oracle.iot.client.device.DirectlyConnectedDevice;
import com.oracle.iot.client.device.persistence.MessagePersistence;
import com.oracle.iot.client.device.util.MessageDispatcher;
import com.oracle.iot.client.device.util.RequestDispatcher;
import com.oracle.iot.client.device.util.RequestHandler;
import com.oracle.iot.client.impl.DiagnosticsImpl;
import com.oracle.iot.client.impl.TestConnectivity;
import com.oracle.iot.client.impl.device.DevicePolicyManager;
import com.oracle.iot.client.impl.device.MessagingPolicyImpl;
import com.oracle.iot.client.impl.device.PersistenceStore;
import com.oracle.iot.client.impl.device.PersistenceStoreManager;
import com.oracle.iot.client.impl.device.StorageObjectImpl;
import com.oracle.iot.client.message.Message;
import com.oracle.iot.client.message.RequestMessage;
import com.oracle.iot.client.message.Resource;
import com.oracle.iot.client.message.ResourceMessage;
import com.oracle.iot.client.message.ResponseMessage;
import com.oracle.iot.client.message.StatusCode;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.iot.client.StorageObject;
import org.json.JSONException;
import org.json.JSONObject;

public final class MessageDispatcherImpl
extends MessageDispatcher {
    private static final int DEFAULT_MAXIMUM_MESSAGES_TO_QUEUE = 10000;
    private static final int DEFAULT_MAXIMUM_MESSAGES_PER_CONNECTION = 100;
    private static final long DEFAULT_POLLING_INTERVAL = 3000L;
    private static final long DEFAULT_SETTLE_TIME = 10000L;
    private static final int REQUEST_DISPATCHER_THREAD_POOL_SIZE = Math.max(Integer.getInteger("oracle.iot.client.device.request_dispatcher_thread_pool_size", 1), 1);
    static final String MAXIMUM_MESSAGES_TO_QUEUE_PROPERTY = "oracle.iot.client.device.dispatcher_max_queue_size";
    private static final String MAXIMUM_MESSAGES_PER_CONNECTION_PROPERTY = "oracle.iot.client.device.dispatcher_max_messages_per_connection";
    private static final long BACKOFF_DELAY = Math.max(Long.getLong("oracle.iot.client.device.message_dispatcher_backoff", 1000L), 100L);
    private static final String POLLING_INTERVAL_PROPERTY = "oracle.iot.client.device.dispatcher_polling_interval";
    private static final String DISABLE_LONG_POLLING_PROPERTY = "com.oracle.iot.client.disable_long_polling";
    private static final String SETTLE_TIME_PROPERTY = "oracle.iot.client.device.dispatcher_settle_time";
    private AtomicBoolean waitOnReconnect = new AtomicBoolean(false);
    static final String COUNTERS_URL = "deviceModels/urn:oracle:iot:dcd:capability:message_dispatcher/counters";
    static final String RESET_URL = "deviceModels/urn:oracle:iot:dcd:capability:message_dispatcher/reset";
    static final String POLLING_INTERVAL_URL = "deviceModels/urn:oracle:iot:dcd:capability:message_dispatcher/pollingInterval";
    static final String DIAGNOSTICS_URL = "deviceModels/urn:oracle:iot:dcd:capability:diagnostics/info";
    static final String TEST_CONNECTIVITY_URL = "deviceModels/urn:oracle:iot:dcd:capability:diagnostics/testConnectivity";
    private RequestHandler counterHandler;
    private final RequestHandler resetHandler;
    private final RequestHandler pollingIntervalHandler;
    private RequestHandler diagnosticsHandler;
    private RequestHandler testConnectivityHandler;
    final HashMap<StorageObjectImpl, HashSet<String>> contentMap;
    final HashSet<String> failedContentIds;
    final PriorityQueue<Message> outgoingMessageQueue;
    private final AtomicInteger queueCapacity = new AtomicInteger(MessageDispatcherImpl.getQueueSize());
    private final int maximumQueueSize;
    private final int maximumMessagesPerConnection;
    private int totalMessagesSent;
    private int totalMessagesReceived;
    private int totalMessagesRetried;
    private long totalBytesSent;
    private long totalBytesReceived;
    private long totalProtocolErrors;
    private long pollingInterval;
    private final Lock sendLock = new ReentrantLock();
    private final Condition messageQueued = this.sendLock.newCondition();
    private final Lock contentLock = new ReentrantLock();
    private final Lock receiveLock = new ReentrantLock();
    private final Condition messageSent = this.receiveLock.newCondition();
    private final Thread transmitThread;
    private final Thread receiveThread;
    private final DirectlyConnectedDevice deviceClient;
    private boolean closed = false;
    private volatile boolean requestClose = false;
    private MessageDispatcher.DeliveryCallback deliveryCallback;
    private MessageDispatcher.ErrorCallback errorCallback;
    private final boolean useLongPolling;
    private final Lock pendingQueueLock = new ReentrantLock();
    private final Condition pendingTrigger = this.pendingQueueLock.newCondition();
    private final Queue<RequestMessage> pendingRequestMessages = new LinkedList<RequestMessage>();
    private static ThreadFactory threadFactory = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            SecurityManager s = System.getSecurityManager();
            ThreadGroup group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            Thread t = new Thread(group, r, "dispatcher-thread", 0L);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    };
    private static final Executor dispatcher = REQUEST_DISPATCHER_THREAD_POOL_SIZE > 1 ? Executors.newFixedThreadPool(REQUEST_DISPATCHER_THREAD_POOL_SIZE, threadFactory) : Executors.newSingleThreadExecutor(threadFactory);
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");

    @Override
    public void setOnDelivery(MessageDispatcher.DeliveryCallback deliveryCallback) {
        this.deliveryCallback = deliveryCallback;
    }

    @Override
    public void setOnError(MessageDispatcher.ErrorCallback errorCallback) {
        this.errorCallback = errorCallback;
    }

    @Override
    public RequestDispatcher getRequestDispatcher() {
        return RequestDispatcher.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageDispatcherImpl(DirectlyConnectedDevice deviceClient) {
        List<Message> messages;
        this.deviceClient = deviceClient;
        this.pollingInterval = MessageDispatcherImpl.getPollingInterval();
        this.maximumQueueSize = MessageDispatcherImpl.getQueueSize();
        this.maximumMessagesPerConnection = MessageDispatcherImpl.getMaximumMessagesPerConnection();
        final String endpointId = this.deviceClient.getEndpointId();
        this.useLongPolling = !Boolean.getBoolean(DISABLE_LONG_POLLING_PROPERTY);
        this.contentMap = new HashMap();
        this.failedContentIds = new HashSet();
        this.outgoingMessageQueue = new PriorityQueue<Message>(MessageDispatcherImpl.getQueueSize(), new Comparator<Message>(){

            @Override
            public int compare(Message o1, Message o2) {
                int c = o2.getPriority().compareTo(o1.getPriority());
                if (c == 0) {
                    c = o1.getEventTime().compareTo(o2.getEventTime());
                }
                if (c == 0) {
                    c = o1.getReliability().compareTo(o2.getReliability());
                }
                if (c == 0) {
                    long lc = o1.getOrdinal() - o2.getOrdinal();
                    c = lc > 0L ? 1 : (lc < 0L ? -1 : 0);
                }
                return c;
            }
        });
        this.totalMessagesReceived = 0;
        this.totalMessagesSent = 0;
        this.totalMessagesRetried = 0;
        this.totalProtocolErrors = 0L;
        this.totalBytesReceived = 0L;
        this.totalBytesSent = 0L;
        this.receiveThread = new Thread((Runnable)new Receiver(), "MessageDispatcher-receive");
        this.receiveThread.setDaemon(true);
        this.receiveThread.start();
        this.transmitThread = new Thread((Runnable)new Transmitter(), "MessageDispatcher-transmit");
        this.transmitThread.setDaemon(true);
        this.transmitThread.start();
        this.counterHandler = new RequestHandler(){

            @Override
            public ResponseMessage handleRequest(RequestMessage request) throws Exception {
                StatusCode status;
                if (request == null) {
                    throw new NullPointerException("Request is null");
                }
                if (request.getMethod() != null) {
                    if ("GET".equals(request.getMethod().toUpperCase(Locale.ROOT))) {
                        try {
                            JSONObject job = new JSONObject();
                            float size = MessageDispatcherImpl.this.maximumQueueSize - MessageDispatcherImpl.this.queueCapacity.get();
                            float max = MessageDispatcherImpl.this.maximumQueueSize;
                            int load = (int)(size / max * 1000.0f);
                            job.put("load", (float)load / 10.0f);
                            job.put("totalBytesSent", MessageDispatcherImpl.this.totalBytesSent);
                            job.put("totalBytesReceived", MessageDispatcherImpl.this.totalBytesReceived);
                            job.put("totalMessagesReceived", MessageDispatcherImpl.this.totalMessagesReceived);
                            job.put("totalMessagesRetried", MessageDispatcherImpl.this.totalMessagesRetried);
                            job.put("totalMessagesSent", MessageDispatcherImpl.this.totalMessagesSent);
                            job.put("totalProtocolErrors", MessageDispatcherImpl.this.totalProtocolErrors);
                            String jsonBody = job.toString();
                            return new ResponseMessage.Builder(request).statusCode(StatusCode.OK).body(jsonBody).build();
                        }
                        catch (Exception exception) {
                            status = StatusCode.BAD_REQUEST;
                        }
                    } else {
                        status = StatusCode.METHOD_NOT_ALLOWED;
                    }
                } else {
                    status = StatusCode.METHOD_NOT_ALLOWED;
                }
                return new ResponseMessage.Builder(request).statusCode(status).build();
            }
        };
        this.resetHandler = new RequestHandler(){

            @Override
            public ResponseMessage handleRequest(RequestMessage request) throws Exception {
                StatusCode status;
                if (request == null) {
                    throw new NullPointerException("Request is null");
                }
                if (request.getMethod() != null) {
                    if ("PUT".equals(request.getMethod().toUpperCase(Locale.ROOT))) {
                        try {
                            MessageDispatcherImpl.this.totalBytesSent = (MessageDispatcherImpl.this.totalBytesReceived = (MessageDispatcherImpl.this.totalProtocolErrors = 0L));
                            MessageDispatcherImpl.this.totalMessagesSent = (MessageDispatcherImpl.this.totalMessagesReceived = (MessageDispatcherImpl.this.totalMessagesRetried = 0));
                            status = StatusCode.OK;
                        }
                        catch (Exception exception) {
                            status = StatusCode.BAD_REQUEST;
                        }
                    } else {
                        status = StatusCode.METHOD_NOT_ALLOWED;
                    }
                } else {
                    status = StatusCode.METHOD_NOT_ALLOWED;
                }
                return new ResponseMessage.Builder(request).statusCode(status).build();
            }
        };
        this.pollingIntervalHandler = new RequestHandler(){

            @Override
            public ResponseMessage handleRequest(RequestMessage request) throws Exception {
                StatusCode status;
                if (request == null) {
                    throw new NullPointerException("Request is null");
                }
                if (request.getMethod() != null) {
                    if ("GET".equals(request.getMethod().toUpperCase(Locale.ROOT))) {
                        try {
                            JSONObject job = new JSONObject();
                            job.put("value", MessageDispatcherImpl.this.pollingInterval);
                            return new ResponseMessage.Builder(request).statusCode(StatusCode.OK).body(job.toString()).build();
                        }
                        catch (Exception exception) {
                            status = StatusCode.BAD_REQUEST;
                        }
                    } else if ("PUT".equals(request.getMethod().toUpperCase(Locale.ROOT))) {
                        try {
                            String jsonRequestBody = new String(request.getBody(), "UTF-8");
                            JSONObject jsonObject = new JSONObject(jsonRequestBody);
                            StringBuilder errors = new StringBuilder();
                            long newPollingInterval = MessageDispatcherImpl.this.getParam(jsonObject, "value", errors);
                            if (errors.toString().length() != 0) {
                                return MessageDispatcherImpl.this.getBadRequestResponse(request, endpointId, errors.toString());
                            }
                            if (newPollingInterval < 0L) {
                                return MessageDispatcherImpl.this.getBadRequestResponse(request, endpointId, "Polling interval must be a numeric value greater than or equal to 0.");
                            }
                            MessageDispatcherImpl.this.pollingInterval = newPollingInterval;
                            status = StatusCode.OK;
                        }
                        catch (JSONException exception) {
                            status = StatusCode.BAD_REQUEST;
                        }
                    } else {
                        status = StatusCode.METHOD_NOT_ALLOWED;
                    }
                } else {
                    status = StatusCode.METHOD_NOT_ALLOWED;
                }
                return new ResponseMessage.Builder(request).statusCode(status).build();
            }
        };
        try {
            this.diagnosticsHandler = new DiagnosticsImpl();
            TestConnectivity testConnectivity = new TestConnectivity(endpointId, this);
            this.testConnectivityHandler = testConnectivity.getTestConnectivityHandler();
            ResourceMessage resourceMessage = ((ResourceMessage.Builder)new ResourceMessage.Builder().endpointName(endpointId).source(endpointId)).register(this.getResource(endpointId, COUNTERS_URL, this.counterHandler, Resource.Method.GET)).register(this.getResource(endpointId, RESET_URL, this.resetHandler, Resource.Method.PUT)).register(this.getResource(endpointId, POLLING_INTERVAL_URL, this.pollingIntervalHandler, Resource.Method.GET, Resource.Method.PUT)).register(this.getResource(endpointId, DIAGNOSTICS_URL, this.diagnosticsHandler, Resource.Method.GET)).register(this.getResource(endpointId, TEST_CONNECTIVITY_URL, this.testConnectivityHandler, Resource.Method.GET, Resource.Method.PUT)).build();
            this.queue((Message)resourceMessage);
        }
        catch (Exception e) {
            MessageDispatcherImpl.getLogger().log(Level.SEVERE, e.getMessage());
            e.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        MessagePersistence messagePersistence = MessagePersistence.getInstance();
        List<Message> list = messages = messagePersistence != null ? messagePersistence.load(deviceClient.getEndpointId()) : null;
        if (messages != null && !messages.isEmpty()) {
            this.sendLock.lock();
            try {
                this.outgoingMessageQueue.addAll(messages);
                this.queueCapacity.addAndGet(-messages.size());
            }
            finally {
                this.sendLock.unlock();
            }
        }
    }

    private static int getQueueSize() {
        int size = Integer.getInteger(MAXIMUM_MESSAGES_TO_QUEUE_PROPERTY, 10000);
        return size > 0 ? size : 10000;
    }

    private static int getMaximumMessagesPerConnection() {
        int max = Integer.getInteger(MAXIMUM_MESSAGES_PER_CONNECTION_PROPERTY, 100);
        return max > 0 ? max : 100;
    }

    private static long getPollingInterval() {
        long interval = Long.getLong(POLLING_INTERVAL_PROPERTY, 3000L);
        return interval >= 0L ? interval : 3000L;
    }

    private Long getParam(JSONObject jsonObject, String paramName, StringBuilder errors) {
        Long value = null;
        try {
            Number jsonNumber = (Number)jsonObject.opt(paramName);
            if (jsonNumber != null) {
                try {
                    value = jsonNumber.longValue();
                }
                catch (NumberFormatException nfe) {
                    errors.append(paramName).append(" must be a numeric value.");
                }
            } else {
                this.appendSpacesToErrors(errors);
                errors.append("The ").append(paramName).append(" value must be supplied.");
            }
        }
        catch (ClassCastException cce) {
            this.appendSpacesToErrors(errors);
            errors.append("The ").append(paramName).append(" value must be a number.");
        }
        return value;
    }

    private void appendSpacesToErrors(StringBuilder errors) {
        if (errors.toString().length() != 0) {
            errors.append("  ");
        }
    }

    private ResponseMessage getBadRequestResponse(RequestMessage requestMessage, String message, String src) {
        return this.getResponseMessage(requestMessage, message, StatusCode.BAD_REQUEST);
    }

    private ResponseMessage getResponseMessage(RequestMessage requestMessage, String body, StatusCode statusCode) {
        return new ResponseMessage.Builder(requestMessage).body(body).statusCode(statusCode).build();
    }

    private String getSoftwareVersion() {
        return System.getProperty("oracle.iot.client.version", "Unknown");
    }

    public void addStorageObjectDependency(StorageObjectImpl storageObject, String clientMsgId) {
        this.contentLock.lock();
        try {
            if (!this.contentMap.containsKey(storageObject)) {
                this.contentMap.put(storageObject, new HashSet());
            }
            this.contentMap.get(storageObject).add(clientMsgId);
        }
        finally {
            this.contentLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStorageObjectDependency(StorageObjectImpl storageObject) {
        boolean completed = storageObject.getSyncStatus() == StorageObject.SyncStatus.IN_SYNC;
        this.contentLock.lock();
        try {
            HashSet<String> ids = this.contentMap.remove(storageObject);
            if (!completed && ids != null) {
                this.failedContentIds.addAll(ids);
            }
        }
        finally {
            this.contentLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isContentDependent(String clientId) {
        this.contentLock.lock();
        try {
            Collection<HashSet<String>> sets = this.contentMap.values();
            for (HashSet<String> set : sets) {
                if (!set.contains(clientId)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.contentLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queue(Message ... messages) {
        if (messages == null || messages.length == 0) {
            throw new IllegalArgumentException("message is null");
        }
        MessagePersistence messagePersistence = MessagePersistence.getInstance();
        if (messagePersistence != null) {
            ArrayList<Message> collection = new ArrayList<Message>();
            Message[] messageArray = messages;
            int n = messageArray.length;
            for (int i = 0; i < n; ++i) {
                Message message = messageArray[i];
                if (message.getReliability() != Message.Reliability.GUARANTEED_DELIVERY) continue;
                collection.add(message);
            }
            if (collection.size() > 0) {
                messagePersistence.save(collection, this.deviceClient.getEndpointId());
            }
        }
        this.sendLock.lock();
        try {
            if (this.queueCapacity.get() < messages.length) {
                throw new ArrayStoreException("queue is full");
            }
            for (Message message : messages) {
                this.outgoingMessageQueue.offer(message);
            }
            this.queueCapacity.addAndGet(-messages.length);
            this.messageQueued.signal();
        }
        finally {
            this.sendLock.unlock();
        }
    }

    @Override
    public void offer(Message ... messages) {
        ArrayList messagesToQueue;
        block9: {
            MessagingPolicyImpl messagingPolicy;
            if (messages == null || messages.length == 0) {
                throw new IllegalArgumentException("message is null");
            }
            PersistenceStore persistenceStore = PersistenceStoreManager.getPersistenceStore(this.deviceClient.getEndpointId());
            Object mpiObj = persistenceStore.getOpaque(MessagingPolicyImpl.class.getName(), null);
            if (mpiObj == null) {
                messagingPolicy = new MessagingPolicyImpl(this.deviceClient);
                persistenceStore.openTransaction().putOpaque(MessagingPolicyImpl.class.getName(), messagingPolicy).commit();
                DevicePolicyManager devicePolicyManager = DevicePolicyManager.getDevicePolicyManager(this.deviceClient);
                devicePolicyManager.addChangeListener(messagingPolicy);
            } else {
                messagingPolicy = (MessagingPolicyImpl)MessagingPolicyImpl.class.cast(mpiObj);
            }
            messagesToQueue = new ArrayList();
            try {
                for (Message message : messages) {
                    Message[] messagesFromPolicy = messagingPolicy.applyPolicies(message);
                    if (messagesToQueue == null) continue;
                    Collections.addAll(messagesToQueue, messagesFromPolicy);
                }
            }
            catch (IOException e) {
                MessageDispatcherImpl.getLogger().log(Level.WARNING, e.getMessage());
                if (this.errorCallback != null) {
                    ArrayList<Message> messageList = new ArrayList<Message>(messages.length);
                    Collections.addAll(messageList, messages);
                    this.errorCallback.failed(messageList, e);
                }
            }
            catch (GeneralSecurityException e) {
                MessageDispatcherImpl.getLogger().log(Level.WARNING, e.getMessage());
                if (this.errorCallback == null) break block9;
                ArrayList<Message> messageList = new ArrayList<Message>(messages.length);
                Collections.addAll(messageList, messages);
                this.errorCallback.failed(messageList, e);
            }
        }
        if (messagesToQueue.size() > 0) {
            this.queue(messagesToQueue.toArray(new Message[messagesToQueue.size()]));
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.requestClose = true;
            if (this.receiveThread != null) {
                this.receiveThread.interrupt();
            }
            try {
                this.transmitThread.interrupt();
                this.transmitThread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.closed = true;
        }
    }

    public boolean isClosed() {
        return this.requestClose;
    }

    private Resource getResource(String endpointId, String name, RequestHandler requestHandler, Resource.Method ... methods) {
        MessageDispatcherImpl messageDispatcher = this;
        RequestDispatcher requestDispatcher = ((MessageDispatcher)messageDispatcher).getRequestDispatcher();
        requestDispatcher.registerRequestHandler(endpointId, name, requestHandler);
        Resource.Builder builder = new Resource.Builder().endpointName(endpointId);
        for (Resource.Method m : methods) {
            builder = builder.method(m);
        }
        return builder.path(name).name(name).build();
    }

    private static Logger getLogger() {
        return LOGGER;
    }

    static /* synthetic */ long access$1300() {
        return BACKOFF_DELAY;
    }

    private class Receiver
    implements Runnable {
        private final long settleTime;
        private final long timeZero;
        private boolean settled;

        private Receiver() {
            long value = Long.getLong(MessageDispatcherImpl.SETTLE_TIME_PROPERTY, 10000L);
            this.settleTime = value >= 0L ? value : 10000L;
            this.timeZero = System.currentTimeMillis();
            boolean bl = this.settled = this.settleTime == 0L;
            if (this.settleTime > 0L) {
                PendingRequestProcessor pendingRequestProcessor = new PendingRequestProcessor(this.settleTime);
                Thread thread = new Thread(pendingRequestProcessor);
                thread.setDaemon(true);
                thread.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block13: while (!MessageDispatcherImpl.this.requestClose) {
                while (MessageDispatcherImpl.this.waitOnReconnect.get() && !MessageDispatcherImpl.this.requestClose) {
                    AtomicBoolean atomicBoolean = MessageDispatcherImpl.this.waitOnReconnect;
                    synchronized (atomicBoolean) {
                        try {
                            MessageDispatcherImpl.this.waitOnReconnect.wait();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        if (MessageDispatcherImpl.this.requestClose) {
                            break block13;
                        }
                    }
                }
                if (!MessageDispatcherImpl.this.useLongPolling) {
                    MessageDispatcherImpl.this.receiveLock.lock();
                    try {
                        if (MessageDispatcherImpl.this.pollingInterval > 0L) {
                            MessageDispatcherImpl.this.messageSent.await(MessageDispatcherImpl.this.pollingInterval, TimeUnit.MILLISECONDS);
                        } else {
                            MessageDispatcherImpl.this.messageSent.await();
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    finally {
                        MessageDispatcherImpl.this.receiveLock.unlock();
                        continue;
                    }
                }
                try {
                    RequestMessage requestMessage = null;
                    while ((requestMessage = MessageDispatcherImpl.this.deviceClient.receive(-1L)) != null) {
                        MessageDispatcherImpl.this.totalMessagesReceived++;
                        MessageDispatcherImpl.this.totalBytesReceived = MessageDispatcherImpl.this.totalBytesReceived + (long)requestMessage.toJson().toString().getBytes(Charset.forName("UTF-8")).length;
                        if (MessageDispatcherImpl.this.requestClose) continue;
                        this.settled |= this.settleTime <= System.currentTimeMillis() - this.timeZero;
                        dispatcher.execute(new Dispatcher(requestMessage, this.settled));
                    }
                }
                catch (IOException ie) {
                    MessageDispatcherImpl.getLogger().log(Level.FINEST, "MessageDispatcher.receiver.run: " + ie.toString());
                    MessageDispatcherImpl.this.waitOnReconnect.set(true);
                }
                catch (GeneralSecurityException ge) {
                    MessageDispatcherImpl.getLogger().log(Level.FINEST, "MessageDispatcher.receiver.run: " + ge.toString());
                    MessageDispatcherImpl.this.waitOnReconnect.set(true);
                }
            }
        }
    }

    private class Dispatcher
    implements Runnable {
        final RequestMessage requestMessage;
        private boolean settled;

        private Dispatcher(RequestMessage requestMessage, boolean settled) {
            this.requestMessage = requestMessage;
            this.settled = settled;
        }

        @Override
        public void run() {
            ResponseMessage responseMessage = RequestDispatcher.getInstance().dispatch(this.requestMessage);
            if (this.settled || responseMessage.getStatusCode() != StatusCode.NOT_FOUND) {
                try {
                    MessageDispatcherImpl.this.queue((Message)responseMessage);
                }
                catch (Throwable t) {
                    MessageDispatcherImpl.getLogger().log(Level.SEVERE, t.toString());
                }
            } else {
                MessageDispatcherImpl.this.pendingQueueLock.lock();
                try {
                    if (MessageDispatcherImpl.this.pendingRequestMessages.offer(this.requestMessage)) {
                        MessageDispatcherImpl.this.pendingTrigger.signal();
                    } else {
                        MessageDispatcherImpl.getLogger().log(Level.SEVERE, "Cannot queue request for dispatch");
                        responseMessage = new ResponseMessage.Builder(this.requestMessage).statusCode(StatusCode.INTERNAL_SERVER_ERROR).build();
                        MessageDispatcherImpl.this.queue((Message)responseMessage);
                    }
                }
                finally {
                    MessageDispatcherImpl.this.pendingQueueLock.unlock();
                }
                return;
            }
        }
    }

    private class PendingRequestProcessor
    implements Runnable {
        private final int MAX_WAIT_TIME = 1000;
        private final long settleTime;
        private final long timeZero;
        private final long averageWaitTime;
        private boolean settled;

        private PendingRequestProcessor(long settleTime) {
            this.settleTime = settleTime;
            this.timeZero = System.currentTimeMillis();
            if (settleTime <= 1000L) {
                this.averageWaitTime = TimeUnit.MILLISECONDS.toNanos(this.settleTime);
            } else {
                long quotient = this.settleTime / 1000L;
                long waitTimeMillis = 1000L + (this.settleTime - quotient * 1000L) / quotient;
                this.averageWaitTime = TimeUnit.MILLISECONDS.toNanos(waitTimeMillis);
            }
            this.settled = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!MessageDispatcherImpl.this.requestClose && !this.settled) {
                ArrayList<RequestMessage> messageList;
                block12: {
                    messageList = null;
                    MessageDispatcherImpl.this.pendingQueueLock.lock();
                    try {
                        long waitTime = TimeUnit.MILLISECONDS.toNanos(this.settleTime - (System.currentTimeMillis() - this.timeZero));
                        if (waitTime > 0L && MessageDispatcherImpl.this.pendingRequestMessages.isEmpty()) {
                            waitTime = MessageDispatcherImpl.this.pendingTrigger.awaitNanos(waitTime);
                        }
                        if (waitTime <= 0L && MessageDispatcherImpl.this.pendingRequestMessages.isEmpty()) break;
                        if (waitTime > 0L) {
                            waitTime = this.averageWaitTime;
                            while (waitTime > 0L) {
                                waitTime = MessageDispatcherImpl.this.pendingTrigger.awaitNanos(waitTime);
                            }
                        }
                        if (MessageDispatcherImpl.this.pendingRequestMessages.isEmpty()) break block12;
                        messageList = new ArrayList<RequestMessage>(MessageDispatcherImpl.this.pendingRequestMessages.size());
                        RequestMessage requestMessage = null;
                        while ((requestMessage = (RequestMessage)MessageDispatcherImpl.this.pendingRequestMessages.poll()) != null) {
                            messageList.add(requestMessage);
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    finally {
                        MessageDispatcherImpl.this.pendingQueueLock.unlock();
                        continue;
                    }
                }
                this.settled |= this.settleTime <= System.currentTimeMillis() - this.timeZero;
                if (messageList == null) continue;
                for (RequestMessage requestMessage : messageList) {
                    dispatcher.execute(new Dispatcher(requestMessage, this.settled));
                }
            }
        }
    }

    private class Transmitter
    implements Runnable {
        private final int[] fib = new int[]{0, 1, 1, 2, 3, 5, 8, 13, 21, 34, 55, 89, 144};
        private final long delay_in_millis = MessageDispatcherImpl.access$1300();
        private int attempt = 0;
        private long backoff = 0L;

        private Transmitter() {
        }

        private long calculateBackoff() {
            if (this.backoff <= 0L) {
                this.attempt = Math.min(this.attempt + 1, this.fib.length - 1);
                this.backoff = (long)this.fib[this.attempt] * this.delay_in_millis;
            }
            return this.backoff;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<Message> pendingMessages = new ArrayList<Message>();
            while (!MessageDispatcherImpl.this.requestClose || !MessageDispatcherImpl.this.outgoingMessageQueue.isEmpty()) {
                boolean newAlert = false;
                MessageDispatcherImpl.this.sendLock.lock();
                try {
                    long t0 = System.currentTimeMillis();
                    while (!MessageDispatcherImpl.this.requestClose && MessageDispatcherImpl.this.outgoingMessageQueue.isEmpty()) {
                        MessageDispatcherImpl.this.messageQueued.await();
                    }
                    if (this.backoff > 0L) {
                        long waitTime = System.currentTimeMillis() - t0;
                        this.backoff = Math.max(this.backoff - waitTime, 0L);
                    }
                    while (!MessageDispatcherImpl.this.outgoingMessageQueue.isEmpty()) {
                        Message message = MessageDispatcherImpl.this.outgoingMessageQueue.poll();
                        newAlert |= message.getType() == Message.Type.ALERT;
                        pendingMessages.add(message);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    MessageDispatcherImpl.this.sendLock.unlock();
                }
                this.send(pendingMessages, newAlert);
            }
        }

        private List<Message> getMessagesToSend(List<Message> pendingMessages, boolean receivedNewAlert) {
            boolean isBackoff;
            if (pendingMessages.isEmpty()) {
                return Collections.emptyList();
            }
            boolean bl = isBackoff = this.backoff > 0L;
            if (isBackoff && !receivedNewAlert) {
                return Collections.emptyList();
            }
            ArrayList<Message> errorList = new ArrayList<Message>();
            ArrayList<Message> messageList = new ArrayList<Message>();
            Iterator<Message> messageIterator = pendingMessages.iterator();
            while (messageIterator.hasNext()) {
                Message message = messageIterator.next();
                String clientId = message.getClientId();
                if (message.getType() == Message.Type.RESPONSE) {
                    messageIterator.remove();
                    messageList.add(message);
                    continue;
                }
                if (MessageDispatcherImpl.this.failedContentIds.contains(clientId)) {
                    messageIterator.remove();
                    MessageDispatcherImpl.this.queueCapacity.addAndGet(1);
                    errorList.add(message);
                    continue;
                }
                if (MessageDispatcherImpl.this.isContentDependent(clientId)) break;
                messageIterator.remove();
                messageList.add(message);
            }
            if (!errorList.isEmpty() && MessageDispatcherImpl.this.errorCallback != null) {
                MessageDispatcherImpl.this.errorCallback.failed(errorList, new IOException("Content sync failed"));
            }
            return messageList;
        }

        private void send(List<Message> pendingMessages, boolean newAlert) {
            block17: {
                List<Message> messages = this.getMessagesToSend(pendingMessages, newAlert);
                if (messages.isEmpty()) {
                    return;
                }
                int fromIndex = 0;
                try {
                    Message[] messageArray = messages.toArray(new Message[messages.size()]);
                    if (this.attempt == 0) {
                        MessageDispatcherImpl.this.deviceClient.send(messageArray);
                        this.messagesSent(messageArray);
                    } else {
                        int iter = 0;
                        int offset = 0;
                        boolean sent = false;
                        do {
                            int a = messageArray.length - offset;
                            int b = this.fib[Math.min(++iter, this.fib.length)] * 10;
                            int size = Math.min(a, b);
                            Message[] sublist = Arrays.copyOfRange(messageArray, offset, offset += size);
                            MessageDispatcherImpl.this.deviceClient.send(sublist);
                            this.messagesSent(sublist);
                            fromIndex = offset;
                        } while (offset < messageArray.length);
                    }
                }
                catch (IOException e) {
                    if (e instanceof TransportException) {
                        int status = ((TransportException)e).getStatusCode();
                        if (status == 503) {
                            this.calculateBackoff();
                            MessageDispatcherImpl.getLogger().log(Level.WARNING, "Server busy. Messages will be retried in " + this.backoff + " milliseconds.");
                        }
                    } else if (e instanceof SocketException) {
                        this.calculateBackoff();
                        MessageDispatcherImpl.getLogger().log(Level.WARNING, e.toString() + ". Messages will be retried in " + this.backoff + " milliseconds.");
                    } else if (e instanceof UnknownHostException) {
                        this.calculateBackoff();
                        MessageDispatcherImpl.getLogger().log(Level.WARNING, e.toString() + ". Messages will be retried in " + this.backoff + " milliseconds.");
                    }
                    MessageDispatcherImpl.this.totalProtocolErrors++;
                    while (fromIndex < messages.size()) {
                        Message message;
                        if ((message = messages.get(fromIndex++)).getRemainingRetries() > 0) {
                            assert (pendingMessages.indexOf(message) == -1);
                            pendingMessages.add(message);
                            continue;
                        }
                        MessageDispatcherImpl.this.queueCapacity.addAndGet(1);
                        MessageDispatcherImpl.getLogger().log(Level.INFO, "Cannot queue message for retry. Message discarded: " + message.getClientId());
                    }
                    if (MessageDispatcherImpl.this.errorCallback != null) {
                        MessageDispatcherImpl.this.errorCallback.failed(messages, e);
                    }
                }
                catch (GeneralSecurityException e) {
                    if (MessageDispatcherImpl.this.errorCallback == null) break block17;
                    MessageDispatcherImpl.this.errorCallback.failed(messages, e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void messagesSent(Message[] messages) {
            this.backoff = 0L;
            this.attempt = 0;
            MessageDispatcherImpl.this.queueCapacity.addAndGet(messages.length);
            if (MessageDispatcherImpl.this.waitOnReconnect.get()) {
                AtomicBoolean atomicBoolean = MessageDispatcherImpl.this.waitOnReconnect;
                synchronized (atomicBoolean) {
                    MessageDispatcherImpl.this.waitOnReconnect.set(false);
                    MessageDispatcherImpl.this.waitOnReconnect.notify();
                }
            }
            if (MessageDispatcherImpl.this.deliveryCallback != null) {
                MessageDispatcherImpl.this.deliveryCallback.delivered(Arrays.asList(messages));
            }
            MessageDispatcherImpl.this.totalMessagesSent = MessageDispatcherImpl.this.totalMessagesSent + messages.length;
            MessagePersistence messagePersistence = MessagePersistence.getInstance();
            ArrayList<Message> guaranteedMessages = messagePersistence != null ? new ArrayList<Message>() : null;
            for (int index = 0; index < messages.length; ++index) {
                Message message = messages[index];
                MessageDispatcherImpl.this.totalBytesSent = MessageDispatcherImpl.this.totalBytesSent + (long)message.toJson().toString().getBytes(Charset.forName("UTF-8")).length;
                if (guaranteedMessages == null || message.getReliability() != Message.Reliability.GUARANTEED_DELIVERY) continue;
                guaranteedMessages.add(message);
            }
            if (guaranteedMessages != null && !guaranteedMessages.isEmpty()) {
                messagePersistence.delete(guaranteedMessages);
            }
            MessageDispatcherImpl.this.receiveLock.lock();
            try {
                MessageDispatcherImpl.this.messageSent.signal();
            }
            finally {
                MessageDispatcherImpl.this.receiveLock.unlock();
            }
        }
    }
}

