/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.device;

import com.oracle.iot.client.impl.util.Base64;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class IndirectActivationRequest {
    private static final String HARDWARE_ID = "hardwareId";
    private static final String FIELD_DEVICE_MODELS = "deviceModels";
    private String hardwareId;
    private Map<String, String> metadata;
    private Set<String> deviceModels;
    private byte[] signature;
    private PublicKey publicKey;

    protected IndirectActivationRequest() {
    }

    public IndirectActivationRequest(String hardwareId, Map<String, String> metadata, Set<String> deviceModels, byte[] signature) {
        this.hardwareId = hardwareId;
        this.metadata = metadata;
        this.deviceModels = deviceModels;
        this.signature = signature;
    }

    public String getHardwareId() {
        return this.hardwareId;
    }

    public void setHardwareId(String hardwareId) {
        this.hardwareId = hardwareId;
    }

    public Set<String> getDeviceModels() {
        return this.deviceModels;
    }

    public void setDeviceModels(Set<String> deviceModels) {
        this.deviceModels = deviceModels;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public static IndirectActivationRequest fromJson(String jsonString) {
        IndirectActivationRequest request = new IndirectActivationRequest();
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            request.fromJson(jsonObject);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return request;
    }

    public void fromJson(JSONObject jsonObject) {
        String sig;
        Iterator<String> iterator = jsonObject.keys();
        this.metadata = new HashMap<String, String>();
        while (iterator.hasNext()) {
            String key = iterator.next();
            Object value = jsonObject.opt(key);
            if (key.equals(HARDWARE_ID)) {
                this.hardwareId = value.toString();
            }
            this.metadata.put(key, value.toString());
        }
        JSONArray deviceModelsArray = jsonObject.optJSONArray(FIELD_DEVICE_MODELS);
        if (deviceModelsArray != null) {
            HashSet<String> deviceModels = new HashSet<String>();
            int size = deviceModelsArray.length();
            for (int i = 0; i < size; ++i) {
                deviceModels.add(deviceModelsArray.opt(i).toString());
            }
            this.setDeviceModels(deviceModels);
        }
        this.signature = (byte[])((sig = jsonObject.optString("signature", null)) != null ? Base64.getDecoder().decode(sig) : null);
    }

    public String toJson() {
        JSONObject jbuilder = new JSONObject();
        JSONArray deviceModels = new JSONArray();
        try {
            if (this.hardwareId == null) {
                throw new NullPointerException("Hardware ID is null");
            }
            if (this.signature != null) {
                jbuilder.put("signature", Base64.getEncoder().encodeToString(this.signature));
            }
            jbuilder.put(HARDWARE_ID, this.hardwareId);
            if (this.metadata != null) {
                Set<Map.Entry<String, String>> entries = this.metadata.entrySet();
                Iterator<Map.Entry<String, String>> iterator = entries.iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> entry = iterator.next();
                    jbuilder.put(entry.getKey(), entry.getValue());
                }
            }
            if (this.deviceModels != null) {
                for (String deviceModel : this.deviceModels) {
                    deviceModels.put(deviceModel);
                }
                jbuilder.put(FIELD_DEVICE_MODELS, deviceModels);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return jbuilder.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("IndirectActivationRequest");
        sb.append("{");
        sb.append("hardwareId=").append(this.hardwareId);
        sb.append("deviceModels=").append(Arrays.toString(this.deviceModels.toArray()));
        if (this.metadata != null) {
            Set<Map.Entry<String, String>> entries = this.metadata.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                sb.append(entry.getKey()).append(entry.getValue());
            }
        }
        sb.append("}");
        return sb.toString();
    }
}

