/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.device;

import com.oracle.iot.client.DeviceModelAction;
import com.oracle.iot.client.DeviceModelAttribute;
import com.oracle.iot.client.device.DirectlyConnectedDevice;
import com.oracle.iot.client.device.util.RequestDispatcher;
import com.oracle.iot.client.impl.DeviceModelImpl;
import com.oracle.iot.client.impl.device.DeviceAnalog;
import com.oracle.iot.client.message.Message;
import com.oracle.iot.client.message.RequestMessage;
import com.oracle.iot.client.message.ResponseMessage;
import com.oracle.iot.client.message.StatusCode;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.iot.client.DeviceModel;

public final class DeviceAnalogImpl
implements DeviceAnalog {
    private final DirectlyConnectedDevice directlyConnectedDevice;
    private final DeviceModelImpl deviceModel;
    private final String endpointId;
    private final Map<String, Object> attributeValueMap;
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");

    public DeviceAnalogImpl(DirectlyConnectedDevice directlyConnectedDevice, DeviceModelImpl deviceModel, String endpointId) {
        this.directlyConnectedDevice = directlyConnectedDevice;
        this.deviceModel = deviceModel;
        this.endpointId = endpointId;
        this.attributeValueMap = new HashMap<String, Object>();
    }

    @Override
    public String getEndpointId() {
        return this.endpointId;
    }

    @Override
    public DeviceModel getDeviceModel() {
        return this.deviceModel;
    }

    @Override
    public void setAttributeValue(String attribute, Object value) {
        boolean badValue;
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        DeviceModelAttribute deviceModelAttribute = this.deviceModel.getDeviceModelAttributes().get(attribute);
        if (deviceModelAttribute == null) {
            throw new IllegalArgumentException(this.deviceModel.getURN() + " does not contain attribute " + attribute);
        }
        DeviceModelAttribute.Type type = deviceModelAttribute.getType();
        switch (type) {
            case NUMBER: {
                badValue = !(value instanceof Number);
                break;
            }
            case STRING: 
            case URI: {
                badValue = !(value instanceof String);
                break;
            }
            case BOOLEAN: {
                badValue = !(value instanceof Boolean);
                break;
            }
            case INTEGER: {
                badValue = !(value instanceof Integer);
                break;
            }
            case DATETIME: {
                badValue = !(value instanceof Long);
                break;
            }
            default: {
                throw new InternalError("unknown type '" + (Object)((Object)type) + "'");
            }
        }
        if (badValue) {
            throw new IllegalArgumentException("cannot set '" + this.deviceModel.getURN() + ":attribute/" + attribute + "' to " + value.toString());
        }
        this.attributeValueMap.put(attribute, value);
    }

    @Override
    public Object getAttributeValue(String attribute) {
        DeviceModelAttribute deviceModelAttribute = this.deviceModel.getDeviceModelAttributes().get(attribute);
        if (deviceModelAttribute == null) {
            throw new IllegalArgumentException(this.deviceModel.getURN() + " does not contain attribute " + attribute);
        }
        Object value = this.attributeValueMap.get(attribute);
        if (value == null) {
            value = deviceModelAttribute.getDefaultValue();
        }
        return value;
    }

    @Override
    public void call(String actionName, Object ... args) {
        boolean useLongPolling;
        Map<String, DeviceModelAction> deviceModelActionMap = this.deviceModel.getDeviceModelActions();
        if (deviceModelActionMap == null) {
            DeviceAnalogImpl.getLogger().log(Level.WARNING, this.deviceModel.getURN() + " does not contain action '" + actionName + "'");
            return;
        }
        DeviceModelAction deviceModelAction = deviceModelActionMap.get(actionName);
        if (deviceModelAction == null) {
            DeviceAnalogImpl.getLogger().log(Level.WARNING, this.deviceModel.getURN() + " does not contain action '" + actionName + "'");
            return;
        }
        DeviceModelAttribute.Type argType = deviceModelAction.getArgType();
        Object arg = args != null && args.length > 0 ? args[0] : null;
        RequestMessage.Builder requestMessageBuilder = ((RequestMessage.Builder)((RequestMessage.Builder)new RequestMessage.Builder().source(this.getEndpointId())).destination(this.getEndpointId())).url("deviceModels/" + this.getDeviceModel().getURN() + "/actions/" + actionName).method("POST");
        if (argType != null) {
            boolean goodArg;
            if (arg == null) {
                DeviceAnalogImpl.getLogger().log(Level.WARNING, this.getDeviceModel().getURN() + " action '" + actionName + "' requires an argument");
                return;
            }
            switch (argType) {
                case NUMBER: 
                case INTEGER: {
                    double lower;
                    double upper;
                    String value;
                    goodArg = arg instanceof Number;
                    if (!goodArg) break;
                    Number number = (Number)Number.class.cast(arg);
                    if (argType == DeviceModelAttribute.Type.INTEGER) {
                        Long roundedValue = Math.round(number.doubleValue());
                        value = Integer.toString(roundedValue.intValue());
                    } else {
                        value = number.toString();
                    }
                    requestMessageBuilder.body("{\"value\":" + value + "}");
                    double val = ((Number)arg).doubleValue();
                    if (deviceModelAction.getUpperBound() != null && Double.compare(val, upper = deviceModelAction.getUpperBound().doubleValue()) > 0) {
                        DeviceAnalogImpl.getLogger().log(Level.WARNING, this.getDeviceModel().getURN() + " action '" + actionName + "' arg out of range: " + val + " > " + upper);
                    }
                    if (deviceModelAction.getLowerBound() == null || Double.compare(val, lower = deviceModelAction.getLowerBound().doubleValue()) >= 0) break;
                    DeviceAnalogImpl.getLogger().log(Level.WARNING, this.getDeviceModel().getURN() + " action '" + actionName + "' arg out of range: " + val + " < " + lower);
                    break;
                }
                case DATETIME: {
                    Object value;
                    boolean bl = goodArg = arg instanceof Date || arg instanceof Number;
                    if (!goodArg) break;
                    if (arg instanceof Date) {
                        Date date = (Date)Date.class.cast(arg);
                        value = Long.toString(date.getTime());
                    } else {
                        Long lval = (Long)Long.class.cast(arg);
                        value = Long.toString(lval);
                    }
                    requestMessageBuilder.body("{\"value\":" + (String)value + "}");
                    break;
                }
                case BOOLEAN: {
                    goodArg = arg instanceof Boolean;
                    if (!goodArg) break;
                    Object value = (Boolean)Boolean.class.cast(arg);
                    requestMessageBuilder.body("{\"value\":" + ((Boolean)value).toString() + "}");
                    break;
                }
                case STRING: 
                case URI: {
                    goodArg = arg instanceof String;
                    if (!goodArg) break;
                    Object value = (String)String.class.cast(arg);
                    requestMessageBuilder.body("{\"value\":" + (String)value + "}");
                    break;
                }
                default: {
                    DeviceAnalogImpl.getLogger().log(Level.SEVERE, "unexpected type " + (Object)((Object)argType));
                    goodArg = false;
                }
            }
            if (!goodArg) {
                DeviceAnalogImpl.getLogger().log(Level.WARNING, this.getDeviceModel().getURN() + " action '" + actionName + "': wrong argument type. " + "Expected " + (Object)((Object)argType) + " found " + arg.getClass());
                return;
            }
        }
        RequestMessage requestMessage = requestMessageBuilder.build();
        boolean bl = useLongPolling = !Boolean.getBoolean("com.oracle.iot.client.disable_long_polling");
        if (useLongPolling) {
            try {
                ResponseMessage responseMessage = RequestDispatcher.getInstance().dispatch(requestMessage);
                if (responseMessage.getStatusCode() == StatusCode.NOT_FOUND) {
                    DeviceAnalogImpl.getLogger().log(Level.INFO, "Endpoint " + this.getEndpointId() + " has no handler for " + requestMessage.getURL());
                }
            }
            catch (Exception e) {
                DeviceAnalogImpl.getLogger().log(Level.WARNING, e.getMessage());
            }
        } else {
            try {
                this.directlyConnectedDevice.send(requestMessage);
            }
            catch (IOException e) {
                DeviceAnalogImpl.getLogger().log(Level.WARNING, e.getMessage());
            }
            catch (GeneralSecurityException e) {
                DeviceAnalogImpl.getLogger().log(Level.WARNING, e.getMessage());
            }
        }
    }

    @Override
    public void queueMessage(Message message) {
        try {
            this.directlyConnectedDevice.offer(message);
        }
        catch (IOException e) {
            DeviceAnalogImpl.getLogger().log(Level.INFO, e.getMessage());
        }
        catch (GeneralSecurityException e) {
            DeviceAnalogImpl.getLogger().log(Level.INFO, e.getMessage());
        }
    }

    private static Logger getLogger() {
        return LOGGER;
    }
}

