/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.device;

import com.oracle.iot.client.DeviceModelFormat;
import com.oracle.iot.client.impl.DeviceModelImpl;
import com.oracle.iot.client.impl.device.StorageObjectImpl;
import com.oracle.iot.client.impl.device.VirtualDeviceImpl;
import com.oracle.iot.client.message.AlertMessage;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.iot.client.DeviceModel;
import oracle.iot.client.ExternalObject;
import oracle.iot.client.StorageObject;
import oracle.iot.client.device.Alert;
import oracle.iot.client.device.VirtualDevice;

public class AlertImpl
extends Alert {
    private final VirtualDeviceImpl virtualDevice;
    private final DeviceModelFormat deviceModelFormat;
    private final Map<String, Object> fieldValues;
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");

    public AlertImpl(VirtualDevice virtualDevice, String alertUrn) {
        if (!(virtualDevice instanceof VirtualDeviceImpl)) {
            throw new IllegalArgumentException("expected: " + VirtualDeviceImpl.class.getName());
        }
        this.deviceModelFormat = AlertImpl.getDeviceModelFormat(virtualDevice, alertUrn);
        if (this.deviceModelFormat == null) {
            throw new IllegalArgumentException("'" + alertUrn + "' not found");
        }
        if (this.deviceModelFormat.getType() != DeviceModelFormat.Type.ALERT) {
            throw new IllegalArgumentException("'" + alertUrn + "' is not an alert format");
        }
        this.virtualDevice = (VirtualDeviceImpl)virtualDevice;
        this.fieldValues = new HashMap<String, Object>();
    }

    @Override
    public <T> Alert set(String fieldName, T value) {
        DeviceModelFormat.Field field = this.getField(fieldName);
        if (field == null) {
            throw new IllegalArgumentException(fieldName + " not in model");
        }
        switch (field.getType()) {
            case NUMBER: {
                if (value instanceof Number) break;
                throw new IllegalArgumentException("value for '" + fieldName + "' is not a NUMBER");
            }
            case INTEGER: {
                if (value instanceof Integer) break;
                throw new IllegalArgumentException("value for '" + fieldName + "' is not an INTEGER");
            }
            case DATETIME: {
                if (value instanceof Date || value instanceof Long) break;
                throw new IllegalArgumentException("value for '" + fieldName + "' is not a DATETIME");
            }
            case BOOLEAN: {
                if (value instanceof Boolean) break;
                throw new IllegalArgumentException("value for '" + fieldName + "' is not a BOOLEAN");
            }
            case STRING: {
                if (value instanceof String) break;
                throw new IllegalArgumentException("value for '" + fieldName + "' is not a STRING");
            }
            case URI: {
                if (value instanceof ExternalObject) break;
                throw new IllegalArgumentException("value for '" + fieldName + "' is not an ExternalObject");
            }
        }
        this.fieldValues.put(fieldName, value);
        return this;
    }

    @Override
    public void raise() {
        AlertMessage.Builder builder = new AlertMessage.Builder();
        List<DeviceModelFormat.Field> fieldList = this.deviceModelFormat.getFields();
        StorageObjectImpl storageObject = null;
        block11: for (DeviceModelFormat.Field field : fieldList) {
            String key = field.getName();
            Object value = this.fieldValues.remove(key);
            if (value != null) {
                switch (field.getType()) {
                    case NUMBER: {
                        builder.dataItem(key, ((Number)value).doubleValue());
                        continue block11;
                    }
                    case INTEGER: {
                        builder.dataItem(key, ((Integer)value).intValue());
                        continue block11;
                    }
                    case DATETIME: {
                        if (value instanceof Date) {
                            builder.dataItem(key, ((Date)value).getTime());
                            continue block11;
                        }
                        if (!(value instanceof Long)) continue block11;
                        builder.dataItem(key, ((Long)value).longValue());
                        continue block11;
                    }
                    case BOOLEAN: {
                        builder.dataItem(key, (Boolean)value);
                        continue block11;
                    }
                    case STRING: {
                        builder.dataItem(key, (String)value);
                        continue block11;
                    }
                    case URI: {
                        if (value instanceof StorageObjectImpl) {
                            storageObject = (StorageObjectImpl)value;
                            if (storageObject.getSyncStatus() == StorageObject.SyncStatus.NOT_IN_SYNC || storageObject.getSyncStatus() == StorageObject.SyncStatus.SYNC_PENDING) {
                                // empty if block
                            }
                            storageObject.setSyncEventInfo(this.virtualDevice, key);
                        }
                        builder.dataItem(key, ((ExternalObject)value).getURI());
                        continue block11;
                    }
                }
                AlertImpl.getLogger().log(Level.INFO, "unknown type: " + (Object)((Object)field.getType()));
                continue;
            }
            if (field.isOptional()) continue;
            this.fieldValues.clear();
            throw new IllegalStateException("non-optional field '" + key + "' not set");
        }
        this.fieldValues.clear();
        builder.format(this.deviceModelFormat.getURN()).description(this.deviceModelFormat.getDescription()).source(this.virtualDevice.getEndpointId());
        AlertMessage message = builder.build();
        try {
            this.virtualDevice.queueMessage(message, storageObject);
        }
        catch (ArrayStoreException e) {
            throw e;
        }
        catch (Throwable t) {
            AlertImpl.getLogger().log(Level.SEVERE, t.toString());
        }
    }

    private DeviceModelFormat.Field getField(String fieldName) {
        if (this.deviceModelFormat == null) {
            return null;
        }
        List<DeviceModelFormat.Field> fieldList = this.deviceModelFormat.getFields();
        for (DeviceModelFormat.Field field : fieldList) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    private static DeviceModelFormat getDeviceModelFormat(VirtualDevice virtualDevice, String alertUrn) {
        DeviceModel dm = virtualDevice.getDeviceModel();
        if (!(dm instanceof DeviceModelImpl)) {
            return null;
        }
        DeviceModelImpl deviceModel = (DeviceModelImpl)dm;
        return deviceModel.getDeviceModelFormats().get(alertUrn);
    }

    private static Logger getLogger() {
        return LOGGER;
    }
}

