/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.device;

import com.oracle.iot.client.SecureConnection;
import com.oracle.iot.client.StorageObject;
import com.oracle.iot.client.device.GatewayDevice;
import com.oracle.iot.client.impl.DeviceModelFactory;
import com.oracle.iot.client.impl.StorageConnectionBase;
import com.oracle.iot.client.impl.device.ActivationManager;
import com.oracle.iot.client.impl.device.ActivationPolicyResponse;
import com.oracle.iot.client.impl.device.DevicePolicyManager;
import com.oracle.iot.client.impl.device.DirectActivationRequest;
import com.oracle.iot.client.impl.device.DirectActivationResponse;
import com.oracle.iot.client.impl.device.MessagingPolicyImpl;
import com.oracle.iot.client.impl.device.PersistenceStore;
import com.oracle.iot.client.impl.device.PersistenceStoreManager;
import com.oracle.iot.client.impl.device.SendReceiveImpl;
import com.oracle.iot.client.impl.device.StorageConnectionImpl;
import com.oracle.iot.client.impl.device.http.HttpSendReceiveImpl;
import com.oracle.iot.client.impl.device.mqtt.MqttSecureConnection;
import com.oracle.iot.client.impl.device.mqtt.MqttSendReceiveImpl;
import com.oracle.iot.client.impl.http.HttpSecureConnection;
import com.oracle.iot.client.message.AlertMessage;
import com.oracle.iot.client.message.DataItem;
import com.oracle.iot.client.message.DataMessage;
import com.oracle.iot.client.message.Message;
import com.oracle.iot.client.message.RequestMessage;
import com.oracle.iot.client.message.Resource;
import com.oracle.iot.client.message.ResourceMessage;
import com.oracle.iot.client.message.ResponseMessage;
import com.oracle.iot.client.trust.TrustedAssetsManager;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.iot.client.DeviceModel;

public class DirectlyConnectedDevice
implements Closeable {
    private static final int USE_DEFAULT_TIMEOUT_VALUE = -1;
    private SendReceiveImpl sendReceiveImpl;
    final SecureConnection secureConnection;
    private final boolean isMqtt;
    protected final TrustedAssetsManager trustedAssetsManager;
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");

    public DirectlyConnectedDevice() throws GeneralSecurityException {
        this(TrustedAssetsManager.Factory.getTrustedAssetsManager(null));
    }

    public DirectlyConnectedDevice(Object context) throws GeneralSecurityException {
        this(TrustedAssetsManager.Factory.getTrustedAssetsManager(context));
    }

    public DirectlyConnectedDevice(String configFilePath, String configFilePassword) throws GeneralSecurityException {
        this(configFilePath, configFilePassword, null);
    }

    public DirectlyConnectedDevice(String configFilePath, String configFilePassword, Object context) throws GeneralSecurityException {
        this(TrustedAssetsManager.Factory.getTrustedAssetsManager(configFilePath, configFilePassword, context));
    }

    DirectlyConnectedDevice(TrustedAssetsManager trustedAssetsManager) throws GeneralSecurityException {
        this.trustedAssetsManager = trustedAssetsManager;
        String scheme = trustedAssetsManager.getServerScheme();
        this.isMqtt = "mqtts".equals(scheme);
        if (!this.isMqtt && !"https".equals(scheme)) {
            throw new GeneralSecurityException("Unsupported server scheme: " + scheme);
        }
        this.secureConnection = this.createSecureConnection();
        if (trustedAssetsManager.isActivated()) {
            this.sendReceiveImpl = this.createSendReceiveImpl();
            PersistenceStore persistenceStore = PersistenceStoreManager.getPersistenceStore(this.getEndpointId());
            persistenceStore.openTransaction().putOpaque(DevicePolicyManager.class.getName(), new DevicePolicyManager(this.secureConnection)).commit();
        }
    }

    public StorageObject createStorageObject(String name, String contentType) throws IOException, GeneralSecurityException {
        StorageConnectionBase storageConnection = StorageConnectionMap.getStorageConnection(this.secureConnection);
        return storageConnection.createStorageObject(this.getEndpointId(), name, contentType);
    }

    public StorageObject createStorageObject(String uri) throws IOException, GeneralSecurityException {
        StorageConnectionBase storageConnection = StorageConnectionMap.getStorageConnection(this.secureConnection);
        return storageConnection.createStorageObject(uri);
    }

    public final void activate(String ... deviceModels) throws IOException, GeneralSecurityException {
        if (this.isActivated()) {
            throw new IllegalStateException("already activated");
        }
        ActivationPolicyResponse activationPolicyResponse = ActivationManager.getActivationPolicy(this.secureConnection, this.trustedAssetsManager.getClientId());
        if (DirectlyConnectedDevice.getLogger().isLoggable(Level.FINEST)) {
            DirectlyConnectedDevice.getLogger().log(Level.FINEST, "activationPolicyResponse: " + String.valueOf(activationPolicyResponse));
        }
        this.trustedAssetsManager.generateKeyPair(activationPolicyResponse.getKeyType(), activationPolicyResponse.getKeySize());
        HashSet<String> deviceModelSet = new HashSet<String>();
        if (deviceModels != null) {
            for (String deviceModel : deviceModels) {
                deviceModelSet.add(deviceModel);
            }
        }
        deviceModelSet.add("urn:oracle:iot:dcd:capability:direct_activation");
        if (this instanceof GatewayDevice) {
            deviceModelSet.add("urn:oracle:iot:dcd:capability:indirect_activation");
        }
        DirectActivationRequest directActivationRequest = ActivationManager.createDirectActivationRequest(this.trustedAssetsManager, activationPolicyResponse.getHashAlgorithm(), deviceModelSet);
        if (DirectlyConnectedDevice.getLogger().isLoggable(Level.FINEST)) {
            DirectlyConnectedDevice.getLogger().log(Level.FINEST, "directActivationRequest: " + directActivationRequest.toString());
        }
        DirectActivationResponse directActivationResponse = ActivationManager.postDirectActivationRequest(this.secureConnection, directActivationRequest);
        if (DirectlyConnectedDevice.getLogger().isLoggable(Level.FINEST)) {
            DirectlyConnectedDevice.getLogger().log(Level.FINEST, "directActivationResponse: Endpoint state is: " + directActivationResponse.getEndpointState());
        }
        String endpointId = directActivationResponse.getEndpointId();
        byte[] certificate = directActivationResponse.getCertificate();
        this.trustedAssetsManager.setEndPointCredentials(endpointId, certificate);
        this.secureConnection.disconnect();
        this.sendReceiveImpl = this.createSendReceiveImpl();
        PersistenceStore persistenceStore = PersistenceStoreManager.getPersistenceStore(this.getEndpointId());
        persistenceStore.openTransaction().putOpaque(DevicePolicyManager.class.getName(), new DevicePolicyManager(this.secureConnection)).commit();
        this.registerDevicePolicyResource();
    }

    public final boolean isActivated() {
        return this.trustedAssetsManager.isActivated();
    }

    public final void send(Message ... messages) throws IOException, GeneralSecurityException {
        if (this.isActivated()) {
            if (DirectlyConnectedDevice.getLogger().isLoggable(Level.FINE)) {
                if (messages.length > 1) {
                    DirectlyConnectedDevice.getLogger().log(Level.FINE, this.getEndpointId() + " : Send  : (" + messages.length + " messages follow)");
                }
                for (int n = 0; n < messages.length; ++n) {
                    String dumpedMessage = DirectlyConnectedDevice.dumpMessage(messages[n]);
                    String counter = messages.length > 1 ? String.format(" : % 5d : ", n + 1) : " : Send  : ";
                    StringBuilder stringBuilder = new StringBuilder(this.getEndpointId()).append(counter).append(dumpedMessage);
                    String logMessage = stringBuilder.toString();
                    DirectlyConnectedDevice.getLogger().log(Level.FINE, logMessage);
                }
            }
        } else {
            throw new IllegalStateException("not activated");
        }
        this.sendReceiveImpl.send(messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void offer(Message ... messages) throws IOException, GeneralSecurityException {
        if (this.isActivated()) {
            MessagingPolicyImpl messagingPolicyImpl;
            PersistenceStore persistenceStore;
            if (messages == null || messages.length == 0) {
                this.send(messages);
            }
            PersistenceStore persistenceStore2 = persistenceStore = PersistenceStoreManager.getPersistenceStore(this.getEndpointId());
            synchronized (persistenceStore2) {
                Object mpiObj = persistenceStore.getOpaque(MessagingPolicyImpl.class.getName(), null);
                if (mpiObj == null) {
                    messagingPolicyImpl = new MessagingPolicyImpl(this);
                    persistenceStore.openTransaction().putOpaque(MessagingPolicyImpl.class.getName(), messagingPolicyImpl).commit();
                    DevicePolicyManager devicePolicyManager = DevicePolicyManager.getDevicePolicyManager(this);
                    devicePolicyManager.addChangeListener(messagingPolicyImpl);
                } else {
                    messagingPolicyImpl = (MessagingPolicyImpl)MessagingPolicyImpl.class.cast(mpiObj);
                }
            }
            ArrayList messagesToPost = new ArrayList();
            for (Message message : messages) {
                Message[] messagesFromPolicies = messagingPolicyImpl.applyPolicies(message);
                if (messagesFromPolicies == null) continue;
                Collections.addAll(messagesToPost, messagesFromPolicies);
            }
            if (messagesToPost.size() > 0) {
                this.send(messagesToPost.toArray(new Message[messagesToPost.size()]));
            }
        } else {
            throw new IllegalStateException("not activated");
        }
    }

    public final RequestMessage receive(long timeout) throws IOException, GeneralSecurityException {
        if (!this.isActivated()) {
            throw new IllegalStateException("not activated");
        }
        long connectionTimeout = timeout == 0L ? -1L : (timeout < 0L ? 0L : timeout);
        long t0 = System.currentTimeMillis();
        RequestMessage requestMessage = this.sendReceiveImpl.receive(connectionTimeout);
        if (requestMessage != null) {
            String path = requestMessage.getURL();
            if ("deviceModels/urn:oracle:iot:dcd:capability:device_policy/policyChanged".equals(path)) {
                try {
                    ResponseMessage responseMessage = DevicePolicyManager.getDevicePolicyManager(this).policyChanged(this, requestMessage);
                    this.send(responseMessage);
                }
                catch (Exception e) {
                    DirectlyConnectedDevice.getLogger().log(Level.WARNING, e.getMessage());
                }
                long remainingTime = connectionTimeout - (System.currentTimeMillis() - t0);
                if (remainingTime > 0L) {
                    return this.receive(remainingTime);
                }
            } else {
                return requestMessage;
            }
        }
        return null;
    }

    public final String getEndpointId() {
        return this.trustedAssetsManager.getEndpointId();
    }

    public final DeviceModel getDeviceModel(String deviceModel) throws IOException, GeneralSecurityException {
        return DeviceModelFactory.getDeviceModel(this.secureConnection, deviceModel);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DirectlyConnectedDevice other = (DirectlyConnectedDevice)obj;
        if (!this.trustedAssetsManager.getServerHost().equals(other.trustedAssetsManager.getServerHost())) {
            return false;
        }
        return this.trustedAssetsManager.getClientId().equals(other.trustedAssetsManager.getClientId());
    }

    public int hashCode() {
        int hash = 37;
        hash = 37 * hash + this.trustedAssetsManager.getServerHost().hashCode();
        hash = 37 * hash + this.trustedAssetsManager.getClientId().hashCode();
        return hash;
    }

    @Override
    public void close() throws IOException {
        this.secureConnection.close();
    }

    private SendReceiveImpl createSendReceiveImpl() {
        if (this.isMqtt) {
            MqttSendReceiveImpl impl = new MqttSendReceiveImpl((MqttSecureConnection)this.secureConnection);
            impl.initialize();
            return impl;
        }
        return new HttpSendReceiveImpl((HttpSecureConnection)this.secureConnection);
    }

    private SecureConnection createSecureConnection() throws GeneralSecurityException {
        try {
            return this.isMqtt ? MqttSecureConnection.createSecureMqttConnection(this.trustedAssetsManager, this instanceof GatewayDevice) : HttpSecureConnection.createHttpSecureConnection(this.trustedAssetsManager, false);
        }
        catch (NoClassDefFoundError e) {
            if (this.isMqtt) {
                throw new GeneralSecurityException("Unable to initialize Mqtt Secure Connection, NoClassDefFoundError: " + e.getMessage() + ".");
            }
            throw new GeneralSecurityException("Unable to initialize Http Secure Connection, NoClassDefFoundError: " + e.getMessage());
        }
    }

    private void registerDevicePolicyResource() throws IOException, GeneralSecurityException {
        if (!this.isActivated()) {
            return;
        }
        Resource resource = new Resource.Builder().endpointName(this.getEndpointId()).method(Resource.Method.PUT).path("deviceModels/urn:oracle:iot:dcd:capability:device_policy/policyChanged").name("urn:oracle:iot:dcd:capability:device_policy").build();
        ResourceMessage resourceMessage = ((ResourceMessage.Builder)new ResourceMessage.Builder().endpointName(this.getEndpointId()).source(this.getEndpointId())).register(resource).build();
        this.sendReceiveImpl.send(resourceMessage);
    }

    private static Logger getLogger() {
        return LOGGER;
    }

    private static String dumpMessage(Message message) {
        List<DataItem<?>> dataItems = message instanceof DataMessage ? ((DataMessage)message).getDataItems() : (message instanceof AlertMessage ? ((AlertMessage)message).getDataItems() : Collections.EMPTY_LIST);
        StringBuilder stringBuilder = new StringBuilder();
        boolean first = true;
        block4: for (DataItem<?> dataItem : dataItems) {
            String val;
            if (!first) {
                stringBuilder.append(',');
            } else {
                first = false;
            }
            stringBuilder.append('\"').append(dataItem.getKey()).append("\"=");
            switch (dataItem.getType()) {
                default: {
                    val = (String)dataItem.getValue();
                    stringBuilder.append('\"').append(val).append('\"');
                    continue block4;
                }
                case DOUBLE: {
                    val = Double.toString(((Number)dataItem.getValue()).doubleValue());
                    stringBuilder.append(val);
                    continue block4;
                }
                case BOOLEAN: 
            }
            val = ((Boolean)dataItem.getValue()).toString();
            stringBuilder.append(val);
        }
        if (!dataItems.isEmpty()) {
            stringBuilder.append(' ');
        }
        stringBuilder.append('(').append(message.getType().alias()).append(')');
        return stringBuilder.toString();
    }

    private static class StorageConnectionMap {
        private static final Map<SecureConnection, WeakReference<StorageConnectionBase>> STORAGE_CONNECTION_MAP = new WeakHashMap<SecureConnection, WeakReference<StorageConnectionBase>>();

        private StorageConnectionMap() {
        }

        private static StorageConnectionBase getStorageConnection(SecureConnection secureConnection) {
            WeakReference<StorageConnectionBase> reference = STORAGE_CONNECTION_MAP.get(secureConnection);
            StorageConnectionBase storageConnection = null;
            if (reference != null) {
                storageConnection = (StorageConnectionBase)reference.get();
            }
            if (storageConnection == null) {
                storageConnection = new StorageConnectionImpl(secureConnection);
                STORAGE_CONNECTION_MAP.put(secureConnection, new WeakReference<StorageConnectionBase>(storageConnection));
            }
            return storageConnection;
        }
    }
}

