/*
 * Decompiled with CFR 0.152.
 */
package oracle.iot.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import oracle.iot.client.AbstractVirtualDevice;
import oracle.iot.client.ExternalObject;

public abstract class StorageObject
extends ExternalObject {
    private final com.oracle.iot.client.StorageObject delegate;
    private volatile SyncStatus syncStatus;
    private volatile SyncCallback syncCallback;
    private String inputPath;
    private String outputPath;

    public String getName() {
        return this.delegate.getName();
    }

    public String getType() {
        return this.delegate.getType();
    }

    public String getEncoding() {
        return this.delegate.getEncoding();
    }

    public long getLength() {
        return this.delegate.getLength();
    }

    public String getDate() {
        return this.delegate.getDate();
    }

    public SyncStatus getSyncStatus() {
        return this.syncStatus;
    }

    public String getInputPath() {
        return this.inputPath;
    }

    public void setInputPath(String inputPath) throws FileNotFoundException {
        if (this.syncStatus == SyncStatus.SYNC_PENDING) {
            throw new IllegalStateException("sync pending");
        }
        if (this.inputPath == null || !this.inputPath.equals(inputPath)) {
            this.inputPath = inputPath;
            if (this.inputPath != null) {
                this.outputPath = null;
                this.syncStatus = SyncStatus.NOT_IN_SYNC;
                this.delegate.setInputStream(new FileInputStream(inputPath));
            }
        }
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) throws FileNotFoundException {
        if (this.syncStatus == SyncStatus.SYNC_PENDING) {
            throw new IllegalStateException("sync pending");
        }
        if (this.outputPath == null || !this.outputPath.equals(outputPath)) {
            this.outputPath = outputPath;
            if (this.outputPath != null) {
                File parent;
                this.inputPath = null;
                this.syncStatus = SyncStatus.NOT_IN_SYNC;
                File file = new File(outputPath);
                if (file.getParent() != null && !(parent = file.getParentFile()).exists()) {
                    parent.mkdirs();
                }
                this.delegate.setOutputStream(new FileOutputStream(outputPath));
            }
        }
    }

    public abstract void sync();

    public <V extends AbstractVirtualDevice> void setOnSync(SyncCallback<V> callback) {
        this.syncCallback = callback;
    }

    public String toString() {
        return super.getURI();
    }

    protected StorageObject(com.oracle.iot.client.StorageObject delegate) {
        super(delegate.getURI());
        this.delegate = delegate;
        this.syncStatus = SyncStatus.NOT_IN_SYNC;
    }

    protected final void setSyncStatus(SyncStatus syncStatus) {
        this.syncStatus = syncStatus;
    }

    protected final SyncCallback getSyncCallback() {
        return this.syncCallback;
    }

    public static interface SyncCallback<V extends AbstractVirtualDevice> {
        public void onSync(SyncEvent<V> var1);
    }

    public static interface SyncEvent<V extends AbstractVirtualDevice> {
        public V getVirtualDevice();

        public String getName();

        public StorageObject getSource();
    }

    public static enum SyncStatus {
        IN_SYNC,
        SYNC_FAILED,
        NOT_IN_SYNC,
        SYNC_PENDING;

    }
}

