/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.message;

import com.oracle.iot.client.message.DataItem;
import com.oracle.iot.client.message.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.json.JSONObject;

public final class DataMessage
extends Message {
    private final String format;
    private final List<DataItem<?>> items;

    private DataMessage(Builder builder) {
        super(builder);
        if (builder.format == null || builder.format.length() == 0) {
            throw new IllegalArgumentException("Format cannot be null or empty.");
        }
        this.format = builder.format;
        if (builder.items == null || builder.items.isEmpty()) {
            throw new IllegalArgumentException("Data items cannot be null or empty.");
        }
        this.items = Collections.unmodifiableList(new ArrayList(builder.items));
    }

    public final String getFormat() {
        return this.format;
    }

    public final List<DataItem<?>> getDataItems() {
        return Collections.unmodifiableList(this.items);
    }

    @Override
    public Message.Type getType() {
        return Message.Type.DATA;
    }

    @Override
    public final String toString() {
        return this.toJson().toString();
    }

    @Override
    public JSONObject toJson() {
        return Message.Utils.dataToJson(this, this.items, this.format, null, null);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DataMessage that = (DataMessage)o;
        if (!this.format.equals(that.format)) {
            return false;
        }
        return this.items.containsAll(that.items) && that.items.containsAll(this.items);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.format.hashCode();
        result = 31 * result + this.items.hashCode();
        return result;
    }

    public static final class Builder
    extends Message.MessageBuilder<Builder> {
        private String format;
        private final List<DataItem<?>> items = new ArrayList();

        @Override
        public Builder fromJson(JSONObject jsonObject) {
            JSONObject payload = jsonObject.optJSONObject("payload");
            Builder builder = (Builder)super.fromJson(jsonObject);
            if (payload != null) {
                builder.format = payload.optString("format", null);
                Message.Utils.dataFromJson(jsonObject, builder.items);
            }
            return builder;
        }

        public final Builder format(String format) {
            this.format = format;
            return this.self();
        }

        public final <T> Builder dataItem(String key, double value) {
            this.items.add(new DataItem(key, value));
            return this.self();
        }

        public final <T> Builder dataItem(String key, boolean value) {
            this.items.add(new DataItem(key, value));
            return this.self();
        }

        public final <T> Builder dataItem(String key, String value) {
            this.items.add(new DataItem(key, value));
            return this.self();
        }

        public final <T> Builder dataItems(Collection<DataItem<?>> dataItems) {
            this.items.addAll(dataItems);
            return this.self();
        }

        @Override
        public final DataMessage build() {
            return new DataMessage(this);
        }

        @Override
        protected final Builder self() {
            return this;
        }
    }
}

