/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.trust;

import com.oracle.iot.client.impl.trust.DefaultTrustedAssetsManager;
import com.oracle.iot.client.impl.trust.UnifiedTrustedAssetsManager;
import com.oracle.iot.client.trust.TrustedAssetsManager;
import java.security.GeneralSecurityException;

public class TrustedAssetsManagerFactory {
    static final String DEFAULT_TA_STORE = "trustedAssetsStore.jks";

    public static TrustedAssetsManager create(Object context) throws GeneralSecurityException {
        String path = System.getProperty("oracle.iot.client.trustedAssetsStore", DEFAULT_TA_STORE);
        String password = System.getProperty("oracle.iot.client.trustedAssetsStorePassword");
        return TrustedAssetsManagerFactory.create(path, password, null);
    }

    public static TrustedAssetsManager create(String path, String password, Object context) throws GeneralSecurityException {
        if (path.endsWith("jceks") || path.endsWith(".jks")) {
            return new DefaultTrustedAssetsManager(path, password, null);
        }
        return new UnifiedTrustedAssetsManager(path, password, null);
    }
}

