/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.trust;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Random;

class SelfSignedX509CertificateFactory {
    private static final byte[] PKCS1_OID = new byte[]{42, -122, 72, -122, -9, 13, 1, 1};
    private static final byte[] COMMON_NAME_OID = new byte[]{85, 4, 3};
    private static final byte MD5_RSA = 4;
    private static final byte SHA1_RSA = 5;
    private static final byte SHA256_RSA = 11;
    private static final byte SHA384_RSA = 12;
    private static final byte SHA512_RSA = 13;
    private static final byte SHA224_RSA = 14;
    private static Random random;

    private SelfSignedX509CertificateFactory() {
    }

    static X509Certificate generateSelfSignedCertificate(RSAPrivateKey privateKey, RSAPublicKey publicKey, String algorithm, String subject, Date notBeforeTime, Date notAfterTime) throws GeneralSecurityException {
        try {
            byte[] encoded = SelfSignedX509CertificateFactory.generateCertificate(privateKey, publicKey, algorithm, subject, notBeforeTime, notAfterTime);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            return (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(encoded));
        }
        catch (IOException ioe) {
            throw new GeneralSecurityException(ioe);
        }
    }

    private static byte[] generateCertificate(RSAPrivateKey privateKey, RSAPublicKey publicKey, String algorithm, String subject, Date notBeforeTime, Date notAfterTime) throws IOException, GeneralSecurityException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ByteArrayOutputStream substream = new ByteArrayOutputStream();
        byte[] tbsCertificate = SelfSignedX509CertificateFactory.generateTBSCertificate(publicKey, algorithm, subject, notBeforeTime, notAfterTime);
        substream.write(tbsCertificate);
        byte[] signatureAlgorithm = SelfSignedX509CertificateFactory.generateSignatureAlgorithm(algorithm);
        substream.write(signatureAlgorithm);
        byte[] signatureValue = SelfSignedX509CertificateFactory.generateSignatureValue(tbsCertificate, algorithm, privateKey);
        substream.write(signatureValue);
        DERUtil.writeDERAndReset(stream, (byte)48, substream);
        return stream.toByteArray();
    }

    private static byte[] generateTBSCertificate(RSAPublicKey publicKey, String algorithm, String subject, Date notBeforeTime, Date notAfterTime) throws IOException, NoSuchAlgorithmException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ByteArrayOutputStream substream = new ByteArrayOutputStream();
        int version = 2;
        DERUtil.writeDERInteger(substream, version);
        DERUtil.writeDERAndReset(stream, (byte)-96, substream);
        if (random == null) {
            random = new Random(publicKey.hashCode());
        }
        int serialNumber = random.nextInt();
        DERUtil.writeDERInteger(stream, serialNumber);
        byte[] signatureAlgorithm = SelfSignedX509CertificateFactory.generateSignatureAlgorithm(algorithm);
        stream.write(signatureAlgorithm);
        byte[] name = subject.getBytes("UTF-8");
        DERUtil.writeDER(substream, (byte)6, SelfSignedX509CertificateFactory.COMMON_NAME_OID);
        DERUtil.writeDER(substream, (byte)19, name);
        DERUtil.writeDERAndReset(substream, (byte)48, substream);
        DERUtil.writeDERAndReset(substream, (byte)49, substream);
        DERUtil.writeDERAndReset(stream, (byte)48, substream);
        byte[] validity = SelfSignedX509CertificateFactory.generateValidity(notBeforeTime, notAfterTime);
        stream.write(validity);
        DERUtil.writeDER(substream, (byte)6, SelfSignedX509CertificateFactory.COMMON_NAME_OID);
        DERUtil.writeDER(substream, (byte)19, name);
        DERUtil.writeDERAndReset(substream, (byte)48, substream);
        DERUtil.writeDERAndReset(substream, (byte)49, substream);
        DERUtil.writeDERAndReset(stream, (byte)48, substream);
        byte[] subjectPublicKeyInfo = publicKey.getEncoded();
        stream.write(subjectPublicKeyInfo);
        DERUtil.writeDERAndReset(stream, (byte)48, stream);
        return stream.toByteArray();
    }

    private static byte[] generateSignatureAlgorithm(String algorithm) throws IOException, NoSuchAlgorithmException {
        int signatureAlgorithm;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ByteArrayOutputStream substream = new ByteArrayOutputStream();
        if (algorithm.equalsIgnoreCase("MD5withRSA")) {
            signatureAlgorithm = 4;
        } else if (algorithm.equalsIgnoreCase("SHA1withRSA")) {
            signatureAlgorithm = 5;
        } else if (algorithm.equalsIgnoreCase("SHA256withRSA")) {
            signatureAlgorithm = 11;
        } else if (algorithm.equalsIgnoreCase("SHA384withRSA")) {
            signatureAlgorithm = 12;
        } else if (algorithm.equalsIgnoreCase("SHA512withRSA")) {
            signatureAlgorithm = 13;
        } else if (algorithm.equalsIgnoreCase("SHA512withRSA")) {
            signatureAlgorithm = 14;
        } else {
            throw new NoSuchAlgorithmException();
        }
        DERUtil.writeDER(substream, (byte)6, SelfSignedX509CertificateFactory.PKCS1_OID, new byte[]{(byte)(0xFF & signatureAlgorithm)}, null);
        DERUtil.writeDER(substream, (byte)5, null);
        DERUtil.writeDERAndReset(stream, (byte)48, substream);
        return stream.toByteArray();
    }

    private static byte[] generateSignatureValue(byte[] tbsCertificate, String algorithm, RSAPrivateKey privateKey) throws IOException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Signature sig = Signature.getInstance(algorithm);
        sig.initSign(privateKey);
        sig.update(tbsCertificate);
        byte[] signature = sig.sign();
        DERUtil.writeDERBitString(stream, signature, 0);
        return stream.toByteArray();
    }

    private static byte[] generateValidity(Date notBeforeTime, Date notAfterTime) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ByteArrayOutputStream substream = new ByteArrayOutputStream();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMddHHmmssZ", Locale.ROOT);
        byte[] nbTime = dateFormat.format(notBeforeTime).getBytes("UTF-8");
        byte[] naTime = dateFormat.format(notAfterTime).getBytes("UTF-8");
        DERUtil.writeDER(substream, (byte)23, nbTime);
        DERUtil.writeDER(substream, (byte)23, naTime);
        DERUtil.writeDERAndReset(stream, (byte)48, substream);
        return stream.toByteArray();
    }

    private static class DERUtil {
        private static final byte INTEGER_TYPE = 2;
        private static final byte BITSTRING_TYPE = 3;
        private static final byte NULL = 5;
        private static final byte OID_TYPE = 6;
        private static final byte PRINTSTR_TYPE = 19;
        private static final byte UTC_TIME_TYPE = 23;
        private static final byte SEQUENCE_TYPE = 48;
        private static final byte SET_TYPE = 49;
        private static final byte EXPLICIT_TAG_TYPE = -96;

        private DERUtil() {
        }

        private static void writeDERBitString(OutputStream stream, byte[] content, int unusedBits) throws IOException {
            stream.write(3);
            int length = (content != null ? content.length : 0) + 1;
            DERUtil.writeLengthSize(stream, length);
            stream.write(unusedBits);
            if (content != null) {
                stream.write(content);
            }
        }

        private static void writeDER(OutputStream stream, byte type, byte[] content) throws IOException {
            stream.write(type);
            int length = content != null ? content.length : 0;
            DERUtil.writeLengthSize(stream, length);
            if (content != null) {
                stream.write(content);
            }
        }

        private static void writeDERAndReset(OutputStream stream, byte type, ByteArrayOutputStream content) throws IOException {
            byte[] data = content.toByteArray();
            content.reset();
            DERUtil.writeDER(stream, type, data);
        }

        private static void writeDER(OutputStream stream, byte type, byte[] content1, byte[] content2, byte[] content3) throws IOException {
            int length = (content1 != null ? content1.length : 0) + (content2 != null ? content2.length : 0) + (content3 != null ? content3.length : 0);
            stream.write(type);
            DERUtil.writeLengthSize(stream, length);
            if (content1 != null) {
                stream.write(content1);
            }
            if (content2 != null) {
                stream.write(content2);
            }
            if (content3 != null) {
                stream.write(content3);
            }
        }

        private static void writeDERInteger(OutputStream stream, int i) throws IOException {
            stream.write(2);
            int size = DERUtil.sizeOf(i);
            stream.write((byte)size);
            if (size == 4) {
                stream.write((byte)(i >> 24));
            }
            if (size >= 3) {
                stream.write((byte)(i >> 16));
            }
            if (size >= 2) {
                stream.write((byte)(i >> 8));
            }
            if (size >= 1) {
                stream.write((byte)i);
            }
        }

        private static void writeLengthSize(OutputStream stream, int length) throws IOException {
            if (length < 128) {
                stream.write((byte)length);
            } else {
                int size = DERUtil.sizeOf(length);
                stream.write((byte)(0x80 | size));
                if (size == 4) {
                    stream.write((byte)(length >> 24));
                }
                if (size >= 3) {
                    stream.write((byte)(length >> 16));
                }
                if (size >= 2) {
                    stream.write((byte)(length >> 8));
                }
                if (size >= 1) {
                    stream.write((byte)length);
                }
            }
        }

        private static int sizeOf(int length) {
            if ((byte)(length >> 24) != 0) {
                return 4;
            }
            if ((byte)(length >> 16) != 0) {
                return 3;
            }
            if ((byte)(length >> 8) != 0) {
                return 2;
            }
            return 1;
        }
    }
}

