/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.trust;

import com.oracle.iot.client.trust.TrustException;
import com.oracle.iot.client.trust.TrustedAssetsManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public abstract class TrustedAssetsManagerBase
implements TrustedAssetsManager {
    public static final String TA_STORE_PROPERTY = "oracle.iot.client.trustedAssetsStore";
    public static final String TA_STORE_PASSWORD_PROPERTY = "oracle.iot.client.trustedAssetsStorePassword";
    protected String clientId;
    protected SecretKey sharedSecret;
    protected String serverScheme;
    protected String serverHost;
    protected int serverPort = -1;
    protected String endpointId;
    protected PrivateKey privateKey;
    protected PublicKey publicKey;
    protected Set<X509Certificate> trustAnchors = null;
    protected Map<String, SecretKey> icdMap;

    protected TrustedAssetsManagerBase() {
    }

    @Override
    public String getServerScheme() {
        return this.serverScheme;
    }

    @Override
    public String getServerHost() {
        return this.serverHost;
    }

    @Override
    public int getServerPort() {
        return this.serverPort;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public PublicKey getPublicKey() {
        if (this.privateKey == null) {
            throw new IllegalStateException("Key pair not yet generated.");
        }
        return this.publicKey;
    }

    @Override
    public Vector<byte[]> getTrustAnchorCertificates() {
        Vector<byte[]> anchors = new Vector<byte[]>();
        if (this.trustAnchors != null) {
            for (X509Certificate anchor : this.trustAnchors) {
                try {
                    anchors.addElement(anchor.getEncoded());
                }
                catch (CertificateEncodingException e) {}
            }
        }
        return anchors;
    }

    @Override
    public void setEndPointCredentials(String endpointId, byte[] certificate) throws TrustException {
        if (this.privateKey == null) {
            throw new IllegalStateException("Key pair not yet generated.");
        }
        this.endpointId = endpointId;
        try {
            this.store();
        }
        catch (Exception e) {
            throw new TrustException("Error storing the trusted assets...", e);
        }
    }

    @Override
    public String getEndpointId() {
        if (this.endpointId == null) {
            throw new IllegalStateException("EndpointId not assigned.");
        }
        return this.endpointId;
    }

    @Override
    public byte[] getEndpointCertificate() {
        if (!this.isActivated()) {
            throw new IllegalStateException("Endpoint not activated.");
        }
        return new byte[0];
    }

    @Override
    public void generateKeyPair(String algorithm, int keySize) throws TrustException {
        KeyPairGenerator keyPairGenerator;
        if (this.endpointId != null) {
            throw new IllegalStateException("Already activated: EndpointId already assigned.");
        }
        if (algorithm == null) {
            throw new NullPointerException("Algorithm cannot be null.");
        }
        if (keySize <= 0) {
            throw new IllegalArgumentException("Key size cannot be negative or 0.");
        }
        try {
            try {
                keyPairGenerator = KeyPairGenerator.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new TrustException("Can't find public key algorithm " + algorithm, nsae);
            }
        }
        catch (GeneralSecurityException e) {
            throw new TrustException(e.getMessage(), e);
        }
        keyPairGenerator.initialize(keySize);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        this.privateKey = keyPair.getPrivate();
        this.publicKey = keyPair.getPublic();
    }

    @Override
    public byte[] signWithPrivateKey(byte[] data, String algorithm) throws TrustException {
        byte[] sig;
        if (this.privateKey == null) {
            throw new IllegalStateException("key not yet generated.");
        }
        if (algorithm == null) {
            throw new NullPointerException("Algorithm cannot be null.");
        }
        if (data == null) {
            throw new NullPointerException("Data cannot be null.");
        }
        try {
            Signature signature;
            try {
                signature = Signature.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new TrustException("Can't find signing algorithm " + algorithm, nsae);
            }
            signature.initSign(this.privateKey);
            signature.update(data);
            sig = signature.sign();
        }
        catch (GeneralSecurityException e) {
            throw new TrustException("Error signing with key...", e);
        }
        return sig;
    }

    @Override
    @Deprecated
    public final byte[] getEncryptedSharedSecret() throws TrustException {
        throw new TrustException("Unsupported operation...");
    }

    @Override
    public byte[] signWithSharedSecret(byte[] data, String algorithm, String hardwareId) throws TrustException {
        byte[] digest;
        if (algorithm == null) {
            throw new NullPointerException("Algorithm cannot be null.");
        }
        if (data == null) {
            throw new NullPointerException("Data cannot be null.");
        }
        SecretKey secretKey = null;
        if (hardwareId == null || hardwareId.equals(this.getClientId())) {
            secretKey = this.sharedSecret;
        } else if (this.icdMap != null) {
            secretKey = this.icdMap.get(hardwareId);
        }
        if (secretKey == null) {
            throw new TrustException("Shared secret not provisioned.");
        }
        try {
            Mac mac;
            try {
                mac = Mac.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new TrustException("Can't find signing algorithm " + algorithm, nsae);
            }
            mac.init(secretKey);
            mac.update(data);
            digest = mac.doFinal();
        }
        catch (GeneralSecurityException e) {
            throw new TrustException("Error signing with shared secret...", e);
        }
        return digest;
    }

    @Override
    public boolean isActivated() {
        return this.endpointId != null;
    }

    @Override
    public void reset() throws TrustException {
        this.endpointId = null;
        this.privateKey = null;
        this.publicKey = null;
        try {
            this.store();
        }
        catch (Exception e) {
            throw new TrustException("Error resetting the trusted assets...", e);
        }
    }

    @Override
    public void close() throws IOException {
    }

    protected void addSharedSecret(String activationId, byte[] sharedSecret) {
        if (this.icdMap == null) {
            this.icdMap = new HashMap<String, SecretKey>();
        }
        SecretKeySpec secretKey = new SecretKeySpec(sharedSecret, "Hmac");
        this.icdMap.put(activationId, secretKey);
    }

    protected abstract void store() throws Exception;

    protected void setServer(String uriString) throws Exception {
        URI uri = new URI(uriString);
        this.serverScheme = uri.getScheme();
        if (!"https".equals(this.serverScheme)) {
            System.setProperty("com.oracle.iot.client.disable_long_polling", "true");
        } else {
            String value = System.getProperty("com.oracle.iot.client.disable_long_polling");
            if ("".equals(value)) {
                System.setProperty("com.oracle.iot.client.disable_long_polling", "true");
            }
        }
        this.serverHost = uri.getHost();
        this.serverPort = uri.getPort();
    }

    protected void setSharedSecret(byte[] sharedSecretString) {
        if (sharedSecretString == null) {
            return;
        }
        this.sharedSecret = new SecretKeySpec(sharedSecretString, "Hmac");
    }

    protected void addTrustAnchor(byte[] encodedCert) throws Exception {
        if (this.trustAnchors == null) {
            this.trustAnchors = new HashSet<X509Certificate>();
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(encodedCert);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        this.trustAnchors.add((X509Certificate)cf.generateCertificate(bis));
    }

    protected void setPrivateKey(byte[] encodedKey) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec ks = new PKCS8EncodedKeySpec(encodedKey);
        this.privateKey = keyFactory.generatePrivate(ks);
    }

    protected void setPublicKey(byte[] encodedKey) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec ks = new X509EncodedKeySpec(encodedKey);
        this.publicKey = keyFactory.generatePublic(ks);
    }
}

