/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.http;

import com.oracle.iot.client.HttpResponse;
import com.oracle.iot.client.RestApi;
import com.oracle.iot.client.impl.AccessToken;
import com.oracle.iot.client.impl.TimeManager;
import com.oracle.iot.client.impl.http.HttpClient;
import com.oracle.iot.client.impl.http.HttpClientImpl;
import com.oracle.iot.client.impl.http.HttpCredentials;
import com.oracle.iot.client.impl.http.HttpSecureConnection;
import com.oracle.iot.client.trust.TrustedAssetsManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpSecureConnectionImpl
extends HttpSecureConnection {
    private static final int USE_DEFAULT_TIMEOUT_VALUE = -1;
    private static final boolean checkTLSRevocation = Boolean.getBoolean("com.sun.net.ssl.checkRevocation");
    private static final Map<String, SSLSocketFactory> socketFactoryMap = Collections.synchronizedMap(new HashMap());
    private final SSLSocketFactory sslSocketFactory;
    private final String hostUrl;
    private static final String ACTIVATION_API = RestApi.V2.getReqRoot() + "/activation";
    private volatile AccessToken accessToken;
    private final Object LOCK = new int[0];
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");

    protected final SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    public HttpSecureConnectionImpl(TrustedAssetsManager tam, boolean sharedSecretCredential) throws GeneralSecurityException {
        super(tam, sharedSecretCredential);
        this.hostUrl = tam.getServerScheme() + "://" + tam.getServerHost();
        SSLSocketFactory socketFactory = socketFactoryMap.get(this.hostUrl);
        if (socketFactory == null) {
            socketFactory = HttpSecureConnectionImpl.getDefaultSSLSocketFactory(tam);
            socketFactoryMap.put(this.hostUrl, socketFactory);
        }
        this.sslSocketFactory = socketFactory;
    }

    @Override
    public HttpResponse get(String restApi) throws IOException, GeneralSecurityException {
        return this.invoke("GET", restApi, null);
    }

    @Override
    public HttpResponse post(String restApi, byte[] payload) throws IOException, GeneralSecurityException {
        return this.invoke("POST", restApi, payload);
    }

    @Override
    public HttpResponse post(String restApi, byte[] payload, int timeout) throws IOException, GeneralSecurityException {
        return this.invoke("POST", restApi, payload, timeout);
    }

    @Override
    public HttpResponse put(String restApi, byte[] payload) throws IOException, GeneralSecurityException {
        return this.invoke("PUT", restApi, payload);
    }

    @Override
    public HttpResponse delete(String restApi) throws IOException, GeneralSecurityException {
        return this.invoke("DELETE", restApi, null);
    }

    @Override
    public HttpResponse patch(String restApi, byte[] payload) throws IOException, GeneralSecurityException {
        return this.invoke("PATCH", restApi, payload);
    }

    private static boolean isActivationApi(String restApi) {
        return ACTIVATION_API.regionMatches(0, restApi, 0, ACTIVATION_API.length());
    }

    private HttpResponse invoke(String method, String restApi, byte[] payload) throws IOException, GeneralSecurityException {
        return this.invoke(method, restApi, payload, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse invoke(String method, String restApi, byte[] payload, int timeout) throws IOException, GeneralSecurityException {
        URL url;
        HttpResponse response;
        block25: {
            if (this.isClosed()) {
                throw new IOException("Connection is closed");
            }
            response = null;
            try {
                String serverHost = this.getTrustedAssetsManager().getServerHost();
                int serverPort = this.getTrustedAssetsManager().getServerPort();
                HashMap<String, String> headers = new HashMap<String, String>(4);
                boolean useWebAPI = RestApi.V2.isWebApi();
                url = new URL("https", serverHost, serverPort, restApi);
                if (!useWebAPI) {
                    AccessToken currentAccessToken = this.accessToken;
                    if (currentAccessToken == null || currentAccessToken.hasExpired()) {
                        Object object = this.LOCK;
                        synchronized (object) {
                            currentAccessToken = this.accessToken;
                            if (currentAccessToken == null || currentAccessToken.hasExpired()) {
                                this.accessToken = currentAccessToken = HttpSecureConnectionImpl.renewAccessToken(this);
                            }
                        }
                    }
                    headers.put("Authorization", currentAccessToken.getTokenType() + " " + currentAccessToken.getToken());
                }
                headers.put("Content-Type", "application/json");
                headers.put("Accept", "application/json");
                if (HttpSecureConnectionImpl.isActivationApi(restApi)) {
                    if (this.getTrustedAssetsManager().isActivated()) {
                        headers.put("X-EndpointId", this.getTrustedAssetsManager().getEndpointId());
                    } else {
                        headers.put("X-ActivationId", this.getTrustedAssetsManager().getClientId());
                    }
                } else if (!RestApi.V2.isWebApi()) {
                    if (this.getTrustedAssetsManager().isActivated()) {
                        String eid = this.getTrustedAssetsManager().getEndpointId();
                        headers.put("X-EndpointId", eid);
                    } else {
                        headers.put("X-ActivationId", this.getTrustedAssetsManager().getClientId());
                    }
                }
                HttpClientImpl httpClient = new HttpClientImpl(this.sslSocketFactory, url);
                response = this.invoke(httpClient, method, payload, headers, timeout);
                if (HttpSecureConnectionImpl.getLogger().isLoggable(Level.FINEST)) {
                    HttpSecureConnectionImpl.getLogger().log(Level.FINEST, response.getVerboseStatus(method, url.toExternalForm()));
                }
                if (response.getStatus() != 401 && response.getStatus() != 403) break block25;
                AccessToken newAccessToken = null;
                Object object = this.LOCK;
                synchronized (object) {
                    this.accessToken = newAccessToken = HttpSecureConnectionImpl.renewAccessToken(this);
                }
                headers.put("Authorization", newAccessToken.getTokenType() + " " + newAccessToken.getToken());
                response = this.invoke(httpClient, method, payload, headers, timeout);
            }
            catch (UnknownHostException uhe) {
                HttpSecureConnectionImpl.getLogger().log(Level.SEVERE, "Unknown host: " + this.getTrustedAssetsManager().getServerHost());
                throw uhe;
            }
            catch (ConnectException ce) {
                HttpSecureConnectionImpl.getLogger().log(Level.SEVERE, "Cannot connect: " + this.getTrustedAssetsManager().getServerHost() + ":" + this.getTrustedAssetsManager().getServerPort());
                throw ce;
            }
            catch (SocketTimeoutException ce) {
                if (timeout < 0) {
                    HttpSecureConnectionImpl.getLogger().log(Level.SEVERE, "Connection timed out: " + this.getTrustedAssetsManager().getServerScheme() + "://" + this.getTrustedAssetsManager().getServerHost() + ":" + this.getTrustedAssetsManager().getServerPort());
                }
                throw ce;
            }
            catch (IOException ie) {
                HttpSecureConnectionImpl.getLogger().log(Level.SEVERE, ie.getMessage(), ie);
                throw ie;
            }
        }
        if (response.getStatus() == 400) {
            String errmsg = response.getVerboseStatus(method, url.toExternalForm());
            HttpSecureConnectionImpl.getLogger().log(Level.SEVERE, errmsg);
        }
        return response;
    }

    protected HttpResponse invoke(HttpClient httpClient, String method, byte[] payload, Map<String, String> headers, int timeout) throws IOException, GeneralSecurityException {
        if (method.equals("GET")) {
            return httpClient.get(headers);
        }
        if (method.equals("POST")) {
            return httpClient.post(payload, headers, timeout);
        }
        if (method.equals("DELETE")) {
            return httpClient.delete(headers);
        }
        if (method.equals("PATCH")) {
            headers.put("X-HTTP-Method-Override", "PATCH");
            return httpClient.post(payload, headers, timeout);
        }
        return httpClient.put(payload, headers);
    }

    private static SSLSocketFactory getDefaultSSLSocketFactory(TrustedAssetsManager trustedAssetsManager) throws GeneralSecurityException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        Vector<byte[]> certs = trustedAssetsManager.getTrustAnchorCertificates();
        if (certs == null || certs.isEmpty()) {
            sslContext.init(null, null, null);
            return sslContext.getSocketFactory();
        }
        final HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
        for (int i = 0; i < certs.size(); ++i) {
            TrustAnchor trustAnchor = new TrustAnchor((X509Certificate)factory.generateCertificate(new ByteArrayInputStream(certs.elementAt(i))), null);
            trustAnchors.add(trustAnchor);
        }
        sslContext.init(null, new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
                throw new CertificateException();
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
                CertificateFactory factory = CertificateFactory.getInstance("X.509");
                CertPath chain = factory.generateCertPath(Arrays.asList(certificates));
                try {
                    PKIXParameters params = new PKIXParameters(trustAnchors);
                    params.setRevocationEnabled(checkTLSRevocation);
                    CertPathValidator validator = CertPathValidator.getInstance("PKIX");
                    validator.validate(chain, params);
                }
                catch (Exception e) {
                    throw new CertificateException(e);
                }
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }}, null);
        return sslContext.getSocketFactory();
    }

    private static HttpResponse postRenewAccessToken(HttpSecureConnectionImpl secureHttpConnection) throws IOException, GeneralSecurityException {
        TrustedAssetsManager trustedAssetsManager = secureHttpConnection.getTrustedAssetsManager();
        String serverHost = trustedAssetsManager.getServerHost();
        int serverPort = trustedAssetsManager.getServerPort();
        URL url = new URL("https", serverHost, serverPort, RestApi.V2.getReqRoot() + "/oauth2/token");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        headers.put("Accept", "application/json");
        if (HttpSecureConnectionImpl.getLogger().isLoggable(Level.FINEST)) {
            HttpSecureConnectionImpl.getLogger().log(Level.FINEST, "POST " + RestApi.V2.getReqRoot() + "/oauth2/token");
        }
        byte[] credentialsPostData = HttpCredentials.getClientAssertionCredentials(trustedAssetsManager, secureHttpConnection.usesOnlySharedSecret());
        HttpClientImpl httpClient = new HttpClientImpl(secureHttpConnection.sslSocketFactory, url);
        return httpClient.post(credentialsPostData, headers);
    }

    private static long parseResponseTime(byte[] responseData) throws IllegalArgumentException {
        String json;
        block5: {
            json = null;
            json = new String(responseData, "UTF-8");
            if (json.indexOf("currentTime") >= 0) break block5;
            long l = System.currentTimeMillis();
            return l;
        }
        try {
            String currentTime = new JSONObject(json).get("currentTime").toString();
            long l = Long.parseLong(currentTime);
            return l;
        }
        catch (Throwable t) {
            HttpSecureConnectionImpl.getLogger().log(Level.SEVERE, t.toString());
            throw new IllegalArgumentException("Failed to parse server time from the response " + json);
        }
    }

    private static AccessToken renewAccessToken(HttpSecureConnectionImpl secureHttpConnection) throws IOException, GeneralSecurityException {
        HttpResponse response = HttpSecureConnectionImpl.postRenewAccessToken(secureHttpConnection);
        int status = response.getStatus();
        if (status == 400) {
            try {
                TimeManager.setCurrentTimeMillis(HttpSecureConnectionImpl.parseResponseTime(response.getData()));
                response = HttpSecureConnectionImpl.postRenewAccessToken(secureHttpConnection);
                status = response.getStatus();
            }
            catch (IllegalArgumentException ex) {
                HttpSecureConnectionImpl.getLogger().log(Level.SEVERE, ex.toString());
            }
        }
        if (status == 400) {
            throw new GeneralSecurityException(response.getVerboseStatus("POST", RestApi.V2.getReqRoot() + "/oauth2/token"));
        }
        if (status != 200) {
            throw new IOException(response.getVerboseStatus("POST", RestApi.V2.getReqRoot() + "/oauth2/token"));
        }
        byte[] data = response.getData();
        if (data == null || data.length == 0) {
            throw new IOException("POST " + RestApi.V2.getReqRoot() + "/oauth2/token: empty payload");
        }
        String json = new String(data, "UTF-8");
        try {
            JSONObject jsonObject = new JSONObject(json);
            return AccessToken.fromJson(jsonObject);
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        Object object = this.LOCK;
        synchronized (object) {
            this.accessToken = null;
        }
    }

    private static Logger getLogger() {
        return LOGGER;
    }
}

