/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.enterprise;

import com.oracle.iot.client.HttpResponse;
import com.oracle.iot.client.enterprise.Response;
import com.oracle.iot.client.impl.http.HttpSecureConnection;
import com.oracle.iot.client.message.StatusCode;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ResponseImpl
implements Response {
    private final String requestId;
    private final String path;
    private final URI uri;
    private final Map<String, String> requestHeaders;
    private byte[] body;
    private Map<String, String> responseHeaders;
    private HttpSecureConnection secureConnection;
    private int statusCode;
    private boolean done;
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");

    public static ResponseImpl from(String path, Map<String, String> reqHeaders, HttpResponse res, HttpSecureConnection secureConnection) throws IOException {
        try {
            byte[] data = res.getData();
            if (data == null) {
                throw new IOException(path + ": No data received");
            }
            String json = new String(data, "UTF-8");
            JSONObject jsonBody = new JSONObject(json);
            String requestId = jsonBody.optString("id", "");
            switch (res.getStatus()) {
                case 200: {
                    HashMap<String, String> respHeaders = new HashMap<String, String>();
                    if (res.getHeaders() != null) {
                        Set<Map.Entry<String, List<String>>> headers = res.getHeaders().entrySet();
                        for (Map.Entry<String, List<String>> header : headers) {
                            respHeaders.put(header.getKey(), header.getValue().toString());
                        }
                    }
                    ResponseImpl resp = new ResponseImpl(requestId, path, null, StatusCode.OK.getCode(), null, secureConnection, reqHeaders, respHeaders, true);
                    resp.updateFrom(res.getData());
                    return resp;
                }
                case 202: {
                    JSONArray links = jsonBody.optJSONArray("links");
                    if (links == null) {
                        throw new IOException(path + ": No links in response");
                    }
                    URI requestURI = null;
                    int size = links.length();
                    for (int i = 0; i < size; ++i) {
                        String rel = links.getJSONObject(i).getString("rel").trim();
                        if (!"requests".equals(rel)) continue;
                        String link = links.getJSONObject(i).getString("href");
                        try {
                            requestURI = new URI(link);
                            break;
                        }
                        catch (URISyntaxException e) {
                            throw new IOException(e);
                        }
                    }
                    if (requestURI == null) {
                        throw new IOException(path + ": Incorrect response: missing request link");
                    }
                    return new ResponseImpl(requestId, path, res.getData(), StatusCode.ACCEPTED.getCode(), requestURI, secureConnection, reqHeaders, null, false);
                }
            }
            throw new IOException(res.getVerboseStatus(null, path));
        }
        catch (JSONException e) {
            throw new IOException(path + ": " + e.getMessage());
        }
    }

    private void updateFrom(byte[] httpResponse) throws IOException {
        String json = new String(httpResponse, "UTF-8");
        try {
            JSONObject jsonObject = new JSONObject(json);
            String reqStatus = jsonObject.optString("status", "");
            if ("COMPLETED".equals(reqStatus)) {
                JSONObject respObject = jsonObject.getJSONObject("response");
                this.statusCode = respObject.getInt("statusCode");
                this.body = respObject.optString("body", "").getBytes("UTF-8");
                this.responseHeaders = new HashMap<String, String>();
                JSONObject jsonHeaders = respObject.optJSONObject("headers");
                if (jsonHeaders != null) {
                    Iterator<String> keys = jsonHeaders.keys();
                    while (keys.hasNext()) {
                        String key = keys.next();
                        Object value = jsonHeaders.opt(key);
                        this.responseHeaders.put(key, value.toString());
                    }
                }
                this.done = true;
                return;
            }
            if ("FAILED".equals(reqStatus)) {
                this.statusCode = StatusCode.BAD_REQUEST.getCode();
                this.done = true;
            }
        }
        catch (UnsupportedOperationException e) {
            throw new IOException(e);
        }
        catch (ClassCastException e) {
            throw new IOException(e);
        }
        catch (NullPointerException e) {
            throw new IOException(e);
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
    }

    private ResponseImpl(String requestId, String path, byte[] body, int status, URI requestURI, HttpSecureConnection secureConnection, Map<String, String> reqHeaders, Map<String, String> respHeaders, boolean done) {
        this.requestId = requestId;
        this.statusCode = status;
        this.path = path;
        this.uri = requestURI;
        this.requestHeaders = reqHeaders;
        this.secureConnection = secureConnection;
        this.body = body;
        this.responseHeaders = respHeaders;
        this.done = done;
    }

    @Override
    public int getStatusCode() throws IllegalStateException {
        if (!this.done) {
            throw new IllegalStateException("Request " + this.requestId + " not done.");
        }
        return this.statusCode;
    }

    @Override
    public String getRequestId() {
        return this.requestId;
    }

    @Override
    public String getPath() {
        if (this.path == null) {
            return this.uri.getPath();
        }
        return this.path;
    }

    @Override
    public byte[] getBody() throws IllegalStateException {
        if (!this.done) {
            throw new IllegalStateException("Request " + this.requestId + " not done.");
        }
        return this.body;
    }

    @Override
    public Map<String, String> getHeaders() throws IllegalStateException {
        if (!this.done) {
            throw new IllegalStateException("Request " + this.requestId + " not done.");
        }
        return this.responseHeaders;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public void poll() throws IOException, GeneralSecurityException {
        if (this.done) {
            return;
        }
        HttpResponse response = this.secureConnection.get(this.uri.getPath());
        int status = response.getStatus();
        if (status != StatusCode.ACCEPTED.getCode() && status != StatusCode.OK.getCode()) {
            ResponseImpl.getLogger().log(Level.INFO, response.getVerboseStatus("GET", this.uri.getPath()));
            this.statusCode = status;
            this.done = true;
            return;
        }
        this.updateFrom(response.getData());
    }

    private static Logger getLogger() {
        return LOGGER;
    }
}

