/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl;

import com.oracle.iot.client.impl.DeviceModelImpl;
import com.oracle.iot.client.impl.VirtualDeviceAttributeBase;
import com.oracle.iot.client.impl.util.Pair;
import java.util.ArrayList;
import java.util.List;
import oracle.iot.client.AbstractVirtualDevice;

public final class VirtualDeviceBase<V extends AbstractVirtualDevice> {
    private volatile boolean updateMode;
    private List<Pair<VirtualDeviceAttributeBase<V, Object>, Object>> updatedAttributes;
    private final Object UPDATE_LOCK = new Object();
    private final Adapter<V> adapter;
    private final String endpointId;
    private final DeviceModelImpl deviceModel;
    private AbstractVirtualDevice.ChangeCallback<V> changeCallback;
    private AbstractVirtualDevice.ErrorCallback<V> errorCallback;

    public VirtualDeviceBase(Adapter<V> adapter, String endpointId, DeviceModelImpl deviceModel) {
        this.adapter = adapter;
        this.endpointId = endpointId;
        this.deviceModel = deviceModel;
    }

    public DeviceModelImpl getDeviceModel() {
        return this.deviceModel;
    }

    public String getEndpointId() {
        return this.endpointId;
    }

    public void set(String attributeName, Object value) {
        VirtualDeviceAttributeBase<V, Object> df = this.adapter.getAttribute(attributeName);
        if (!df.isSettable()) {
            throw new UnsupportedOperationException("attempt to modify read-only attribute '" + attributeName + "'");
        }
        df.validate(df.getDeviceModelAttribute(), value);
        if (!this.isUpdateMode()) {
            this.adapter.setValue(df, value);
        } else {
            this.updateSetField(df, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        Object object = this.UPDATE_LOCK;
        synchronized (object) {
            if (this.updatedAttributes == null) {
                this.updatedAttributes = new ArrayList<Pair<VirtualDeviceAttributeBase<V, Object>, Object>>();
            }
            this.updateMode = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        Object object = this.UPDATE_LOCK;
        synchronized (object) {
            if (this.updatedAttributes != null && !this.updatedAttributes.isEmpty()) {
                ArrayList workingCopy = new ArrayList(this.updatedAttributes.size());
                workingCopy.addAll(this.updatedAttributes);
                this.adapter.updateFields(workingCopy);
                this.updatedAttributes.clear();
            }
            this.updateMode = false;
        }
    }

    public synchronized void setOnChange(AbstractVirtualDevice.ChangeCallback<V> callback) {
        this.changeCallback = callback;
    }

    public synchronized AbstractVirtualDevice.ChangeCallback<V> getOnChangeCallback() {
        return this.changeCallback;
    }

    public synchronized void setOnError(AbstractVirtualDevice.ErrorCallback<V> callback) {
        this.errorCallback = callback;
    }

    public synchronized AbstractVirtualDevice.ErrorCallback<V> getOnErrorCallback() {
        return this.errorCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUpdateMode() {
        Object object = this.UPDATE_LOCK;
        synchronized (object) {
            return this.updateMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSetField(VirtualDeviceAttributeBase<V, Object> attribute, Object value) {
        Object object = this.UPDATE_LOCK;
        synchronized (object) {
            this.updatedAttributes.add(new Pair<VirtualDeviceAttributeBase<V, Object>, Object>(attribute, value));
        }
    }

    public String toString() {
        return "{" + this.endpointId + " , " + this.deviceModel.getURN() + "}";
    }

    public static class ErrorEvent<V extends AbstractVirtualDevice>
    extends AbstractVirtualDevice.ErrorEvent<V> {
        private final V virtualDevice;
        private final AbstractVirtualDevice.NamedValue<?> value;
        private final String message;

        public ErrorEvent(V virtualDevice, AbstractVirtualDevice.NamedValue<?> value, String message) {
            this.virtualDevice = virtualDevice;
            this.value = value;
            this.message = message;
        }

        @Override
        public V getVirtualDevice() {
            return this.virtualDevice;
        }

        @Override
        public AbstractVirtualDevice.NamedValue<?> getNamedValue() {
            return this.value;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    public static class ChangeEvent<V extends AbstractVirtualDevice>
    extends AbstractVirtualDevice.ChangeEvent<V> {
        private final V virtualDevice;
        private final AbstractVirtualDevice.NamedValue<?> value;

        public ChangeEvent(V virtualDevice, AbstractVirtualDevice.NamedValue<?> value) {
            this.virtualDevice = virtualDevice;
            this.value = value;
        }

        @Override
        public V getVirtualDevice() {
            return this.virtualDevice;
        }

        @Override
        public AbstractVirtualDevice.NamedValue<?> getNamedValue() {
            return this.value;
        }
    }

    public static class NamedValueImpl<T>
    extends AbstractVirtualDevice.NamedValue<T> {
        private final String name;
        private final T value;
        private AbstractVirtualDevice.NamedValue<?> next;

        public NamedValueImpl(String name, T value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public AbstractVirtualDevice.NamedValue<?> next() {
            return this.next;
        }

        public void setNext(AbstractVirtualDevice.NamedValue<?> next) {
            this.next = next;
        }
    }

    public static interface Adapter<V extends AbstractVirtualDevice> {
        public void setValue(VirtualDeviceAttributeBase<V, Object> var1, Object var2);

        public VirtualDeviceAttributeBase<V, Object> getAttribute(String var1);

        public void updateFields(List<Pair<VirtualDeviceAttributeBase<V, Object>, Object>> var1);
    }
}

