/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl;

import com.oracle.iot.client.StorageObject;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import oracle.iot.client.AbstractVirtualDevice;
import oracle.iot.client.StorageObject;

public abstract class StorageObjectBase
extends oracle.iot.client.StorageObject {
    private final StorageObject delegate;
    private final List<StorageObject.SyncEvent> syncEvents;
    protected static final Executor dispatcher = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            SecurityManager s = System.getSecurityManager();
            ThreadGroup group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            Thread t = new Thread(group, r, "sync-callback-thread", 0L);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    });

    public StorageObjectBase(StorageObject delegate) {
        super(delegate);
        this.delegate = delegate;
        this.syncEvents = Collections.synchronizedList(new LinkedList());
    }

    @Override
    public void sync() {
        if (this.getSyncStatus() == StorageObject.SyncStatus.NOT_IN_SYNC) {
            if (this.getOutputPath() == null && this.getInputPath() == null) {
                throw new IllegalStateException("input path or output path must be set");
            }
            this.setSyncStatus(StorageObject.SyncStatus.SYNC_PENDING);
            this.addSyncEvent(this.createSyncEvent());
        } else {
            this.addSyncEvent(this.createSyncEvent());
        }
    }

    @Override
    public final <V extends AbstractVirtualDevice> void setOnSync(StorageObject.SyncCallback<V> callback) {
        super.setOnSync(callback);
        this.syncEvents.clear();
    }

    protected final StorageObject getDelegate() {
        return this.delegate;
    }

    protected final List<StorageObject.SyncEvent> getSyncEvents() {
        return this.syncEvents;
    }

    protected final void addSyncEvent(final StorageObject.SyncEvent syncEvent) {
        if (this.getSyncCallback() == null) {
            return;
        }
        switch (this.getSyncStatus()) {
            case SYNC_PENDING: 
            case NOT_IN_SYNC: {
                this.syncEvents.add(syncEvent);
                break;
            }
            case SYNC_FAILED: 
            case IN_SYNC: {
                dispatcher.execute(new Runnable(){

                    @Override
                    public void run() {
                        StorageObject.SyncCallback syncCallback = StorageObjectBase.this.getSyncCallback();
                        if (syncCallback != null) {
                            syncCallback.onSync(syncEvent);
                        }
                    }
                });
            }
        }
    }

    protected abstract void handleStateChange();

    protected abstract StorageObject.SyncEvent createSyncEvent();

    protected static final class SyncEventImpl<V extends AbstractVirtualDevice>
    implements StorageObject.SyncEvent<V> {
        private final oracle.iot.client.StorageObject source;
        private final V virtualDevice;
        private final String name;

        @Override
        public V getVirtualDevice() {
            return this.virtualDevice;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public oracle.iot.client.StorageObject getSource() {
            return this.source;
        }

        public SyncEventImpl(oracle.iot.client.StorageObject source, V virtualDevice, String name) {
            this.source = source;
            this.virtualDevice = virtualDevice;
            this.name = name;
        }
    }
}

