/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.trust;

import com.oracle.iot.client.impl.trust.DefaultTrustedAssetsManager;
import com.oracle.iot.client.trust.TrustException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;

public class TrustedAssetsProvisionerBase {
    private static final String lineSep = System.getProperty("line.separator", "\n");

    protected static void main(String[] args, String storeExtension) {
        try {
            String taStore = TrustedAssetsProvisionerBase.provision(args, storeExtension);
            TrustedAssetsProvisionerBase.display("Created trusted assets store: " + taStore);
            System.exit(0);
        }
        catch (IllegalArgumentException iae) {
            System.err.println(iae.getMessage());
            TrustedAssetsProvisionerBase.showUsage();
        }
        catch (Exception e) {
            System.err.println("Caught '" + e + ": " + e.getMessage() + "' while creating the trusted assets store");
        }
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String provision(String[] args, String storeExtension) throws IllegalArgumentException, GeneralSecurityException, IOException {
        String taStore = null;
        String taStorePassword = null;
        String serverScheme = "https";
        String serverHost = null;
        int serverPort = 443;
        String activationId = null;
        String endpointId = null;
        String sharedSecret = null;
        String truststore = null;
        String truststorePassword = null;
        String truststoreType = null;
        String trustAnchorAlias = null;
        boolean userAuth = false;
        boolean listStore = false;
        boolean verbose = false;
        for (int n = 0; n < args.length; ++n) {
            String key = args[n];
            if (Options.USER.equals(key)) {
                userAuth = true;
                continue;
            }
            if (Options.TA_STORE_FILE.equals(key)) {
                taStore = TrustedAssetsProvisionerBase.getOptionValue(args, ++n);
                continue;
            }
            if (Options.TA_STORE_PASSWORD.equals(key)) {
                taStorePassword = TrustedAssetsProvisionerBase.getOptionValue(args, ++n);
                continue;
            }
            if (Options.DEVICE_ID.equals(key)) {
                activationId = TrustedAssetsProvisionerBase.getOptionValue(args, ++n);
                continue;
            }
            if (Options.ACTIVATION_ID.equals(key)) {
                activationId = TrustedAssetsProvisionerBase.getOptionValue(args, ++n);
                continue;
            }
            if (Options.ENDPOINT_ID.equals(key)) {
                endpointId = TrustedAssetsProvisionerBase.getOptionValue(args, ++n);
                continue;
            }
            if (Options.SHARED_SECRET.equals(key)) {
                sharedSecret = TrustedAssetsProvisionerBase.getOptionValue(args, ++n);
                continue;
            }
            if (Options.SERVER_SCHEME.equals(key)) {
                serverScheme = TrustedAssetsProvisionerBase.getOptionValue(args, ++n);
                continue;
            }
            if (Options.SERVER_HOST.equals(key)) {
                serverHost = TrustedAssetsProvisionerBase.getOptionValue(args, ++n);
                continue;
            }
            if (Options.SERVER_PORT.equals(key)) {
                String s = TrustedAssetsProvisionerBase.getOptionValue(args, ++n);
                try {
                    serverPort = Integer.parseInt(s);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("invalid port value '" + s);
                }
            }
            if (Options.TRUST_STORE.equals(key)) {
                truststore = TrustedAssetsProvisionerBase.getOptionValue(args, ++n);
                continue;
            }
            if (Options.TRUST_STORE_PASSWORD.equals(key)) {
                truststorePassword = TrustedAssetsProvisionerBase.getOptionValue(args, ++n);
                continue;
            }
            if (Options.TRUST_STORE_TYPE.equals(key)) {
                truststoreType = TrustedAssetsProvisionerBase.getOptionValue(args, ++n);
                continue;
            }
            if (Options.TRUST_ANCHOR_ALIAS.equals(key)) {
                trustAnchorAlias = TrustedAssetsProvisionerBase.getOptionValue(args, ++n);
                continue;
            }
            if (Options.LIST_STORE.equals(key)) {
                listStore = true;
                continue;
            }
            if (Options.VERBOSE.equals(key)) {
                verbose = true;
                continue;
            }
            throw new IllegalArgumentException("unknown option '" + key + "'");
        }
        File file = null;
        if (taStore != null) {
            file = new File(taStore);
        }
        if (file != null && listStore && taStorePassword != null) {
            if (!(args.length == 5 || args.length == 6 && verbose)) {
                throw new IllegalArgumentException("wrong number of arguments for listing taStore.");
            }
            if (!file.exists()) {
                throw new IllegalArgumentException("taStore file does not exist.");
            }
            TrustedAssetsProvisionerBase.listStore(file, taStorePassword, verbose);
            System.exit(0);
        }
        if (activationId != null && endpointId != null) {
            throw new IllegalArgumentException("incompatible options: '-activationId' and '-endpointId'");
        }
        if (userAuth && (activationId != null || endpointId != null)) {
            throw new IllegalArgumentException("incompatible options: '-activationId', '-endpointId' and '-user'");
        }
        if (!(userAuth || activationId != null && activationId.length() != 0 || endpointId != null && endpointId.length() != 0)) {
            throw new IllegalArgumentException("missing '-activationId', '-endpointId' or '-user' option");
        }
        if (serverHost == null || serverHost.length() == 0) {
            throw new IllegalArgumentException("missing '-serverHost' option");
        }
        if (serverPort > 65535 || serverPort < 0) {
            throw new IllegalArgumentException("illegal server port value");
        }
        if (!(userAuth || sharedSecret != null && sharedSecret.length() != 0)) {
            throw new IllegalArgumentException("missing '-sharedSecret' option");
        }
        if (userAuth && sharedSecret != null) {
            throw new IllegalArgumentException("missing '-sharedSecret' option not supported for user authentication mode ");
        }
        if (userAuth && taStore == null) {
            throw new IllegalArgumentException("missing '-taStore' option");
        }
        if (taStorePassword == null) {
            throw new IllegalArgumentException("missing '-taStorePassword' option");
        }
        if (taStore == null) {
            String clientId = activationId != null ? activationId : endpointId;
            file = new File(System.getProperty("user.dir"), "/" + clientId + "." + storeExtension);
        }
        if (file.exists()) {
            throw new IllegalArgumentException("Trusted assets store file already exists : " + file);
        }
        DefaultTrustedAssetsManager.ProvisioningSupport provisioningSupport = DefaultTrustedAssetsManager.ProvisioningSupport.create(file, taStorePassword).setServer(serverScheme, serverHost, serverPort);
        if (!userAuth) {
            if (activationId != null) {
                provisioningSupport.setClientCredentials(activationId, sharedSecret);
            } else {
                provisioningSupport.setEnterpriseClientCredentials(endpointId, sharedSecret);
            }
        }
        if (truststore != null && truststore.length() != 0) {
            if (truststorePassword == null) {
                throw new IllegalArgumentException("missing '-truststorePassword' option");
            }
            FileInputStream fis = null;
            try {
                String keyStoreType = truststoreType != null ? truststoreType : KeyStore.getDefaultType();
                KeyStore ks = KeyStore.getInstance(keyStoreType);
                fis = new FileInputStream(truststore);
                ks.load(fis, truststorePassword.toCharArray());
                if (trustAnchorAlias != null) {
                    X509Certificate trustAnchor = (X509Certificate)ks.getCertificate(trustAnchorAlias);
                    provisioningSupport.addTrustAnchor(trustAnchorAlias, trustAnchor);
                } else {
                    Enumeration<String> e = ks.aliases();
                    while (e.hasMoreElements()) {
                        String alias = e.nextElement();
                        if (!ks.isCertificateEntry(alias)) continue;
                        X509Certificate trustAnchor = (X509Certificate)ks.getCertificate(alias);
                        provisioningSupport.addTrustAnchor(alias, trustAnchor);
                    }
                }
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        provisioningSupport.provision();
        if (listStore) {
            TrustedAssetsProvisionerBase.listStore(file, taStorePassword, verbose);
        }
        return file.getCanonicalPath();
    }

    private static String getOptionValue(String[] args, int n) throws IllegalArgumentException {
        if (n >= args.length) {
            throw new IllegalArgumentException("Missing parameter for command option: " + args[n - 1]);
        }
        String value = args[n];
        for (Options option : Options.values()) {
            if (!option.equals(value)) continue;
            throw new IllegalArgumentException("Ambiguous or missing parameter for command option: " + args[n - 1]);
        }
        return value;
    }

    private static void listStore(File file, String taStorePassword, boolean verbose) throws TrustException {
        DefaultTrustedAssetsManager tam = new DefaultTrustedAssetsManager(file.getPath(), taStorePassword, null);
        TrustedAssetsProvisionerBase.display("\nTrusted assets store: " + file);
        try {
            TrustedAssetsProvisionerBase.display(" Server host: " + tam.getServerHost());
        }
        catch (IllegalStateException ise) {
            TrustedAssetsProvisionerBase.display(" Server host is not set.");
        }
        TrustedAssetsProvisionerBase.display(" Server port: " + tam.getServerPort());
        try {
            TrustedAssetsProvisionerBase.display(" Client ID: " + tam.getClientId());
        }
        catch (IllegalStateException ise) {
            TrustedAssetsProvisionerBase.display(" Client ID is not set.");
        }
        try {
            TrustedAssetsProvisionerBase.display(" Endpoint ID: " + tam.getEndpointId());
        }
        catch (IllegalStateException ise) {
            TrustedAssetsProvisionerBase.display(" Endpoint ID is not set.");
        }
        try {
            PublicKey key = tam.getPublicKey();
            TrustedAssetsProvisionerBase.display(" Public key is set.");
            if (verbose) {
                TrustedAssetsProvisionerBase.display("  " + key);
            }
        }
        catch (IllegalStateException ise) {
            TrustedAssetsProvisionerBase.display(" Public key is not set.");
        }
        Vector<byte[]> certs = tam.getTrustAnchorCertificates();
        if (certs.size() == 0) {
            TrustedAssetsProvisionerBase.display(" Trust anchor certificates are not set.");
        } else {
            TrustedAssetsProvisionerBase.display(" Trust anchor certificates are set.");
            if (verbose) {
                StringBuilder sb = new StringBuilder(lineSep);
                try {
                    CertificateFactory factory = CertificateFactory.getInstance("X.509");
                    for (byte[] cert : certs) {
                        ByteArrayInputStream inputStream = new ByteArrayInputStream(cert);
                        Certificate certificate = factory.generateCertificate(inputStream);
                        sb.append(certificate.toString()).append(lineSep);
                    }
                }
                catch (CertificateException e) {
                    sb.delete(0, sb.length());
                    for (byte[] cert : certs) {
                        sb.append(lineSep);
                        for (byte b : cert) {
                            sb.append(String.format(Locale.ROOT, "%02x", b & 0xFF));
                        }
                    }
                }
                TrustedAssetsProvisionerBase.display(sb.toString());
            }
        }
    }

    private static void showUsage() {
        TrustedAssetsProvisionerBase.display("Usage: \n");
        TrustedAssetsProvisionerBase.display("java com.oracle.iot.client.impl.trust.TrustedAssetsProvisioner \n\t[-user]\n\t[-taStore <file>] # required if -user option specified; if not specified the TA store will be name <activationId|endpointId>.<jks|bks>\n\t-taStorePassword <password> \n\t[ -serverScheme mqtts|https] \n\t-serverHost <hostname> \n\t[ -serverPort <port> ]\n\t-activationId <id> | -endpointId <id>\n\t-sharedSecret <secret> \n\t-truststore <file> \n\t-truststorePassword <password> \n\t-truststoreType <type> \n\t[ -trustAnchorAlias <alias> ]\n\t[ -list [-v] ]\n");
        TrustedAssetsProvisionerBase.display("-serverScheme is optional, if omitted https will be used. mqtts means mqtt over ssl; -serverPort is optional, if omitted 443 wi ll be used; -trustAnchorAlias is optional, if omitted all the certificates will be imported from the provided truststore.");
        TrustedAssetsProvisionerBase.display("-activationId and -endpointId options are mutually exclusive.");
        TrustedAssetsProvisionerBase.display("-user is used to provision an enterprise client for user authentication.");
        TrustedAssetsProvisionerBase.display("-list is used to list the content of the TA Store. -v is additionally used for verbose listing.");
        TrustedAssetsProvisionerBase.display("\nOr:");
        TrustedAssetsProvisionerBase.display("java com.oracle.iot.client.impl.trust.TrustedAssetsProvisioner \n\t-taStore <file>\n\t-taStorePassword <password> \n\t-list [-v] \nTo list an already created store.\n");
    }

    private static void display(String s) {
        System.out.println(s);
    }

    private static enum Options {
        USER("-user"),
        TA_STORE_FILE("-taStore"),
        TA_STORE_PASSWORD("-taStorePassword"),
        DEVICE_ID("-deviceId"),
        ACTIVATION_ID("-activationId"),
        ENDPOINT_ID("-endpointId"),
        SHARED_SECRET("-sharedSecret"),
        SERVER_SCHEME("-serverScheme"),
        SERVER_HOST("-serverHost"),
        SERVER_PORT("-serverPort"),
        TRUST_STORE("-truststore"),
        TRUST_STORE_PASSWORD("-truststorePassword"),
        TRUST_STORE_TYPE("-truststoreType"),
        TRUST_ANCHOR_ALIAS("-trustAnchorAlias"),
        LIST_STORE("-list"),
        VERBOSE("-v");

        private final String option;

        private Options(String option) {
            this.option = option;
        }

        public boolean equals(String value) {
            return this.option.equalsIgnoreCase(value);
        }

        public String toString() {
            return this.option;
        }
    }
}

