/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.util;

import com.oracle.iot.client.util.Bootstrapper;
import java.io.File;
import java.io.FileInputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.HashSet;

public class NetworkProvisioner {
    static final int MAX_DATAGRAM_DATA = 65507;
    static final int DATAGRAM_OVERHEAD = 28;

    public static void main(String[] args) {
        boolean provision = true;
        if (args.length == 0) {
            provision = false;
        } else if (args.length != 2) {
            System.err.println("Incorrect arguments");
            NetworkProvisioner.showUsage();
            System.exit(-1);
        }
        try {
            if (!provision) {
                NetworkProvisioner.discover();
            } else {
                NetworkProvisioner.provision(args);
            }
        }
        catch (Exception e) {
            NetworkProvisioner.display(e.getMessage());
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private static void discover() throws Exception {
        HashSet<String> clientSet = new HashSet<String>();
        DatagramSocket datagramSocket = new DatagramSocket();
        byte[] outBuffer = new byte[]{1};
        byte[] inBuffer = new byte[datagramSocket.getReceiveBufferSize()];
        InetAddress inetAddress = InetAddress.getByName("238.163.7.96");
        DatagramPacket outgoingPacket = new DatagramPacket(outBuffer, outBuffer.length, inetAddress, 4456);
        NetworkProvisioner.display("\nWaiting for connections...");
        NetworkProvisioner.display("\n\tPress Enter to exit.\n");
        while (true) {
            datagramSocket.send(outgoingPacket);
            DatagramPacket incomingPacket = new DatagramPacket(inBuffer, inBuffer.length);
            datagramSocket.setSoTimeout(500);
            try {
                datagramSocket.receive(incomingPacket);
                if (incomingPacket.getLength() < 3 || inBuffer[0] != 2) continue;
                DiscoverResponse dr = NetworkProvisioner.parseDiscoverResponse(incomingPacket);
                String clientInfo = dr.key + " = " + dr.value + ", IpAddress = " + dr.address;
                if (clientSet.add(clientInfo)) {
                    NetworkProvisioner.display("Client: " + clientInfo);
                }
            }
            catch (SocketTimeoutException ste) {
                // empty catch block
            }
            if (System.in.available() <= 0) continue;
            datagramSocket.close();
            System.exit(0);
        }
    }

    private static void provision(String[] args) throws Exception {
        InetAddress inetAddress = InetAddress.getByName(args[0]);
        DatagramSocket datagramSocket = new DatagramSocket();
        NetworkProvisioner.display("Sending provisioning info.");
        int tries = 6;
        while (tries-- > 0) {
            NetworkProvisioner.sendProvisionRequest(datagramSocket, args[1], inetAddress, 4456);
            byte[] inBuffer = new byte[datagramSocket.getReceiveBufferSize()];
            DatagramPacket incomingPacket = new DatagramPacket(inBuffer, inBuffer.length);
            datagramSocket.setSoTimeout(5000);
            try {
                datagramSocket.receive(incomingPacket);
                int offset = 0;
                if (incomingPacket.getLength() < 2 || inBuffer[offset] != 4) {
                    NetworkProvisioner.display("Client did not respond correctly. ");
                    break;
                }
                byte status = inBuffer[1];
                if (status == 0) {
                    NetworkProvisioner.display("Client was successfully provisioned. ");
                    break;
                }
                if (status == 1) {
                    NetworkProvisioner.display("Client was not successfully provisioned. ");
                    break;
                }
                NetworkProvisioner.display("Client did not respond correctly. ");
                break;
            }
            catch (SocketTimeoutException ste) {
                if (tries != 0) continue;
                NetworkProvisioner.display("Provisioning timed out. ");
            }
        }
        datagramSocket.close();
    }

    private static DiscoverResponse parseDiscoverResponse(DatagramPacket datagram) throws Exception {
        byte[] inBuffer = datagram.getData();
        int offset = 1;
        Bootstrapper.LV lv = Bootstrapper.decodeLengthValue(inBuffer, offset);
        String valueKey = lv.value;
        lv = Bootstrapper.decodeLengthValue(inBuffer, offset += lv.length);
        String value = lv.value;
        return new DiscoverResponse(valueKey, value, datagram.getAddress().getHostAddress());
    }

    private static void sendProvisionRequest(DatagramSocket socket, String fileName, InetAddress address, int port) throws Exception {
        File file = new File(fileName);
        long fileLength = file.length();
        if (fileLength > 65510L) {
            throw new Exception("Provisioning file too large for a datagram");
        }
        long requestLength = fileLength + 3L;
        long sendBufferSize = socket.getSendBufferSize();
        if (requestLength + 28L > sendBufferSize) {
            int nextBufferSize = (int)requestLength + 28;
            socket.setSendBufferSize(nextBufferSize);
            if (socket.getSendBufferSize() < nextBufferSize) {
                throw new Exception("Provisioning file too big for send buffer");
            }
        }
        byte[] request = new byte[(int)requestLength];
        request[0] = 3;
        request[1] = (byte)(fileLength >> 8);
        request[2] = (byte)fileLength;
        FileInputStream fis = new FileInputStream(file);
        fis.read(request, 3, (int)fileLength);
        DatagramPacket datagram = new DatagramPacket(request, request.length, address, port);
        socket.send(datagram);
    }

    private static void display(String string) {
        System.out.println(string);
    }

    private static void showUsage() {
        NetworkProvisioner.display("Usage: java " + NetworkProvisioner.class.getName() + "\n\t[<Client host> <Provisioning file>] \n" + "\n\tWhere the Network Provisioner discovers available clients " + "\n\twhen no arguments are provided, and provisions the " + "\n\tselected client when all arguments are present. " + "\n\tWhere the Client host is the IP address of the " + "\n\tBootstrapper, displayed in discovery. " + "\n\tWhere the Provisioning file is the name of the file " + "\n\tcontaining the provisioning information in the unified " + "\n\tprovisioner format. ");
    }

    private static class DiscoverResponse {
        String key;
        String value;
        String address;

        DiscoverResponse(String key, String value, String address) {
            this.key = key;
            this.value = value;
            this.address = address;
        }
    }
}

