/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.message;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.json.JSONException;
import org.json.JSONObject;

public class Resource {
    private String endpointName;
    private String name;
    private Status status;
    private String path;
    private List<Method> methods;

    private Resource(Builder builder) {
        if (builder.name == null || builder.name.length() == 0 || builder.path == null || builder.path.length() == 0) {
            throw new IllegalArgumentException("Resource name, path cannot be null or empty.");
        }
        this.endpointName = builder.endpointName;
        this.name = builder.name;
        this.path = builder.path;
        this.status = builder.status != null ? builder.status : Status.ADDED;
        if (this.status != Status.REMOVED) {
            if (builder.methods == null || builder.methods.isEmpty()) {
                throw new IllegalArgumentException("Resource methods cannot be null or empty.");
            }
            this.methods = builder.methods;
        }
    }

    public JSONObject toJson() {
        try {
            JSONObject res = new JSONObject();
            if (this.endpointName != null && this.endpointName.length() != 0) {
                res.put("endpointName", this.endpointName);
            }
            res.put("name", this.name);
            res.put("path", this.path);
            if (this.status != null) {
                res.put("status", this.status.name());
            } else {
                res.put("status", Status.ADDED.name());
            }
            if (this.methods != null) {
                res.put("methods", Method.listToString(this.methods));
            }
            return res;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.toJson().toString();
    }

    public final void setStatus(Status st) {
        this.status = st;
    }

    public final String getEndpointName() {
        return this.endpointName;
    }

    public final String getName() {
        return this.name;
    }

    public final String getPath() {
        return this.path;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final List<Method> getMethods() {
        return this.methods;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Resource that = (Resource)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.path.equals(that.path)) {
            return false;
        }
        if (!this.status.equals((Object)that.status)) {
            return false;
        }
        return this.methods == null || this.methods.equals(that.methods);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.path.hashCode();
        if (this.status != null) {
            result = 31 * result + this.status.hashCode();
        }
        if (this.methods != null) {
            result = 31 * result + this.methods.hashCode();
        }
        return result;
    }

    public static final class Builder {
        private String endpointName;
        private String path;
        private String name;
        private Status status;
        private List<Method> methods;

        public Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            return this;
        }

        public Builder method(Method method) {
            if (this.methods == null) {
                this.methods = new ArrayList<Method>();
            }
            this.methods.add(method);
            return this;
        }

        public Builder methods(List<Method> methods) {
            if (this.methods == null) {
                this.methods = new ArrayList<Method>();
            }
            if (methods != null) {
                for (Method method : methods) {
                    this.methods.add(method);
                }
            }
            return this;
        }

        public final Builder fromJson(JSONObject resObject) {
            String st = resObject.optString("status", null);
            if (st != null) {
                this.status = st.equals("ADDED") ? Status.ADDED : Status.REMOVED;
            }
            this.methods = Method.stringToList(resObject.optString("methods", null));
            this.endpointName = resObject.optString("endpointName", null);
            this.name = resObject.optString("name", null);
            this.path = resObject.optString("path", null);
            return this;
        }

        public Resource build() {
            return new Resource(this);
        }
    }

    public static enum Status {
        ADDED,
        REMOVED;

    }

    public static enum Method {
        GET(1),
        POST(2),
        PUT(4),
        DELETE(8),
        PATCH(16);

        private final int value;

        private Method(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static Method createValue(String name) {
            try {
                return Method.valueOf(name);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public static List<Method> createValue(int bitMask) {
            ArrayList<Method> methods = new ArrayList<Method>();
            for (Method m : Method.values()) {
                if ((bitMask & m.value()) == 0) continue;
                methods.add(m);
            }
            return methods;
        }

        public static int getBitMask(List<Method> methods) {
            int result = 0;
            for (Method m : methods) {
                result += m.value();
            }
            return result;
        }

        public static String listToString(List<Method> methods) {
            StringBuilder result = new StringBuilder();
            if (methods != null && !methods.isEmpty()) {
                for (Method method : methods) {
                    result.append(result.length() == 0 ? "" : ",").append(method.name());
                }
            }
            return result.toString();
        }

        public static List<Method> stringToList(String methods) {
            ArrayList<Method> result = new ArrayList<Method>();
            if (methods != null && methods.length() != 0) {
                StringTokenizer methodsParser = new StringTokenizer(methods, ",");
                while (methodsParser.hasMoreTokens()) {
                    Method method = Method.createValue(methodsParser.nextToken());
                    if (method == null) continue;
                    result.add(method);
                }
            }
            return result;
        }
    }
}

