/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.message;

import com.oracle.iot.client.impl.util.Base64;
import com.oracle.iot.client.message.Message;
import com.oracle.iot.client.message.MessageParsingException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public final class RequestMessage
extends Message {
    private final Map<String, List<String>> headers;
    private final Map<String, String> params;
    private final String method;
    private final String url;
    private final byte[] body;

    private RequestMessage(Builder builder) {
        super(builder);
        this.headers = builder.headers == null ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap(builder.headers));
        this.params = builder.params == null ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap(builder.params));
        if (builder.url == null || builder.url.length() == 0) {
            throw new IllegalArgumentException("Requested url cannot be null or empty.");
        }
        this.url = builder.url;
        this.body = builder.body == null ? new byte[0] : Arrays.copyOf(builder.body, builder.body.length);
        this.method = builder.method == null ? "get" : builder.method;
    }

    public final Map<String, List<String>> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public final List<String> getHeaderValues(String name) {
        if (name != null) {
            name = name.toLowerCase(Locale.ROOT);
            return Collections.unmodifiableList(this.headers.get(name));
        }
        return Collections.emptyList();
    }

    public final String getHeaderValue(String name, int index) {
        List<String> values;
        if (name != null) {
            name = name.toLowerCase(Locale.ROOT);
        }
        if ((values = this.headers.get(name)) != null && values.size() > index) {
            return this.headers.get(name).get(index);
        }
        return null;
    }

    public final String getHeaderValue(String name) {
        List<String> values;
        if (name != null) {
            name = name.toLowerCase(Locale.ROOT);
        }
        if ((values = this.headers.get(name)) != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    public final Map<String, String> getParams() {
        return this.params;
    }

    public final String getParam(String name) {
        return this.params.get(name);
    }

    public final String getURL() {
        return this.url;
    }

    public final byte[] getBody() {
        return Arrays.copyOf(this.body, this.body.length);
    }

    public final String getBodyString() {
        try {
            return new String(this.getBody(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public final String getMethod() {
        if (this.method != null) {
            return this.method.toLowerCase(Locale.ROOT);
        }
        return null;
    }

    @Override
    public Message.Type getType() {
        return Message.Type.REQUEST;
    }

    @Override
    public final String toString() {
        return this.toJson().toString();
    }

    @Override
    public final JSONObject toJson() {
        return Message.Utils.bodyToJson(this, this.params, null, null, this.method, this.url, null, this.headers, this.body);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RequestMessage that = (RequestMessage)o;
        if (!Arrays.equals(this.body, that.body)) {
            return false;
        }
        if (!this.headers.equals(that.headers)) {
            return false;
        }
        if (!this.method.equals(that.method)) {
            return false;
        }
        if (!this.params.equals(that.params)) {
            return false;
        }
        return this.url.equals(that.url);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.headers.hashCode();
        result = 31 * result + this.params.hashCode();
        result = 31 * result + this.method.hashCode();
        result = 31 * result + this.url.hashCode();
        result = 31 * result + Message.Utils.hashCodeByteArray(this.body);
        return result;
    }

    public static final class Builder
    extends Message.MessageBuilder<Builder> {
        private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
        private final Map<String, String> params = new HashMap<String, String>();
        private String method;
        private String url;
        private byte[] body;

        public final Builder header(String name, List<String> values) {
            String lowerName;
            Message.Utils.checkNullValueThrowsNPE(name, "RequestMessage: Header name");
            Message.Utils.checkNullValuesThrowsNPE(values, "RequestMessage: Header values");
            if (!Message.Utils.isHttpHeaderAsciiPrintable(name, values)) {
                throw new IllegalArgumentException("RequestMessage: Header contains non-ASCII printable characters!");
            }
            if (values == null) {
                values = new ArrayList<String>();
            }
            if (this.headers.containsKey(lowerName = name.toLowerCase(Locale.ROOT))) {
                ArrayList<String> newValues = new ArrayList<String>((Collection)this.headers.get(lowerName));
                newValues.addAll(values);
                this.headers.put(lowerName, Collections.unmodifiableList(new ArrayList(newValues)));
            } else {
                this.headers.put(lowerName, Collections.unmodifiableList(new ArrayList<String>(values)));
            }
            return this.self();
        }

        public final Builder param(String name, String value) {
            Message.Utils.checkNullValueThrowsNPE(name, "RequestMessage: Param name");
            this.params.put(name, value);
            return this.self();
        }

        public final Builder url(String url) {
            this.url = url;
            return this.self();
        }

        public final Builder body(byte[] body) {
            this.body = Arrays.copyOf(body, body.length);
            return this.self();
        }

        public final Builder body(String body) {
            try {
                return this.body(body.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        public final Builder method(String method) {
            this.method = method != null ? method.toLowerCase(Locale.ROOT) : null;
            return this.self();
        }

        @Override
        public final Builder fromJson(JSONObject jsonObject) {
            JSONObject params;
            String key;
            Iterator<String> keys;
            byte[] body;
            super.fromJson(jsonObject);
            if (this.clientId == null || this.clientId.length() == 0) {
                throw new MessageParsingException("clientId should be set for RequestMessage");
            }
            JSONObject payload = jsonObject.optJSONObject("payload");
            Message.Utils.checkNullValueAndThrowMPE(payload, "request.message.payload.null");
            String method = payload.optString("method", null);
            Message.Utils.checkNullOrEmptyStringThrowMPE(method, "request.message.method.null");
            String url = payload.optString("url", null);
            Message.Utils.checkNullOrEmptyStringThrowMPE(url, "request.message.url.null");
            try {
                body = Base64.getDecoder().decode(payload.optString("body", null));
            }
            catch (IllegalArgumentException e) {
                throw new MessageParsingException("request.message.body.wrong");
            }
            catch (NullPointerException e) {
                throw new MessageParsingException("request.message.body.null");
            }
            this.method(method);
            this.url(url);
            this.body(body);
            JSONObject headers = payload.optJSONObject("headers");
            if (headers != null) {
                ArrayList<String> headerList = new ArrayList<String>();
                keys = headers.keys();
                while (keys.hasNext()) {
                    key = keys.next();
                    Object jsonValue = headers.opt(key);
                    if (!(jsonValue instanceof JSONArray)) continue;
                    JSONArray headerValues = (JSONArray)jsonValue;
                    int size = headerValues.length();
                    for (int i = 0; i < size; ++i) {
                        String headerValue = headerValues.optString(i, null);
                        headerList.add(headerValue);
                    }
                    this.header(key, headerList);
                    headerList.clear();
                }
            }
            if ((params = payload.optJSONObject("params")) != null) {
                keys = params.keys();
                while (keys.hasNext()) {
                    key = keys.next();
                    String paramValue = params.optString(key, null);
                    this.param(key, paramValue);
                }
            }
            return this.self();
        }

        @Override
        protected final Builder self() {
            return this;
        }

        @Override
        public RequestMessage build() {
            return new RequestMessage(this);
        }
    }
}

