/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.http;

import com.oracle.iot.client.impl.TimeManager;
import com.oracle.iot.client.impl.util.Base64;
import com.oracle.iot.client.trust.TrustedAssetsManager;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;

final class HttpCredentials {
    private static final long EXP_CLAIM_DELTA = 900000L;
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String DEFAULT_MESSAGE_DIGEST_ALGORITHM = "HmacSHA256";

    private HttpCredentials() {
    }

    static byte[] getClientAssertionCredentials(TrustedAssetsManager tam, boolean useOnlySharedSecret) throws GeneralSecurityException {
        return HttpCredentials.getAssertionCredentialsPostData(tam, useOnlySharedSecret);
    }

    private static byte[] getAssertionCredentialsPostData(TrustedAssetsManager trustedAssetsManager, boolean useOnlySharedSecret) throws GeneralSecurityException {
        String scope = trustedAssetsManager.isActivated() ? "" : "oracle/iot/activation";
        StringBuilder postData = new StringBuilder();
        postData.append("grant_type=client_credentials");
        postData.append("&client_assertion_type=urn%3Aietf%3Aparams%3Aoauth%3Aclient-assertion-type%3Ajwt-bearer");
        postData.append("&client_assertion=" + HttpCredentials.buildClientAssertion(trustedAssetsManager, useOnlySharedSecret));
        postData.append("&scope=" + scope);
        String dataString = postData.toString();
        return dataString.getBytes(UTF_8);
    }

    private static String buildClientAssertion(TrustedAssetsManager trustedAssetsManager, boolean useOnlySharedSecret) throws GeneralSecurityException {
        long exp = (TimeManager.currentTimeMillis() + 900000L) / 1000L;
        String id = !useOnlySharedSecret && !trustedAssetsManager.isActivated() ? trustedAssetsManager.getClientId() : trustedAssetsManager.getEndpointId();
        boolean useSharedSecret = useOnlySharedSecret || !trustedAssetsManager.isActivated();
        String alg = useSharedSecret ? "HS256" : "RS256";
        String header = "{\"typ\":\"JWT\",\"alg\":\"" + alg + "\"}";
        String claims = "{\"iss\":\"" + id + "\"" + ", \"sub\":\"" + id + "\"" + ", \"aud\":\"oracle/iot/oauth2/token\"" + ", \"exp\":" + exp + "}";
        StringBuilder inputToSign = new StringBuilder();
        inputToSign.append(Base64.getUrlEncoder().encodeToString(header.getBytes(UTF_8)));
        inputToSign.append(".");
        inputToSign.append(Base64.getUrlEncoder().encodeToString(claims.getBytes(UTF_8)));
        byte[] bytesToSign = inputToSign.toString().getBytes(UTF_8);
        byte[] signedBytes = null;
        signedBytes = useSharedSecret ? trustedAssetsManager.signWithSharedSecret(bytesToSign, DEFAULT_MESSAGE_DIGEST_ALGORITHM, null) : trustedAssetsManager.signWithPrivateKey(bytesToSign, "SHA256withRSA");
        String signature = Base64.getUrlEncoder().encodeToString(signedBytes);
        inputToSign.append(".");
        inputToSign.append(signature);
        return inputToSign.toString();
    }
}

