/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.device.mqtt;

import com.oracle.iot.client.impl.util.Base64;
import com.oracle.iot.client.trust.TrustException;
import com.oracle.iot.client.trust.TrustedAssetsManager;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;

final class MqttCredentials {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String DEFAULT_MESSAGE_DIGEST_ALGORITHM = "HmacSHA256";
    private static final long EXP_CLAIM_DELTA = 900000L;

    private MqttCredentials() {
    }

    static char[] getClientAssertionCredentials(TrustedAssetsManager trustedAssetsManager) throws GeneralSecurityException {
        String assertion = MqttCredentials.buildClientAssertion(trustedAssetsManager);
        return assertion.toCharArray();
    }

    static char[] getClientAssertionCredentials(TrustedAssetsManager trustedAssetsManager, String id, boolean useSharedSecret) throws GeneralSecurityException {
        String assertion = MqttCredentials.buildClientAssertion(trustedAssetsManager, id, useSharedSecret);
        return assertion.toCharArray();
    }

    private static String buildClientAssertion(TrustedAssetsManager trustedAssetsManager) throws GeneralSecurityException {
        boolean useSharedSecret;
        String id;
        if (!trustedAssetsManager.isActivated()) {
            id = trustedAssetsManager.getClientId();
            useSharedSecret = true;
        } else {
            id = trustedAssetsManager.getEndpointId();
            useSharedSecret = false;
        }
        return MqttCredentials.buildClientAssertion(trustedAssetsManager, id, useSharedSecret);
    }

    private static String buildClientAssertion(TrustedAssetsManager trustedAssetsManager, String id, boolean useSharedSecret) throws GeneralSecurityException {
        long exp = (System.currentTimeMillis() + 900000L) / 1000L;
        String alg = useSharedSecret ? "HS256" : "RS256";
        String header = "{\"typ\":\"JWT\",\"alg\":\"" + alg + "\"}";
        String claims = "{\"iss\":\"" + id + "\"" + ", \"sub\":\"" + id + "\"" + ", \"aud\":\"oracle/iot/oauth2/token\"" + ", \"exp\":" + exp + "}";
        StringBuilder inputToSign = new StringBuilder();
        inputToSign.append(Base64.getUrlEncoder().encodeToString(header.getBytes(UTF_8)));
        inputToSign.append(".");
        inputToSign.append(Base64.getUrlEncoder().encodeToString(claims.getBytes(UTF_8)));
        byte[] bytesToSign = inputToSign.toString().getBytes(UTF_8);
        byte[] signedBytes = null;
        try {
            signedBytes = useSharedSecret ? trustedAssetsManager.signWithSharedSecret(bytesToSign, DEFAULT_MESSAGE_DIGEST_ALGORITHM, null) : trustedAssetsManager.signWithPrivateKey(bytesToSign, "SHA256withRSA");
        }
        catch (TrustException e) {
            throw new GeneralSecurityException(e.getMessage(), e);
        }
        String signature = Base64.getUrlEncoder().encodeToString(signedBytes);
        inputToSign.append(".");
        inputToSign.append(signature);
        return inputToSign.toString();
    }
}

