/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.device;

import com.oracle.iot.client.StorageObject;
import com.oracle.iot.client.device.DirectlyConnectedDevice;
import com.oracle.iot.client.device.util.StorageDispatcher;
import com.oracle.iot.client.impl.StorageObjectBase;
import com.oracle.iot.client.impl.device.StorageDispatcherImpl;
import com.oracle.iot.client.impl.device.StorageObjectDelegate;
import com.oracle.iot.client.impl.device.VirtualDeviceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.iot.client.StorageObject;
import oracle.iot.client.device.VirtualDevice;

public final class StorageObjectImpl
extends StorageObjectBase {
    private String nameForSyncEvent;
    private VirtualDevice deviceForSyncEvent;
    private final StorageDispatcherImpl storageDispatcher;
    private static final StorageDispatcher.ProgressCallback progressCallback = new StorageDispatcher.ProgressCallback(){

        @Override
        public void progress(StorageDispatcher.Progress progress) {
            StorageObjectDelegate delegate = (StorageObjectDelegate)progress.getStorageObject();
            final StorageObjectImpl storageObject = (StorageObjectImpl)delegateMap.get(delegate);
            if (storageObject == null) {
                return;
            }
            StorageObject.SyncStatus oldStatus = storageObject.getSyncStatus();
            StorageDispatcher.Progress.State state = progress.getState();
            switch (state) {
                case COMPLETED: {
                    storageObject.setSyncStatus(StorageObject.SyncStatus.IN_SYNC);
                    delegateMap.remove(delegate);
                    break;
                }
                case CANCELLED: 
                case FAILED: {
                    storageObject.setSyncStatus(StorageObject.SyncStatus.SYNC_FAILED);
                    delegateMap.remove(delegate);
                    break;
                }
            }
            if (oldStatus != storageObject.getSyncStatus()) {
                StorageObject.SyncCallback syncCallback;
                if (storageObject.getInputPath() != null) {
                    storageObject.handleStateChange();
                }
                if ((syncCallback = storageObject.getSyncCallback()) != null) {
                    dispatcher.execute(new Runnable(){

                        @Override
                        public void run() {
                            ArrayList syncEvents = new ArrayList(storageObject.getSyncEvents());
                            while (!syncEvents.isEmpty()) {
                                StorageObject.SyncEvent syncEvent = (StorageObject.SyncEvent)syncEvents.remove(0);
                                syncCallback.onSync(syncEvent);
                            }
                        }
                    });
                }
            }
        }
    };
    private static Map<StorageObject, StorageObjectImpl> delegateMap = Collections.synchronizedMap(new HashMap());

    public StorageObjectImpl(DirectlyConnectedDevice directlyConnectedDevice, StorageObject delegate) {
        super(delegate);
        this.storageDispatcher = (StorageDispatcherImpl)StorageDispatcher.getStorageDispatcher(directlyConnectedDevice);
    }

    @Override
    public final void sync() {
        if (this.getSyncStatus() == StorageObject.SyncStatus.NOT_IN_SYNC) {
            super.sync();
            if (!this.storageDispatcher.isClosed()) {
                StorageObject delegate = this.getDelegate();
                delegateMap.put(delegate, this);
                this.storageDispatcher.setProgressCallback(progressCallback);
                this.storageDispatcher.queue(delegate);
            }
        } else {
            super.sync();
        }
    }

    @Override
    protected void handleStateChange() {
        if (this.deviceForSyncEvent != null) {
            ((VirtualDeviceImpl)this.deviceForSyncEvent).handleStorageObjectStateChange(this);
        }
    }

    @Override
    protected StorageObject.SyncEvent<VirtualDevice> createSyncEvent() {
        return new StorageObjectBase.SyncEventImpl<VirtualDevice>(this, this.deviceForSyncEvent, this.nameForSyncEvent);
    }

    void setSyncEventInfo(VirtualDevice virtualDevice, String nameForSyncEvent) {
        this.deviceForSyncEvent = virtualDevice;
        this.nameForSyncEvent = nameForSyncEvent;
    }
}

