/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.device;

import com.oracle.iot.client.impl.device.DeviceFunction;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DevicePolicy {
    private final String id;
    private final String deviceModelURN;
    private final Map<String, List<Function>> pipelines;
    private final String description;
    private final long lastModified;
    private final boolean enabled;

    public static String ALL_ATTRIBUTES() {
        return "*";
    }

    public String getId() {
        return this.id;
    }

    public String getDeviceModelURN() {
        return this.deviceModelURN;
    }

    public List<Function> getPipeline(String attributeName) {
        return attributeName != null ? this.pipelines.get(attributeName) : this.pipelines.get(DevicePolicy.ALL_ATTRIBUTES());
    }

    public Map<String, List<Function>> getPipelines() {
        return this.pipelines;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != DevicePolicy.class) {
            return false;
        }
        return this.id.equals(((DevicePolicy)obj).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(this.getDeviceModelURN()).append("\n\"pipelines\":\n[");
        Map<String, List<Function>> pipelines = this.getPipelines();
        if (pipelines != null && !pipelines.isEmpty()) {
            boolean first = true;
            for (Map.Entry<String, List<Function>> pipeline : pipelines.entrySet()) {
                DevicePolicy.dumpPipeline(stringBuilder, pipeline.getKey(), pipeline.getValue(), first);
                first = false;
            }
        }
        stringBuilder.append("\n]");
        return stringBuilder.toString();
    }

    public DevicePolicy(String id, String deviceModelURN, Map<String, List<Function>> pipelines, String description, long lastModified, boolean enabled) {
        this.id = id;
        this.deviceModelURN = deviceModelURN;
        this.pipelines = new HashMap<String, List<Function>>();
        if (pipelines != null) {
            this.pipelines.putAll(pipelines);
        }
        this.description = description;
        this.lastModified = lastModified;
        this.enabled = enabled;
    }

    private static String dumpPipeline(StringBuilder stringBuilder, String attributeName, List<Function> pipeline, boolean first) {
        if (!first) {
            stringBuilder.append(',');
        }
        stringBuilder.append("\n  {\n    \"attributeName\":\"").append(attributeName).append("\",").append("\n    \"pipeline\":\n    [");
        if (pipeline != null && !pipeline.isEmpty()) {
            for (Function function : pipeline) {
                String id = function.getId();
                Map<String, ?> parameters = function.getParameters();
                DeviceFunction deviceFunction = DeviceFunction.getDeviceFunction(id);
                if (deviceFunction != null) {
                    stringBuilder.append("\n      ").append(deviceFunction.getDetails(parameters));
                    continue;
                }
                stringBuilder.append("\n      `").append(id).append("` not found!");
            }
            stringBuilder.append("\n");
        }
        stringBuilder.append("    ]\n  }");
        return stringBuilder.toString();
    }

    public static class Function {
        private final String id;
        private final Map<String, ?> parameters;

        public Function(String id, Map<String, ?> parameters) {
            this.id = id;
            this.parameters = parameters != null && !parameters.isEmpty() ? Collections.unmodifiableMap(new HashMap(parameters)) : Collections.emptyMap();
        }

        public String getId() {
            return this.id;
        }

        public Map<String, ?> getParameters() {
            return this.parameters;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != Function.class) {
                return false;
            }
            return this.id.equals(((Function)obj).id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }
}

