/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl;

import com.oracle.iot.client.HttpResponse;
import com.oracle.iot.client.RestApi;
import com.oracle.iot.client.SecureConnection;
import com.oracle.iot.client.impl.DeviceModelParser;
import com.oracle.iot.client.message.StatusCode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.iot.client.DeviceModel;
import oracle.iot.client.enterprise.Filter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DeviceModelFactory {
    private static final String DM_PREFIX = "dm-";
    private static final String LOCAL_STORE;
    private static final String FILE_TYPE = ".json";
    private static final boolean ALLOW_DRAFT_MODELS;
    private static final Logger LOGGER;

    private static String checkLocalStorePath(String localStorePathname) {
        if (localStorePathname == null || "".equals(localStorePathname)) {
            return null;
        }
        File file = new File(localStorePathname);
        if (file.exists()) {
            if (!file.isDirectory()) {
                DeviceModelFactory.getLogger().log(Level.WARNING, "Cannot local device model store is not a directory: " + localStorePathname);
                return null;
            }
            if (file.canRead() && file.canWrite()) {
                return file.getAbsolutePath();
            }
            if (!file.canRead()) {
                DeviceModelFactory.getLogger().log(Level.WARNING, "Cannot read from local device model store: " + localStorePathname);
            }
            if (!file.canWrite()) {
                DeviceModelFactory.getLogger().log(Level.WARNING, "Cannot write to local device model store: " + localStorePathname);
            }
        } else {
            if (file.mkdir()) {
                return file.getAbsolutePath();
            }
            DeviceModelFactory.getLogger().log(Level.WARNING, "Cannot create local device model store: " + localStorePathname);
        }
        return null;
    }

    private DeviceModelFactory() {
    }

    public static DeviceModel getDeviceModel(SecureConnection secureConnection, String urn) throws IOException, GeneralSecurityException {
        return DeviceModelFactory.getDeviceModel(null, secureConnection, urn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeviceModel getDeviceModel(String aid, SecureConnection secureConnection, String urn) throws IOException, GeneralSecurityException {
        String uri;
        String path = null;
        if (LOCAL_STORE != null) {
            Reader reader = null;
            try {
                String encoded = URLEncoder.encode(urn, "UTF-8");
                path = LOCAL_STORE + File.separator + DM_PREFIX + encoded + FILE_TYPE;
                reader = new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8");
                DeviceModel deviceModel = DeviceModelParser.fromJson(reader);
                return deviceModel;
            }
            catch (JSONException e) {
                DeviceModelFactory.getLogger().log(Level.SEVERE, e.getMessage());
                throw new IOException(e);
            }
            catch (FileNotFoundException e) {
            }
            catch (UnsupportedEncodingException e) {
                DeviceModelFactory.getLogger().log(Level.SEVERE, e.getMessage());
                throw e;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ignored) {}
                }
            }
        }
        try {
            if (aid != null) {
                Filter f = Filter.eq("urn", urn);
                uri = new URI(null, null, RestApi.V2.getReqRoot() + "/apps/" + aid + "/deviceModels", "q=" + f.toJson().toString(), null).toString();
            } else {
                uri = new URI(null, null, RestApi.V2.getReqRoot() + "/deviceModels/" + urn, "expand=formats", null).toString();
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        byte[] data = DeviceModelFactory.getObject(secureConnection, uri);
        if (data == null) {
            return null;
        }
        DeviceModel dm = null;
        Object devicePolicy = null;
        try {
            JSONObject object = new JSONObject(new String(data, "UTF-8"));
            if (aid != null) {
                JSONArray items = object.getJSONArray("items");
                if (items.length() > 0) {
                    JSONObject jsonObject = items.getJSONObject(0);
                    dm = DeviceModelParser.fromJson(jsonObject);
                    if (LOCAL_STORE != null) {
                        data = jsonObject.toString().getBytes("UTF8");
                    }
                }
            } else {
                if (!ALLOW_DRAFT_MODELS && object.optBoolean("draft", false)) {
                    return null;
                }
                dm = DeviceModelParser.fromJson(object);
            }
        }
        catch (Exception e) {
            throw new IOException("GET " + uri.toString() + ": " + e.getMessage());
        }
        if (LOCAL_STORE != null) {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(path);
                fileOutputStream.write(data);
            }
            catch (IOException e) {
                DeviceModelFactory.getLogger().log(Level.SEVERE, e.toString());
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException ignored) {}
                }
            }
        }
        return dm;
    }

    private static byte[] getObject(SecureConnection secureConnection, String uri) throws IOException, GeneralSecurityException {
        HttpResponse res = secureConnection.get(uri);
        int status = res.getStatus();
        if (status == StatusCode.NOT_FOUND.getCode()) {
            return null;
        }
        if (status != StatusCode.OK.getCode()) {
            throw new IOException(res.getVerboseStatus("GET", uri));
        }
        byte[] data = res.getData();
        if (data == null) {
            throw new IOException("GET " + uri + " failed: no data received");
        }
        return data;
    }

    private static Logger getLogger() {
        return LOGGER;
    }

    static {
        String localStorePathname = System.getProperty("oracle.iot.client.device_model_store");
        LOCAL_STORE = DeviceModelFactory.checkLocalStorePath(localStorePathname);
        ALLOW_DRAFT_MODELS = Boolean.getBoolean("com.oracle.iot.client.device.allow_draft_device_models");
        LOGGER = Logger.getLogger("oracle.iot.client");
    }
}

