/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.device.persistence;

import com.oracle.iot.client.device.persistence.JavaDBDataSourceFactory;
import com.oracle.iot.client.device.persistence.MessagePersistence;
import com.oracle.iot.client.device.persistence.PersistenceMetaData;
import com.oracle.iot.client.message.Message;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class MessagePersistenceImpl
extends MessagePersistence {
    final DataSource dataSource;
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessagePersistenceImpl(Object context) {
        if (PersistenceMetaData.isPersistenceEnabled()) {
            Properties properties = new Properties();
            properties.put("databaseName", PersistenceMetaData.getDBName());
            DataSource ds = null;
            try {
                ds = JavaDBDataSourceFactory.createDataSource(properties);
            }
            catch (SQLException e) {
                MessagePersistenceImpl.getLogger().log(Level.WARNING, "SQL exception during creation of the DataSource.", e);
            }
            finally {
                this.dataSource = ds;
            }
            if (!this.tableExists("MESSAGES")) {
                this.createTable("MESSAGES");
            }
        } else {
            this.dataSource = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean tableExists(String tableName) {
        Connection connection = null;
        ResultSet resultSet = null;
        try {
            boolean b;
            connection = this.dataSource.getConnection();
            connection.setTransactionIsolation(PersistenceMetaData.getIsolationLevel(connection));
            connection.setAutoCommit(false);
            DatabaseMetaData metaData = connection.getMetaData();
            resultSet = metaData.getTables(null, null, tableName, null);
            boolean bl = b = resultSet.next();
            return bl;
        }
        catch (SQLException e) {
            MessagePersistenceImpl.getLogger().log(Level.WARNING, "SQL exception during validation of existence of the table for messages.", e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException ignored) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createTable(String tableName) {
        Connection connection = null;
        Statement createStmt = null;
        try {
            connection = this.dataSource.getConnection();
            connection.setTransactionIsolation(PersistenceMetaData.getIsolationLevel(connection));
            createStmt = connection.createStatement();
            int maxEndpointIdLength = 100;
            int maxUuidLength = 40;
            String CREATE_TABLE = "CREATE TABLE " + tableName.toUpperCase(Locale.ROOT) + "(TIMESTAMP BIGINT NOT NULL," + "UUID VARCHAR(" + maxUuidLength + ") NOT NULL," + "ENDPOINT_ID VARCHAR(" + maxEndpointIdLength + ") NOT NULL," + "MESSAGE BLOB," + " PRIMARY KEY (UUID))";
            String ENDPOINT_ID_INDEX = "CREATE INDEX endpoint_id ON " + tableName + "(ENDPOINT_ID)";
            createStmt.executeUpdate(CREATE_TABLE);
            createStmt.executeUpdate(ENDPOINT_ID_INDEX);
        }
        catch (SQLException e) {
            if ("X0Y32".equals(e.getSQLState())) {
                MessagePersistenceImpl.getLogger().log(Level.FINE, "The table for messages already exists.", e);
            } else {
                MessagePersistenceImpl.getLogger().log(Level.WARNING, "SQL exception during creation of the table for messages.", e);
            }
        }
        finally {
            if (createStmt != null) {
                try {
                    createStmt.close();
                }
                catch (SQLException ignored) {}
            }
        }
    }

    @Override
    public void save(Collection<Message> messages, String endpointId) {
        this.save("MESSAGES", messages, endpointId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void save(String tableName, Collection<Message> messages, String endpointId) {
        if (!PersistenceMetaData.isPersistenceEnabled()) {
            return;
        }
        Connection connection = null;
        Statement ps = null;
        try {
            connection = this.dataSource.getConnection();
            connection.setTransactionIsolation(PersistenceMetaData.getIsolationLevel(connection));
            connection.setAutoCommit(false);
            ps = connection.prepareStatement("INSERT INTO " + tableName + " VALUES (?, ?, ?, ?)");
            for (Message message : messages) {
                byte[] blob;
                try {
                    blob = message.toJson().toString().getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException cannot_happen) {
                    throw new RuntimeException(cannot_happen);
                }
                ps.setLong(1, message.getEventTime());
                ps.setString(2, message.getClientId());
                ps.setString(3, endpointId);
                ps.setBlob(4, new ByteArrayInputStream(blob));
                ps.addBatch();
            }
            ps.executeBatch();
            connection.commit();
        }
        catch (SQLException e) {
            MessagePersistenceImpl.getLogger().log(Level.WARNING, "SQL exception during saving messages to database.", e);
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (SQLException e1) {
                    MessagePersistenceImpl.getLogger().log(Level.WARNING, "Cannot rollback transaction.", e1);
                }
            }
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException ignored) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void save(String tableName, Message message, String endpointId) {
        if (!PersistenceMetaData.isPersistenceEnabled()) {
            return;
        }
        Connection connection = null;
        Statement ps = null;
        try {
            byte[] blob;
            connection = this.dataSource.getConnection();
            connection.setTransactionIsolation(PersistenceMetaData.getIsolationLevel(connection));
            connection.setAutoCommit(false);
            ps = connection.prepareStatement("INSERT INTO " + tableName + " VALUES (?, ?, ?, ?)");
            try {
                blob = message.toJson().toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException cannot_happen) {
                throw new RuntimeException(cannot_happen);
            }
            ps.setLong(1, message.getEventTime());
            ps.setString(2, message.getClientId());
            ps.setString(3, endpointId);
            ps.setBlob(4, new ByteArrayInputStream(blob));
            ps.execute();
            connection.commit();
        }
        catch (SQLException e) {
            MessagePersistenceImpl.getLogger().log(Level.WARNING, "SQL exception during saving messages to database.", e);
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (SQLException e1) {
                    MessagePersistenceImpl.getLogger().log(Level.WARNING, "Cannot rollback transaction.", e1);
                }
            }
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException ignored) {}
            }
        }
    }

    @Override
    public void delete(Collection<Message> messages) {
        this.delete("MESSAGES", messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void delete(String tableName, Collection<Message> messages) {
        if (!PersistenceMetaData.isPersistenceEnabled()) {
            return;
        }
        Connection connection = null;
        Statement ps = null;
        try {
            connection = this.dataSource.getConnection();
            connection.setTransactionIsolation(PersistenceMetaData.getIsolationLevel(connection));
            connection.setAutoCommit(false);
            ps = connection.prepareStatement("DELETE FROM " + tableName + " WHERE uuid = ?");
            for (Message message : messages) {
                ps.setString(1, message.getClientId());
                ps.addBatch();
            }
            ps.executeBatch();
            connection.commit();
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException e1) {
                MessagePersistenceImpl.getLogger().log(Level.WARNING, "Cannot rollback transaction.", e1);
            }
            MessagePersistenceImpl.getLogger().log(Level.WARNING, "SQL exception during deleting messages from database.", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException ignored) {}
            }
        }
    }

    @Override
    public List<Message> load(String endpointId) {
        return this.load("MESSAGES", endpointId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized List<Message> load(String tableName, String endpointId) {
        if (!PersistenceMetaData.isPersistenceEnabled()) {
            return null;
        }
        Connection connection = null;
        Statement ps = null;
        ResultSet resultSet = null;
        try {
            connection = this.dataSource.getConnection();
            connection.setTransactionIsolation(PersistenceMetaData.getIsolationLevel(connection));
            ArrayList<Message> messages = new ArrayList<Message>();
            ps = connection.prepareStatement("SELECT * FROM " + tableName + " WHERE ENDPOINT_ID = ? ORDER BY timestamp");
            ps.setString(1, endpointId);
            resultSet = ps.executeQuery();
            while (resultSet.next()) {
                Blob blob = resultSet.getBlob(4);
                byte[] bytes = blob.getBytes(1L, (int)blob.length());
                List<Message> list = Message.fromJson(bytes);
                Message message = list.isEmpty() ? null : list.get(0);
                messages.add(message);
            }
            ArrayList<Message> arrayList = messages;
            return arrayList;
        }
        catch (SQLException e) {
            MessagePersistenceImpl.getLogger().log(Level.WARNING, "SQL exception during loading messages from database.", e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException ignored) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException ignored) {}
            }
        }
        return Collections.emptyList();
    }

    private static Logger getLogger() {
        return LOGGER;
    }
}

